
# Autogenerated by mlir-tblgen; don't manually edit.

from jaxlib.mlir.dialects._ods_common import _cext as _ods_cext
from jaxlib.mlir.dialects._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "tpu"

@_ods_cext.register_operation(_Dialect)
class AllReduceOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.all_reduce"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, dim, kind, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dim"] = (dim if (
    isinstance(dim, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(dim, context=_ods_context))
    attributes["kind"] = (kind if (
    isinstance(kind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TPU_ReductionKindAttr')) else
      _ods_ir.AttrBuilder.get('TPU_ReductionKindAttr')(kind, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def dim(self):
    return self.operation.attributes["dim"]

  @dim.setter
  def dim(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dim"] = value

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def all_reduce(input, dim, kind, *, loc=None, ip=None) -> _ods_ir.Value:
  return AllReduceOp(input=input, dim=dim, kind=kind, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AllocaSemaphoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sem_alloc"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.results[0]

def sem_alloc(result, *, loc=None, ip=None) -> _ods_ir.Value:
  return AllocaSemaphoreOp(result=result, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AssumeLayoutOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.assume_layout"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def assume_layout(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return AssumeLayoutOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AssumeMultipleOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.assume_multiple"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, multiple, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["multiple"] = (multiple if (
    isinstance(multiple, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(multiple, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def multiple(self):
    return self.operation.attributes["multiple"]

  @multiple.setter
  def multiple(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["multiple"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def assume_multiple(value, multiple, *, loc=None, ip=None) -> _ods_ir.Value:
  return AssumeMultipleOp(value=value, multiple=multiple, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitcastOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def bitcast(output, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitcastOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitcastVregOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.bitcast_vreg"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def bitcast_vreg(output, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return BitcastVregOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastInSublanesOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.broadcast_in_sublanes"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, source, lane, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["lane"] = (lane if (
    isinstance(lane, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(lane, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def lane(self):
    return self.operation.attributes["lane"]

  @lane.setter
  def lane(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["lane"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def broadcast_in_sublanes(output, source, lane, *, loc=None, ip=None) -> _ods_ir.Value:
  return BroadcastInSublanesOp(output=output, source=source, lane=lane, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConcatenateOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.concatenate"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, sources, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(sources))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(dimension, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sources(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def concatenate(output, sources, dimension, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConcatenateOp(output=output, sources=sources, dimension=dimension, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CreateMaskOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.create_mask"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, low, high, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(low))
    operands.extend(_get_op_results_or_values(high))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def low(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 0, 2, 0, 0)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def high(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 0, 2, 0, 1)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def create_mask(output, low, high, *, loc=None, ip=None) -> _ods_ir.Value:
  return CreateMaskOp(output=output, low=low, high=high, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CreateSubelementMaskOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.create_subelement_mask"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, from_, to, num_subelems, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["from"] = (from_ if (
    isinstance(from_, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(from_, context=_ods_context))
    attributes["to"] = (to if (
    isinstance(to, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(to, context=_ods_context))
    attributes["num_subelems"] = (num_subelems if (
    isinstance(num_subelems, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(num_subelems, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def from_(self):
    return self.operation.attributes["from"]

  @from_.setter
  def from_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["from"] = value

  @builtins.property
  def to(self):
    return self.operation.attributes["to"]

  @to.setter
  def to(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["to"] = value

  @builtins.property
  def num_subelems(self):
    return self.operation.attributes["num_subelems"]

  @num_subelems.setter
  def num_subelems(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["num_subelems"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def create_subelement_mask(output, from_, to, num_subelems, *, loc=None, ip=None) -> _ods_ir.Value:
  return CreateSubelementMaskOp(output=output, from_=from_, to=to, num_subelems=num_subelems, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DelayOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.delay"

  _ODS_REGIONS = (0, True)

  def __init__(self, nanos, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(nanos))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def nanos(self):
    return self.operation.operands[0]

def delay(nanos, *, loc=None, ip=None) -> _ods_ir.Operation:
  return DelayOp(nanos=nanos, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class DeviceIdOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.device_id"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.results[0]

def device_id(*, loc=None, ip=None) -> _ods_ir.Value:
  return DeviceIdOp(loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DynamicGatherOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.dynamic_gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, source, indices, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(dimension, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    return self.operation.operands[1]

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def dynamic_gather(output, source, indices, dimension, *, loc=None, ip=None) -> _ods_ir.Value:
  return DynamicGatherOp(output=output, source=source, indices=indices, dimension=dimension, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DynamicRotateOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.dynamic_rotate"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, value, amount, dimension, *, stride=None, stride_dimension=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_result_or_value(amount))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SI32Attr')) else
      _ods_ir.AttrBuilder.get('SI32Attr')(dimension, context=_ods_context))
    if stride is not None: attributes["stride"] = (stride if (
        isinstance(stride, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SI32Attr')) else
          _ods_ir.AttrBuilder.get('SI32Attr')(stride, context=_ods_context))
    if stride_dimension is not None: attributes["stride_dimension"] = (stride_dimension if (
        isinstance(stride_dimension, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SI32Attr')) else
          _ods_ir.AttrBuilder.get('SI32Attr')(stride_dimension, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def amount(self):
    return self.operation.operands[1]

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def stride(self):
    if "stride" not in self.operation.attributes:
      return None
    return self.operation.attributes["stride"]

  @stride.setter
  def stride(self, value):
    if value is not None:
      self.operation.attributes["stride"] = value
    elif "stride" in self.operation.attributes:
      del self.operation.attributes["stride"]

  @stride.deleter
  def stride(self):
    del self.operation.attributes["stride"]

  @builtins.property
  def stride_dimension(self):
    if "stride_dimension" not in self.operation.attributes:
      return None
    return self.operation.attributes["stride_dimension"]

  @stride_dimension.setter
  def stride_dimension(self, value):
    if value is not None:
      self.operation.attributes["stride_dimension"] = value
    elif "stride_dimension" in self.operation.attributes:
      del self.operation.attributes["stride_dimension"]

  @stride_dimension.deleter
  def stride_dimension(self):
    del self.operation.attributes["stride_dimension"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def dynamic_rotate(result, value, amount, dimension, *, stride=None, stride_dimension=None, loc=None, ip=None) -> _ods_ir.Value:
  return DynamicRotateOp(result=result, value=value, amount=amount, dimension=dimension, stride=stride, stride_dimension=stride_dimension, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class EnqueueDMAOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.enqueue_dma"

  _ODS_OPERAND_SEGMENTS = [1,0,1,1,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, source, target, target_semaphore, *, source_semaphore=None, device_id=None, core_id=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(source_semaphore) if source_semaphore is not None else None)
    operands.append(_get_op_result_or_value(target))
    operands.append(_get_op_result_or_value(target_semaphore))
    operands.append(_get_op_result_or_value(device_id) if device_id is not None else None)
    operands.append(_get_op_result_or_value(core_id) if core_id is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def source_semaphore(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def target(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0]

  @builtins.property
  def target_semaphore(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0]

  @builtins.property
  def device_id(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def core_id(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range[0] if len(operand_range) > 0 else None

def enqueue_dma(source, target, target_semaphore, *, source_semaphore=None, device_id=None, core_id=None, loc=None, ip=None) -> _ods_ir.Operation:
  return EnqueueDMAOp(source=source, target=target, target_semaphore=target_semaphore, source_semaphore=source_semaphore, device_id=device_id, core_id=core_id, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class EraseLayoutOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.erase_memref_layout"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def erase_memref_layout(result, operand, *, loc=None, ip=None) -> _ods_ir.Value:
  return EraseLayoutOp(result=result, operand=operand, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GatherOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, source, indices, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["indices"] = (indices if (
    isinstance(indices, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(indices, context=_ods_context))
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(dimension, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    return self.operation.attributes["indices"]

  @indices.setter
  def indices(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["indices"] = value

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def gather(output, source, indices, dimension, *, loc=None, ip=None) -> _ods_ir.Value:
  return GatherOp(output=output, source=source, indices=indices, dimension=dimension, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GetBarrierSemaphoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sem_barrier"

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(semaphore)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def semaphore(self):
    return self.operation.results[0]

def sem_barrier(semaphore, *, loc=None, ip=None) -> _ods_ir.Value:
  return GetBarrierSemaphoreOp(semaphore=semaphore, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GetInternalScratchOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.internal_scratch"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.results[0]

def internal_scratch(result, *, loc=None, ip=None) -> _ods_ir.Value:
  return GetInternalScratchOp(result=result, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GetIterationBoundOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.iteration_bound"

  _ODS_REGIONS = (0, True)

  def __init__(self, dim, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dim"] = (dim if (
    isinstance(dim, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(dim, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dim(self):
    return self.operation.attributes["dim"]

  @dim.setter
  def dim(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dim"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def iteration_bound(dim, *, loc=None, ip=None) -> _ods_ir.Value:
  return GetIterationBoundOp(dim=dim, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IotaOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.iota"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, *, dimension=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if dimension is not None: attributes["dimension"] = (dimension if (
        isinstance(dimension, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(dimension, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dimension(self):
    if "dimension" not in self.operation.attributes:
      return None
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is not None:
      self.operation.attributes["dimension"] = value
    elif "dimension" in self.operation.attributes:
      del self.operation.attributes["dimension"]

  @dimension.deleter
  def dimension(self):
    del self.operation.attributes["dimension"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def iota(output, *, dimension=None, loc=None, ip=None) -> _ods_ir.Value:
  return IotaOp(output=output, dimension=dimension, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LoadOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, sublane_mask, *, sublane_stride=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sublane_mask"] = (sublane_mask if (
    isinstance(sublane_mask, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(sublane_mask, context=_ods_context))
    if sublane_stride is not None: attributes["sublane_stride"] = (sublane_stride if (
        isinstance(sublane_stride, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(sublane_stride, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def sublane_mask(self):
    return self.operation.attributes["sublane_mask"]

  @sublane_mask.setter
  def sublane_mask(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_mask"] = value

  @builtins.property
  def sublane_stride(self):
    if "sublane_stride" not in self.operation.attributes:
      return None
    return self.operation.attributes["sublane_stride"]

  @sublane_stride.setter
  def sublane_stride(self, value):
    if value is not None:
      self.operation.attributes["sublane_stride"] = value
    elif "sublane_stride" in self.operation.attributes:
      del self.operation.attributes["sublane_stride"]

  @sublane_stride.deleter
  def sublane_stride(self):
    del self.operation.attributes["sublane_stride"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def load(result, base, indices, sublane_mask, *, sublane_stride=None, loc=None, ip=None) -> _ods_ir.Value:
  return LoadOp(result=result, base=base, indices=indices, sublane_mask=sublane_mask, sublane_stride=sublane_stride, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.log"

  _ODS_REGIONS = (0, True)

  def __init__(self, inputs, tag, *, formatted=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["tag"] = (tag if (
    isinstance(tag, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(tag, context=_ods_context))
    if formatted is not None: attributes["formatted"] = (formatted if (
        isinstance(formatted, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(formatted, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def tag(self):
    return self.operation.attributes["tag"]

  @tag.setter
  def tag(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["tag"] = value

  @builtins.property
  def formatted(self):
    return self.operation.attributes["formatted"]

  @formatted.setter
  def formatted(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["formatted"] = value

def log(inputs, tag, *, formatted=None, loc=None, ip=None) -> _ods_ir.Operation:
  return LogOp(inputs=inputs, tag=tag, formatted=formatted, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class MaskCastOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.mask_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def mask_cast(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return MaskCastOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MatmulOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.matmul"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, acc, *, transpose_lhs=None, transpose_rhs=None, precision=None, dimension_numbers=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(acc))
    _ods_context = _ods_get_default_loc_context(loc)
    if transpose_lhs is not None: attributes["transpose_lhs"] = (transpose_lhs if (
        isinstance(transpose_lhs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(transpose_lhs, context=_ods_context))
    if transpose_rhs is not None: attributes["transpose_rhs"] = (transpose_rhs if (
        isinstance(transpose_rhs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(transpose_rhs, context=_ods_context))
    if precision is not None: attributes["precision"] = (precision if (
        isinstance(precision, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TPU_ContractPrecisionEnum')) else
          _ods_ir.AttrBuilder.get('TPU_ContractPrecisionEnum')(precision, context=_ods_context))
    if dimension_numbers is not None: attributes["dimension_numbers"] = (dimension_numbers if (
        isinstance(dimension_numbers, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TPU_DotDimensionNumbersAttr')) else
          _ods_ir.AttrBuilder.get('TPU_DotDimensionNumbersAttr')(dimension_numbers, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def acc(self):
    return self.operation.operands[2]

  @builtins.property
  def transpose_lhs(self):
    return self.operation.attributes["transpose_lhs"]

  @transpose_lhs.setter
  def transpose_lhs(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["transpose_lhs"] = value

  @builtins.property
  def transpose_rhs(self):
    return self.operation.attributes["transpose_rhs"]

  @transpose_rhs.setter
  def transpose_rhs(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["transpose_rhs"] = value

  @builtins.property
  def precision(self):
    if "precision" not in self.operation.attributes:
      return None
    return self.operation.attributes["precision"]

  @precision.setter
  def precision(self, value):
    if value is not None:
      self.operation.attributes["precision"] = value
    elif "precision" in self.operation.attributes:
      del self.operation.attributes["precision"]

  @precision.deleter
  def precision(self):
    del self.operation.attributes["precision"]

  @builtins.property
  def dimension_numbers(self):
    if "dimension_numbers" not in self.operation.attributes:
      return None
    return self.operation.attributes["dimension_numbers"]

  @dimension_numbers.setter
  def dimension_numbers(self, value):
    if value is not None:
      self.operation.attributes["dimension_numbers"] = value
    elif "dimension_numbers" in self.operation.attributes:
      del self.operation.attributes["dimension_numbers"]

  @dimension_numbers.deleter
  def dimension_numbers(self):
    del self.operation.attributes["dimension_numbers"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def matmul(result, lhs, rhs, acc, *, transpose_lhs=None, transpose_rhs=None, precision=None, dimension_numbers=None, loc=None, ip=None) -> _ods_ir.Value:
  return MatmulOp(result=result, lhs=lhs, rhs=rhs, acc=acc, transpose_lhs=transpose_lhs, transpose_rhs=transpose_rhs, precision=precision, dimension_numbers=dimension_numbers, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemRefBitcastOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.memref_bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def memref_bitcast(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return MemRefBitcastOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemRefReshapeOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.memref_reshape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def memref_reshape(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return MemRefReshapeOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemRefSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.memref_slice"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, mem_ref, base_idx, dynamic_sizes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(mem_ref))
    operands.append(_get_op_results_or_values(base_idx))
    operands.append(_get_op_results_or_values(dynamic_sizes))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def mem_ref(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def base_idx(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def dynamic_sizes(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def result(self):
    return self.operation.results[0]

def memref_slice(result, mem_ref, base_idx, dynamic_sizes, *, loc=None, ip=None) -> _ods_ir.Value:
  return MemRefSliceOp(result=result, mem_ref=mem_ref, base_idx=base_idx, dynamic_sizes=dynamic_sizes, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemRefSqueezeOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.memref_squeeze"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def memref_squeeze(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return MemRefSqueezeOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PRNGRandomBitsOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.prng_random_bits"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def output(self):
    return self.operation.results[0]

def prng_random_bits(output, *, loc=None, ip=None) -> _ods_ir.Value:
  return PRNGRandomBitsOp(output=output, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PRNGSeed32Op(_ods_ir.OpView):
  OPERATION_NAME = "tpu.prng_set_seed_32"

  _ODS_REGIONS = (0, True)

  def __init__(self, seeds, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(seeds))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def seeds(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def prng_set_seed_32(seeds, *, loc=None, ip=None) -> _ods_ir.Operation:
  return PRNGSeed32Op(seeds=seeds, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class PackSubelementsOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.pack_subelements"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, sources, pack_format, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(sources))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pack_format"] = (pack_format if (
    isinstance(pack_format, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TPU_PackFormatEnum')) else
      _ods_ir.AttrBuilder.get('TPU_PackFormatEnum')(pack_format, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sources(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def pack_format(self):
    return self.operation.attributes["pack_format"]

  @pack_format.setter
  def pack_format(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pack_format"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def pack_subelements(output, sources, pack_format, *, loc=None, ip=None) -> _ods_ir.Value:
  return PackSubelementsOp(output=output, sources=sources, pack_format=pack_format, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RegionOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.region"

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def region(results_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(RegionOp(results_=results_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReinterpretCastOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.reinterpret_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def reinterpret_cast(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return ReinterpretCastOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RepeatOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.repeat"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, source, dimension, times, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(dimension, context=_ods_context))
    attributes["times"] = (times if (
    isinstance(times, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(times, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def times(self):
    return self.operation.attributes["times"]

  @times.setter
  def times(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["times"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def repeat(output, source, dimension, times, *, loc=None, ip=None) -> _ods_ir.Value:
  return RepeatOp(output=output, source=source, dimension=dimension, times=times, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RollVectorsOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.roll_vectors"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def roll_vectors(output, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return RollVectorsOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RotateOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.rotate"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, amount, dimension, *, stride=None, stride_dimension=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["amount"] = (amount if (
    isinstance(amount, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SI32Attr')) else
      _ods_ir.AttrBuilder.get('SI32Attr')(amount, context=_ods_context))
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SI32Attr')) else
      _ods_ir.AttrBuilder.get('SI32Attr')(dimension, context=_ods_context))
    if stride is not None: attributes["stride"] = (stride if (
        isinstance(stride, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SI32Attr')) else
          _ods_ir.AttrBuilder.get('SI32Attr')(stride, context=_ods_context))
    if stride_dimension is not None: attributes["stride_dimension"] = (stride_dimension if (
        isinstance(stride_dimension, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SI32Attr')) else
          _ods_ir.AttrBuilder.get('SI32Attr')(stride_dimension, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def amount(self):
    return self.operation.attributes["amount"]

  @amount.setter
  def amount(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["amount"] = value

  @builtins.property
  def dimension(self):
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def stride(self):
    if "stride" not in self.operation.attributes:
      return None
    return self.operation.attributes["stride"]

  @stride.setter
  def stride(self, value):
    if value is not None:
      self.operation.attributes["stride"] = value
    elif "stride" in self.operation.attributes:
      del self.operation.attributes["stride"]

  @stride.deleter
  def stride(self):
    del self.operation.attributes["stride"]

  @builtins.property
  def stride_dimension(self):
    if "stride_dimension" not in self.operation.attributes:
      return None
    return self.operation.attributes["stride_dimension"]

  @stride_dimension.setter
  def stride_dimension(self, value):
    if value is not None:
      self.operation.attributes["stride_dimension"] = value
    elif "stride_dimension" in self.operation.attributes:
      del self.operation.attributes["stride_dimension"]

  @stride_dimension.deleter
  def stride_dimension(self):
    del self.operation.attributes["stride_dimension"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def rotate(value, amount, dimension, *, stride=None, stride_dimension=None, loc=None, ip=None) -> _ods_ir.Value:
  return RotateOp(value=value, amount=amount, dimension=dimension, stride=stride, stride_dimension=stride_dimension, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SemaphoreReadOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sem_read"

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(semaphore))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def semaphore(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def sem_read(semaphore, *, loc=None, ip=None) -> _ods_ir.Value:
  return SemaphoreReadOp(semaphore=semaphore, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SemaphoreSignalOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sem_signal"

  _ODS_OPERAND_SEGMENTS = [1,1,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, amount, *, device_id=None, core_id=None, core_type=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(semaphore))
    operands.append(_get_op_result_or_value(amount))
    operands.append(_get_op_result_or_value(device_id) if device_id is not None else None)
    operands.append(_get_op_result_or_value(core_id) if core_id is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    if core_type is not None: attributes["core_type"] = (core_type if (
        isinstance(core_type, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TPU_CoreTypeEnum')) else
          _ods_ir.AttrBuilder.get('TPU_CoreTypeEnum')(core_type, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def semaphore(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def amount(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def device_id(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def core_id(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def core_type(self):
    if "core_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["core_type"]

  @core_type.setter
  def core_type(self, value):
    if value is not None:
      self.operation.attributes["core_type"] = value
    elif "core_type" in self.operation.attributes:
      del self.operation.attributes["core_type"]

  @core_type.deleter
  def core_type(self):
    del self.operation.attributes["core_type"]

def sem_signal(semaphore, amount, *, device_id=None, core_id=None, core_type=None, loc=None, ip=None) -> _ods_ir.Operation:
  return SemaphoreSignalOp(semaphore=semaphore, amount=amount, device_id=device_id, core_id=core_id, core_type=core_type, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SemaphoreWaitOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sem_wait"

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, amount, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(semaphore))
    operands.append(_get_op_result_or_value(amount))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def semaphore(self):
    return self.operation.operands[0]

  @builtins.property
  def amount(self):
    return self.operation.operands[1]

def sem_wait(semaphore, amount, *, loc=None, ip=None) -> _ods_ir.Operation:
  return SemaphoreWaitOp(semaphore=semaphore, amount=amount, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ShuffledLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.shuffled_load"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, sublane_mask, sublane_offsets, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sublane_mask"] = (sublane_mask if (
    isinstance(sublane_mask, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(sublane_mask, context=_ods_context))
    attributes["sublane_offsets"] = (sublane_offsets if (
    isinstance(sublane_offsets, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(sublane_offsets, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def sublane_mask(self):
    return self.operation.attributes["sublane_mask"]

  @sublane_mask.setter
  def sublane_mask(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_mask"] = value

  @builtins.property
  def sublane_offsets(self):
    return self.operation.attributes["sublane_offsets"]

  @sublane_offsets.setter
  def sublane_offsets(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_offsets"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def shuffled_load(result, base, indices, sublane_mask, sublane_offsets, *, loc=None, ip=None) -> _ods_ir.Value:
  return ShuffledLoadOp(result=result, base=base, indices=indices, sublane_mask=sublane_mask, sublane_offsets=sublane_offsets, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ShuffledStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.shuffled_store"

  _ODS_REGIONS = (0, True)

  def __init__(self, valueToStore, base, indices, sublane_mask, sublane_offsets, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(valueToStore))
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sublane_mask"] = (sublane_mask if (
    isinstance(sublane_mask, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(sublane_mask, context=_ods_context))
    attributes["sublane_offsets"] = (sublane_offsets if (
    isinstance(sublane_offsets, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(sublane_offsets, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def valueToStore(self):
    return self.operation.operands[0]

  @builtins.property
  def base(self):
    return self.operation.operands[1]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def sublane_mask(self):
    return self.operation.attributes["sublane_mask"]

  @sublane_mask.setter
  def sublane_mask(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_mask"] = value

  @builtins.property
  def sublane_offsets(self):
    return self.operation.attributes["sublane_offsets"]

  @sublane_offsets.setter
  def sublane_offsets(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_offsets"] = value

def shuffled_store(value_to_store, base, indices, sublane_mask, sublane_offsets, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ShuffledStoreOp(valueToStore=value_to_store, base=base, indices=indices, sublane_mask=sublane_mask, sublane_offsets=sublane_offsets, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class StoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.store"

  _ODS_OPERAND_SEGMENTS = [1,1,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, valueToStore, base, indices, sublane_mask, *, mask=None, sublane_stride=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(valueToStore))
    operands.append(_get_op_result_or_value(base))
    operands.append(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask) if mask is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sublane_mask"] = (sublane_mask if (
    isinstance(sublane_mask, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(sublane_mask, context=_ods_context))
    if sublane_stride is not None: attributes["sublane_stride"] = (sublane_stride if (
        isinstance(sublane_stride, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(sublane_stride, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def valueToStore(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def base(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def indices(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def mask(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def sublane_mask(self):
    return self.operation.attributes["sublane_mask"]

  @sublane_mask.setter
  def sublane_mask(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_mask"] = value

  @builtins.property
  def sublane_stride(self):
    if "sublane_stride" not in self.operation.attributes:
      return None
    return self.operation.attributes["sublane_stride"]

  @sublane_stride.setter
  def sublane_stride(self, value):
    if value is not None:
      self.operation.attributes["sublane_stride"] = value
    elif "sublane_stride" in self.operation.attributes:
      del self.operation.attributes["sublane_stride"]

  @sublane_stride.deleter
  def sublane_stride(self):
    del self.operation.attributes["sublane_stride"]

def store(value_to_store, base, indices, sublane_mask, *, mask=None, sublane_stride=None, loc=None, ip=None) -> _ods_ir.Operation:
  return StoreOp(valueToStore=value_to_store, base=base, indices=indices, sublane_mask=sublane_mask, mask=mask, sublane_stride=sublane_stride, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class StridedLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.strided_load"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["strides"] = (strides if (
    isinstance(strides, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(strides, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def strides(self):
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def strided_load(result, base, indices, strides, *, loc=None, ip=None) -> _ods_ir.Value:
  return StridedLoadOp(result=result, base=base, indices=indices, strides=strides, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class StridedStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.strided_store"

  _ODS_REGIONS = (0, True)

  def __init__(self, valueToStore, base, indices, strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(valueToStore))
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["strides"] = (strides if (
    isinstance(strides, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(strides, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def valueToStore(self):
    return self.operation.operands[0]

  @builtins.property
  def base(self):
    return self.operation.operands[1]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def strides(self):
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

def strided_store(value_to_store, base, indices, strides, *, loc=None, ip=None) -> _ods_ir.Operation:
  return StridedStoreOp(valueToStore=value_to_store, base=base, indices=indices, strides=strides, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TraceOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.trace"

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, message, level, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["message"] = (message if (
    isinstance(message, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    attributes["level"] = (level if (
    isinstance(level, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(level, context=_ods_context))
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def message(self):
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["message"] = value

  @builtins.property
  def level(self):
    return self.operation.attributes["level"]

  @level.setter
  def level(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["level"] = value

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self):
    return self.regions[0]

def trace(results_, message, level, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(TraceOp(results_=results_, message=message, level=level, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TraceStartOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.trace_start"

  _ODS_REGIONS = (0, True)

  def __init__(self, message, level, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["message"] = (message if (
    isinstance(message, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    attributes["level"] = (level if (
    isinstance(level, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(level, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def message(self):
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["message"] = value

  @builtins.property
  def level(self):
    return self.operation.attributes["level"]

  @level.setter
  def level(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["level"] = value

def trace_start(message, level, *, loc=None, ip=None) -> _ods_ir.Operation:
  return TraceStartOp(message=message, level=level, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TraceStopOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.trace_stop"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def trace_stop(*, loc=None, ip=None) -> _ods_ir.Operation:
  return TraceStopOp(loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class UnpackSubelementsOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.unpack_subelements"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, source, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["index"] = (index if (
    isinstance(index, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(index, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.attributes["index"]

  @index.setter
  def index(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["index"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

def unpack_subelements(output, source, index, *, loc=None, ip=None) -> _ods_ir.Value:
  return UnpackSubelementsOp(output=output, source=source, index=index, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class UnrollVectorsOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.unroll_vectors"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(output)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def unroll_vectors(output, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UnrollVectorsOp(output=output, input=input, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VectorStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.vector_store"

  _ODS_OPERAND_SEGMENTS = [1,1,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, valueToStore, base, indices, strides, *, mask=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(valueToStore))
    operands.append(_get_op_result_or_value(base))
    operands.append(_get_op_results_or_values(indices))
    operands.append(_get_op_result_or_value(mask) if mask is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["strides"] = (strides if (
    isinstance(strides, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(strides, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def valueToStore(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def base(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def indices(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def mask(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def strides(self):
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

def vector_store(value_to_store, base, indices, strides, *, mask=None, loc=None, ip=None) -> _ods_ir.Operation:
  return VectorStoreOp(valueToStore=value_to_store, base=base, indices=indices, strides=strides, mask=mask, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class WaitDMAOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.wait_dma"

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, ref, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(semaphore))
    operands.append(_get_op_result_or_value(ref))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def semaphore(self):
    return self.operation.operands[0]

  @builtins.property
  def ref(self):
    return self.operation.operands[1]

def wait_dma(semaphore, ref, *, loc=None, ip=None) -> _ods_ir.Operation:
  return WaitDMAOp(semaphore=semaphore, ref=ref, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(results_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(results_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return YieldOp(results_=results_, loc=loc, ip=ip)
