import os
import subprocess

# Define the paths to the input and output folders
input_folder = "input"  # Pasta de entrada
output_folder = "output"  # Pasta de saída

# Ensure the output folder exists
os.makedirs(output_folder, exist_ok=True)

# List all .wav files in the input folder
wav_files = [f for f in os.listdir(input_folder) if f.endswith('.wav')]

# Caminho absoluto para o Python do venv
python_path = os.path.join(os.path.dirname(__file__), 'venv', 'Scripts', 'python.exe')

# Process each .wav file using the audiosr command
for wav_file in wav_files:
    input_path = os.path.join(input_folder, wav_file)
    output_path = os.path.join(output_folder, wav_file)  # Output file path

    # Execute the audiosr command
    command = [
        python_path,  # Python do ambiente virtual
        os.path.join(os.path.dirname(__file__), 'audiosr', '__main__.py'),  # Caminho absoluto para o script
        '-i', input_path,
        '-s', output_folder,
        '--model_name', 'speech',
        '-d', 'cuda',
        '--ddim_steps', '50',
        '-gs', '3',
        '--seed', '42'
    ]

    # Executa o comando e aguarda a conclusão
    subprocess.run(command)
