# Generate simple instance map from the complex instance map

import os
#import cv2
import scipy.misc as misc
import numpy as np
import os
###########################Display image##################################################################
def show(Im,Name="img")  :
    cv2.imshow(Name,Im.astype(np.uint8))
    cv2.waitKey()
    cv2.destroyAllWindows()
##############################################################################################
CatName={}
CatName[1]='Vessel'
CatName[2]='V Label'
CatName[3]='V Cork'
CatName[4]='V Parts GENERAL'
CatName[5]='Ignore'
CatName[6]='Liquid GENERAL'
CatName[7]='Liquid Suspension'
CatName[8]='Foam'
CatName[9]='Gel'
CatName[10]='Solid GENERAL'
CatName[11]='Granular'
CatName[12]='Powder'
CatName[13]='Solid Bulk'
CatName[14]='Vapor'
CatName[15]='Other Material'
CatName[16]='Filled'
###############################################################################################
##############################################################################################
MainDir=r"..\..\Complex\TrainAnnotations\\"
#"../../Complex/TestAnnotations/"

Out=r"..\Train/"
OutImg=Out+"/Image/"
OutAnn=Out+"/Instance/"

if not os.path.exists(Out): os.mkdir(Out)
if not os.path.exists(OutImg): os.mkdir(OutImg)
if not os.path.exists(OutAnn): os.mkdir(OutAnn)
#############################################################################################
CatDic={}
for AnnDir in os.listdir(MainDir):
        print(AnnDir)
        CatDic[AnnDir]={}
        CatDic[AnnDir]["PartCats"]={} # categories of each part instance
        CatDic[AnnDir]["MaterialCats"] = {} # Categories of each material intace
        CatDic[AnnDir]["MultiPhaseMaterial"] = [] # list of instance of materials which are part of a multiphase system
        CatDic[AnnDir]["MultiPhaseVessels"] = [] # list of vessel instance of containing multiphase materials
        Im = cv2.imread(MainDir+"/"+AnnDir + "/Image.png")
        UnifiedMask=np.zeros([Im.shape[0],Im.shape[1],3],dtype=np.uint8)
       # if not os.path.isdir(InstDir): continue
# ----------------------Materials--------------------------------------------------------------------------
        NumInstance = 0
        InstDir = MainDir + "/" + AnnDir + r"/Material//"
        for Name in os.listdir(InstDir):
            CatString = ""
            if "CatID_" in Name:
                  CatString = Name[Name.find("CatID_") + 6:Name.find(".png")]
            ListCat = []
            while (len(CatString) > 0):
                if "_" in CatString:
                    ID = int(CatString[:CatString.find("_")])
                else:
                    ID = int(CatString)
                    CatString = ""
                if not ID in ListCat: ListCat.append(CatName[ID])
                CatString = CatString[CatString.find("_") + 1:]
            if (7 in ListCat) and (not 6 in ListCat):   ListCat.append(CatName[6])
            if ((11 in ListCat) or (12 in ListCat) or (13 in ListCat))and (not 10 in ListCat):   ListCat.append(CatName[10])
            AnnMask = cv2.imread(InstDir+"/"+Name)

            NumInstance+=1
            UnifiedMask[:,:,0][(AnnMask[:,:,0] > 0) * (AnnMask[:,:,0]  < 3)>0]=NumInstance
            UnifiedMask[:,:,0][AnnMask[:, :, 2] == 7]=254
            CatDic[AnnDir]["MaterialCats"][NumInstance]=ListCat

# ----------------------------Parts--------------------------------------------------------------------
        NumInstance = 0
        InstDir = MainDir + "/" + AnnDir + r"/Parts//"
        for Name in os.listdir(InstDir):
            CatString = ""
            if "CatID_" in Name:
                  CatString = Name[Name.find("CatID_") + 6:Name.find(".png")]
            ListCat = []
            while (len(CatString) > 0):
                if "_" in CatString:
                    ID = int(CatString[:CatString.find("_")])
                else:
                    ID = int(CatString)
                    CatString = ""
                if not ID in ListCat: ListCat.append(CatName[ID])
                CatString = CatString[CatString.find("_") + 1:]
            AnnMask = cv2.imread(InstDir+"/"+Name)

            NumInstance+=1
            UnifiedMask[:,:,1][(AnnMask[:,:,0] > 0) * (AnnMask[:,:,0]  < 3)>0]=NumInstance
            UnifiedMask[:,:,1][AnnMask[:, :, 2] == 7]=254
            CatDic[AnnDir]["PartCats"][NumInstance] = ListCat



# ----------------------------Vessels--------------------------------------------------------------------
        NumInstance = 0
        InstDir = MainDir + "/" + AnnDir + r"/Vessel//"
        for Name in os.listdir(InstDir):
            AnnMask = cv2.imread(InstDir+"/"+Name)
            NumInstance+=1
            UnifiedMask[:,:,2][(AnnMask[:,:,0] > 0) * (AnnMask[:,:,0]  < 3)>0]=NumInstance
            UnifiedMask[:,:,2][AnnMask[:, :, 2] == 7]=254



# ----------------------------MultiPhase--------------------------------------------------------------------
        for i in  range(1,UnifiedMask[:,:,2].max()+1):
                      if i not in UnifiedMask[:,:,2] : continue
                      lphase=np.unique((UnifiedMask[:, :, 2] == i).astype(np.uint8)*UnifiedMask[:, :, 0])


                      if len(lphase)>2:
                          CatDic[AnnDir]["MultiPhaseVessels"].append(int(i))
                          for j in lphase:
                              if j==0: continue
                              CatDic[AnnDir]["MultiPhaseMaterial"].append(int(j))

#----------------------------------------------------------------------------------------------------------------
        cv2.imwrite(OutAnn+"/"+AnnDir+".png",UnifiedMask)
        cv2.imwrite(OutImg + "/" + AnnDir + ".jpg", Im)

import json
with open(Out+'//InstCategory.json', 'w') as fp:
        json.dump(CatDic,indent=4,fp=fp)
#############################DISPLAY#################################################################################
##############################DISPLAY###############################################################################
#############################DISPLAY#######################################################################################
#==================================================================================================================
        #####Materials
        # if True: #254 in UnifiedMask:
        #     for i in  range(1,UnifiedMask[:,:,0].max()+1):
        #              if i not in UnifiedMask[:,:,0]: continue
        #              I=Im.copy()
        #              I[:, :, 0] *= 1 - (UnifiedMask[:, :, 0] == i).astype(np.uint8)
        #              I[:, :, 1] *= 1 - (UnifiedMask[:, :, 0] == i).astype(np.uint8)
        #              I[:, :, 2] *= 1 - (UnifiedMask[:, :, 0] == 254).astype(np.uint8)
        #              mp=""
        #              if i in CatDic[AnnDir]["MultiPhaseMaterial"]: mp="Multiphase"
        #              show(I,"material"+str(CatDic[AnnDir]["MaterialCats"][i])+mp)
        # ########Parts
        # if 1: #254 in UnifiedMask:
        #     for i in  range(1,UnifiedMask[:,:,1].max()+1):
        #              if i not in UnifiedMask[:,:,1]: continue
        #              I=Im.copy()
        #              I[:, :, 0] *= 1 - (UnifiedMask[:, :, 1] == i).astype(np.uint8)
        #              I[:, :, 1] *= 1 - (UnifiedMask[:, :, 1] == i).astype(np.uint8)
        #              I[:, :, 2] *= 1 - (UnifiedMask[:, :, 1] == 254).astype(np.uint8)
        #
        #              show(I,"parts"+str(CatDic[AnnDir]["PartCats"][i]))
        # #####Vessel
        # if 1: #254 in UnifiedMask:
        #     for i in  range(1,UnifiedMask[:,:,2].max()+1):
        #              if i not in UnifiedMask[:,:,2] : continue
        #              I=Im.copy()
        #              I[:, :, 0] *= 1 - (UnifiedMask[:, :, 2] == i).astype(np.uint8)
        #              I[:, :, 1] *= 1 - (UnifiedMask[:, :, 2] == i).astype(np.uint8)
        #              I[:, :, 2] *= 1 - (UnifiedMask[:, :, 2] == 254).astype(np.uint8)
        #              mp=""
        #              if i in CatDic[AnnDir]["MultiPhaseVessels"]: mp="Multiphase"
        #              show(I,"vessel"+mp)

