import{s as Ws,o as Qs,n as _}from"../chunks/scheduler.1d51f4c0.js";import{S as vs,i as Ss,g as w,s as U,r as m,A as Rs,h as u,f as p,c as J,j as ms,u as d,x as B,k as Gs,y as V,a as j,v as A,d as g,t as f,w as b}from"../chunks/index.fda43871.js";import{T as ds}from"../chunks/Tip.e808fe4c.js";import{C as Y}from"../chunks/CodeBlock.16130beb.js";import{H as D,E as ks}from"../chunks/getInferenceSnippets.58a43ad0.js";import{H as Ms,a as X}from"../chunks/HfOption.42596235.js";function zs(h){let l,i="<strong>Tech Stack</strong>: Gradio (for the UI) + Inference Providers (for the AI)";return{c(){l=w("p"),l.innerHTML=i},l(e){l=u(e,"P",{"data-svelte-h":!0}),B(l)!=="svelte-6re1qd"&&(l.innerHTML=i)},m(e,t){j(e,l,t)},p:_,d(e){e&&p(l)}}}function Vs(h){let l,i="<strong>Tech Stack</strong>: HTML/JavaScript (for the UI) + Inference Providers (for the AI)",e,t,s='We’ll use HTML and JavaScript for the UI just to keep things simple and agnostic, but if you want to see more mature examples, you can check out the <a href="https://huggingface.co/huggingfacejs/spaces" rel="nofollow">Hugging Face JS spaces</a> page.';return{c(){l=w("p"),l.innerHTML=i,e=U(),t=w("p"),t.innerHTML=s},l(n){l=u(n,"P",{"data-svelte-h":!0}),B(l)!=="svelte-scf74u"&&(l.innerHTML=i),e=J(n),t=u(n,"P",{"data-svelte-h":!0}),B(t)!=="svelte-180edvt"&&(t.innerHTML=s)},m(n,r){j(n,l,r),j(n,e,r),j(n,t,r)},p:_,d(n){n&&(p(l),p(e),p(t))}}}function Ys(h){let l,i,e,t;return l=new X({props:{id:"tech-stack",option:"python",$$slots:{default:[zs]},$$scope:{ctx:h}}}),e=new X({props:{id:"tech-stack",option:"javascript",$$slots:{default:[Vs]},$$scope:{ctx:h}}}),{c(){m(l.$$.fragment),i=U(),m(e.$$.fragment)},l(s){d(l.$$.fragment,s),i=J(s),d(e.$$.fragment,s)},m(s,n){A(l,s,n),j(s,i,n),A(e,s,n),t=!0},p(s,n){const r={};n&2&&(r.$$scope={dirty:n,ctx:s}),l.$set(r);const M={};n&2&&(M.$$scope={dirty:n,ctx:s}),e.$set(M)},i(s){t||(g(l.$$.fragment,s),g(e.$$.fragment,s),t=!0)},o(s){f(l.$$.fragment,s),f(e.$$.fragment,s),t=!1},d(s){s&&p(i),b(l,s),b(e,s)}}}function Xs(h){let l,i="Before we start coding, authenticate with Hugging Face using the CLI:",e,t,s,n,r='When prompted, paste your Hugging Face token. This handles authentication automatically for all your inference calls. You can generate one from <a href="https://huggingface.co/settings/tokens/new?ownUserPermissions=inference.serverless.write&amp;tokenType=fineGrained" rel="nofollow">your settings page</a>.',M;return t=new Y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1YiUwQWhmJTIwYXV0aCUyMGxvZ2lu",highlighted:`pip install huggingface_hub
hf auth login`,wrap:!1}}),{c(){l=w("p"),l.textContent=i,e=U(),m(t.$$.fragment),s=U(),n=w("p"),n.innerHTML=r},l(c){l=u(c,"P",{"data-svelte-h":!0}),B(l)!=="svelte-1frpmc9"&&(l.textContent=i),e=J(c),d(t.$$.fragment,c),s=J(c),n=u(c,"P",{"data-svelte-h":!0}),B(n)!=="svelte-7amyfj"&&(n.innerHTML=r)},m(c,y){j(c,l,y),j(c,e,y),A(t,c,y),j(c,s,y),j(c,n,y),M=!0},p:_,i(c){M||(g(t.$$.fragment,c),M=!0)},o(c){f(t.$$.fragment,c),M=!1},d(c){c&&(p(l),p(e),p(s),p(n)),b(t,c)}}}function _s(h){let l,i="When we deploy our app to Hugging Face Spaces, we’ll need to add our token as a secret. This is a secure way to handle the token and avoid exposing it in the code.";return{c(){l=w("p"),l.textContent=i},l(e){l=u(e,"P",{"data-svelte-h":!0}),B(l)!=="svelte-8y62za"&&(l.textContent=i)},m(e,t){j(e,l,t)},p:_,d(e){e&&p(l)}}}function xs(h){let l,i='You’ll need your Hugging Face token. Get one from <a href="https://huggingface.co/settings/tokens/new?ownUserPermissions=inference.serverless.write&amp;tokenType=fineGrained" rel="nofollow">your settings page</a>. We can set it as an environment variable in our app.',e,t,s,n,r,M,c;return t=new Y({props:{code:"ZXhwb3J0JTIwSEZfVE9LRU4lM0QlMjJ5b3VyX3Rva2VuX2hlcmUlMjI=",highlighted:'<span class="hljs-built_in">export</span> HF_TOKEN=<span class="hljs-string">&quot;your_token_here&quot;</span>',wrap:!1}}),n=new Y({props:{code:"JTJGJTJGJTIwQWRkJTIweW91ciUyMHRva2VuJTIwYXQlMjB0aGUlMjB0b3AlMjBvZiUyMHlvdXIlMjBzY3JpcHQlMEFjb25zdCUyMEhGX1RPS0VOJTIwJTNEJTIwcHJvY2Vzcy5lbnYuSEZfVE9LRU4lM0I=",highlighted:`<span class="hljs-comment">// Add your token at the top of your script</span>
<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>;`,wrap:!1}}),M=new ds({props:{warning:!0,$$slots:{default:[_s]},$$scope:{ctx:h}}}),{c(){l=w("p"),l.innerHTML=i,e=U(),m(t.$$.fragment),s=U(),m(n.$$.fragment),r=U(),m(M.$$.fragment)},l(y){l=u(y,"P",{"data-svelte-h":!0}),B(l)!=="svelte-72y8m9"&&(l.innerHTML=i),e=J(y),d(t.$$.fragment,y),s=J(y),d(n.$$.fragment,y),r=J(y),d(M.$$.fragment,y)},m(y,$){j(y,l,$),j(y,e,$),A(t,y,$),j(y,s,$),A(n,y,$),j(y,r,$),A(M,y,$),c=!0},p(y,$){const E={};$&2&&(E.$$scope={dirty:$,ctx:y}),M.$set(E)},i(y){c||(g(t.$$.fragment,y),g(n.$$.fragment,y),g(M.$$.fragment,y),c=!0)},o(y){f(t.$$.fragment,y),f(n.$$.fragment,y),f(M.$$.fragment,y),c=!1},d(y){y&&(p(l),p(e),p(s),p(r)),b(t,y),b(n,y),b(M,y)}}}function Hs(h){let l,i,e,t;return l=new X({props:{id:"auth",option:"python",$$slots:{default:[Xs]},$$scope:{ctx:h}}}),e=new X({props:{id:"auth",option:"javascript",$$slots:{default:[xs]},$$scope:{ctx:h}}}),{c(){m(l.$$.fragment),i=U(),m(e.$$.fragment)},l(s){d(l.$$.fragment,s),i=J(s),d(e.$$.fragment,s)},m(s,n){A(l,s,n),j(s,i,n),A(e,s,n),t=!0},p(s,n){const r={};n&2&&(r.$$scope={dirty:n,ctx:s}),l.$set(r);const M={};n&2&&(M.$$scope={dirty:n,ctx:s}),e.$set(M)},i(s){t||(g(l.$$.fragment,s),g(e.$$.fragment,s),t=!0)},o(s){f(l.$$.fragment,s),f(e.$$.fragment,s),t=!1},d(s){s&&p(i),b(l,s),b(e,s)}}}function Fs(h){let l,i="Now let’s create a simple web interface using Gradio:",e,t,s,n,r="Here we’re using Gradio’s <code>gr.Audio</code> component to either upload an audio file or use the microphone input. We’re keeping things simple with two outputs: a transcript and a summary with action items.",M;return t=new Y({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnQlMEElMEFkZWYlMjBwcm9jZXNzX21lZXRpbmdfYXVkaW8oYXVkaW9fZmlsZSklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJQcm9jZXNzJTIwdXBsb2FkZWQlMjBhdWRpbyUyMGZpbGUlMjBhbmQlMjByZXR1cm4lMjB0cmFuc2NyaXB0JTIwJTJCJTIwc3VtbWFyeSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwYXVkaW9fZmlsZSUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMlBsZWFzZSUyMHVwbG9hZCUyMGFuJTIwYXVkaW8lMjBmaWxlLiUyMiUyQyUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFdlJ2xsJTIwaW1wbGVtZW50JTIwdGhlJTIwQUklMjBsb2dpYyUyMG5leHQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJUcmFuc2NyaXB0JTIwd2lsbCUyMGFwcGVhciUyMGhlcmUuLi4lMjIlMkMlMjAlMjJTdW1tYXJ5JTIwd2lsbCUyMGFwcGVhciUyMGhlcmUuLi4lMjIlMEElMEElMjMlMjBDcmVhdGUlMjB0aGUlMjBHcmFkaW8lMjBpbnRlcmZhY2UlMEFhcHAlMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0Rwcm9jZXNzX21lZXRpbmdfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyhsYWJlbCUzRCUyMlVwbG9hZCUyME1lZXRpbmclMjBBdWRpbyUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3IuVGV4dGJveChsYWJlbCUzRCUyMlRyYW5zY3JpcHQlMjIlMkMlMjBsaW5lcyUzRDEwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3gobGFiZWwlM0QlMjJTdW1tYXJ5JTIwJTI2JTIwQWN0aW9uJTIwSXRlbXMlMjIlMkMlMjBsaW5lcyUzRDgpJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjIlRjAlOUYlOEUlQTQlMjBBSSUyME1lZXRpbmclMjBOb3RlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyVXBsb2FkJTIwYW4lMjBhdWRpbyUyMGZpbGUlMjB0byUyMGdldCUyMGFuJTIwaW5zdGFudCUyMHRyYW5zY3JpcHQlMjBhbmQlMjBzdW1tYXJ5JTIwd2l0aCUyMGFjdGlvbiUyMGl0ZW1zLiUyMiUwQSklMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBhcHAubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_meeting_audio</span>(<span class="hljs-params">audio_file</span>):
    <span class="hljs-string">&quot;&quot;&quot;Process uploaded audio file and return transcript + summary&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_file <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Please upload an audio file.&quot;</span>, <span class="hljs-string">&quot;&quot;</span>
    
    <span class="hljs-comment"># We&#x27;ll implement the AI logic next</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Transcript will appear here...&quot;</span>, <span class="hljs-string">&quot;Summary will appear here...&quot;</span>

<span class="hljs-comment"># Create the Gradio interface</span>
app = gr.Interface(
    fn=process_meeting_audio,
    inputs=gr.Audio(label=<span class="hljs-string">&quot;Upload Meeting Audio&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=[
        gr.Textbox(label=<span class="hljs-string">&quot;Transcript&quot;</span>, lines=<span class="hljs-number">10</span>),
        gr.Textbox(label=<span class="hljs-string">&quot;Summary &amp; Action Items&quot;</span>, lines=<span class="hljs-number">8</span>)
    ],
    title=<span class="hljs-string">&quot;🎤 AI Meeting Notes&quot;</span>,
    description=<span class="hljs-string">&quot;Upload an audio file to get an instant transcript and summary with action items.&quot;</span>
)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    app.launch()`,wrap:!1}}),{c(){l=w("p"),l.textContent=i,e=U(),m(t.$$.fragment),s=U(),n=w("p"),n.innerHTML=r},l(c){l=u(c,"P",{"data-svelte-h":!0}),B(l)!=="svelte-agnmrx"&&(l.textContent=i),e=J(c),d(t.$$.fragment,c),s=J(c),n=u(c,"P",{"data-svelte-h":!0}),B(n)!=="svelte-mdm151"&&(n.innerHTML=r)},m(c,y){j(c,l,y),j(c,e,y),A(t,c,y),j(c,s,y),j(c,n,y),M=!0},p:_,i(c){M||(g(t.$$.fragment,c),M=!0)},o(c){f(t.$$.fragment,c),M=!1},d(c){c&&(p(l),p(e),p(s),p(n)),b(t,c)}}}function qs(h){let l,i="For JavaScript, we’ll create a clean HTML interface with native file upload and a simple loading state:",e,t,s,n,r="This creates a clean drag-and-drop interface with styled results sections for the transcript and summary.",M,c,y="Our application can then use the <code>InferenceClient</code> from <code>huggingface.js</code> to call the transcription and summarization functions.",$,E,N,v,W="We’ll also need to implement the <code>transcribe</code> and <code>summarize</code> functions.",G;return t=new Y({props:{code:"JTNDYm9keSUzRSUwQSUyMCUyMCUyMCUyMCUzQ2gxJTNFJUYwJTlGJThFJUE0JTIwQUklMjBNZWV0aW5nJTIwTm90ZXMlM0MlMkZoMSUzRSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUzQ2RpdiUyMGNsYXNzJTNEJTIydXBsb2FkJTIyJTIwb25jbGljayUzRCUyMmRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCdmaWxlJykuY2xpY2soKSUyMiUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzQ2lucHV0JTIwdHlwZSUzRCUyMmZpbGUlMjIlMjBpZCUzRCUyMmZpbGUlMjIlMjBhY2NlcHQlM0QlMjJhdWRpbyUyRiolMjIlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0NwJTNFVXBsb2FkJTIwYXVkaW8lMjBmaWxlJTNDJTJGcCUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzQ2J1dHRvbiUyMHR5cGUlM0QlMjJidXR0b24lMjIlM0VDaG9vc2UlMjBGaWxlJTNDJTJGYnV0dG9uJTNFJTBBJTIwJTIwJTIwJTIwJTNDJTJGZGl2JTNFJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTNDZGl2JTIwY2xhc3MlM0QlMjJsb2FkaW5nJTIyJTIwaWQlM0QlMjJsb2FkaW5nJTIyJTNFUHJvY2Vzc2luZy4uLiUzQyUyRmRpdiUzRSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUzQ2RpdiUyMGNsYXNzJTNEJTIycmVzdWx0cyUyMiUyMGlkJTNEJTIycmVzdWx0cyUyMiUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzQ2RpdiUyMGNsYXNzJTNEJTIycmVzdWx0JTIyJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNDaDMlM0UlRjAlOUYlOTMlOUQlMjBUcmFuc2NyaXB0JTNDJTJGaDMlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0NkaXYlMjBpZCUzRCUyMnRyYW5zY3JpcHQlMjIlM0UlM0MlMkZkaXYlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0MlMkZkaXYlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0NkaXYlMjBjbGFzcyUzRCUyMnJlc3VsdCUyMiUzRSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzQ2gzJTNFJUYwJTlGJTkzJThCJTIwU3VtbWFyeSUzQyUyRmgzJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNDZGl2JTIwaWQlM0QlMjJzdW1tYXJ5JTIyJTNFJTNDJTJGZGl2JTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNDJTJGZGl2JTNFJTBBJTIwJTIwJTIwJTIwJTNDJTJGZGl2JTNFJTBBJTNDJTJGYm9keSUzRQ==",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">body</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">h1</span>&gt;</span>🎤 AI Meeting Notes<span class="hljs-tag">&lt;/<span class="hljs-name">h1</span>&gt;</span>
    
    <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;upload&quot;</span> <span class="hljs-attr">onclick</span>=<span class="hljs-string">&quot;document.getElementById(&#x27;file&#x27;).click()&quot;</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">input</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;file&quot;</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;file&quot;</span> <span class="hljs-attr">accept</span>=<span class="hljs-string">&quot;audio/*&quot;</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">p</span>&gt;</span>Upload audio file<span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">button</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;button&quot;</span>&gt;</span>Choose File<span class="hljs-tag">&lt;/<span class="hljs-name">button</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
    
    <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;loading&quot;</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;loading&quot;</span>&gt;</span>Processing...<span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
    
    <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;results&quot;</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;results&quot;</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;result&quot;</span>&gt;</span>
            <span class="hljs-tag">&lt;<span class="hljs-name">h3</span>&gt;</span>📝 Transcript<span class="hljs-tag">&lt;/<span class="hljs-name">h3</span>&gt;</span>
            <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;transcript&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
        <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;result&quot;</span>&gt;</span>
            <span class="hljs-tag">&lt;<span class="hljs-name">h3</span>&gt;</span>📋 Summary<span class="hljs-tag">&lt;/<span class="hljs-name">h3</span>&gt;</span>
            <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;summary&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
        <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
<span class="hljs-tag">&lt;/<span class="hljs-name">body</span>&gt;</span>`,wrap:!1}}),E=new Y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://esm.sh/@huggingface/inference&#x27;</span>;

<span class="hljs-comment">// Access the token from Hugging Face Spaces secrets</span>
<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-variable language_">window</span>.<span class="hljs-property">huggingface</span>?.<span class="hljs-property">variables</span>?.<span class="hljs-property">HF_TOKEN</span>;
<span class="hljs-comment">// Or if you&#x27;re running locally, you can set it as an environment variable</span>
<span class="hljs-comment">// const HF_TOKEN = ({}).HF_TOKEN;</span>

<span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;file&#x27;</span>).<span class="hljs-property">onchange</span> = <span class="hljs-keyword">async</span> (e) =&gt; {
    <span class="hljs-keyword">if</span> (!e.<span class="hljs-property">target</span>.<span class="hljs-property">files</span>[<span class="hljs-number">0</span>]) <span class="hljs-keyword">return</span>;
    
    <span class="hljs-keyword">const</span> file = e.<span class="hljs-property">target</span>.<span class="hljs-property">files</span>[<span class="hljs-number">0</span>];
    
    <span class="hljs-title function_">show</span>(<span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;loading&#x27;</span>));
    <span class="hljs-title function_">hide</span>(<span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;results&#x27;</span>), <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;error&#x27;</span>));
    
    <span class="hljs-keyword">try</span> {
        <span class="hljs-keyword">const</span> transcript = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcribe</span>(file);
        <span class="hljs-keyword">const</span> summary = <span class="hljs-keyword">await</span> <span class="hljs-title function_">summarize</span>(transcript);

        <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;transcript&#x27;</span>).<span class="hljs-property">textContent</span> = transcript;
        <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;summary&#x27;</span>).<span class="hljs-property">textContent</span> = summary;
        
        <span class="hljs-title function_">hide</span>(<span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;loading&#x27;</span>));
        <span class="hljs-title function_">show</span>(<span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;results&#x27;</span>));
    } <span class="hljs-keyword">catch</span> (error) {
        <span class="hljs-title function_">hide</span>(<span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;loading&#x27;</span>));
        <span class="hljs-title function_">showError</span>(<span class="hljs-string">\`Error: <span class="hljs-subst">\${error.message}</span>\`</span>);
    }
};`,wrap:!1}}),{c(){l=w("p"),l.textContent=i,e=U(),m(t.$$.fragment),s=U(),n=w("p"),n.textContent=r,M=U(),c=w("p"),c.innerHTML=y,$=U(),m(E.$$.fragment),N=U(),v=w("p"),v.innerHTML=W},l(I){l=u(I,"P",{"data-svelte-h":!0}),B(l)!=="svelte-vgyqps"&&(l.textContent=i),e=J(I),d(t.$$.fragment,I),s=J(I),n=u(I,"P",{"data-svelte-h":!0}),B(n)!=="svelte-cuvxj4"&&(n.textContent=r),M=J(I),c=u(I,"P",{"data-svelte-h":!0}),B(c)!=="svelte-1j055fb"&&(c.innerHTML=y),$=J(I),d(E.$$.fragment,I),N=J(I),v=u(I,"P",{"data-svelte-h":!0}),B(v)!=="svelte-160ro2n"&&(v.innerHTML=W)},m(I,Z){j(I,l,Z),j(I,e,Z),A(t,I,Z),j(I,s,Z),j(I,n,Z),j(I,M,Z),j(I,c,Z),j(I,$,Z),A(E,I,Z),j(I,N,Z),j(I,v,Z),G=!0},p:_,i(I){G||(g(t.$$.fragment,I),g(E.$$.fragment,I),G=!0)},o(I){f(t.$$.fragment,I),f(E.$$.fragment,I),G=!1},d(I){I&&(p(l),p(e),p(s),p(n),p(M),p(c),p($),p(N),p(v)),b(t,I),b(E,I)}}}function Ls(h){let l,i,e,t;return l=new X({props:{id:"ui",option:"python",$$slots:{default:[Fs]},$$scope:{ctx:h}}}),e=new X({props:{id:"ui",option:"javascript",$$slots:{default:[qs]},$$scope:{ctx:h}}}),{c(){m(l.$$.fragment),i=U(),m(e.$$.fragment)},l(s){d(l.$$.fragment,s),i=J(s),d(e.$$.fragment,s)},m(s,n){A(l,s,n),j(s,i,n),A(e,s,n),t=!0},p(s,n){const r={};n&2&&(r.$$scope={dirty:n,ctx:s}),l.$set(r);const M={};n&2&&(M.$$scope={dirty:n,ctx:s}),e.$set(M)},i(s){t||(g(l.$$.fragment,s),g(e.$$.fragment,s),t=!0)},o(s){f(l.$$.fragment,s),f(e.$$.fragment,s),t=!1},d(s){s&&p(i),b(l,s),b(e,s)}}}function Ds(h){let l,i='We’ll use the <code>auto</code> provider to automatically select the first available provider for the model. You can define your own priority list of providers in the <a href="https://huggingface.co/settings/inference-providers" rel="nofollow">Inference Providers</a> page.';return{c(){l=w("p"),l.innerHTML=i},l(e){l=u(e,"P",{"data-svelte-h":!0}),B(l)!=="svelte-na730p"&&(l.innerHTML=i)},m(e,t){j(e,l,t)},p:_,d(e){e&&p(l)}}}function Ks(h){let l,i="Now let’s implement the transcription using OpenAI’s <code>whisper-large-v3</code> model for fast, reliable speech processing.",e,t,s,n,r;return t=new ds({props:{$$slots:{default:[Ds]},$$scope:{ctx:h}}}),n=new Y({props:{code:"ZGVmJTIwdHJhbnNjcmliZV9hdWRpbyhhdWRpb19maWxlX3BhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyVHJhbnNjcmliZSUyMGF1ZGlvJTIwdXNpbmclMjBmYWwuYWklMjBmb3IlMjBzcGVlZCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMmF1dG8lMjIpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUGFzcyUyMHRoZSUyMGZpbGUlMjBwYXRoJTIwZGlyZWN0bHklMjAtJTIwdGhlJTIwY2xpZW50JTIwaGFuZGxlcyUyMGZpbGUlMjByZWFkaW5nJTBBJTIwJTIwJTIwJTIwdHJhbnNjcmlwdCUyMCUzRCUyMGNsaWVudC5hdXRvbWF0aWNfc3BlZWNoX3JlY29nbml0aW9uKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTNEYXVkaW9fZmlsZV9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJvcGVuYWklMkZ3aGlzcGVyLWxhcmdlLXYzJTIyJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRyYW5zY3JpcHQudGV4dA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio_file_path</span>):
    <span class="hljs-string">&quot;&quot;&quot;Transcribe audio using fal.ai for speed&quot;&quot;&quot;</span>
    client = InferenceClient(provider=<span class="hljs-string">&quot;auto&quot;</span>)
    
    <span class="hljs-comment"># Pass the file path directly - the client handles file reading</span>
    transcript = client.automatic_speech_recognition(
        audio=audio_file_path,
        model=<span class="hljs-string">&quot;openai/whisper-large-v3&quot;</span>
    )
    
    <span class="hljs-keyword">return</span> transcript.text`,wrap:!1}}),{c(){l=w("p"),l.innerHTML=i,e=U(),m(t.$$.fragment),s=U(),m(n.$$.fragment)},l(M){l=u(M,"P",{"data-svelte-h":!0}),B(l)!=="svelte-yyu0ez"&&(l.innerHTML=i),e=J(M),d(t.$$.fragment,M),s=J(M),d(n.$$.fragment,M)},m(M,c){j(M,l,c),j(M,e,c),A(t,M,c),j(M,s,c),A(n,M,c),r=!0},p(M,c){const y={};c&2&&(y.$$scope={dirty:c,ctx:M}),t.$set(y)},i(M){r||(g(t.$$.fragment,M),g(n.$$.fragment,M),r=!0)},o(M){f(t.$$.fragment,M),f(n.$$.fragment,M),r=!1},d(M){M&&(p(l),p(e),p(s)),b(t,M),b(n,M)}}}function Ps(h){let l,i='We’ll use the <code>auto</code> provider to automatically select the first available provider for the model. You can define your own priority list of providers in the <a href="https://huggingface.co/settings/inference-providers" rel="nofollow">Inference Providers</a> page.';return{c(){l=w("p"),l.innerHTML=i},l(e){l=u(e,"P",{"data-svelte-h":!0}),B(l)!=="svelte-na730p"&&(l.innerHTML=i)},m(e,t){j(e,l,t)},p:_,d(e){e&&p(l)}}}function Os(h){let l,i="Now let’s implement the transcription using OpenAI’s <code>whisper-large-v3</code> model for fast, reliable speech processing.",e,t,s,n,r;return t=new ds({props:{$$slots:{default:[Ps]},$$scope:{ctx:h}}}),n=new Y({props:{code:"aW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCdodHRwcyUzQSUyRiUyRmVzbS5zaCUyRiU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJyUzQiUwQSUwQWFzeW5jJTIwZnVuY3Rpb24lMjB0cmFuc2NyaWJlKGZpbGUpJTIwJTdCJTBBJTIwJTIwJTIwJTIwY29uc3QlMjBjbGllbnQlMjAlM0QlMjBuZXclMjBJbmZlcmVuY2VDbGllbnQoSEZfVE9LRU4pJTNCJTBBJTBBJTIwJTIwJTIwJTIwY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsaWVudC5hdXRvbWF0aWNTcGVlY2hSZWNvZ25pdGlvbiglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhJTNBJTIwZmlsZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNBJTIwJTIyb3BlbmFpJTJGd2hpc3Blci1sYXJnZS12My10dXJibyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb3ZpZGVyJTNBJTIwJTIyYXV0byUyMiUwQSUyMCUyMCUyMCUyMCU3RCklM0IlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXQudGV4dCUyMCU3QyU3QyUyMG91dHB1dCUyMCU3QyU3QyUyMCdUcmFuc2NyaXB0aW9uJTIwY29tcGxldGVkJyUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://esm.sh/@huggingface/inference&#x27;</span>;

<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">file</span>) {
    <span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

    <span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">automaticSpeechRecognition</span>({
        <span class="hljs-attr">data</span>: file,
        <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;openai/whisper-large-v3-turbo&quot;</span>,
        <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;auto&quot;</span>
    });
    
    <span class="hljs-keyword">return</span> output.<span class="hljs-property">text</span> || output || <span class="hljs-string">&#x27;Transcription completed&#x27;</span>;
}`,wrap:!1}}),{c(){l=w("p"),l.innerHTML=i,e=U(),m(t.$$.fragment),s=U(),m(n.$$.fragment)},l(M){l=u(M,"P",{"data-svelte-h":!0}),B(l)!=="svelte-yyu0ez"&&(l.innerHTML=i),e=J(M),d(t.$$.fragment,M),s=J(M),d(n.$$.fragment,M)},m(M,c){j(M,l,c),j(M,e,c),A(t,M,c),j(M,s,c),A(n,M,c),r=!0},p(M,c){const y={};c&2&&(y.$$scope={dirty:c,ctx:M}),t.$set(y)},i(M){r||(g(t.$$.fragment,M),g(n.$$.fragment,M),r=!0)},o(M){f(t.$$.fragment,M),f(n.$$.fragment,M),r=!1},d(M){M&&(p(l),p(e),p(s)),b(t,M),b(n,M)}}}function sl(h){let l,i,e,t;return l=new X({props:{id:"transcription",option:"python",$$slots:{default:[Ks]},$$scope:{ctx:h}}}),e=new X({props:{id:"transcription",option:"javascript",$$slots:{default:[Os]},$$scope:{ctx:h}}}),{c(){m(l.$$.fragment),i=U(),m(e.$$.fragment)},l(s){d(l.$$.fragment,s),i=J(s),d(e.$$.fragment,s)},m(s,n){A(l,s,n),j(s,i,n),A(e,s,n),t=!0},p(s,n){const r={};n&2&&(r.$$scope={dirty:n,ctx:s}),l.$set(r);const M={};n&2&&(M.$$scope={dirty:n,ctx:s}),e.$set(M)},i(s){t||(g(l.$$.fragment,s),g(e.$$.fragment,s),t=!0)},o(s){f(l.$$.fragment,s),f(e.$$.fragment,s),t=!1},d(s){s&&p(i),b(l,s),b(e,s)}}}function ll(h){let l,i=`Next, we’ll use a powerful language model like <code>deepseek-ai/DeepSeek-R1-0528</code> from DeepSeek via an Inference Provider, and just like in the previous step, we’ll use the <code>auto</code> provider to automatically select the first available provider for the model.
We will define a custom prompt to ensure the output is formatted as a summary with action items and decisions made:`,e,t,s;return t=new Y({props:{code:"ZGVmJTIwZ2VuZXJhdGVfc3VtbWFyeSh0cmFuc2NyaXB0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdlbmVyYXRlJTIwc3VtbWFyeSUyMHVzaW5nJTIwYW4lMjBJbmZlcmVuY2UlMjBQcm92aWRlciUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMmF1dG8lMjIpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwZiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFuYWx5emUlMjB0aGlzJTIwbWVldGluZyUyMHRyYW5zY3JpcHQlMjBhbmQlMjBwcm92aWRlJTNBJTBBJTIwJTIwJTIwJTIwMS4lMjBBJTIwY29uY2lzZSUyMHN1bW1hcnklMjBvZiUyMGtleSUyMHBvaW50cyUwQSUyMCUyMCUyMCUyMDIuJTIwQWN0aW9uJTIwaXRlbXMlMjB3aXRoJTIwcmVzcG9uc2libGUlMjBwYXJ0aWVzJTBBJTIwJTIwJTIwJTIwMy4lMjBJbXBvcnRhbnQlMjBkZWNpc2lvbnMlMjBtYWRlJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwVHJhbnNjcmlwdCUzQSUyMCU3QnRyYW5zY3JpcHQlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBGb3JtYXQlMjB3aXRoJTIwY2xlYXIlMjBzZWN0aW9ucyUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMyUyMFN1bW1hcnklMEElMjAlMjAlMjAlMjAlMjMlMjMlMjBBY3Rpb24lMjBJdGVtcyUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMyUyMERlY2lzaW9ucyUyME1hZGUlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmRlZXBzZWVrLWFpJTJGRGVlcFNlZWstUjEtMDUyOCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwcHJvbXB0JTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMDAlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_summary</span>(<span class="hljs-params">transcript</span>):
    <span class="hljs-string">&quot;&quot;&quot;Generate summary using an Inference Provider&quot;&quot;&quot;</span>
    client = InferenceClient(provider=<span class="hljs-string">&quot;auto&quot;</span>)
    
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Analyze this meeting transcript and provide:
    1. A concise summary of key points
    2. Action items with responsible parties
    3. Important decisions made
    
    Transcript: <span class="hljs-subst">{transcript}</span>
    
    Format with clear sections:
    ## Summary
    ## Action Items  
    ## Decisions Made
    &quot;&quot;&quot;</span>
    
    response = client.chat.completions.create(
        model=<span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1-0528&quot;</span>,
        messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}],
        max_tokens=<span class="hljs-number">1000</span>
    )
    
    <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content`,wrap:!1}}),{c(){l=w("p"),l.innerHTML=i,e=U(),m(t.$$.fragment)},l(n){l=u(n,"P",{"data-svelte-h":!0}),B(l)!=="svelte-1hw4xen"&&(l.innerHTML=i),e=J(n),d(t.$$.fragment,n)},m(n,r){j(n,l,r),j(n,e,r),A(t,n,r),s=!0},p:_,i(n){s||(g(t.$$.fragment,n),s=!0)},o(n){f(t.$$.fragment,n),s=!1},d(n){n&&(p(l),p(e)),b(t,n)}}}function al(h){let l,i=`Next, we’ll use a powerful language model like <code>deepseek-ai/DeepSeek-R1-0528</code> from DeepSeek via an Inference Provider, and just like in the previous step, we’ll use the <code>auto</code> provider to automatically select the first available provider for the model.
We will define a custom prompt to ensure the output is formatted as a summary with action items and decisions made:`,e,t,s;return t=new Y({props:{code:"YXN5bmMlMjBmdW5jdGlvbiUyMHN1bW1hcml6ZSh0cmFuc2NyaXB0KSUyMCU3QiUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwY2xpZW50JTIwJTNEJTIwbmV3JTIwSW5mZXJlbmNlQ2xpZW50KEhGX1RPS0VOKSUzQiUwQSUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwcHJvbXB0JTIwJTNEJTIwJTYwQW5hbHl6ZSUyMHRoaXMlMjBtZWV0aW5nJTIwdHJhbnNjcmlwdCUyMGFuZCUyMHByb3ZpZGUlM0ElMEElMjAlMjAlMjAlMjAxLiUyMEElMjBjb25jaXNlJTIwc3VtbWFyeSUyMG9mJTIwa2V5JTIwcG9pbnRzJTBBJTIwJTIwJTIwJTIwMi4lMjBBY3Rpb24lMjBpdGVtcyUyMHdpdGglMjByZXNwb25zaWJsZSUyMHBhcnRpZXMlMEElMjAlMjAlMjAlMjAzLiUyMEltcG9ydGFudCUyMGRlY2lzaW9ucyUyMG1hZGUlMEElMEElMjAlMjAlMjAlMjBUcmFuc2NyaXB0JTNBJTIwJTI0JTdCdHJhbnNjcmlwdCU3RCUwQSUwQSUyMCUyMCUyMCUyMEZvcm1hdCUyMHdpdGglMjBjbGVhciUyMHNlY3Rpb25zJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIzJTIwU3VtbWFyeSUwQSUyMCUyMCUyMCUyMCUyMyUyMyUyMEFjdGlvbiUyMEl0ZW1zJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIzJTIwRGVjaXNpb25zJTIwTWFkZSU2MCUzQiUwQSUwQSUyMCUyMCUyMCUyMGNvbnN0JTIwcmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGNsaWVudC5jaGF0Q29tcGxldGlvbiglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzQSUyMCUyMmRlZXBzZWVrLWFpJTJGRGVlcFNlZWstUjEtMDUyOCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb250ZW50JTNBJTIwcHJvbXB0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzQSUyMDEwMDAlMEElMjAlMjAlMjAlMjAlN0QlMkMlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm92aWRlciUzQSUyMCUyMmF1dG8lMjIlMEElMjAlMjAlMjAlMjAlN0QpJTNCJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2UuY2hvaWNlcyUzRi4lNUIwJTVEJTNGLm1lc3NhZ2UlM0YuY29udGVudCUyMCU3QyU3QyUyMHJlc3BvbnNlJTIwJTdDJTdDJTIwJ05vJTIwc3VtbWFyeSUyMGF2YWlsYWJsZSclM0IlMEElN0Q=",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">summarize</span>(<span class="hljs-params">transcript</span>) {
    <span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

    <span class="hljs-keyword">const</span> prompt = <span class="hljs-string">\`Analyze this meeting transcript and provide:
    1. A concise summary of key points
    2. Action items with responsible parties
    3. Important decisions made

    Transcript: <span class="hljs-subst">\${transcript}</span>

    Format with clear sections:
    ## Summary
    ## Action Items  
    ## Decisions Made\`</span>;

    <span class="hljs-keyword">const</span> response = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">chatCompletion</span>({
        <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1-0528&quot;</span>,
        <span class="hljs-attr">messages</span>: [
            {
                <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, 
                <span class="hljs-attr">content</span>: prompt
            }
        ],
        <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">1000</span>
    }, {
        <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;auto&quot;</span>
    });
    
    <span class="hljs-keyword">return</span> response.<span class="hljs-property">choices</span>?.[<span class="hljs-number">0</span>]?.<span class="hljs-property">message</span>?.<span class="hljs-property">content</span> || response || <span class="hljs-string">&#x27;No summary available&#x27;</span>;
}`,wrap:!1}}),{c(){l=w("p"),l.innerHTML=i,e=U(),m(t.$$.fragment)},l(n){l=u(n,"P",{"data-svelte-h":!0}),B(l)!=="svelte-1hw4xen"&&(l.innerHTML=i),e=J(n),d(t.$$.fragment,n)},m(n,r){j(n,l,r),j(n,e,r),A(t,n,r),s=!0},p:_,i(n){s||(g(t.$$.fragment,n),s=!0)},o(n){f(t.$$.fragment,n),s=!1},d(n){n&&(p(l),p(e)),b(t,n)}}}function nl(h){let l,i,e,t;return l=new X({props:{id:"summarization",option:"python",$$slots:{default:[ll]},$$scope:{ctx:h}}}),e=new X({props:{id:"summarization",option:"javascript",$$slots:{default:[al]},$$scope:{ctx:h}}}),{c(){m(l.$$.fragment),i=U(),m(e.$$.fragment)},l(s){d(l.$$.fragment,s),i=J(s),d(e.$$.fragment,s)},m(s,n){A(l,s,n),j(s,i,n),A(e,s,n),t=!0},p(s,n){const r={};n&2&&(r.$$scope={dirty:n,ctx:s}),l.$set(r);const M={};n&2&&(M.$$scope={dirty:n,ctx:s}),e.$set(M)},i(s){t||(g(l.$$.fragment,s),g(e.$$.fragment,s),t=!0)},o(s){f(l.$$.fragment,s),f(e.$$.fragment,s),t=!1},d(s){s&&p(i),b(l,s),b(e,s)}}}function tl(h){let l,i="To deploy, we’ll need to create an <code>app.py</code> file and upload it to Hugging Face Spaces.",e,t,s,n="<strong>📋 Click to view the complete app.py file</strong>",r,M,c,y,$="Our app will run on port 7860 and look like this:",E,N,v='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers-guides/gradio-app.png" alt="Gradio app"/>',W,G,I="To deploy, we’ll need to create a new Space and upload our files.",Z,S,x='<li><strong>Create a new Space</strong>: Go to <a href="https://huggingface.co/new-space" rel="nofollow">huggingface.co/new-space</a></li> <li><strong>Choose Gradio SDK</strong> and make it public</li> <li><strong>Upload your files</strong>: Upload <code>app.py</code></li> <li><strong>Add your token</strong>: In Space settings, add <code>HF_TOKEN</code> as a secret (get it from <a href="https://huggingface.co/settings/tokens" rel="nofollow">your settings</a>)</li> <li><strong>Launch</strong>: Your app will be live at <code>https://huggingface.co/spaces/your-username/your-space-name</code></li>',R,Q,z="<p><strong>Note</strong>: While we used CLI authentication locally, Spaces requires the token as a secret for the deployment environment.</p>",k;return M=new Y({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnQlMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKGF1ZGlvX2ZpbGVfcGF0aCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJUcmFuc2NyaWJlJTIwYXVkaW8lMjB1c2luZyUyMGFuJTIwSW5mZXJlbmNlJTIwUHJvdmlkZXIlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQocHJvdmlkZXIlM0QlMjJhdXRvJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFBhc3MlMjB0aGUlMjBmaWxlJTIwcGF0aCUyMGRpcmVjdGx5JTIwLSUyMHRoZSUyMGNsaWVudCUyMGhhbmRsZXMlMjBmaWxlJTIwcmVhZGluZyUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHQlMjAlM0QlMjBjbGllbnQuYXV0b21hdGljX3NwZWVjaF9yZWNvZ25pdGlvbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUzRGF1ZGlvX2ZpbGVfcGF0aCUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1sYXJnZS12MyUyMiUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0cmFuc2NyaXB0LnRleHQlMEElMEElMEFkZWYlMjBnZW5lcmF0ZV9zdW1tYXJ5KHRyYW5zY3JpcHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2VuZXJhdGUlMjBzdW1tYXJ5JTIwdXNpbmclMjBhbiUyMEluZmVyZW5jZSUyMFByb3ZpZGVyJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KHByb3ZpZGVyJTNEJTIyYXV0byUyMiklMEElMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBmJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQW5hbHl6ZSUyMHRoaXMlMjBtZWV0aW5nJTIwdHJhbnNjcmlwdCUyMGFuZCUyMHByb3ZpZGUlM0ElMEElMjAlMjAlMjAlMjAxLiUyMEElMjBjb25jaXNlJTIwc3VtbWFyeSUyMG9mJTIwa2V5JTIwcG9pbnRzJTBBJTIwJTIwJTIwJTIwMi4lMjBBY3Rpb24lMjBpdGVtcyUyMHdpdGglMjByZXNwb25zaWJsZSUyMHBhcnRpZXMlMEElMjAlMjAlMjAlMjAzLiUyMEltcG9ydGFudCUyMGRlY2lzaW9ucyUyMG1hZGUlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBUcmFuc2NyaXB0JTNBJTIwJTdCdHJhbnNjcmlwdCU3RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMEZvcm1hdCUyMHdpdGglMjBjbGVhciUyMHNlY3Rpb25zJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIzJTIwU3VtbWFyeSUwQSUyMCUyMCUyMCUyMCUyMyUyMyUyMEFjdGlvbiUyMEl0ZW1zJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIzJTIwRGVjaXNpb25zJTIwTWFkZSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyZGVlcHNlZWstYWklMkZEZWVwU2Vlay1SMS0wNTI4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBwcm9tcHQlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfdG9rZW5zJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZS5jaG9pY2VzJTVCMCU1RC5tZXNzYWdlLmNvbnRlbnQlMEElMEElMEFkZWYlMjBwcm9jZXNzX21lZXRpbmdfYXVkaW8oYXVkaW9fZmlsZSklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJNYWluJTIwcHJvY2Vzc2luZyUyMGZ1bmN0aW9uJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBhdWRpb19maWxlJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyUGxlYXNlJTIwdXBsb2FkJTIwYW4lMjBhdWRpbyUyMGZpbGUuJTIyJTJDJTIwJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU3RlcCUyMDElM0ElMjBUcmFuc2NyaWJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNjcmlwdCUyMCUzRCUyMHRyYW5zY3JpYmVfYXVkaW8oYXVkaW9fZmlsZSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTdGVwJTIwMiUzQSUyMFN1bW1hcml6ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1bW1hcnklMjAlM0QlMjBnZW5lcmF0ZV9zdW1tYXJ5KHRyYW5zY3JpcHQpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdCUyQyUyMHN1bW1hcnklMEElMEElMjAlMjAlMjAlMjBleGNlcHQlMjBFeGNlcHRpb24lMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyRXJyb3IlMjBwcm9jZXNzaW5nJTIwYXVkaW8lM0ElMjAlN0JzdHIoZSklN0QlMjIlMkMlMjAlMjIlMjIlMEElMEElMEElMjMlMjBDcmVhdGUlMjBHcmFkaW8lMjBpbnRlcmZhY2UlMEFhcHAlMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0Rwcm9jZXNzX21lZXRpbmdfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyhsYWJlbCUzRCUyMlVwbG9hZCUyME1lZXRpbmclMjBBdWRpbyUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3IuVGV4dGJveChsYWJlbCUzRCUyMlRyYW5zY3JpcHQlMjIlMkMlMjBsaW5lcyUzRDEwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3gobGFiZWwlM0QlMjJTdW1tYXJ5JTIwJTI2JTIwQWN0aW9uJTIwSXRlbXMlMjIlMkMlMjBsaW5lcyUzRDgpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjIlRjAlOUYlOEUlQTQlMjBBSSUyME1lZXRpbmclMjBOb3RlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyVXBsb2FkJTIwYXVkaW8lMjB0byUyMGdldCUyMGluc3RhbnQlMjB0cmFuc2NyaXB0cyUyMGFuZCUyMHN1bW1hcmllcy4lMjIlMkMlMEEpJTBBJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwYXBwLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio_file_path</span>):
    <span class="hljs-string">&quot;&quot;&quot;Transcribe audio using an Inference Provider&quot;&quot;&quot;</span>
    client = InferenceClient(provider=<span class="hljs-string">&quot;auto&quot;</span>)

    <span class="hljs-comment"># Pass the file path directly - the client handles file reading</span>
    transcript = client.automatic_speech_recognition(
        audio=audio_file_path, model=<span class="hljs-string">&quot;openai/whisper-large-v3&quot;</span>
    )

    <span class="hljs-keyword">return</span> transcript.text


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_summary</span>(<span class="hljs-params">transcript</span>):
    <span class="hljs-string">&quot;&quot;&quot;Generate summary using an Inference Provider&quot;&quot;&quot;</span>
    client = InferenceClient(provider=<span class="hljs-string">&quot;auto&quot;</span>)

    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Analyze this meeting transcript and provide:
    1. A concise summary of key points
    2. Action items with responsible parties
    3. Important decisions made
    
    Transcript: <span class="hljs-subst">{transcript}</span>
    
    Format with clear sections:
    ## Summary
    ## Action Items  
    ## Decisions Made
    &quot;&quot;&quot;</span>

    response = client.chat.completions.create(
        model=<span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1-0528&quot;</span>,
        messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}],
        max_tokens=<span class="hljs-number">1000</span>,
    )

    <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_meeting_audio</span>(<span class="hljs-params">audio_file</span>):
    <span class="hljs-string">&quot;&quot;&quot;Main processing function&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_file <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Please upload an audio file.&quot;</span>, <span class="hljs-string">&quot;&quot;</span>

    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Step 1: Transcribe</span>
        transcript = transcribe_audio(audio_file)

        <span class="hljs-comment"># Step 2: Summarize</span>
        summary = generate_summary(transcript)

        <span class="hljs-keyword">return</span> transcript, summary

    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error processing audio: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>, <span class="hljs-string">&quot;&quot;</span>


<span class="hljs-comment"># Create Gradio interface</span>
app = gr.Interface(
    fn=process_meeting_audio,
    inputs=gr.Audio(label=<span class="hljs-string">&quot;Upload Meeting Audio&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=[
        gr.Textbox(label=<span class="hljs-string">&quot;Transcript&quot;</span>, lines=<span class="hljs-number">10</span>),
        gr.Textbox(label=<span class="hljs-string">&quot;Summary &amp; Action Items&quot;</span>, lines=<span class="hljs-number">8</span>),
    ],
    title=<span class="hljs-string">&quot;🎤 AI Meeting Notes&quot;</span>,
    description=<span class="hljs-string">&quot;Upload audio to get instant transcripts and summaries.&quot;</span>,
)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    app.launch()`,wrap:!1}}),{c(){l=w("p"),l.innerHTML=i,e=U(),t=w("details"),s=w("summary"),s.innerHTML=n,r=U(),m(M.$$.fragment),c=U(),y=w("p"),y.textContent=$,E=U(),N=w("p"),N.innerHTML=v,W=U(),G=w("p"),G.textContent=I,Z=U(),S=w("ol"),S.innerHTML=x,R=U(),Q=w("blockquote"),Q.innerHTML=z},l(T){l=u(T,"P",{"data-svelte-h":!0}),B(l)!=="svelte-falld9"&&(l.innerHTML=i),e=J(T),t=u(T,"DETAILS",{});var C=ms(t);s=u(C,"SUMMARY",{"data-svelte-h":!0}),B(s)!=="svelte-18nprsf"&&(s.innerHTML=n),r=J(C),d(M.$$.fragment,C),c=J(C),y=u(C,"P",{"data-svelte-h":!0}),B(y)!=="svelte-1n5m4re"&&(y.textContent=$),E=J(C),N=u(C,"P",{"data-svelte-h":!0}),B(N)!=="svelte-ibsop9"&&(N.innerHTML=v),C.forEach(p),W=J(T),G=u(T,"P",{"data-svelte-h":!0}),B(G)!=="svelte-13uvzr6"&&(G.textContent=I),Z=J(T),S=u(T,"OL",{"data-svelte-h":!0}),B(S)!=="svelte-1yvydwn"&&(S.innerHTML=x),R=J(T),Q=u(T,"BLOCKQUOTE",{"data-svelte-h":!0}),B(Q)!=="svelte-1gqrdse"&&(Q.innerHTML=z)},m(T,C){j(T,l,C),j(T,e,C),j(T,t,C),V(t,s),V(t,r),A(M,t,null),V(t,c),V(t,y),V(t,E),V(t,N),j(T,W,C),j(T,G,C),j(T,Z,C),j(T,S,C),j(T,R,C),j(T,Q,C),k=!0},p:_,i(T){k||(g(M.$$.fragment,T),k=!0)},o(T){f(M.$$.fragment,T),k=!1},d(T){T&&(p(l),p(e),p(t),p(W),p(G),p(Z),p(S),p(R),p(Q)),b(M)}}}function el(h){let l,i="For JavaScript deployment, create a simple static HTML file:",e,t,s,n="<strong>📋 Click to view the complete index.html file</strong>",r,M,c,y,$="We can run our app locally by going to the file from our browser.",E,N,v='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers-guides/js-app.png" alt="Local app"/>',W,G,I="To deploy:",Z,S,x='<li><strong>Create a new Space</strong>: Go to <a href="https://huggingface.co/new-space" rel="nofollow">huggingface.co/new-space</a></li> <li><strong>Choose Static SDK</strong> and make it public</li> <li><strong>Upload your file</strong>: Upload <code>index.html</code></li> <li><strong>Add your token as a secret</strong>: In Space settings, add <code>HF_TOKEN</code> as a <strong>Secret</strong></li> <li><strong>Launch</strong>: Your app will be live at <code>https://huggingface.co/spaces/your-username/your-space-name</code></li>',R,Q,z="<p><strong>Note</strong>: The token is securely managed by Hugging Face Spaces and accessed via <code>window.huggingface.variables.HF_TOKEN</code>.</p>",k;return M=new Y({props:{code:"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",highlighted:`<span class="hljs-meta">&lt;!DOCTYPE <span class="hljs-keyword">html</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">html</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">head</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">meta</span> <span class="hljs-attr">name</span>=<span class="hljs-string">&quot;viewport&quot;</span> <span class="hljs-attr">content</span>=<span class="hljs-string">&quot;width=device-width, initial-scale=1.0&quot;</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">title</span>&gt;</span>🎤 AI Meeting Notes<span class="hljs-tag">&lt;/<span class="hljs-name">title</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">style</span>&gt;</span><span class="language-css">
        <span class="hljs-selector-tag">body</span> { <span class="hljs-attribute">font-family</span>: system-ui; <span class="hljs-attribute">max-width</span>: <span class="hljs-number">600px</span>; <span class="hljs-attribute">margin</span>: <span class="hljs-number">50px</span> auto; <span class="hljs-attribute">padding</span>: <span class="hljs-number">20px</span>; }
        <span class="hljs-selector-class">.upload</span> { <span class="hljs-attribute">border</span>: <span class="hljs-number">2px</span> dashed <span class="hljs-number">#ccc</span>; <span class="hljs-attribute">padding</span>: <span class="hljs-number">40px</span>; <span class="hljs-attribute">text-align</span>: center; <span class="hljs-attribute">margin</span>: <span class="hljs-number">20px</span> <span class="hljs-number">0</span>; <span class="hljs-attribute">cursor</span>: pointer; }
        <span class="hljs-selector-class">.upload</span><span class="hljs-selector-pseudo">:hover</span> { <span class="hljs-attribute">border-color</span>: <span class="hljs-number">#007bff</span>; }
        <span class="hljs-selector-tag">button</span> { <span class="hljs-attribute">background</span>: <span class="hljs-number">#007bff</span>; <span class="hljs-attribute">color</span>: white; <span class="hljs-attribute">border</span>: none; <span class="hljs-attribute">padding</span>: <span class="hljs-number">10px</span> <span class="hljs-number">20px</span>; <span class="hljs-attribute">border-radius</span>: <span class="hljs-number">4px</span>; <span class="hljs-attribute">cursor</span>: pointer; }
        <span class="hljs-selector-class">.loading</span> { <span class="hljs-attribute">display</span>: none; <span class="hljs-attribute">text-align</span>: center; <span class="hljs-attribute">margin</span>: <span class="hljs-number">20px</span> <span class="hljs-number">0</span>; }
        <span class="hljs-selector-class">.results</span> { <span class="hljs-attribute">display</span>: none; <span class="hljs-attribute">margin-top</span>: <span class="hljs-number">20px</span>; }
        <span class="hljs-selector-class">.result</span> { <span class="hljs-attribute">background</span>: <span class="hljs-number">#f5f5f5</span>; <span class="hljs-attribute">padding</span>: <span class="hljs-number">15px</span>; <span class="hljs-attribute">margin</span>: <span class="hljs-number">10px</span> <span class="hljs-number">0</span>; <span class="hljs-attribute">border-radius</span>: <span class="hljs-number">4px</span>; }
        <span class="hljs-selector-class">.error</span> { <span class="hljs-attribute">color</span>: red; <span class="hljs-attribute">background</span>: <span class="hljs-number">#ffe6e6</span>; <span class="hljs-attribute">padding</span>: <span class="hljs-number">15px</span>; <span class="hljs-attribute">border-radius</span>: <span class="hljs-number">4px</span>; <span class="hljs-attribute">display</span>: none; }
        <span class="hljs-selector-tag">input</span><span class="hljs-selector-attr">[type=<span class="hljs-string">&quot;file&quot;</span>]</span> { <span class="hljs-attribute">display</span>: none; }
    </span><span class="hljs-tag">&lt;/<span class="hljs-name">style</span>&gt;</span>
<span class="hljs-tag">&lt;/<span class="hljs-name">head</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">body</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">h1</span>&gt;</span>🎤 AI Meeting Notes<span class="hljs-tag">&lt;/<span class="hljs-name">h1</span>&gt;</span>
       
    <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;upload&quot;</span> <span class="hljs-attr">onclick</span>=<span class="hljs-string">&quot;document.getElementById(&#x27;file&#x27;).click()&quot;</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">input</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;file&quot;</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;file&quot;</span> <span class="hljs-attr">accept</span>=<span class="hljs-string">&quot;audio/*&quot;</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">p</span>&gt;</span>Upload audio file<span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">button</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;button&quot;</span>&gt;</span>Choose File<span class="hljs-tag">&lt;/<span class="hljs-name">button</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
    
    <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;loading&quot;</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;loading&quot;</span>&gt;</span>Processing...<span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;error&quot;</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;error&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
    
    <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;results&quot;</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;results&quot;</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;result&quot;</span>&gt;</span>
            <span class="hljs-tag">&lt;<span class="hljs-name">h3</span>&gt;</span>📝 Transcript<span class="hljs-tag">&lt;/<span class="hljs-name">h3</span>&gt;</span>
            <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;transcript&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
        <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
        <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;result&quot;</span>&gt;</span>
            <span class="hljs-tag">&lt;<span class="hljs-name">h3</span>&gt;</span>📋 Summary<span class="hljs-tag">&lt;/<span class="hljs-name">h3</span>&gt;</span>
            <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;summary&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
        <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>

    <span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="language-javascript">
        <span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://esm.sh/@huggingface/inference&#x27;</span>;
        
        <span class="hljs-comment">// Access the token from Hugging Face Spaces secrets</span>
        <span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-variable language_">window</span>.<span class="hljs-property">huggingface</span>?.<span class="hljs-property">variables</span>?.<span class="hljs-property">HF_TOKEN</span>;
        
        <span class="hljs-comment">// Add error handling for missing token</span>
        <span class="hljs-keyword">if</span> (!<span class="hljs-variable constant_">HF_TOKEN</span>) {
            <span class="hljs-title function_">showError</span>(<span class="hljs-string">&#x27;HF_TOKEN not configured. Please add it in Space settings.&#x27;</span>);
            <span class="hljs-keyword">return</span>;
        }
        
        <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;file&#x27;</span>).<span class="hljs-property">onchange</span> = <span class="hljs-keyword">async</span> (e) =&gt; {
            <span class="hljs-keyword">if</span> (!e.<span class="hljs-property">target</span>.<span class="hljs-property">files</span>[<span class="hljs-number">0</span>]) <span class="hljs-keyword">return</span>;
            
            <span class="hljs-keyword">const</span> file = e.<span class="hljs-property">target</span>.<span class="hljs-property">files</span>[<span class="hljs-number">0</span>];
            
            <span class="hljs-title function_">show</span>(<span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;loading&#x27;</span>));
            <span class="hljs-title function_">hide</span>(<span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;results&#x27;</span>), <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;error&#x27;</span>));
            
            <span class="hljs-keyword">try</span> {
                <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&#x27;🎤 Starting transcription...&#x27;</span>);
                <span class="hljs-keyword">const</span> transcript = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcribe</span>(file);
                <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&#x27;✅ Transcription completed:&#x27;</span>, transcript.<span class="hljs-title function_">substring</span>(<span class="hljs-number">0</span>, <span class="hljs-number">100</span>) + <span class="hljs-string">&#x27;...&#x27;</span>);
                
                <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&#x27;🖊️ Starting summarization...&#x27;</span>);
                <span class="hljs-keyword">const</span> summary = <span class="hljs-keyword">await</span> <span class="hljs-title function_">summarize</span>(transcript);
                <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&#x27;✅ Summary completed:&#x27;</span>, summary.<span class="hljs-title function_">substring</span>(<span class="hljs-number">0</span>, <span class="hljs-number">100</span>) + <span class="hljs-string">&#x27;...&#x27;</span>);
                
                <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;transcript&#x27;</span>).<span class="hljs-property">textContent</span> = transcript;
                <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;summary&#x27;</span>).<span class="hljs-property">textContent</span> = summary;
                
                <span class="hljs-title function_">hide</span>(<span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;loading&#x27;</span>));
                <span class="hljs-title function_">show</span>(<span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;results&#x27;</span>));
            } <span class="hljs-keyword">catch</span> (error) {
                <span class="hljs-title function_">hide</span>(<span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;loading&#x27;</span>));
                <span class="hljs-title function_">showError</span>(<span class="hljs-string">\`Error: <span class="hljs-subst">\${error.message}</span>\`</span>);
            }
        };
        
        <span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">file</span>) {
            <span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

            <span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">automaticSpeechRecognition</span>({
                <span class="hljs-attr">data</span>: file,
                <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;openai/whisper-large-v3-turbo&quot;</span>,
                <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;auto&quot;</span>
            });
            
            <span class="hljs-keyword">return</span> output.<span class="hljs-property">text</span> || output || <span class="hljs-string">&#x27;Transcription completed&#x27;</span>;
        }
        
        <span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">summarize</span>(<span class="hljs-params">transcript</span>) {
            <span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

            <span class="hljs-keyword">const</span> prompt = <span class="hljs-string">\`Analyze this meeting transcript and provide:
            1. A concise summary of key points
            2. Action items with responsible parties
            3. Important decisions made

            Transcript: <span class="hljs-subst">\${transcript}</span>

            Format with clear sections:
            ## Summary
            ## Action Items  
            ## Decisions Made\`</span>;

            <span class="hljs-keyword">const</span> response = <span class="hljs-keyword">await</span> client.<span class="hljs-title function_">chatCompletion</span>({
                <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1-0528&quot;</span>,
                <span class="hljs-attr">messages</span>: [
                    {
                        <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, 
                        <span class="hljs-attr">content</span>: prompt
                    }
                ],
                <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">1000</span>
            }, {
                <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;auto&quot;</span>
            });
            
            <span class="hljs-keyword">return</span> response.<span class="hljs-property">choices</span>?.[<span class="hljs-number">0</span>]?.<span class="hljs-property">message</span>?.<span class="hljs-property">content</span> || response || <span class="hljs-string">&#x27;No summary available&#x27;</span>;
        }
        
        <span class="hljs-keyword">const</span> <span class="hljs-title function_">show</span> = el =&gt; el.<span class="hljs-property">style</span>.<span class="hljs-property">display</span> = <span class="hljs-string">&#x27;block&#x27;</span>;
        <span class="hljs-keyword">const</span> <span class="hljs-title function_">hide</span> = (<span class="hljs-params">...els</span>) =&gt; els.<span class="hljs-title function_">forEach</span>(<span class="hljs-function"><span class="hljs-params">el</span> =&gt;</span> el.<span class="hljs-property">style</span>.<span class="hljs-property">display</span> = <span class="hljs-string">&#x27;none&#x27;</span>);
        <span class="hljs-keyword">const</span> <span class="hljs-title function_">showError</span> = msg =&gt; {
            <span class="hljs-keyword">const</span> error = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&#x27;error&#x27;</span>);
            error.<span class="hljs-property">innerHTML</span> = msg;
            <span class="hljs-title function_">show</span>(error);
        };
    </span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>
<span class="hljs-tag">&lt;/<span class="hljs-name">body</span>&gt;</span>
<span class="hljs-tag">&lt;/<span class="hljs-name">html</span>&gt;</span>`,wrap:!1}}),{c(){l=w("p"),l.textContent=i,e=U(),t=w("details"),s=w("summary"),s.innerHTML=n,r=U(),m(M.$$.fragment),c=U(),y=w("p"),y.textContent=$,E=U(),N=w("p"),N.innerHTML=v,W=U(),G=w("p"),G.textContent=I,Z=U(),S=w("ol"),S.innerHTML=x,R=U(),Q=w("blockquote"),Q.innerHTML=z},l(T){l=u(T,"P",{"data-svelte-h":!0}),B(l)!=="svelte-msmbet"&&(l.textContent=i),e=J(T),t=u(T,"DETAILS",{});var C=ms(t);s=u(C,"SUMMARY",{"data-svelte-h":!0}),B(s)!=="svelte-4npc9i"&&(s.innerHTML=n),r=J(C),d(M.$$.fragment,C),c=J(C),y=u(C,"P",{"data-svelte-h":!0}),B(y)!=="svelte-1thvetd"&&(y.textContent=$),E=J(C),N=u(C,"P",{"data-svelte-h":!0}),B(N)!=="svelte-16bn4n3"&&(N.innerHTML=v),C.forEach(p),W=J(T),G=u(T,"P",{"data-svelte-h":!0}),B(G)!=="svelte-8ht9li"&&(G.textContent=I),Z=J(T),S=u(T,"OL",{"data-svelte-h":!0}),B(S)!=="svelte-8vwz1w"&&(S.innerHTML=x),R=J(T),Q=u(T,"BLOCKQUOTE",{"data-svelte-h":!0}),B(Q)!=="svelte-1a0q7y9"&&(Q.innerHTML=z)},m(T,C){j(T,l,C),j(T,e,C),j(T,t,C),V(t,s),V(t,r),A(M,t,null),V(t,c),V(t,y),V(t,E),V(t,N),j(T,W,C),j(T,G,C),j(T,Z,C),j(T,S,C),j(T,R,C),j(T,Q,C),k=!0},p:_,i(T){k||(g(M.$$.fragment,T),k=!0)},o(T){f(M.$$.fragment,T),k=!1},d(T){T&&(p(l),p(e),p(t),p(W),p(G),p(Z),p(S),p(R),p(Q)),b(M)}}}function Ml(h){let l,i,e,t;return l=new X({props:{id:"deployment",option:"python",$$slots:{default:[tl]},$$scope:{ctx:h}}}),e=new X({props:{id:"deployment",option:"javascript",$$slots:{default:[el]},$$scope:{ctx:h}}}),{c(){m(l.$$.fragment),i=U(),m(e.$$.fragment)},l(s){d(l.$$.fragment,s),i=J(s),d(e.$$.fragment,s)},m(s,n){A(l,s,n),j(s,i,n),A(e,s,n),t=!0},p(s,n){const r={};n&2&&(r.$$scope={dirty:n,ctx:s}),l.$set(r);const M={};n&2&&(M.$$scope={dirty:n,ctx:s}),e.$set(M)},i(s){t||(g(l.$$.fragment,s),g(e.$$.fragment,s),t=!0)},o(s){f(l.$$.fragment,s),f(e.$$.fragment,s),t=!1},d(s){s&&p(i),b(l,s),b(e,s)}}}function pl(h){let l,i,e,t,s,n,r,M="You’ve learned the basics and understand the provider ecosystem. Now let’s build something practical: an <strong>AI Meeting Notes</strong> app that transcribes audio files and generates summaries with action items.",c,y,$="This project demonstrates real-world AI orchestration using multiple specialized providers within a single application.",E,N,v,W,G="Our app will:",I,Z,S="<li><strong>Accept audio</strong> as a microphone input through a web interface</li> <li><strong>Transcribe speech</strong> using a fast speech-to-text model</li> <li><strong>Generate summaries</strong> using a powerful language model</li> <li><strong>Deploy to the web</strong> for easy sharing</li>",x,R,Q,z,k,T,C,K,js,H,cs,P,is,F,ys,O,rs,q,os,ss,Us,L,Js,ls,Ts,as,As='Congratulations! You’ve created a production-ready AI application that: handles real-world tasks, provides a professional interface, scales automatically, and costs efficiently. If you want to explore more providers, you can check out the <a href="https://huggingface.co/inference-providers" rel="nofollow">Inference Providers</a> page. Or here are some ideas for next steps:',ws,ns,gs="<li><strong>Improve your prompt</strong>: Try different prompts to improve the quality for your use case</li> <li><strong>Try different models</strong>: Experiment with various speech and text models</li> <li><strong>Compare performance</strong>: Benchmark speed vs. accuracy across providers</li>",us,ts,fs="Up next: learn how to deploy a dedicated Inference Endpoint and call it from your apps.",hs,es,Is,ps,Cs;return s=new D({props:{title:"Building Your First AI App with Inference Providers",local:"building-your-first-ai-app-with-inference-providers",headingTag:"h1"}}),N=new D({props:{title:"Project Overview",local:"project-overview",headingTag:"h2"}}),R=new Ms({props:{id:"tech-stack",options:["python","javascript"],$$slots:{default:[Ys]},$$scope:{ctx:h}}}),z=new D({props:{title:"Step 1: Set Up Authentication",local:"step-1-set-up-authentication",headingTag:"h2"}}),T=new Ms({props:{id:"auth",options:["python","javascript"],$$slots:{default:[Hs]},$$scope:{ctx:h}}}),K=new D({props:{title:"Step 2: Build the User Interface",local:"step-2-build-the-user-interface",headingTag:"h2"}}),H=new Ms({props:{id:"ui",options:["python","javascript"],$$slots:{default:[Ls]},$$scope:{ctx:h}}}),P=new D({props:{title:"Step 3: Add Speech Transcription",local:"step-3-add-speech-transcription",headingTag:"h2"}}),F=new Ms({props:{id:"transcription",options:["python","javascript"],$$slots:{default:[sl]},$$scope:{ctx:h}}}),O=new D({props:{title:"Step 4: Add AI Summarization",local:"step-4-add-ai-summarization",headingTag:"h2"}}),q=new Ms({props:{id:"summarization",options:["python","javascript"],$$slots:{default:[nl]},$$scope:{ctx:h}}}),ss=new D({props:{title:"Step 5: Deploy on Hugging Face Spaces",local:"step-5-deploy-on-hugging-face-spaces",headingTag:"h2"}}),L=new Ms({props:{id:"deployment",options:["python","javascript"],$$slots:{default:[Ml]},$$scope:{ctx:h}}}),ls=new D({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),es=new ks({props:{source:"https://github.com/huggingface/101-course/blob/main/chapters/en/chapter2/3.mdx"}}),{c(){l=w("meta"),i=U(),e=w("p"),t=U(),m(s.$$.fragment),n=U(),r=w("p"),r.innerHTML=M,c=U(),y=w("p"),y.textContent=$,E=U(),m(N.$$.fragment),v=U(),W=w("p"),W.textContent=G,I=U(),Z=w("ol"),Z.innerHTML=S,x=U(),m(R.$$.fragment),Q=U(),m(z.$$.fragment),k=U(),m(T.$$.fragment),C=U(),m(K.$$.fragment),js=U(),m(H.$$.fragment),cs=U(),m(P.$$.fragment),is=U(),m(F.$$.fragment),ys=U(),m(O.$$.fragment),rs=U(),m(q.$$.fragment),os=U(),m(ss.$$.fragment),Us=U(),m(L.$$.fragment),Js=U(),m(ls.$$.fragment),Ts=U(),as=w("p"),as.innerHTML=As,ws=U(),ns=w("ul"),ns.innerHTML=gs,us=U(),ts=w("p"),ts.textContent=fs,hs=U(),m(es.$$.fragment),Is=U(),ps=w("p"),this.h()},l(a){const o=Rs("svelte-u9bgzb",document.head);l=u(o,"META",{name:!0,content:!0}),o.forEach(p),i=J(a),e=u(a,"P",{}),ms(e).forEach(p),t=J(a),d(s.$$.fragment,a),n=J(a),r=u(a,"P",{"data-svelte-h":!0}),B(r)!=="svelte-1xvjfqn"&&(r.innerHTML=M),c=J(a),y=u(a,"P",{"data-svelte-h":!0}),B(y)!=="svelte-gz55cx"&&(y.textContent=$),E=J(a),d(N.$$.fragment,a),v=J(a),W=u(a,"P",{"data-svelte-h":!0}),B(W)!=="svelte-5khb3j"&&(W.textContent=G),I=J(a),Z=u(a,"OL",{"data-svelte-h":!0}),B(Z)!=="svelte-8ofcwq"&&(Z.innerHTML=S),x=J(a),d(R.$$.fragment,a),Q=J(a),d(z.$$.fragment,a),k=J(a),d(T.$$.fragment,a),C=J(a),d(K.$$.fragment,a),js=J(a),d(H.$$.fragment,a),cs=J(a),d(P.$$.fragment,a),is=J(a),d(F.$$.fragment,a),ys=J(a),d(O.$$.fragment,a),rs=J(a),d(q.$$.fragment,a),os=J(a),d(ss.$$.fragment,a),Us=J(a),d(L.$$.fragment,a),Js=J(a),d(ls.$$.fragment,a),Ts=J(a),as=u(a,"P",{"data-svelte-h":!0}),B(as)!=="svelte-cyuk9m"&&(as.innerHTML=As),ws=J(a),ns=u(a,"UL",{"data-svelte-h":!0}),B(ns)!=="svelte-i47df0"&&(ns.innerHTML=gs),us=J(a),ts=u(a,"P",{"data-svelte-h":!0}),B(ts)!=="svelte-2ddwnb"&&(ts.textContent=fs),hs=J(a),d(es.$$.fragment,a),Is=J(a),ps=u(a,"P",{}),ms(ps).forEach(p),this.h()},h(){Gs(l,"name","hf:doc:metadata"),Gs(l,"content",jl)},m(a,o){V(document.head,l),j(a,i,o),j(a,e,o),j(a,t,o),A(s,a,o),j(a,n,o),j(a,r,o),j(a,c,o),j(a,y,o),j(a,E,o),A(N,a,o),j(a,v,o),j(a,W,o),j(a,I,o),j(a,Z,o),j(a,x,o),A(R,a,o),j(a,Q,o),A(z,a,o),j(a,k,o),A(T,a,o),j(a,C,o),A(K,a,o),j(a,js,o),A(H,a,o),j(a,cs,o),A(P,a,o),j(a,is,o),A(F,a,o),j(a,ys,o),A(O,a,o),j(a,rs,o),A(q,a,o),j(a,os,o),A(ss,a,o),j(a,Us,o),A(L,a,o),j(a,Js,o),A(ls,a,o),j(a,Ts,o),j(a,as,o),j(a,ws,o),j(a,ns,o),j(a,us,o),j(a,ts,o),j(a,hs,o),A(es,a,o),j(a,Is,o),j(a,ps,o),Cs=!0},p(a,[o]){const bs={};o&2&&(bs.$$scope={dirty:o,ctx:a}),R.$set(bs);const Bs={};o&2&&(Bs.$$scope={dirty:o,ctx:a}),T.$set(Bs);const Zs={};o&2&&(Zs.$$scope={dirty:o,ctx:a}),H.$set(Zs);const Ns={};o&2&&(Ns.$$scope={dirty:o,ctx:a}),F.$set(Ns);const $s={};o&2&&($s.$$scope={dirty:o,ctx:a}),q.$set($s);const Es={};o&2&&(Es.$$scope={dirty:o,ctx:a}),L.$set(Es)},i(a){Cs||(g(s.$$.fragment,a),g(N.$$.fragment,a),g(R.$$.fragment,a),g(z.$$.fragment,a),g(T.$$.fragment,a),g(K.$$.fragment,a),g(H.$$.fragment,a),g(P.$$.fragment,a),g(F.$$.fragment,a),g(O.$$.fragment,a),g(q.$$.fragment,a),g(ss.$$.fragment,a),g(L.$$.fragment,a),g(ls.$$.fragment,a),g(es.$$.fragment,a),Cs=!0)},o(a){f(s.$$.fragment,a),f(N.$$.fragment,a),f(R.$$.fragment,a),f(z.$$.fragment,a),f(T.$$.fragment,a),f(K.$$.fragment,a),f(H.$$.fragment,a),f(P.$$.fragment,a),f(F.$$.fragment,a),f(O.$$.fragment,a),f(q.$$.fragment,a),f(ss.$$.fragment,a),f(L.$$.fragment,a),f(ls.$$.fragment,a),f(es.$$.fragment,a),Cs=!1},d(a){a&&(p(i),p(e),p(t),p(n),p(r),p(c),p(y),p(E),p(v),p(W),p(I),p(Z),p(x),p(Q),p(k),p(C),p(js),p(cs),p(is),p(ys),p(rs),p(os),p(Us),p(Js),p(Ts),p(as),p(ws),p(ns),p(us),p(ts),p(hs),p(Is),p(ps)),p(l),b(s,a),b(N,a),b(R,a),b(z,a),b(T,a),b(K,a),b(H,a),b(P,a),b(F,a),b(O,a),b(q,a),b(ss,a),b(L,a),b(ls,a),b(es,a)}}}const jl='{"title":"Building Your First AI App with Inference Providers","local":"building-your-first-ai-app-with-inference-providers","sections":[{"title":"Project Overview","local":"project-overview","sections":[],"depth":2},{"title":"Step 1: Set Up Authentication","local":"step-1-set-up-authentication","sections":[],"depth":2},{"title":"Step 2: Build the User Interface","local":"step-2-build-the-user-interface","sections":[],"depth":2},{"title":"Step 3: Add Speech Transcription","local":"step-3-add-speech-transcription","sections":[],"depth":2},{"title":"Step 4: Add AI Summarization","local":"step-4-add-ai-summarization","sections":[],"depth":2},{"title":"Step 5: Deploy on Hugging Face Spaces","local":"step-5-deploy-on-hugging-face-spaces","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function cl(h){return Qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tl extends vs{constructor(l){super(),Ss(this,l,cl,pl,Ws,{})}}export{Tl as component};
