import{s as ie,o as ce,n as gt}from"../chunks/scheduler.1d51f4c0.js";import{S as ye,i as re,g as r,s as o,r as w,A as ue,h as u,f as l,c as i,j as Me,u as d,x as j,k as pe,y as Je,a as e,v as I,d as C,t as f,w as g}from"../chunks/index.fda43871.js";import{T as je}from"../chunks/Tip.e808fe4c.js";import{C as W}from"../chunks/CodeBlock.16130beb.js";import{H as E,E as Te}from"../chunks/getInferenceSnippets.58a43ad0.js";import{H as oe,a as bt}from"../chunks/HfOption.42596235.js";function Ue(G){let p,h='This Tutorial uses Python, but your client can be any language that can make HTTP requests. The model and engine you deploy on Inference Endpoints uses the <strong>OpenAI Chat Completions format</strong>, so you can use any <a href="https://platform.openai.com/docs/libraries" rel="nofollow">OpenAI client</a> to connect to them, in languages like JavaScript, Java, and Go.';return{c(){p=r("p"),p.innerHTML=h},l(c){p=u(c,"P",{"data-svelte-h":!0}),j(p)!=="svelte-1t7fc3k"&&(p.innerHTML=h)},m(c,T){e(c,p,T)},p:gt,d(c){c&&l(p)}}}function he(G){let p,h="<strong>Using Hugging Face InferenceClient</strong>",c,T,U="First, install the required dependencies:",y,a,n,J,Z="The Hugging Face InferenceClient provides a clean interface that’s compatible with the OpenAI API format:",B,b,A;return a=new W({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdyYWRpbyUyMGh1Z2dpbmdmYWNlLWh1Yg==",highlighted:"pip install gradio huggingface-hub",wrap:!1}}),b=new W({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># Initialize the Hugging Face InferenceClient</span>
client = InferenceClient(
    base_url=<span class="hljs-string">&quot;&lt;endpoint-url&gt;/v1/&quot;</span>,  <span class="hljs-comment"># Replace with your endpoint URL</span>
    token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)  <span class="hljs-comment"># Use environment variable for security</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat_with_hf_client</span>(<span class="hljs-params">message, history</span>):
    <span class="hljs-comment"># Convert Gradio history to messages format</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: msg[<span class="hljs-string">&quot;role&quot;</span>], <span class="hljs-string">&quot;content&quot;</span>: msg[<span class="hljs-string">&quot;content&quot;</span>]} <span class="hljs-keyword">for</span> msg <span class="hljs-keyword">in</span> history]
    
    <span class="hljs-comment"># Add the current message</span>
    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: message})
    
    <span class="hljs-comment"># Create chat completion</span>
    chat_completion = client.chat.completions.create(
        model=<span class="hljs-string">&quot;endpoint-name&quot;</span>,  <span class="hljs-comment"># Use the name of your endpoint (i.e. qwen3-1.7b-instruct-xxxx)</span>
        messages=messages,
        max_tokens=<span class="hljs-number">150</span>,
        temperature=<span class="hljs-number">0.7</span>,
    )
    
    <span class="hljs-comment"># Return the response</span>
    <span class="hljs-keyword">return</span> chat_completion.choices[<span class="hljs-number">0</span>].message.content

<span class="hljs-comment"># Create the Gradio interface</span>
demo = gr.ChatInterface(
    fn=chat_with_hf_client,
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
    title=<span class="hljs-string">&quot;Custom Chat with Inference Endpoints&quot;</span>,
    examples=[<span class="hljs-string">&quot;What is deep learning?&quot;</span>, <span class="hljs-string">&quot;Explain neural networks&quot;</span>, <span class="hljs-string">&quot;How does AI work?&quot;</span>]
)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    demo.launch()`,wrap:!1}}),{c(){p=r("p"),p.innerHTML=h,c=o(),T=r("p"),T.textContent=U,y=o(),w(a.$$.fragment),n=o(),J=r("p"),J.textContent=Z,B=o(),w(b.$$.fragment)},l(M){p=u(M,"P",{"data-svelte-h":!0}),j(p)!=="svelte-15fpcnt"&&(p.innerHTML=h),c=i(M),T=u(M,"P",{"data-svelte-h":!0}),j(T)!=="svelte-1f3oki6"&&(T.textContent=U),y=i(M),d(a.$$.fragment,M),n=i(M),J=u(M,"P",{"data-svelte-h":!0}),j(J)!=="svelte-u7e6qd"&&(J.textContent=Z),B=i(M),d(b.$$.fragment,M)},m(M,m){e(M,p,m),e(M,c,m),e(M,T,m),e(M,y,m),I(a,M,m),e(M,n,m),e(M,J,m),e(M,B,m),I(b,M,m),A=!0},p:gt,i(M){A||(C(a.$$.fragment,M),C(b.$$.fragment,M),A=!0)},o(M){f(a.$$.fragment,M),f(b.$$.fragment,M),A=!1},d(M){M&&(l(p),l(c),l(T),l(y),l(n),l(J),l(B)),g(a,M),g(b,M)}}}function me(G){let p,h="<strong>Using OpenAI Client</strong>",c,T,U="First, install the required dependencies:",y,a,n,J,Z="Here’s a basic chat function using the OpenAI client:",B,b,A;return a=new W({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdyYWRpbyUyMG9wZW5haQ==",highlighted:"pip install gradio openai",wrap:!1}}),b=new W({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># Initialize the OpenAI client with your Inference Endpoint</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;&lt;endpoint-url&gt;/v1/&quot;</span>,  <span class="hljs-comment"># Replace with your endpoint URL</span>
    api_key=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)  <span class="hljs-comment"># Use environment variable for security</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat_with_openai</span>(<span class="hljs-params">message, history</span>):

    <span class="hljs-comment"># Convert Gradio history to OpenAI format</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: msg[<span class="hljs-string">&quot;role&quot;</span>], <span class="hljs-string">&quot;content&quot;</span>: msg[<span class="hljs-string">&quot;content&quot;</span>]} <span class="hljs-keyword">for</span> msg <span class="hljs-keyword">in</span> history]
    
    <span class="hljs-comment"># Add the current message</span>
    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: message})
    
    <span class="hljs-comment"># Create chat completion</span>
    chat_completion = client.chat.completions.create(
        model=<span class="hljs-string">&quot;endpoint-name&quot;</span>,  <span class="hljs-comment"># Use the name of your endpoint (i.e. qwen3-1.7b-xxxx)</span>
        messages=messages,
        max_tokens=<span class="hljs-number">150</span>,
        temperature=<span class="hljs-number">0.7</span>,
    )
    
    <span class="hljs-comment"># return the response</span>
    <span class="hljs-keyword">return</span> chat_completion.choices[<span class="hljs-number">0</span>].message.content
                

<span class="hljs-comment"># Create the Gradio interface</span>
demo = gr.ChatInterface(
    fn=chat_with_openai,
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
    title=<span class="hljs-string">&quot;Custom Chat with Inference Endpoints&quot;</span>,
    examples=[<span class="hljs-string">&quot;What is deep learning?&quot;</span>, <span class="hljs-string">&quot;Explain neural networks&quot;</span>, <span class="hljs-string">&quot;How does AI work?&quot;</span>]
)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    demo.launch()`,wrap:!1}}),{c(){p=r("p"),p.innerHTML=h,c=o(),T=r("p"),T.textContent=U,y=o(),w(a.$$.fragment),n=o(),J=r("p"),J.textContent=Z,B=o(),w(b.$$.fragment)},l(M){p=u(M,"P",{"data-svelte-h":!0}),j(p)!=="svelte-on37og"&&(p.innerHTML=h),c=i(M),T=u(M,"P",{"data-svelte-h":!0}),j(T)!=="svelte-1f3oki6"&&(T.textContent=U),y=i(M),d(a.$$.fragment,M),n=i(M),J=u(M,"P",{"data-svelte-h":!0}),j(J)!=="svelte-fjp75b"&&(J.textContent=Z),B=i(M),d(b.$$.fragment,M)},m(M,m){e(M,p,m),e(M,c,m),e(M,T,m),e(M,y,m),I(a,M,m),e(M,n,m),e(M,J,m),e(M,B,m),I(b,M,m),A=!0},p:gt,i(M){A||(C(a.$$.fragment,M),C(b.$$.fragment,M),A=!0)},o(M){f(a.$$.fragment,M),f(b.$$.fragment,M),A=!1},d(M){M&&(l(p),l(c),l(T),l(y),l(n),l(J),l(B)),g(a,M),g(b,M)}}}function we(G){let p,h="<strong>Using Requests Library</strong>",c,T,U="First, install the required dependencies:",y,a,n,J,Z="Here’s a basic chat function using the requests library with the Messages API:",B,b,A;return a=new W({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdyYWRpbyUyMHJlcXVlc3Rz",highlighted:"pip install gradio requests",wrap:!1}}),b=new W({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> requests

<span class="hljs-comment"># Configure your Inference Endpoint</span>
API_URL = <span class="hljs-string">&quot;&lt;endpoint-url&gt;/v1/chat/completions&quot;</span>  <span class="hljs-comment"># Use the chat completions endpoint</span>

headers = {
    <span class="hljs-string">&quot;Accept&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
    <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
    <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}</span>&quot;</span>  <span class="hljs-comment"># Use environment variable for security</span>
}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat_with_requests</span>(<span class="hljs-params">message, history</span>):
    <span class="hljs-comment"># Convert Gradio history to messages format</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: msg[<span class="hljs-string">&quot;role&quot;</span>], <span class="hljs-string">&quot;content&quot;</span>: msg[<span class="hljs-string">&quot;content&quot;</span>]} <span class="hljs-keyword">for</span> msg <span class="hljs-keyword">in</span> history]
    
    <span class="hljs-comment"># Add the current message</span>
    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: message})
    
    <span class="hljs-comment"># Prepare the payload using the Messages API format</span>
    payload = {
        <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;endpoint-name&quot;</span>,  <span class="hljs-comment"># Use the name of your endpoint (i.e. qwen3-1.7b-xxxx)</span>
        <span class="hljs-string">&quot;messages&quot;</span>: messages,
        <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">150</span>,
        <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
        <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">False</span>
    }
    
    <span class="hljs-comment"># Make the request</span>
    response = requests.post(API_URL, headers=headers, json=payload)
    response.raise_for_status()
    
    <span class="hljs-comment"># Parse the response</span>
    result = response.json()
    <span class="hljs-keyword">return</span> result[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>]

<span class="hljs-comment"># Create the Gradio interface</span>
demo = gr.ChatInterface(
    fn=chat_with_requests,
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
    title=<span class="hljs-string">&quot;Custom Chat with Inference Endpoints&quot;</span>,
    examples=[<span class="hljs-string">&quot;What is deep learning?&quot;</span>, <span class="hljs-string">&quot;Explain neural networks&quot;</span>, <span class="hljs-string">&quot;How does AI work?&quot;</span>]
)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    demo.launch()`,wrap:!1}}),{c(){p=r("p"),p.innerHTML=h,c=o(),T=r("p"),T.textContent=U,y=o(),w(a.$$.fragment),n=o(),J=r("p"),J.textContent=Z,B=o(),w(b.$$.fragment)},l(M){p=u(M,"P",{"data-svelte-h":!0}),j(p)!=="svelte-10zf8di"&&(p.innerHTML=h),c=i(M),T=u(M,"P",{"data-svelte-h":!0}),j(T)!=="svelte-1f3oki6"&&(T.textContent=U),y=i(M),d(a.$$.fragment,M),n=i(M),J=u(M,"P",{"data-svelte-h":!0}),j(J)!=="svelte-177no80"&&(J.textContent=Z),B=i(M),d(b.$$.fragment,M)},m(M,m){e(M,p,m),e(M,c,m),e(M,T,m),e(M,y,m),I(a,M,m),e(M,n,m),e(M,J,m),e(M,B,m),I(b,M,m),A=!0},p:gt,i(M){A||(C(a.$$.fragment,M),C(b.$$.fragment,M),A=!0)},o(M){f(a.$$.fragment,M),f(b.$$.fragment,M),A=!1},d(M){M&&(l(p),l(c),l(T),l(y),l(n),l(J),l(B)),g(a,M),g(b,M)}}}function de(G){let p,h,c,T,U,y;return p=new bt({props:{id:"chat-implementation",option:"hf-client",$$slots:{default:[he]},$$scope:{ctx:G}}}),c=new bt({props:{id:"chat-implementation",option:"openai-client",$$slots:{default:[me]},$$scope:{ctx:G}}}),U=new bt({props:{id:"chat-implementation",option:"requests",$$slots:{default:[we]},$$scope:{ctx:G}}}),{c(){w(p.$$.fragment),h=o(),w(c.$$.fragment),T=o(),w(U.$$.fragment)},l(a){d(p.$$.fragment,a),h=i(a),d(c.$$.fragment,a),T=i(a),d(U.$$.fragment,a)},m(a,n){I(p,a,n),e(a,h,n),I(c,a,n),e(a,T,n),I(U,a,n),y=!0},p(a,n){const J={};n&2&&(J.$$scope={dirty:n,ctx:a}),p.$set(J);const Z={};n&2&&(Z.$$scope={dirty:n,ctx:a}),c.$set(Z);const B={};n&2&&(B.$$scope={dirty:n,ctx:a}),U.$set(B)},i(a){y||(C(p.$$.fragment,a),C(c.$$.fragment,a),C(U.$$.fragment,a),y=!0)},o(a){f(p.$$.fragment,a),f(c.$$.fragment,a),f(U.$$.fragment,a),y=!1},d(a){a&&(l(h),l(T)),g(p,a),g(c,a),g(U,a)}}}function Ie(G){let p,h,c,T="The Hugging Face InferenceClient supports streaming similar to the OpenAI client:",U,y,a;return p=new E({props:{title:"Hugging Face InferenceClient Streaming",local:"hugging-face-inferenceclient-streaming",headingTag:"h3"}}),y=new W({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(
    base_url=<span class="hljs-string">&quot;&lt;endpoint-url&gt;/v1/&quot;</span>,
    token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat_with_hf_streaming</span>(<span class="hljs-params">message, history</span>):
    <span class="hljs-comment"># Convert history to messages format</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: msg[<span class="hljs-string">&quot;role&quot;</span>], <span class="hljs-string">&quot;content&quot;</span>: msg[<span class="hljs-string">&quot;content&quot;</span>]} <span class="hljs-keyword">for</span> msg <span class="hljs-keyword">in</span> history]
    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: message})
    
    <span class="hljs-comment"># Create streaming chat completion</span>
    chat_completion = client.chat.completions.create(
        model=<span class="hljs-string">&quot;endpoint-name&quot;</span>,
        messages=messages,
        max_tokens=<span class="hljs-number">150</span>,
        temperature=<span class="hljs-number">0.7</span>,
        stream=<span class="hljs-literal">True</span>  <span class="hljs-comment"># Enable streaming</span>
    )
    
    response = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> chat_completion:
        <span class="hljs-keyword">if</span> chunk.choices[<span class="hljs-number">0</span>].delta.content:
            response += chunk.choices[<span class="hljs-number">0</span>].delta.content
            <span class="hljs-keyword">yield</span> response  <span class="hljs-comment"># Yield partial response for streaming</span>

<span class="hljs-comment"># Create streaming interface</span>
demo = gr.ChatInterface(
    fn=chat_with_hf_streaming,
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
    title=<span class="hljs-string">&quot;Streaming Chat with Inference Endpoints&quot;</span>
)

demo.launch()`,wrap:!1}}),{c(){w(p.$$.fragment),h=o(),c=r("p"),c.textContent=T,U=o(),w(y.$$.fragment)},l(n){d(p.$$.fragment,n),h=i(n),c=u(n,"P",{"data-svelte-h":!0}),j(c)!=="svelte-tuciwp"&&(c.textContent=T),U=i(n),d(y.$$.fragment,n)},m(n,J){I(p,n,J),e(n,h,J),e(n,c,J),e(n,U,J),I(y,n,J),a=!0},p:gt,i(n){a||(C(p.$$.fragment,n),C(y.$$.fragment,n),a=!0)},o(n){f(p.$$.fragment,n),f(y.$$.fragment,n),a=!1},d(n){n&&(l(h),l(c),l(U)),g(p,n),g(y,n)}}}function Ce(G){let p,h,c,T="To use streaming with the OpenAI client, we need to set <code>stream=True</code> and yield the response as it builds:",U,y,a;return p=new E({props:{title:"OpenAI Client Streaming",local:"openai-client-streaming",headingTag:"h3"}}),y=new W({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSShiYXNlX3VybCUzRCUyMiUzQ2VuZHBvaW50LXVybCUzRSUyRnYxJTJGJTIyJTJDJTIwYXBpX2tleSUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMikpJTBBJTBBJTBBZGVmJTIwY2hhdF93aXRoX3N0cmVhbWluZyhtZXNzYWdlJTJDJTIwaGlzdG9yeSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBDb252ZXJ0JTIwaGlzdG9yeSUyMHRvJTIwT3BlbkFJJTIwZm9ybWF0JTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwbXNnJTVCJTIycm9sZSUyMiU1RCUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBtc2clNUIlMjJjb250ZW50JTIyJTVEJTdEJTIwZm9yJTIwbXNnJTIwaW4lMjBoaXN0b3J5JTVEJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMG1lc3NhZ2UlN0QpJTBBJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyZW5kcG9pbnQtbmFtZSUyMiUyQyUyMCUyMyUyMFVzZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHlvdXIlMjBlbmRwb2ludCUyMChpLmUuJTIwcXdlbjMtMS43Yi14eHh4KSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjBtYXhfdG9rZW5zJTNEMTUwJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjclMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTIwJTIwJTIzJTIwRW5hYmxlJTIwc3RyZWFtaW5nJTBBKSUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwJTIyJTIyJTBBZm9yJTIwY2h1bmslMjBpbiUyMGNoYXRfY29tcGxldGlvbiUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwY2h1bmsuY2hvaWNlcyU1QjAlNUQuZGVsdGEuY29udGVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTJCJTNEJTIwY2h1bmsuY2hvaWNlcyU1QjAlNUQuZGVsdGEuY29udGVudCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHlpZWxkJTIwcmVzcG9uc2UlMjAlMjAlMjMlMjBZaWVsZCUyMHBhcnRpYWwlMjByZXNwb25zZSUyMGZvciUyMHN0cmVhbWluZyUwQSUwQSUwQSUyMyUyMENyZWF0ZSUyMHN0cmVhbWluZyUyMGludGVyZmFjZSUwQWRlbW8lMjAlM0QlMjBnci5DaGF0SW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEY2hhdF93aXRoX3N0cmVhbWluZyUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJtZXNzYWdlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyU3RyZWFtaW5nJTIwQ2hhdCUyMHdpdGglMjBJbmZlcmVuY2UlMjBFbmRwb2ludHMlMjIlMkMlMEEpJTBBJTBBZGVtby5sYXVuY2goKSUwQQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(base_url=<span class="hljs-string">&quot;&lt;endpoint-url&gt;/v1/&quot;</span>, api_key=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>))


<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat_with_streaming</span>(<span class="hljs-params">message, history</span>):
    <span class="hljs-comment"># Convert history to OpenAI format</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: msg[<span class="hljs-string">&quot;role&quot;</span>], <span class="hljs-string">&quot;content&quot;</span>: msg[<span class="hljs-string">&quot;content&quot;</span>]} <span class="hljs-keyword">for</span> msg <span class="hljs-keyword">in</span> history]
    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: message})


chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;endpoint-name&quot;</span>, <span class="hljs-comment"># Use the name of your endpoint (i.e. qwen3-1.7b-xxxx)</span>
    messages=messages,
    max_tokens=<span class="hljs-number">150</span>,
    temperature=<span class="hljs-number">0.7</span>,
    stream=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable streaming</span>
)

response = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> chat_completion:
    <span class="hljs-keyword">if</span> chunk.choices[<span class="hljs-number">0</span>].delta.content:
        response += chunk.choices[<span class="hljs-number">0</span>].delta.content
        <span class="hljs-keyword">yield</span> response  <span class="hljs-comment"># Yield partial response for streaming</span>


<span class="hljs-comment"># Create streaming interface</span>
demo = gr.ChatInterface(
    fn=chat_with_streaming,
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
    title=<span class="hljs-string">&quot;Streaming Chat with Inference Endpoints&quot;</span>,
)

demo.launch()
`,wrap:!1}}),{c(){w(p.$$.fragment),h=o(),c=r("p"),c.innerHTML=T,U=o(),w(y.$$.fragment)},l(n){d(p.$$.fragment,n),h=i(n),c=u(n,"P",{"data-svelte-h":!0}),j(c)!=="svelte-21doe5"&&(c.innerHTML=T),U=i(n),d(y.$$.fragment,n)},m(n,J){I(p,n,J),e(n,h,J),e(n,c,J),e(n,U,J),I(y,n,J),a=!0},p:gt,i(n){a||(C(p.$$.fragment,n),C(y.$$.fragment,n),a=!0)},o(n){f(p.$$.fragment,n),f(y.$$.fragment,n),a=!1},d(n){n&&(l(h),l(c),l(U)),g(p,n),g(y,n)}}}function fe(G){let p,h,c,T="For requests, you can use the streaming approach with the Messages API by setting <code>stream=True</code>:",U,y,a;return p=new E({props:{title:"Requests Library Streaming",local:"requests-library-streaming",headingTag:"h3"}}),y=new W({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> json

API_URL = <span class="hljs-string">&quot;https://&lt;id&gt;.&lt;region&gt;.&lt;cloud&gt;.endpoints.huggingface.cloud/v1/chat/completions&quot;</span>

headers = {
    <span class="hljs-string">&quot;Accept&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
    <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
    <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}</span>&quot;</span>,
}


<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat_with_requests_streaming</span>(<span class="hljs-params">message, history</span>):
    <span class="hljs-comment"># Convert Gradio history to messages format</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: msg[<span class="hljs-string">&quot;role&quot;</span>], <span class="hljs-string">&quot;content&quot;</span>: msg[<span class="hljs-string">&quot;content&quot;</span>]} <span class="hljs-keyword">for</span> msg <span class="hljs-keyword">in</span> history]
    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: message})

    <span class="hljs-comment"># Prepare payload using Messages API format</span>
    payload = {
        <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;smollm2-1-7b-instruct-ljn&quot;</span>,
        <span class="hljs-string">&quot;messages&quot;</span>: messages,
        <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">150</span>,
        <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
        <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable streaming</span>
    }

    response = requests.post(API_URL, headers=headers, json=payload, stream=<span class="hljs-literal">True</span>)

    content = <span class="hljs-string">&quot;&quot;</span>

    <span class="hljs-keyword">for</span> line <span class="hljs-keyword">in</span> response.iter_lines():
        line = line.decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-keyword">if</span> line.startswith(<span class="hljs-string">&quot;data: &quot;</span>) <span class="hljs-keyword">and</span> <span class="hljs-keyword">not</span> line.endswith(<span class="hljs-string">&quot;[DONE]&quot;</span>):
            data = json.loads(line[<span class="hljs-built_in">len</span>(<span class="hljs-string">&quot;data: &quot;</span>) :])
            chunk = data[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;delta&quot;</span>].get(<span class="hljs-string">&quot;content&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)
            content += chunk
            <span class="hljs-keyword">yield</span> content


<span class="hljs-comment"># Create streaming interface</span>
demo = gr.ChatInterface(
    fn=chat_with_requests_streaming,
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
    title=<span class="hljs-string">&quot;Streaming Chat with Inference Endpoints&quot;</span>,
)

demo.launch()
`,wrap:!1}}),{c(){w(p.$$.fragment),h=o(),c=r("p"),c.innerHTML=T,U=o(),w(y.$$.fragment)},l(n){d(p.$$.fragment,n),h=i(n),c=u(n,"P",{"data-svelte-h":!0}),j(c)!=="svelte-1yg3qym"&&(c.innerHTML=T),U=i(n),d(y.$$.fragment,n)},m(n,J){I(p,n,J),e(n,h,J),e(n,c,J),e(n,U,J),I(y,n,J),a=!0},p:gt,i(n){a||(C(p.$$.fragment,n),C(y.$$.fragment,n),a=!0)},o(n){f(p.$$.fragment,n),f(y.$$.fragment,n),a=!1},d(n){n&&(l(h),l(c),l(U)),g(p,n),g(y,n)}}}function ge(G){let p,h,c,T,U,y;return p=new bt({props:{id:"streaming-implementation",option:"hf-client",$$slots:{default:[Ie]},$$scope:{ctx:G}}}),c=new bt({props:{id:"streaming-implementation",option:"openai-client",$$slots:{default:[Ce]},$$scope:{ctx:G}}}),U=new bt({props:{id:"streaming-implementation",option:"requests",$$slots:{default:[fe]},$$scope:{ctx:G}}}),{c(){w(p.$$.fragment),h=o(),w(c.$$.fragment),T=o(),w(U.$$.fragment)},l(a){d(p.$$.fragment,a),h=i(a),d(c.$$.fragment,a),T=i(a),d(U.$$.fragment,a)},m(a,n){I(p,a,n),e(a,h,n),I(c,a,n),e(a,T,n),I(U,a,n),y=!0},p(a,n){const J={};n&2&&(J.$$scope={dirty:n,ctx:a}),p.$set(J);const Z={};n&2&&(Z.$$scope={dirty:n,ctx:a}),c.$set(Z);const B={};n&2&&(B.$$scope={dirty:n,ctx:a}),U.$set(B)},i(a){y||(C(p.$$.fragment,a),C(c.$$.fragment,a),C(U.$$.fragment,a),y=!0)},o(a){f(p.$$.fragment,a),f(c.$$.fragment,a),f(U.$$.fragment,a),y=!1},d(a){a&&(l(h),l(T)),g(p,a),g(c,a),g(U,a)}}}function be(G){let p,h,c,T,U,y,a,n="This tutorial will guide you from end to end on how to deploy your own chat application using Hugging Face Inference Endpoints. We will use Gradio to create a chat interface and an OpenAI client to connect to the Inference Endpoint.",J,Z,B,b,A="Prerequisites:",M,m,Il="<li>A running Inference Endpoint (created in the previous unit)</li> <li>Your endpoint URL and an access token</li>",Zt,v,Gt,Q,Cl="First, we need to create an Inference Endpoint for a model that can chat.",At,N,fl=`Start by navigating to the Inference Endpoints UI, and once you have logged in you should see a button for creating a new Inference
Endpoint. Click the “New” button.`,Et,k,gl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/quick_start/1-new-button.png" alt="new-button"/>',Wt,V,bl=`From there you’ll be directed to the catalog. The Model Catalog consists of popular models which have tuned configurations to work just as one-click
deploys. You can filter by name, task, price of the hardware and much more.`,$t,S,Bl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/quick_start/2-catalog.png" alt="catalog"/>',qt,X,Zl=`In this example let’s deploy the <a href="https://huggingface.co/Qwen/Qwen3-1.7B" rel="nofollow">Qwen/Qwen3-1.7B</a> model. You can find
it by searching for <code>qwen3 1.7b</code> in the search field and deploy it by clicking the card.`,vt,R,Gl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/chatbot/qwen-search.png" alt="qwen"/>',Qt,z,Al=`Next we’ll choose which hardware and deployment settings we’ll go for. Since this is a catalog model, all of the pre-selected options are very good
defaults. So in this case we don’t need to change anything. In case you want a deeper dive on what the different settings mean you can check out
the <a href="./guides/configuration">configuration guide</a>.`,Nt,_,El=`For this model the Nvidia L4 is the recommended choice. It will be perfect for our testing. Performant but still reasonably priced. Also note that by
default the endpoint will scale down to zero, meaning it will become idle after 1h of inactivity.`,kt,Y,Wl="Now all you need to do is click click “Create Endpoint” 🚀",Vt,x,$l='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/chatbot/config.png" alt="config"/>',St,F,ql=`Now our Inference Endpoint is initializing, which usually takes about 3-5 minutes. If you want to can allow browser notifications which will give you a
ping once the endpoint reaches a running state.`,Xt,H,vl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/chatbot/init.png" alt="init"/>',Rt,L,zt,P,Ql="Now that we’ve created our Inference Endpoint, we can test it in the playground section.",_t,D,Nl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/chatbot/playground.png" alt="playground"/>',Yt,K,kl="You can use the model through a chat interface or copy code snippets to use it in your own application.",xt,O,Ft,tt,Vl='We need to grab details of our Inference Endpoint, which we can find in the Endpoint’s <a href="https://endpoints.huggingface.co/" rel="nofollow">Overview</a>. We will need the following details:',Ht,lt,Sl="<li>The base URL of the endpoint plus the version of the OpenAI API (e.g. <code>https://&lt;id&gt;.&lt;region&gt;.&lt;cloud&gt;.endpoints.huggingface.cloud/v1/</code>)</li> <li>The name of the endpoint to use (e.g. <code>qwen3-1-7b-xll</code>)</li> <li>The token to use for authentication (e.g. <code>hf_&lt;token&gt;</code>)</li>",Lt,et,Xl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/chatbot/endpoint-page.png" alt="endpoint-details"/>',Pt,st,Rl='We can find the token in your <a href="https://huggingface.co/settings/tokens" rel="nofollow">account settings</a> which is accessible from the top dropdown and clicking on your account name.',Dt,nt,Kt,at,zl='The easiest way to deploy a chat application with <a href="https://gradio.app/" rel="nofollow">Gradio</a> is to use the convenient <code>load_chat</code> method. This abstracts everything away and you can have a working chat application quickly.',Ot,Mt,tl,pt,_l="The <code>load_chat</code> method won’t cater for your production needs, but it’s a great way to get started and test your application.",ll,ot,el,it,Yl="If you want more control over your chat application, you can build your own custom chat interface with Gradio. This gives you more flexibility to customize the behavior, add features, and handle errors.",sl,ct,xl="Choose your preferred method for connecting to Inference Endpoints:",nl,$,al,yt,Ml,rt,Fl="For a better user experience, you can implement streaming responses. This will require us to handle the messages and <code>yield</code> them to the client.",pl,ut,Hl="Here’s how to add streaming to each client:",ol,q,il,Jt,cl,jt,Ll="Our app will run on port 7860 and look like this:",yl,Tt,Pl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/chatbot/app.png" alt="Gradio app"/>',rl,Ut,Dl="To deploy, we’ll need to create a new Space and upload our files.",ul,ht,Kl='<li><strong>Create a new Space</strong>: Go to <a href="https://huggingface.co/new-space" rel="nofollow">huggingface.co/new-space</a></li> <li><strong>Choose Gradio SDK</strong> and make it public</li> <li><strong>Upload your files</strong>: Upload <code>app.py</code></li> <li><strong>Add your token</strong>: In Space settings, add <code>HF_TOKEN</code> as a secret (get it from <a href="https://huggingface.co/settings/tokens" rel="nofollow">your settings</a>)</li> <li><strong>Launch</strong>: Your app will be live at <code>https://huggingface.co/spaces/your-username/your-space-name</code></li>',Jl,mt,Ol="<p><strong>Note</strong>: While we used CLI authentication locally, Spaces requires the token as a secret for the deployment environment.</p>",jl,wt,te="When you’re comfortable with your app, continue to the summary and quiz.",Tl,dt,Ul,It,le="That’s it! You now have a chat application running on Hugging Face Spaces powered by Inference Endpoints.",hl,Ct,ee='Why not level up and try out the <a href="./tutorials/transcription">next guide</a> to build a Text-to-Speech application?',ml,ft,wl,Bt,dl;return U=new E({props:{title:"End to end AI Application with Inference Endpoints",local:"end-to-end-ai-application-with-inference-endpoints",headingTag:"h1"}}),Z=new je({props:{$$slots:{default:[Ue]},$$scope:{ctx:G}}}),v=new E({props:{title:"Create your Inference Endpoint",local:"create-your-inference-endpoint",headingTag:"h2"}}),L=new E({props:{title:"Test your Inference Endpoint in the browser",local:"test-your-inference-endpoint-in-the-browser",headingTag:"h2"}}),O=new E({props:{title:"Get your Inference Endpoint details",local:"get-your-inference-endpoint-details",headingTag:"h2"}}),nt=new E({props:{title:"Deploy in a few lines of code",local:"deploy-in-a-few-lines-of-code",headingTag:"h2"}}),Mt=new W({props:{code:"aW1wb3J0JTIwb3MlMEElMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBJTBBZ3IubG9hZF9jaGF0KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEJTIyJTNDZW5kcG9pbnQtdXJsJTNFJTJGdjElMkYlMjIlMkMlMjAlMjMlMjBSZXBsYWNlJTIwd2l0aCUyMHlvdXIlMjBlbmRwb2ludCUyMFVSTCUyMCUyQiUyMHZlcnNpb24lMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmVuZHBvaW50LW5hbWUlMjIlMkMlMjAlMjMlMjBSZXBsYWNlJTIwd2l0aCUyMHlvdXIlMjBlbmRwb2ludCUyMG5hbWUlMEElMjAlMjAlMjAlMjB0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMkMlMjAlMjMlMjBSZXBsYWNlJTIwd2l0aCUyMHlvdXIlMjB0b2tlbiUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

gr.load_chat(
    base_url=<span class="hljs-string">&quot;&lt;endpoint-url&gt;/v1/&quot;</span>, <span class="hljs-comment"># Replace with your endpoint URL + version</span>
    model=<span class="hljs-string">&quot;endpoint-name&quot;</span>, <span class="hljs-comment"># Replace with your endpoint name</span>
    token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>), <span class="hljs-comment"># Replace with your token</span>
).launch()`,wrap:!1}}),ot=new E({props:{title:"Build your own custom chat application",local:"build-your-own-custom-chat-application",headingTag:"h2"}}),$=new oe({props:{id:"chat-implementation",options:["hf-client","openai-client","requests"],$$slots:{default:[de]},$$scope:{ctx:G}}}),yt=new E({props:{title:"Adding Streaming Support",local:"adding-streaming-support",headingTag:"h2"}}),q=new oe({props:{id:"streaming-implementation",options:["hf-client","openai-client","requests"],$$slots:{default:[ge]},$$scope:{ctx:G}}}),Jt=new E({props:{title:"Deploy your chat application",local:"deploy-your-chat-application",headingTag:"h2"}}),dt=new E({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),ft=new Te({props:{source:"https://github.com/huggingface/101-course/blob/main/chapters/en/chapter2/5.mdx"}}),{c(){p=r("meta"),h=o(),c=r("p"),T=o(),w(U.$$.fragment),y=o(),a=r("p"),a.textContent=n,J=o(),w(Z.$$.fragment),B=o(),b=r("p"),b.textContent=A,M=o(),m=r("ul"),m.innerHTML=Il,Zt=o(),w(v.$$.fragment),Gt=o(),Q=r("p"),Q.textContent=Cl,At=o(),N=r("p"),N.textContent=fl,Et=o(),k=r("p"),k.innerHTML=gl,Wt=o(),V=r("p"),V.textContent=bl,$t=o(),S=r("p"),S.innerHTML=Bl,qt=o(),X=r("p"),X.innerHTML=Zl,vt=o(),R=r("p"),R.innerHTML=Gl,Qt=o(),z=r("p"),z.innerHTML=Al,Nt=o(),_=r("p"),_.textContent=El,kt=o(),Y=r("p"),Y.textContent=Wl,Vt=o(),x=r("p"),x.innerHTML=$l,St=o(),F=r("p"),F.textContent=ql,Xt=o(),H=r("p"),H.innerHTML=vl,Rt=o(),w(L.$$.fragment),zt=o(),P=r("p"),P.textContent=Ql,_t=o(),D=r("p"),D.innerHTML=Nl,Yt=o(),K=r("p"),K.textContent=kl,xt=o(),w(O.$$.fragment),Ft=o(),tt=r("p"),tt.innerHTML=Vl,Ht=o(),lt=r("ul"),lt.innerHTML=Sl,Lt=o(),et=r("p"),et.innerHTML=Xl,Pt=o(),st=r("p"),st.innerHTML=Rl,Dt=o(),w(nt.$$.fragment),Kt=o(),at=r("p"),at.innerHTML=zl,Ot=o(),w(Mt.$$.fragment),tl=o(),pt=r("p"),pt.innerHTML=_l,ll=o(),w(ot.$$.fragment),el=o(),it=r("p"),it.textContent=Yl,sl=o(),ct=r("p"),ct.textContent=xl,nl=o(),w($.$$.fragment),al=o(),w(yt.$$.fragment),Ml=o(),rt=r("p"),rt.innerHTML=Fl,pl=o(),ut=r("p"),ut.textContent=Hl,ol=o(),w(q.$$.fragment),il=o(),w(Jt.$$.fragment),cl=o(),jt=r("p"),jt.textContent=Ll,yl=o(),Tt=r("p"),Tt.innerHTML=Pl,rl=o(),Ut=r("p"),Ut.textContent=Dl,ul=o(),ht=r("ol"),ht.innerHTML=Kl,Jl=o(),mt=r("blockquote"),mt.innerHTML=Ol,jl=o(),wt=r("p"),wt.textContent=te,Tl=o(),w(dt.$$.fragment),Ul=o(),It=r("p"),It.textContent=le,hl=o(),Ct=r("p"),Ct.innerHTML=ee,ml=o(),w(ft.$$.fragment),wl=o(),Bt=r("p"),this.h()},l(t){const s=ue("svelte-u9bgzb",document.head);p=u(s,"META",{name:!0,content:!0}),s.forEach(l),h=i(t),c=u(t,"P",{}),Me(c).forEach(l),T=i(t),d(U.$$.fragment,t),y=i(t),a=u(t,"P",{"data-svelte-h":!0}),j(a)!=="svelte-1k65zp7"&&(a.textContent=n),J=i(t),d(Z.$$.fragment,t),B=i(t),b=u(t,"P",{"data-svelte-h":!0}),j(b)!=="svelte-4fn3fh"&&(b.textContent=A),M=i(t),m=u(t,"UL",{"data-svelte-h":!0}),j(m)!=="svelte-75kv7o"&&(m.innerHTML=Il),Zt=i(t),d(v.$$.fragment,t),Gt=i(t),Q=u(t,"P",{"data-svelte-h":!0}),j(Q)!=="svelte-15thrvo"&&(Q.textContent=Cl),At=i(t),N=u(t,"P",{"data-svelte-h":!0}),j(N)!=="svelte-147h3qd"&&(N.textContent=fl),Et=i(t),k=u(t,"P",{"data-svelte-h":!0}),j(k)!=="svelte-dnyg4"&&(k.innerHTML=gl),Wt=i(t),V=u(t,"P",{"data-svelte-h":!0}),j(V)!=="svelte-11utja6"&&(V.textContent=bl),$t=i(t),S=u(t,"P",{"data-svelte-h":!0}),j(S)!=="svelte-fxecmn"&&(S.innerHTML=Bl),qt=i(t),X=u(t,"P",{"data-svelte-h":!0}),j(X)!=="svelte-1hfg5l1"&&(X.innerHTML=Zl),vt=i(t),R=u(t,"P",{"data-svelte-h":!0}),j(R)!=="svelte-lar0em"&&(R.innerHTML=Gl),Qt=i(t),z=u(t,"P",{"data-svelte-h":!0}),j(z)!=="svelte-1ekjdqo"&&(z.innerHTML=Al),Nt=i(t),_=u(t,"P",{"data-svelte-h":!0}),j(_)!=="svelte-1baa6m9"&&(_.textContent=El),kt=i(t),Y=u(t,"P",{"data-svelte-h":!0}),j(Y)!=="svelte-uhpblt"&&(Y.textContent=Wl),Vt=i(t),x=u(t,"P",{"data-svelte-h":!0}),j(x)!=="svelte-13bbzr1"&&(x.innerHTML=$l),St=i(t),F=u(t,"P",{"data-svelte-h":!0}),j(F)!=="svelte-1ujocpz"&&(F.textContent=ql),Xt=i(t),H=u(t,"P",{"data-svelte-h":!0}),j(H)!=="svelte-1vjlki5"&&(H.innerHTML=vl),Rt=i(t),d(L.$$.fragment,t),zt=i(t),P=u(t,"P",{"data-svelte-h":!0}),j(P)!=="svelte-19rlqt8"&&(P.textContent=Ql),_t=i(t),D=u(t,"P",{"data-svelte-h":!0}),j(D)!=="svelte-1ka9eqz"&&(D.innerHTML=Nl),Yt=i(t),K=u(t,"P",{"data-svelte-h":!0}),j(K)!=="svelte-1pdktab"&&(K.textContent=kl),xt=i(t),d(O.$$.fragment,t),Ft=i(t),tt=u(t,"P",{"data-svelte-h":!0}),j(tt)!=="svelte-1lccfab"&&(tt.innerHTML=Vl),Ht=i(t),lt=u(t,"UL",{"data-svelte-h":!0}),j(lt)!=="svelte-zmd562"&&(lt.innerHTML=Sl),Lt=i(t),et=u(t,"P",{"data-svelte-h":!0}),j(et)!=="svelte-2v5kr8"&&(et.innerHTML=Xl),Pt=i(t),st=u(t,"P",{"data-svelte-h":!0}),j(st)!=="svelte-y2qnlj"&&(st.innerHTML=Rl),Dt=i(t),d(nt.$$.fragment,t),Kt=i(t),at=u(t,"P",{"data-svelte-h":!0}),j(at)!=="svelte-bfky2a"&&(at.innerHTML=zl),Ot=i(t),d(Mt.$$.fragment,t),tl=i(t),pt=u(t,"P",{"data-svelte-h":!0}),j(pt)!=="svelte-1gpt8m1"&&(pt.innerHTML=_l),ll=i(t),d(ot.$$.fragment,t),el=i(t),it=u(t,"P",{"data-svelte-h":!0}),j(it)!=="svelte-1krh3b"&&(it.textContent=Yl),sl=i(t),ct=u(t,"P",{"data-svelte-h":!0}),j(ct)!=="svelte-4kkdzr"&&(ct.textContent=xl),nl=i(t),d($.$$.fragment,t),al=i(t),d(yt.$$.fragment,t),Ml=i(t),rt=u(t,"P",{"data-svelte-h":!0}),j(rt)!=="svelte-7z4ymg"&&(rt.innerHTML=Fl),pl=i(t),ut=u(t,"P",{"data-svelte-h":!0}),j(ut)!=="svelte-ttzscb"&&(ut.textContent=Hl),ol=i(t),d(q.$$.fragment,t),il=i(t),d(Jt.$$.fragment,t),cl=i(t),jt=u(t,"P",{"data-svelte-h":!0}),j(jt)!=="svelte-1n5m4re"&&(jt.textContent=Ll),yl=i(t),Tt=u(t,"P",{"data-svelte-h":!0}),j(Tt)!=="svelte-rhi1bh"&&(Tt.innerHTML=Pl),rl=i(t),Ut=u(t,"P",{"data-svelte-h":!0}),j(Ut)!=="svelte-13uvzr6"&&(Ut.textContent=Dl),ul=i(t),ht=u(t,"OL",{"data-svelte-h":!0}),j(ht)!=="svelte-1yvydwn"&&(ht.innerHTML=Kl),Jl=i(t),mt=u(t,"BLOCKQUOTE",{"data-svelte-h":!0}),j(mt)!=="svelte-1gqrdse"&&(mt.innerHTML=Ol),jl=i(t),wt=u(t,"P",{"data-svelte-h":!0}),j(wt)!=="svelte-14hpp8c"&&(wt.textContent=te),Tl=i(t),d(dt.$$.fragment,t),Ul=i(t),It=u(t,"P",{"data-svelte-h":!0}),j(It)!=="svelte-xl8t4e"&&(It.textContent=le),hl=i(t),Ct=u(t,"P",{"data-svelte-h":!0}),j(Ct)!=="svelte-19b7xtr"&&(Ct.innerHTML=ee),ml=i(t),d(ft.$$.fragment,t),wl=i(t),Bt=u(t,"P",{}),Me(Bt).forEach(l),this.h()},h(){pe(p,"name","hf:doc:metadata"),pe(p,"content",Be)},m(t,s){Je(document.head,p),e(t,h,s),e(t,c,s),e(t,T,s),I(U,t,s),e(t,y,s),e(t,a,s),e(t,J,s),I(Z,t,s),e(t,B,s),e(t,b,s),e(t,M,s),e(t,m,s),e(t,Zt,s),I(v,t,s),e(t,Gt,s),e(t,Q,s),e(t,At,s),e(t,N,s),e(t,Et,s),e(t,k,s),e(t,Wt,s),e(t,V,s),e(t,$t,s),e(t,S,s),e(t,qt,s),e(t,X,s),e(t,vt,s),e(t,R,s),e(t,Qt,s),e(t,z,s),e(t,Nt,s),e(t,_,s),e(t,kt,s),e(t,Y,s),e(t,Vt,s),e(t,x,s),e(t,St,s),e(t,F,s),e(t,Xt,s),e(t,H,s),e(t,Rt,s),I(L,t,s),e(t,zt,s),e(t,P,s),e(t,_t,s),e(t,D,s),e(t,Yt,s),e(t,K,s),e(t,xt,s),I(O,t,s),e(t,Ft,s),e(t,tt,s),e(t,Ht,s),e(t,lt,s),e(t,Lt,s),e(t,et,s),e(t,Pt,s),e(t,st,s),e(t,Dt,s),I(nt,t,s),e(t,Kt,s),e(t,at,s),e(t,Ot,s),I(Mt,t,s),e(t,tl,s),e(t,pt,s),e(t,ll,s),I(ot,t,s),e(t,el,s),e(t,it,s),e(t,sl,s),e(t,ct,s),e(t,nl,s),I($,t,s),e(t,al,s),I(yt,t,s),e(t,Ml,s),e(t,rt,s),e(t,pl,s),e(t,ut,s),e(t,ol,s),I(q,t,s),e(t,il,s),I(Jt,t,s),e(t,cl,s),e(t,jt,s),e(t,yl,s),e(t,Tt,s),e(t,rl,s),e(t,Ut,s),e(t,ul,s),e(t,ht,s),e(t,Jl,s),e(t,mt,s),e(t,jl,s),e(t,wt,s),e(t,Tl,s),I(dt,t,s),e(t,Ul,s),e(t,It,s),e(t,hl,s),e(t,Ct,s),e(t,ml,s),I(ft,t,s),e(t,wl,s),e(t,Bt,s),dl=!0},p(t,[s]){const se={};s&2&&(se.$$scope={dirty:s,ctx:t}),Z.$set(se);const ne={};s&2&&(ne.$$scope={dirty:s,ctx:t}),$.$set(ne);const ae={};s&2&&(ae.$$scope={dirty:s,ctx:t}),q.$set(ae)},i(t){dl||(C(U.$$.fragment,t),C(Z.$$.fragment,t),C(v.$$.fragment,t),C(L.$$.fragment,t),C(O.$$.fragment,t),C(nt.$$.fragment,t),C(Mt.$$.fragment,t),C(ot.$$.fragment,t),C($.$$.fragment,t),C(yt.$$.fragment,t),C(q.$$.fragment,t),C(Jt.$$.fragment,t),C(dt.$$.fragment,t),C(ft.$$.fragment,t),dl=!0)},o(t){f(U.$$.fragment,t),f(Z.$$.fragment,t),f(v.$$.fragment,t),f(L.$$.fragment,t),f(O.$$.fragment,t),f(nt.$$.fragment,t),f(Mt.$$.fragment,t),f(ot.$$.fragment,t),f($.$$.fragment,t),f(yt.$$.fragment,t),f(q.$$.fragment,t),f(Jt.$$.fragment,t),f(dt.$$.fragment,t),f(ft.$$.fragment,t),dl=!1},d(t){t&&(l(h),l(c),l(T),l(y),l(a),l(J),l(B),l(b),l(M),l(m),l(Zt),l(Gt),l(Q),l(At),l(N),l(Et),l(k),l(Wt),l(V),l($t),l(S),l(qt),l(X),l(vt),l(R),l(Qt),l(z),l(Nt),l(_),l(kt),l(Y),l(Vt),l(x),l(St),l(F),l(Xt),l(H),l(Rt),l(zt),l(P),l(_t),l(D),l(Yt),l(K),l(xt),l(Ft),l(tt),l(Ht),l(lt),l(Lt),l(et),l(Pt),l(st),l(Dt),l(Kt),l(at),l(Ot),l(tl),l(pt),l(ll),l(el),l(it),l(sl),l(ct),l(nl),l(al),l(Ml),l(rt),l(pl),l(ut),l(ol),l(il),l(cl),l(jt),l(yl),l(Tt),l(rl),l(Ut),l(ul),l(ht),l(Jl),l(mt),l(jl),l(wt),l(Tl),l(Ul),l(It),l(hl),l(Ct),l(ml),l(wl),l(Bt)),l(p),g(U,t),g(Z,t),g(v,t),g(L,t),g(O,t),g(nt,t),g(Mt,t),g(ot,t),g($,t),g(yt,t),g(q,t),g(Jt,t),g(dt,t),g(ft,t)}}}const Be='{"title":"End to end AI Application with Inference Endpoints","local":"end-to-end-ai-application-with-inference-endpoints","sections":[{"title":"Create your Inference Endpoint","local":"create-your-inference-endpoint","sections":[],"depth":2},{"title":"Test your Inference Endpoint in the browser","local":"test-your-inference-endpoint-in-the-browser","sections":[],"depth":2},{"title":"Get your Inference Endpoint details","local":"get-your-inference-endpoint-details","sections":[],"depth":2},{"title":"Deploy in a few lines of code","local":"deploy-in-a-few-lines-of-code","sections":[],"depth":2},{"title":"Build your own custom chat application","local":"build-your-own-custom-chat-application","sections":[],"depth":2},{"title":"Adding Streaming Support","local":"adding-streaming-support","sections":[{"title":"Hugging Face InferenceClient Streaming","local":"hugging-face-inferenceclient-streaming","sections":[],"depth":3},{"title":"OpenAI Client Streaming","local":"openai-client-streaming","sections":[],"depth":3},{"title":"Requests Library Streaming","local":"requests-library-streaming","sections":[],"depth":3}],"depth":2},{"title":"Deploy your chat application","local":"deploy-your-chat-application","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Ze(G){return ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ve extends ye{constructor(p){super(),re(this,p,Ze,be,ie,{})}}export{ve as component};
