import{s as cl,n as ul,o as Ml}from"../chunks/scheduler.1d51f4c0.js";import{S as ml,i as hl,g as a,s,r as c,m as Se,A as yl,h as p,f as l,c as i,j as w,u,x as r,n as He,k as _e,y as o,a as n,v as M,d as m,t as h,w as y}from"../chunks/index.fda43871.js";import{C as b}from"../chunks/CodeBlock.16130beb.js";import{H as g,E as dl}from"../chunks/getInferenceSnippets.58a43ad0.js";function Tl(We){let U,$t,bt,xt,v,Bt,I,Ge="In this section, we’ll create our sentiment analysis MCP server using Gradio. This server will expose a sentiment analysis tool that can be used by both human users through a web interface and AI models through the MCP protocol.",St,$,Ht,x,Re="Gradio provides a straightforward way to create MCP servers by automatically converting your Python functions into MCP tools. When you set <code>mcp_server=True</code> in <code>launch()</code>, Gradio:",_t,B,Le="<li>Automatically converts your functions into MCP Tools</li> <li>Maps input components to tool argument schemas</li> <li>Determines response formats from output components</li> <li>Sets up JSON-RPC over HTTP+SSE for client-server communication</li> <li>Creates both a web interface and an MCP server endpoint</li>",Wt,S,Gt,H,Ze="First, let’s create a new directory for our project and set up the required dependencies:",Rt,_,Lt,W,Zt,G,Ae="<p>Hugging face spaces needs an app.py file to build the space. So the name of the python file has to be app.py</p>",At,R,Ee="Create a new file called <code>app.py</code> with the following code:",Et,L,Qt,Z,Nt,A,Qe="Let’s break down the key components:",kt,T,ut,Ne="<p><strong>Function Definition</strong>:</p> <ul><li>The <code>sentiment_analysis</code> function takes a text input and returns a dictionary</li> <li>It uses TextBlob to analyze the sentiment</li> <li>The docstring is crucial as it helps Gradio generate the MCP tool schema</li> <li>Type hints (<code>str</code> and <code>dict</code>) help define the input/output schema</li></ul>",Te,Mt,ke="<p><strong>Gradio Interface</strong>:</p> <ul><li><code>gr.Interface</code> creates both the web UI and MCP server</li> <li>The function is exposed as an MCP tool automatically</li> <li>Input and output components define the tool’s schema</li> <li>The JSON output component ensures proper serialization</li></ul>",we,E,mt,qe="<strong>MCP Server</strong>:",ge,J,ht,Ve="Setting <code>mcp_server=True</code> enables the MCP server",Ue,yt,Pe="The server will be available at <code>http://localhost:7860/gradio_api/mcp/sse</code>",Je,dt,Ce,Q,qt,N,Vt,k,Xe="Start the server by running:",Pt,q,Xt,V,Ye="You should see output indicating that both the web interface and MCP server are running. The web interface will be available at <code>http://localhost:7860</code>, and the MCP server at <code>http://localhost:7860/gradio_api/mcp/sse</code>.",Yt,P,zt,X,ze="You can test the server in two ways:",Ft,Y,Fe="<li><p><strong>Web Interface</strong>:</p> <ul><li>Open <code>http://localhost:7860</code> in your browser</li> <li>Enter some text and click “Submit”</li> <li>You should see the sentiment analysis results</li></ul></li> <li><p><strong>MCP Schema</strong>:</p> <ul><li>Visit <code>http://localhost:7860/gradio_api/mcp/schema</code></li> <li>This shows the MCP tool schema that clients will use</li> <li>You can also find this in the “View API” link in the footer of your Gradio app</li></ul></li>",Ot,z,Dt,d,Tt,Oe="<p><strong>Type Hints and Docstrings</strong>:</p> <ul><li>Always provide type hints for your function parameters and return values</li> <li>Include a docstring with an “Args:” block for each parameter</li> <li>This helps Gradio generate accurate MCP tool schemas</li></ul>",fe,wt,De="<p><strong>String Inputs</strong>:</p> <ul><li>When in doubt, accept input arguments as <code>str</code></li> <li>Convert them to the desired type inside the function</li> <li>This provides better compatibility with MCP clients</li></ul>",je,F,gt,Ke="<strong>SSE Support</strong>:",be,O,Ut,tl="Some MCP clients don’t support SSE-based MCP Servers",ve,C,Ie,Jt,el="mcp-remote",$e,D,xe,Ct,ll="<p><strong>Connection Issues</strong>:</p> <ul><li>If you encounter connection problems, try restarting both the client and server</li> <li>Check that the server is running and accessible</li> <li>Verify that the MCP schema is available at the expected URL</li></ul>",Kt,K,te,tt,nl="To make your server available to others, you can deploy it to Hugging Face Spaces:",ee,et,sl="<li><p>Create a new Space on Hugging Face:</p> <ul><li>Go to huggingface.co/spaces</li> <li>Click “Create new Space”</li> <li>Choose “Gradio” as the SDK</li> <li>Name your space (e.g., “mcp-sentiment”)</li></ul></li> <li><p>Create a <code>requirements.txt</code> file:</p></li>",le,lt,ne,f,il="<li>Push your code to the Space:</li>",se,nt,ie,st,al="Your MCP server will now be available at:",ae,it,pe,at,oe,pt,pl="Now that we have our MCP server running, we’ll create clients to interact with it. In the next sections, we’ll:",re,ot,ol="<li>Create a HuggingFace.js-based client inspired by Tiny Agents</li> <li>Implement a SmolAgents-based Python client</li> <li>Test both clients with our deployed server</li>",ce,rt,rl="Let’s move on to building our first client!",ue,ct,Me,vt,me;return v=new g({props:{title:"MCP Servers in Gradio",local:"mcp-servers-in-gradio",headingTag:"h1"}}),$=new g({props:{title:"Introduction to Gradio MCP Integration",local:"introduction-to-gradio-mcp-integration",headingTag:"h2"}}),S=new g({props:{title:"Setting Up the Project",local:"setting-up-the-project",headingTag:"h2"}}),_=new b({props:{code:"bWtkaXIlMjBtY3Atc2VudGltZW50JTBBY2QlMjBtY3Atc2VudGltZW50JTBBcHl0aG9uJTIwLW0lMjB2ZW52JTIwdmVudiUwQXNvdXJjZSUyMHZlbnYlMkZiaW4lMkZhY3RpdmF0ZSUyMCUyMCUyMyUyME9uJTIwV2luZG93cyUzQSUyMHZlbnYlNUNTY3JpcHRzJTVDYWN0aXZhdGUlMEFwaXAlMjBpbnN0YWxsJTIwJTIyZ3JhZGlvJTVCbWNwJTVEJTIyJTIwdGV4dGJsb2I=",highlighted:`<span class="hljs-built_in">mkdir</span> mcp-sentiment
<span class="hljs-built_in">cd</span> mcp-sentiment
python -m venv venv
<span class="hljs-built_in">source</span> venv/bin/activate  <span class="hljs-comment"># On Windows: venv\\Scripts\\activate</span>
pip install <span class="hljs-string">&quot;gradio[mcp]&quot;</span> textblob`,wrap:!1}}),W=new g({props:{title:"Creating the Server",local:"creating-the-server",headingTag:"h2"}}),L=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> textblob <span class="hljs-keyword">import</span> TextBlob

<span class="hljs-keyword">def</span> <span class="hljs-title function_">sentiment_analysis</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Analyze the sentiment of the given text.

    Args:
        text (str): The text to analyze

    Returns:
        str: A JSON string containing polarity, subjectivity, and assessment
    &quot;&quot;&quot;</span>
    blob = TextBlob(text)
    sentiment = blob.sentiment
    
    result = {
        <span class="hljs-string">&quot;polarity&quot;</span>: <span class="hljs-built_in">round</span>(sentiment.polarity, <span class="hljs-number">2</span>),  <span class="hljs-comment"># -1 (negative) to 1 (positive)</span>
        <span class="hljs-string">&quot;subjectivity&quot;</span>: <span class="hljs-built_in">round</span>(sentiment.subjectivity, <span class="hljs-number">2</span>),  <span class="hljs-comment"># 0 (objective) to 1 (subjective)</span>
        <span class="hljs-string">&quot;assessment&quot;</span>: <span class="hljs-string">&quot;positive&quot;</span> <span class="hljs-keyword">if</span> sentiment.polarity &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;negative&quot;</span> <span class="hljs-keyword">if</span> sentiment.polarity &lt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;neutral&quot;</span>
    }

    <span class="hljs-keyword">return</span> json.dumps(result)

<span class="hljs-comment"># Create the Gradio interface</span>
demo = gr.Interface(
    fn=sentiment_analysis,
    inputs=gr.Textbox(placeholder=<span class="hljs-string">&quot;Enter text to analyze...&quot;</span>),
    outputs=gr.Textbox(),  <span class="hljs-comment"># Changed from gr.JSON() to gr.Textbox()</span>
    title=<span class="hljs-string">&quot;Text Sentiment Analysis&quot;</span>,
    description=<span class="hljs-string">&quot;Analyze the sentiment of text using TextBlob&quot;</span>
)

<span class="hljs-comment"># Launch the interface and MCP server</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    demo.launch(mcp_server=<span class="hljs-literal">True</span>)`,wrap:!1}}),Z=new g({props:{title:"Understanding the Code",local:"understanding-the-code",headingTag:"h2"}}),Q=new b({props:{code:"ZXhwb3J0JTIwR1JBRElPX01DUF9TRVJWRVIlM0RUcnVl",highlighted:'<span class="hljs-built_in">export</span> GRADIO_MCP_SERVER=True',wrap:!1}}),N=new g({props:{title:"Running the Server",local:"running-the-server",headingTag:"h2"}}),q=new b({props:{code:"cHl0aG9uJTIwYXBwLnB5",highlighted:"python app.py",wrap:!1}}),P=new g({props:{title:"Testing the Server",local:"testing-the-server",headingTag:"h2"}}),z=new g({props:{title:"Troubleshooting Tips",local:"troubleshooting-tips",headingTag:"h2"}}),D=new b({props:{code:"JTdCJTBBJTIwJTIwJTIybWNwU2VydmVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbW1hbmQlMjIlM0ElMjAlMjJucHglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJhcmdzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWNwLXJlbW90ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E3ODYwJTJGZ3JhZGlvX2FwaSUyRm1jcCUyRnNzZSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;mcpServers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradio&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;npx&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;mcp-remote&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;http://localhost:7860/gradio_api/mcp/sse&quot;</span>
      <span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),K=new g({props:{title:"Deploying to Hugging Face Spaces",local:"deploying-to-hugging-face-spaces",headingTag:"h2"}}),lt=new b({props:{code:"Z3JhZGlvJTVCbWNwJTVEJTBBdGV4dGJsb2I=",highlighted:`gradio[mcp]
textblob`,wrap:!1}}),nt=new b({props:{code:"Z2l0JTIwaW5pdCUwQWdpdCUyMGFkZCUyMGFwcC5weSUyMHJlcXVpcmVtZW50cy50eHQlMEFnaXQlMjBjb21taXQlMjAtbSUyMCUyMkluaXRpYWwlMjBjb21taXQlMjIlMEFnaXQlMjByZW1vdGUlMjBhZGQlMjBvcmlnaW4lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGWU9VUl9VU0VSTkFNRSUyRm1jcC1zZW50aW1lbnQlMEFnaXQlMjBwdXNoJTIwLXUlMjBvcmlnaW4lMjBtYWlu",highlighted:`git init
git add app.py requirements.txt
git commit -m <span class="hljs-string">&quot;Initial commit&quot;</span>
git remote add origin https://huggingface.co/spaces/YOUR_USERNAME/mcp-sentiment
git push -u origin main`,wrap:!1}}),it=new b({props:{code:"aHR0cHMlM0ElMkYlMkZZT1VSX1VTRVJOQU1FLW1jcC1zZW50aW1lbnQuaGYuc3BhY2UlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3Nl",highlighted:'https:<span class="hljs-regexp">//</span>YOUR_USERNAME-mcp-sentiment.hf.space<span class="hljs-regexp">/gradio_api/m</span>cp/sse',wrap:!1}}),at=new g({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),ct=new dl({props:{source:"https://github.com/huggingface/101-course/blob/main/chapters/en/chapter3/8.mdx"}}),{c(){U=a("meta"),$t=s(),bt=a("p"),xt=s(),c(v.$$.fragment),Bt=s(),I=a("p"),I.textContent=Ge,St=s(),c($.$$.fragment),Ht=s(),x=a("p"),x.innerHTML=Re,_t=s(),B=a("ol"),B.innerHTML=Le,Wt=s(),c(S.$$.fragment),Gt=s(),H=a("p"),H.textContent=Ze,Rt=s(),c(_.$$.fragment),Lt=s(),c(W.$$.fragment),Zt=s(),G=a("blockquote"),G.innerHTML=Ae,At=s(),R=a("p"),R.innerHTML=Ee,Et=s(),c(L.$$.fragment),Qt=s(),c(Z.$$.fragment),Nt=s(),A=a("p"),A.textContent=Qe,kt=s(),T=a("ol"),ut=a("li"),ut.innerHTML=Ne,Te=s(),Mt=a("li"),Mt.innerHTML=ke,we=s(),E=a("li"),mt=a("p"),mt.innerHTML=qe,ge=s(),J=a("ul"),ht=a("li"),ht.innerHTML=Ve,Ue=s(),yt=a("li"),yt.innerHTML=Pe,Je=s(),dt=a("li"),Ce=Se(`You can also enable it using the environment variable:
	`),c(Q.$$.fragment),qt=s(),c(N.$$.fragment),Vt=s(),k=a("p"),k.textContent=Xe,Pt=s(),c(q.$$.fragment),Xt=s(),V=a("p"),V.innerHTML=Ye,Yt=s(),c(P.$$.fragment),zt=s(),X=a("p"),X.textContent=ze,Ft=s(),Y=a("ol"),Y.innerHTML=Fe,Ot=s(),c(z.$$.fragment),Dt=s(),d=a("ol"),Tt=a("li"),Tt.innerHTML=Oe,fe=s(),wt=a("li"),wt.innerHTML=De,je=s(),F=a("li"),gt=a("p"),gt.innerHTML=Ke,be=s(),O=a("ul"),Ut=a("li"),Ut.textContent=tl,ve=s(),C=a("li"),Ie=Se("In those cases, use "),Jt=a("code"),Jt.textContent=el,$e=Se(`:
	`),c(D.$$.fragment),xe=s(),Ct=a("li"),Ct.innerHTML=ll,Kt=s(),c(K.$$.fragment),te=s(),tt=a("p"),tt.textContent=nl,ee=s(),et=a("ol"),et.innerHTML=sl,le=s(),c(lt.$$.fragment),ne=s(),f=a("ol"),f.innerHTML=il,se=s(),c(nt.$$.fragment),ie=s(),st=a("p"),st.textContent=al,ae=s(),c(it.$$.fragment),pe=s(),c(at.$$.fragment),oe=s(),pt=a("p"),pt.textContent=pl,re=s(),ot=a("ol"),ot.innerHTML=ol,ce=s(),rt=a("p"),rt.textContent=rl,ue=s(),c(ct.$$.fragment),Me=s(),vt=a("p"),this.h()},l(t){const e=yl("svelte-u9bgzb",document.head);U=p(e,"META",{name:!0,content:!0}),e.forEach(l),$t=i(t),bt=p(t,"P",{}),w(bt).forEach(l),xt=i(t),u(v.$$.fragment,t),Bt=i(t),I=p(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-15g2s94"&&(I.textContent=Ge),St=i(t),u($.$$.fragment,t),Ht=i(t),x=p(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1yi0ix"&&(x.innerHTML=Re),_t=i(t),B=p(t,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-g4mq16"&&(B.innerHTML=Le),Wt=i(t),u(S.$$.fragment,t),Gt=i(t),H=p(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-mmri3o"&&(H.textContent=Ze),Rt=i(t),u(_.$$.fragment,t),Lt=i(t),u(W.$$.fragment,t),Zt=i(t),G=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(G)!=="svelte-jocz8i"&&(G.innerHTML=Ae),At=i(t),R=p(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-viak6g"&&(R.innerHTML=Ee),Et=i(t),u(L.$$.fragment,t),Qt=i(t),u(Z.$$.fragment,t),Nt=i(t),A=p(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ccttqs"&&(A.textContent=Qe),kt=i(t),T=p(t,"OL",{});var ft=w(T);ut=p(ft,"LI",{"data-svelte-h":!0}),r(ut)!=="svelte-1r6ud1j"&&(ut.innerHTML=Ne),Te=i(ft),Mt=p(ft,"LI",{"data-svelte-h":!0}),r(Mt)!=="svelte-1zxric"&&(Mt.innerHTML=ke),we=i(ft),E=p(ft,"LI",{});var he=w(E);mt=p(he,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-9494xm"&&(mt.innerHTML=qe),ge=i(he),J=p(he,"UL",{});var jt=w(J);ht=p(jt,"LI",{"data-svelte-h":!0}),r(ht)!=="svelte-1habxzw"&&(ht.innerHTML=Ve),Ue=i(jt),yt=p(jt,"LI",{"data-svelte-h":!0}),r(yt)!=="svelte-hwrhz1"&&(yt.innerHTML=Pe),Je=i(jt),dt=p(jt,"LI",{});var Be=w(dt);Ce=He(Be,`You can also enable it using the environment variable:
	`),u(Q.$$.fragment,Be),Be.forEach(l),jt.forEach(l),he.forEach(l),ft.forEach(l),qt=i(t),u(N.$$.fragment,t),Vt=i(t),k=p(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-tq7guq"&&(k.textContent=Xe),Pt=i(t),u(q.$$.fragment,t),Xt=i(t),V=p(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-16j4roj"&&(V.innerHTML=Ye),Yt=i(t),u(P.$$.fragment,t),zt=i(t),X=p(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1hexqja"&&(X.textContent=ze),Ft=i(t),Y=p(t,"OL",{"data-svelte-h":!0}),r(Y)!=="svelte-1prsps9"&&(Y.innerHTML=Fe),Ot=i(t),u(z.$$.fragment,t),Dt=i(t),d=p(t,"OL",{});var j=w(d);Tt=p(j,"LI",{"data-svelte-h":!0}),r(Tt)!=="svelte-1kjwfqe"&&(Tt.innerHTML=Oe),fe=i(j),wt=p(j,"LI",{"data-svelte-h":!0}),r(wt)!=="svelte-mxigd7"&&(wt.innerHTML=De),je=i(j),F=p(j,"LI",{});var ye=w(F);gt=p(ye,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-pauept"&&(gt.innerHTML=Ke),be=i(ye),O=p(ye,"UL",{});var de=w(O);Ut=p(de,"LI",{"data-svelte-h":!0}),r(Ut)!=="svelte-18matxo"&&(Ut.textContent=tl),ve=i(de),C=p(de,"LI",{});var It=w(C);Ie=He(It,"In those cases, use "),Jt=p(It,"CODE",{"data-svelte-h":!0}),r(Jt)!=="svelte-32a5p1"&&(Jt.textContent=el),$e=He(It,`:
	`),u(D.$$.fragment,It),It.forEach(l),de.forEach(l),ye.forEach(l),xe=i(j),Ct=p(j,"LI",{"data-svelte-h":!0}),r(Ct)!=="svelte-46q023"&&(Ct.innerHTML=ll),j.forEach(l),Kt=i(t),u(K.$$.fragment,t),te=i(t),tt=p(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1itkhgv"&&(tt.textContent=nl),ee=i(t),et=p(t,"OL",{"data-svelte-h":!0}),r(et)!=="svelte-1thxdu2"&&(et.innerHTML=sl),le=i(t),u(lt.$$.fragment,t),ne=i(t),f=p(t,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-ok99j"&&(f.innerHTML=il),se=i(t),u(nt.$$.fragment,t),ie=i(t),st=p(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-rjtj0p"&&(st.textContent=al),ae=i(t),u(it.$$.fragment,t),pe=i(t),u(at.$$.fragment,t),oe=i(t),pt=p(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-p1bgao"&&(pt.textContent=pl),re=i(t),ot=p(t,"OL",{"data-svelte-h":!0}),r(ot)!=="svelte-6w66tp"&&(ot.innerHTML=ol),ce=i(t),rt=p(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-19wsvhm"&&(rt.textContent=rl),ue=i(t),u(ct.$$.fragment,t),Me=i(t),vt=p(t,"P",{}),w(vt).forEach(l),this.h()},h(){_e(U,"name","hf:doc:metadata"),_e(U,"content",wl),_e(f,"start","3")},m(t,e){o(document.head,U),n(t,$t,e),n(t,bt,e),n(t,xt,e),M(v,t,e),n(t,Bt,e),n(t,I,e),n(t,St,e),M($,t,e),n(t,Ht,e),n(t,x,e),n(t,_t,e),n(t,B,e),n(t,Wt,e),M(S,t,e),n(t,Gt,e),n(t,H,e),n(t,Rt,e),M(_,t,e),n(t,Lt,e),M(W,t,e),n(t,Zt,e),n(t,G,e),n(t,At,e),n(t,R,e),n(t,Et,e),M(L,t,e),n(t,Qt,e),M(Z,t,e),n(t,Nt,e),n(t,A,e),n(t,kt,e),n(t,T,e),o(T,ut),o(T,Te),o(T,Mt),o(T,we),o(T,E),o(E,mt),o(E,ge),o(E,J),o(J,ht),o(J,Ue),o(J,yt),o(J,Je),o(J,dt),o(dt,Ce),M(Q,dt,null),n(t,qt,e),M(N,t,e),n(t,Vt,e),n(t,k,e),n(t,Pt,e),M(q,t,e),n(t,Xt,e),n(t,V,e),n(t,Yt,e),M(P,t,e),n(t,zt,e),n(t,X,e),n(t,Ft,e),n(t,Y,e),n(t,Ot,e),M(z,t,e),n(t,Dt,e),n(t,d,e),o(d,Tt),o(d,fe),o(d,wt),o(d,je),o(d,F),o(F,gt),o(F,be),o(F,O),o(O,Ut),o(O,ve),o(O,C),o(C,Ie),o(C,Jt),o(C,$e),M(D,C,null),o(d,xe),o(d,Ct),n(t,Kt,e),M(K,t,e),n(t,te,e),n(t,tt,e),n(t,ee,e),n(t,et,e),n(t,le,e),M(lt,t,e),n(t,ne,e),n(t,f,e),n(t,se,e),M(nt,t,e),n(t,ie,e),n(t,st,e),n(t,ae,e),M(it,t,e),n(t,pe,e),M(at,t,e),n(t,oe,e),n(t,pt,e),n(t,re,e),n(t,ot,e),n(t,ce,e),n(t,rt,e),n(t,ue,e),M(ct,t,e),n(t,Me,e),n(t,vt,e),me=!0},p:ul,i(t){me||(m(v.$$.fragment,t),m($.$$.fragment,t),m(S.$$.fragment,t),m(_.$$.fragment,t),m(W.$$.fragment,t),m(L.$$.fragment,t),m(Z.$$.fragment,t),m(Q.$$.fragment,t),m(N.$$.fragment,t),m(q.$$.fragment,t),m(P.$$.fragment,t),m(z.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(lt.$$.fragment,t),m(nt.$$.fragment,t),m(it.$$.fragment,t),m(at.$$.fragment,t),m(ct.$$.fragment,t),me=!0)},o(t){h(v.$$.fragment,t),h($.$$.fragment,t),h(S.$$.fragment,t),h(_.$$.fragment,t),h(W.$$.fragment,t),h(L.$$.fragment,t),h(Z.$$.fragment,t),h(Q.$$.fragment,t),h(N.$$.fragment,t),h(q.$$.fragment,t),h(P.$$.fragment,t),h(z.$$.fragment,t),h(D.$$.fragment,t),h(K.$$.fragment,t),h(lt.$$.fragment,t),h(nt.$$.fragment,t),h(it.$$.fragment,t),h(at.$$.fragment,t),h(ct.$$.fragment,t),me=!1},d(t){t&&(l($t),l(bt),l(xt),l(Bt),l(I),l(St),l(Ht),l(x),l(_t),l(B),l(Wt),l(Gt),l(H),l(Rt),l(Lt),l(Zt),l(G),l(At),l(R),l(Et),l(Qt),l(Nt),l(A),l(kt),l(T),l(qt),l(Vt),l(k),l(Pt),l(Xt),l(V),l(Yt),l(zt),l(X),l(Ft),l(Y),l(Ot),l(Dt),l(d),l(Kt),l(te),l(tt),l(ee),l(et),l(le),l(ne),l(f),l(se),l(ie),l(st),l(ae),l(pe),l(oe),l(pt),l(re),l(ot),l(ce),l(rt),l(ue),l(Me),l(vt)),l(U),y(v,t),y($,t),y(S,t),y(_,t),y(W,t),y(L,t),y(Z,t),y(Q),y(N,t),y(q,t),y(P,t),y(z,t),y(D),y(K,t),y(lt,t),y(nt,t),y(it,t),y(at,t),y(ct,t)}}}const wl='{"title":"MCP Servers in Gradio","local":"mcp-servers-in-gradio","sections":[{"title":"Introduction to Gradio MCP Integration","local":"introduction-to-gradio-mcp-integration","sections":[],"depth":2},{"title":"Setting Up the Project","local":"setting-up-the-project","sections":[],"depth":2},{"title":"Creating the Server","local":"creating-the-server","sections":[],"depth":2},{"title":"Understanding the Code","local":"understanding-the-code","sections":[],"depth":2},{"title":"Running the Server","local":"running-the-server","sections":[],"depth":2},{"title":"Testing the Server","local":"testing-the-server","sections":[],"depth":2},{"title":"Troubleshooting Tips","local":"troubleshooting-tips","sections":[],"depth":2},{"title":"Deploying to Hugging Face Spaces","local":"deploying-to-hugging-face-spaces","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function gl(We){return Ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends ml{constructor(U){super(),hl(this,U,gl,Tl,cl,{})}}export{jl as component};
