import{s as pl,n as cl,o as hl}from"../chunks/scheduler.7da89386.js";import{S as dl,i as ul,g as s,s as i,r as m,A as fl,h as o,f as l,c as a,j as $t,u as p,x as r,k as ml,y as w,a as n,v as c,d as h,t as d,w as u}from"../chunks/index.0b7befd3.js";import{C as $e}from"../chunks/CodeBlock.c5b6371f.js";import{H as f,E as Tl}from"../chunks/getInferenceSnippets.1a42b155.js";function wl(kt){let b,Ue,ve,Ce,J,Ie,$,_t=`Kernels on the Hub must fulfill the requirements outlined on this page. By
ensuring kernels are compliant, they can be used on a wide range of Linux
systems and Torch builds.`,xe,v,jt=`You can use <a href="https://github.com/huggingface/kernel-builder/" rel="nofollow">kernel-builder</a>
to build compliant kernels.`,ke,g,_e,U,Ht=`A kernel repository on the Hub must contain a <code>build</code> directory. This
directory contains build variants of a kernel in the form of directories
following the template
<code>&lt;framework&gt;&lt;version&gt;-cxx&lt;abiver&gt;-&lt;cu&gt;&lt;cudaver&gt;-&lt;arch&gt;-&lt;os&gt;</code>.
For example <code>build/torch26-cxx98-cu118-x86_64-linux</code>.`,je,C,Lt=`Each variant directory must contain a single directory with the same name
as the repository (replacing <code>-</code> by <code>_</code>). For instance, kernels in the
<code>kernels-community/activation</code> repository have a directories like
<code>build/&lt;variant&gt;/activation</code>. This directory
must be a Python package with an <code>__init__.py</code> file.`,He,I,Le,x,Bt=`A kernel can be compliant for a specific compute framework (e.g. CUDA) or
architecture (e.g. x86_64). For compliance with a compute framework and
architecture combination, all the variants from the <a href="https://github.com/huggingface/kernel-builder/blob/main/docs/build-variants.md" rel="nofollow">build variant list</a>
must be available for that combination.`,Be,k,Ae,_,At=`Kernels are versioned on the Hub using Git tags. Version tags must be of
the form <code>v&lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;</code>. Versions are used by <a href="./locking.md">locking</a>
to resolve the version constraints.`,Ge,j,Gt='We recommend using <a href="https://semver.org/" rel="nofollow">semver</a> to version kernels.',Se,H,Pe,L,St=`Kernels will typically contain a native Python module with precompiled
compute kernels and bindings. This module must fulfill the requirements
outlined in this section. For all operating systems, a kernel must not
have dynamic library dependencies outside:`,Ze,B,Pt="<li>Torch;</li> <li>CUDA/ROCm libraries installed as dependencies of Torch.</li>",Ee,A,ze,G,Zt=`The Kernel Hub also encourages to write the kernels in a <code>torch.compile</code>
compliant way. This helps to ensure that the kernels are compatible with
<code>torch.compile</code> without introducing any graph breaks and triggering
recompilation which can limit the benefits of compilation.`,Fe,S,Et=`<a href="https://github.com/huggingface/kernel-builder/blob/d1ee9bf9301ac8c5199099d90ee1c9d5c789d5ba/examples/relu-backprop-compile/tests/test_relu.py#L162" rel="nofollow">Here</a> is a simple test example which checks for graph breaks and
recompilation triggers during <code>torch.compile</code>.`,Ne,P,Ve,Z,zt=`<li>Use <a href="https://docs.python.org/3/c-api/stable.html#stable-application-binary-interface" rel="nofollow">ABI3/Limited API</a>
for compatibility with Python 3.9 and later.</li> <li>Compatible with <a href="https://github.com/pypa/manylinux?tab=readme-ov-file#manylinux_2_28-almalinux-8-based" rel="nofollow"><code>manylinux_2_28</code></a>.
This means that the extension <strong>must not</strong> use symbols versions higher than:<ul><li>GLIBC 2.28</li> <li>GLIBCXX 3.4.24</li> <li>CXXABI 1.3.11</li> <li>GCC 7.0.0</li></ul></li>`,Qe,E,Ft="These requirements can be checked with the ABI checker (see below).",Re,z,We,F,Nt=`<li>Use <a href="https://docs.python.org/3/c-api/stable.html#stable-application-binary-interface" rel="nofollow">ABI3/Limited API</a>
for compatibility with Python 3.9 and later.</li> <li>macOS deployment target 15.0.</li> <li>Metal 3.0 (<code>-std=metal3.0</code>).</li>`,Xe,N,Vt="The ABI3 requirement can be checked with the ABI checker (see below).",Ye,V,qe,Q,Qt=`The manylinux_2_28 and Python ABI 3.9 version requirements can be checked with
<a href="https://crates.io/crates/kernel-abi-check" rel="nofollow"><code>kernel-abi-check</code></a>:`,De,R,Oe,W,Ke,X,Rt=`Torch native extension functions must be <a href="https://pytorch.org/tutorials/advanced/cpp_custom_ops.html#cpp-custom-ops-tutorial" rel="nofollow">registered</a>
in <code>torch.ops.&lt;namespace&gt;</code>. Since we allow loading of multiple versions of
a module in the same Python process, <code>namespace</code> must be unique for each
version of a kernel. Failing to do so will create clashes when different
versions of the same kernel are loaded. Two suggested ways of doing this
are:`,et,Y,Wt=`<li>Appending a truncated SHA-1 hash of the git commit that the kernel was
built from to the name of the extension.</li> <li>Appending random material to the name of the extension.</li>`,tt,q,Xt=`<strong>Note:</strong> we recommend against appending a version number or git tag.
Version numbers are typically not bumped on each commit, so users
might use two different commits that happen to have the same version
number. Git tags are not stable, so they do not provide a good way
of guaranteeing uniqueness of the namespace.`,lt,D,nt,O,Yt=`A kernel can provide layers in addition to kernel functions. A layer from
the Hub can replace the <code>forward</code> method of an existing layer for a certain
device type. This makes it possible to provide more performant kernels for
existing layers. See the <a href="layers.md">layers documentation</a> for more information
on how to use layers.`,it,K,at,ee,qt=`To make the extension of layers safe, the layers must fulfill the following
requirements:`,st,te,Dt=`<li>The layers are subclasses of <code>torch.nn.Module</code>.</li> <li>The layers are pure, meaning that they do not have their own state. This
means that:<ul><li>The layer must not define its own constructor.</li> <li>The layer must not use class variables.</li></ul></li> <li>No other methods must be defined than <code>forward</code>.</li> <li>The <code>forward</code> method has a signature that is compatible with the
<code>forward</code> method that it is extending.</li>`,ot,le,Ot="There are two exceptions to the <em>no class variables rule</em>:",rt,ne,Kt=`<li>The <code>has_backward</code> variable can be used to indicate whether the layer has
a backward pass implemented (<code>True</code> when absent).</li> <li>The <code>can_torch_compile</code> variable can be used to indicate whether the layer
supports <code>torch.compile</code> (<code>False</code> when absent).</li>`,mt,ie,el="This is an example of a pure layer:",pt,ae,ct,se,tl=`For some layers, the <code>forward</code> method has to use state from the adopting class.
In these cases, we recommend to use type annotations to indicate what member
variables are expected. For instance:`,ht,oe,dt,re,ll=`This layer expects the adopting layer to have <code>weight</code> and <code>variance_epsilon</code>
member variables and uses them in the <code>forward</code> method.`,ut,me,ft,pe,nl=`To accommodate portable loading, <code>layers</code> must be defined in the main
<code>__init__.py</code> file. For example:`,Tt,ce,wt,he,yt,y,Te,il="<p>Python code must be compatible with Python 3.9 and later.</p>",vt,T,we,al=`All Python code imports from the kernel itself must be relative. So,
for instance if in the example kernel <code>example</code>,
<code>module_b</code> needs a function from <code>module_a</code>, import as:`,gt,de,Ut,ye,sl="<strong>Never use:</strong>",Ct,ue,It,Me,ol=`The latter would import from the module <code>example</code> that is in Python’s
global module dict. However, since we allow loading multiple versions
of a module, we uniquely name the module.`,xt,be,rl=`<p>Only modules from the Python standard library, Torch, or the kernel itself
can be imported.</p>`,Mt,fe,bt,ge,Jt;return J=new f({props:{title:"Kernel requirements",local:"kernel-requirements",headingTag:"h1"}}),g=new f({props:{title:"Directory layout",local:"directory-layout",headingTag:"h2"}}),I=new f({props:{title:"Build variants",local:"build-variants",headingTag:"h2"}}),k=new f({props:{title:"Versioning",local:"versioning",headingTag:"h2"}}),H=new f({props:{title:"Native Python module",local:"native-python-module",headingTag:"h2"}}),A=new f({props:{title:"Compatibility with torch.compile",local:"compatibility-with-torchcompile",headingTag:"h2"}}),P=new f({props:{title:"Linux",local:"linux",headingTag:"h3"}}),z=new f({props:{title:"macOS",local:"macos",headingTag:"h3"}}),V=new f({props:{title:"ABI checker",local:"abi-checker",headingTag:"h3"}}),R=new $e({props:{code:"JTBBJTI0JTIwY2FyZ28lMjBpbnN0YWxsJTIwa2VybmVsLWFiaS1jaGVjayUwQSUyNCUyMGtlcm5lbC1hYmktY2hlY2slMjByZXN1bHQlMkZyZWx1JTJGX3JlbHVfZTg3ZTBjYV9kaXJ0eS5hYmkzLnNvJTBBJUYwJTlGJTkwJThEJTIwQ2hlY2tpbmclMjBmb3IlMjBjb21wYXRpYmlsaXR5JTIwd2l0aCUyMG1hbnlsaW51eF8yXzI4JTIwYW5kJTIwUHl0aG9uJTIwQUJJJTIwdmVyc2lvbiUyMDMuOSUwQSVFMiU5QyU4NSUyME5vJTIwY29tcGF0aWJpbGl0eSUyMGlzc3VlcyUyMGZvdW5k",highlighted:`
$ cargo install kernel-abi-check
$ kernel-abi-check result/relu/_relu_e87e0ca_dirty.abi3.so
🐍 Checking <span class="hljs-keyword">for</span> compatibility with manylinux_2_28 and Python ABI version 3.9
✅ No compatibility issues found`,wrap:!1}}),W=new f({props:{title:"Torch extension",local:"torch-extension",headingTag:"h2"}}),D=new f({props:{title:"Layers",local:"layers",headingTag:"h2"}}),K=new f({props:{title:"Writing layers",local:"writing-layers",headingTag:"h3"}}),ae=new $e({props:{code:"Y2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGlzJTIwbGF5ZXIlMjBkb2VzJTIwbm90JTIwaW1wbGVtZW50JTIwYmFja3dhcmQuJTBBJTIwJTIwJTIwJTIwaGFzX2JhY2t3YXJkJTNBJTIwYm9vbCUyMCUzRCUyMEZhbHNlJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCUzQSUyMHRvcmNoLlRlbnNvciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkJTIwJTNEJTIweC5zaGFwZSU1Qi0xJTVEJTIwJTJGJTJGJTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF9zaGFwZSUyMCUzRCUyMHguc2hhcGUlNUIlM0EtMSU1RCUyMCUyQiUyMChkJTJDKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMHRvcmNoLmVtcHR5KG91dHB1dF9zaGFwZSUyQyUyMGR0eXBlJTNEeC5kdHlwZSUyQyUyMGRldmljZSUzRHguZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wcy5zaWx1X2FuZF9tdWwob3V0JTJDJTIweCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXQ=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-comment"># This layer does not implement backward.</span>
    has_backward: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>):
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        output_shape = x.shape[:-<span class="hljs-number">1</span>] + (d,)
        out = torch.empty(output_shape, dtype=x.dtype, device=x.device)
        ops.silu_and_mul(out, x)
        <span class="hljs-keyword">return</span> out`,wrap:!1}}),oe=new $e({props:{code:"Y2xhc3MlMjBMbGFtYVJNU05vcm0obm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMHdlaWdodCUzQSUyMHRvcmNoLlRlbnNvciUwQSUyMCUyMCUyMCUyMHZhcmlhbmNlX2Vwc2lsb24lM0ElMjBmbG9hdCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGhpZGRlbl9zdGF0ZXMlM0ElMjB0b3JjaC5UZW5zb3IpJTIwLSUzRSUyMHRvcmNoLlRlbnNvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHJtc19ub3JtX2ZuKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLndlaWdodCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJpYXMlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXBzJTNEc2VsZi52YXJpYW5jZV9lcHNpbG9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJvcG91dF9wJTNEMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlbm9ybSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWxfaW5fZnAzMiUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaRMSNorm</span>(nn.Module):
    weight: torch.Tensor
    variance_epsilon: <span class="hljs-built_in">float</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states: torch.Tensor</span>) -&gt; torch.Tensor:
        <span class="hljs-keyword">return</span> rms_norm_fn(
            hidden_states,
            self.weight,
            bias=<span class="hljs-literal">None</span>,
            residual=<span class="hljs-literal">None</span>,
            eps=self.variance_epsilon,
            dropout_p=<span class="hljs-number">0.0</span>,
            prenorm=<span class="hljs-literal">False</span>,
            residual_in_fp32=<span class="hljs-literal">False</span>,
        )`,wrap:!1}}),me=new f({props:{title:"Exporting layers",local:"exporting-layers",headingTag:"h3"}}),ce=new $e({props:{code:"ZnJvbSUyMC4lMjBpbXBvcnQlMjBsYXllcnMlMEElMEFfX2FsbF9fJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIzJTIwLi4uJTBBJTIwJTIwJTIybGF5ZXJzJTIyJTBBJTIwJTIwJTIzJTIwLi4uJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> . <span class="hljs-keyword">import</span> layers

__all__ = [
  <span class="hljs-comment"># ...</span>
  <span class="hljs-string">&quot;layers&quot;</span>
  <span class="hljs-comment"># ...</span>
]`,wrap:!1}}),he=new f({props:{title:"Python requirements",local:"python-requirements",headingTag:"h2"}}),de=new $e({props:{code:"ZnJvbSUyMC5tb2R1bGVfYSUyMGltcG9ydCUyMGZvbw==",highlighted:'<span class="hljs-keyword">from</span> .module_a <span class="hljs-keyword">import</span> foo',wrap:!1}}),ue=new $e({props:{code:"JTIzJTIwRE8lMjBOT1QlMjBETyUyMFRISVMhJTBBJTBBZnJvbSUyMGV4YW1wbGUubW9kdWxlX2ElMjBpbXBvcnQlMjBmb28=",highlighted:`<span class="hljs-comment"># DO NOT DO THIS!</span>

<span class="hljs-keyword">from</span> example.module_a <span class="hljs-keyword">import</span> foo`,wrap:!1}}),fe=new Tl({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/kernel-requirements.md"}}),{c(){b=s("meta"),Ue=i(),ve=s("p"),Ce=i(),m(J.$$.fragment),Ie=i(),$=s("p"),$.textContent=_t,xe=i(),v=s("p"),v.innerHTML=jt,ke=i(),m(g.$$.fragment),_e=i(),U=s("p"),U.innerHTML=Ht,je=i(),C=s("p"),C.innerHTML=Lt,He=i(),m(I.$$.fragment),Le=i(),x=s("p"),x.innerHTML=Bt,Be=i(),m(k.$$.fragment),Ae=i(),_=s("p"),_.innerHTML=At,Ge=i(),j=s("p"),j.innerHTML=Gt,Se=i(),m(H.$$.fragment),Pe=i(),L=s("p"),L.textContent=St,Ze=i(),B=s("ul"),B.innerHTML=Pt,Ee=i(),m(A.$$.fragment),ze=i(),G=s("p"),G.innerHTML=Zt,Fe=i(),S=s("p"),S.innerHTML=Et,Ne=i(),m(P.$$.fragment),Ve=i(),Z=s("ul"),Z.innerHTML=zt,Qe=i(),E=s("p"),E.textContent=Ft,Re=i(),m(z.$$.fragment),We=i(),F=s("ul"),F.innerHTML=Nt,Xe=i(),N=s("p"),N.textContent=Vt,Ye=i(),m(V.$$.fragment),qe=i(),Q=s("p"),Q.innerHTML=Qt,De=i(),m(R.$$.fragment),Oe=i(),m(W.$$.fragment),Ke=i(),X=s("p"),X.innerHTML=Rt,et=i(),Y=s("ul"),Y.innerHTML=Wt,tt=i(),q=s("p"),q.innerHTML=Xt,lt=i(),m(D.$$.fragment),nt=i(),O=s("p"),O.innerHTML=Yt,it=i(),m(K.$$.fragment),at=i(),ee=s("p"),ee.textContent=qt,st=i(),te=s("ul"),te.innerHTML=Dt,ot=i(),le=s("p"),le.innerHTML=Ot,rt=i(),ne=s("ol"),ne.innerHTML=Kt,mt=i(),ie=s("p"),ie.textContent=el,pt=i(),m(ae.$$.fragment),ct=i(),se=s("p"),se.innerHTML=tl,ht=i(),m(oe.$$.fragment),dt=i(),re=s("p"),re.innerHTML=ll,ut=i(),m(me.$$.fragment),ft=i(),pe=s("p"),pe.innerHTML=nl,Tt=i(),m(ce.$$.fragment),wt=i(),m(he.$$.fragment),yt=i(),y=s("ul"),Te=s("li"),Te.innerHTML=il,vt=i(),T=s("li"),we=s("p"),we.innerHTML=al,gt=i(),m(de.$$.fragment),Ut=i(),ye=s("p"),ye.innerHTML=sl,Ct=i(),m(ue.$$.fragment),It=i(),Me=s("p"),Me.innerHTML=ol,xt=i(),be=s("li"),be.innerHTML=rl,Mt=i(),m(fe.$$.fragment),bt=i(),ge=s("p"),this.h()},l(e){const t=fl("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ue=a(e),ve=o(e,"P",{}),$t(ve).forEach(l),Ce=a(e),p(J.$$.fragment,e),Ie=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-omjx4j"&&($.textContent=_t),xe=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-mwob7l"&&(v.innerHTML=jt),ke=a(e),p(g.$$.fragment,e),_e=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1j93b1m"&&(U.innerHTML=Ht),je=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1cuxqpl"&&(C.innerHTML=Lt),He=a(e),p(I.$$.fragment,e),Le=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-11ghnwy"&&(x.innerHTML=Bt),Be=a(e),p(k.$$.fragment,e),Ae=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1869t00"&&(_.innerHTML=At),Ge=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1lhbdsc"&&(j.innerHTML=Gt),Se=a(e),p(H.$$.fragment,e),Pe=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-17te4hc"&&(L.textContent=St),Ze=a(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-17x1sgf"&&(B.innerHTML=Pt),Ee=a(e),p(A.$$.fragment,e),ze=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-f057os"&&(G.innerHTML=Zt),Fe=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-nz528e"&&(S.innerHTML=Et),Ne=a(e),p(P.$$.fragment,e),Ve=a(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-gs8bip"&&(Z.innerHTML=zt),Qe=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-vq3k4i"&&(E.textContent=Ft),Re=a(e),p(z.$$.fragment,e),We=a(e),F=o(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-nrm36c"&&(F.innerHTML=Nt),Xe=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1xbbttu"&&(N.textContent=Vt),Ye=a(e),p(V.$$.fragment,e),qe=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-16l01xm"&&(Q.innerHTML=Qt),De=a(e),p(R.$$.fragment,e),Oe=a(e),p(W.$$.fragment,e),Ke=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1z00i8l"&&(X.innerHTML=Rt),et=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-1n44n6m"&&(Y.innerHTML=Wt),tt=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-vo8uhp"&&(q.innerHTML=Xt),lt=a(e),p(D.$$.fragment,e),nt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-17jmyq"&&(O.innerHTML=Yt),it=a(e),p(K.$$.fragment,e),at=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-ew142v"&&(ee.textContent=qt),st=a(e),te=o(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-pm5vd9"&&(te.innerHTML=Dt),ot=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-17brked"&&(le.innerHTML=Ot),rt=a(e),ne=o(e,"OL",{"data-svelte-h":!0}),r(ne)!=="svelte-1a9mvrx"&&(ne.innerHTML=Kt),mt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-mthj86"&&(ie.textContent=el),pt=a(e),p(ae.$$.fragment,e),ct=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1xsl1kb"&&(se.innerHTML=tl),ht=a(e),p(oe.$$.fragment,e),dt=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-9hcs08"&&(re.innerHTML=ll),ut=a(e),p(me.$$.fragment,e),ft=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1jwjnkj"&&(pe.innerHTML=nl),Tt=a(e),p(ce.$$.fragment,e),wt=a(e),p(he.$$.fragment,e),yt=a(e),y=o(e,"UL",{});var Je=$t(y);Te=o(Je,"LI",{"data-svelte-h":!0}),r(Te)!=="svelte-1yjmw8t"&&(Te.innerHTML=il),vt=a(Je),T=o(Je,"LI",{});var M=$t(T);we=o(M,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1xx048c"&&(we.innerHTML=al),gt=a(M),p(de.$$.fragment,M),Ut=a(M),ye=o(M,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-ca1g42"&&(ye.innerHTML=sl),Ct=a(M),p(ue.$$.fragment,M),It=a(M),Me=o(M,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1v83762"&&(Me.innerHTML=ol),M.forEach(l),xt=a(Je),be=o(Je,"LI",{"data-svelte-h":!0}),r(be)!=="svelte-wkdo8"&&(be.innerHTML=rl),Je.forEach(l),Mt=a(e),p(fe.$$.fragment,e),bt=a(e),ge=o(e,"P",{}),$t(ge).forEach(l),this.h()},h(){ml(b,"name","hf:doc:metadata"),ml(b,"content",yl)},m(e,t){w(document.head,b),n(e,Ue,t),n(e,ve,t),n(e,Ce,t),c(J,e,t),n(e,Ie,t),n(e,$,t),n(e,xe,t),n(e,v,t),n(e,ke,t),c(g,e,t),n(e,_e,t),n(e,U,t),n(e,je,t),n(e,C,t),n(e,He,t),c(I,e,t),n(e,Le,t),n(e,x,t),n(e,Be,t),c(k,e,t),n(e,Ae,t),n(e,_,t),n(e,Ge,t),n(e,j,t),n(e,Se,t),c(H,e,t),n(e,Pe,t),n(e,L,t),n(e,Ze,t),n(e,B,t),n(e,Ee,t),c(A,e,t),n(e,ze,t),n(e,G,t),n(e,Fe,t),n(e,S,t),n(e,Ne,t),c(P,e,t),n(e,Ve,t),n(e,Z,t),n(e,Qe,t),n(e,E,t),n(e,Re,t),c(z,e,t),n(e,We,t),n(e,F,t),n(e,Xe,t),n(e,N,t),n(e,Ye,t),c(V,e,t),n(e,qe,t),n(e,Q,t),n(e,De,t),c(R,e,t),n(e,Oe,t),c(W,e,t),n(e,Ke,t),n(e,X,t),n(e,et,t),n(e,Y,t),n(e,tt,t),n(e,q,t),n(e,lt,t),c(D,e,t),n(e,nt,t),n(e,O,t),n(e,it,t),c(K,e,t),n(e,at,t),n(e,ee,t),n(e,st,t),n(e,te,t),n(e,ot,t),n(e,le,t),n(e,rt,t),n(e,ne,t),n(e,mt,t),n(e,ie,t),n(e,pt,t),c(ae,e,t),n(e,ct,t),n(e,se,t),n(e,ht,t),c(oe,e,t),n(e,dt,t),n(e,re,t),n(e,ut,t),c(me,e,t),n(e,ft,t),n(e,pe,t),n(e,Tt,t),c(ce,e,t),n(e,wt,t),c(he,e,t),n(e,yt,t),n(e,y,t),w(y,Te),w(y,vt),w(y,T),w(T,we),w(T,gt),c(de,T,null),w(T,Ut),w(T,ye),w(T,Ct),c(ue,T,null),w(T,It),w(T,Me),w(y,xt),w(y,be),n(e,Mt,t),c(fe,e,t),n(e,bt,t),n(e,ge,t),Jt=!0},p:cl,i(e){Jt||(h(J.$$.fragment,e),h(g.$$.fragment,e),h(I.$$.fragment,e),h(k.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(P.$$.fragment,e),h(z.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(W.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),Jt=!0)},o(e){d(J.$$.fragment,e),d(g.$$.fragment,e),d(I.$$.fragment,e),d(k.$$.fragment,e),d(H.$$.fragment,e),d(A.$$.fragment,e),d(P.$$.fragment,e),d(z.$$.fragment,e),d(V.$$.fragment,e),d(R.$$.fragment,e),d(W.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(he.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(fe.$$.fragment,e),Jt=!1},d(e){e&&(l(Ue),l(ve),l(Ce),l(Ie),l($),l(xe),l(v),l(ke),l(_e),l(U),l(je),l(C),l(He),l(Le),l(x),l(Be),l(Ae),l(_),l(Ge),l(j),l(Se),l(Pe),l(L),l(Ze),l(B),l(Ee),l(ze),l(G),l(Fe),l(S),l(Ne),l(Ve),l(Z),l(Qe),l(E),l(Re),l(We),l(F),l(Xe),l(N),l(Ye),l(qe),l(Q),l(De),l(Oe),l(Ke),l(X),l(et),l(Y),l(tt),l(q),l(lt),l(nt),l(O),l(it),l(at),l(ee),l(st),l(te),l(ot),l(le),l(rt),l(ne),l(mt),l(ie),l(pt),l(ct),l(se),l(ht),l(dt),l(re),l(ut),l(ft),l(pe),l(Tt),l(wt),l(yt),l(y),l(Mt),l(bt),l(ge)),l(b),u(J,e),u(g,e),u(I,e),u(k,e),u(H,e),u(A,e),u(P,e),u(z,e),u(V,e),u(R,e),u(W,e),u(D,e),u(K,e),u(ae,e),u(oe,e),u(me,e),u(ce,e),u(he,e),u(de),u(ue),u(fe,e)}}}const yl='{"title":"Kernel requirements","local":"kernel-requirements","sections":[{"title":"Directory layout","local":"directory-layout","sections":[],"depth":2},{"title":"Build variants","local":"build-variants","sections":[],"depth":2},{"title":"Versioning","local":"versioning","sections":[],"depth":2},{"title":"Native Python module","local":"native-python-module","sections":[],"depth":2},{"title":"Compatibility with torch.compile","local":"compatibility-with-torchcompile","sections":[{"title":"Linux","local":"linux","sections":[],"depth":3},{"title":"macOS","local":"macos","sections":[],"depth":3},{"title":"ABI checker","local":"abi-checker","sections":[],"depth":3}],"depth":2},{"title":"Torch extension","local":"torch-extension","sections":[],"depth":2},{"title":"Layers","local":"layers","sections":[{"title":"Writing layers","local":"writing-layers","sections":[],"depth":3},{"title":"Exporting layers","local":"exporting-layers","sections":[],"depth":3}],"depth":2},{"title":"Python requirements","local":"python-requirements","sections":[],"depth":2}],"depth":1}';function Ml(kt){return hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gl extends dl{constructor(b){super(),ul(this,b,Ml,wl,pl,{})}}export{gl as component};
