import{s as Qe,a as Ye,n as Fe,o as Re}from"../chunks/scheduler.56725da7.js";import{S as ze,i as De,e as o,s as i,c as r,h as Oe,a as s,d as n,b as a,f as _e,g as p,j as m,k as M,l as Je,m as l,n as u,t as h,o as c,p as f}from"../chunks/index.18a26576.js";import{C as Ke}from"../chunks/CopyLLMTxtMenu.76d2dee2.js";import{D as qe}from"../chunks/Docstring.4f47c3b1.js";import{C as Ce}from"../chunks/CodeBlock.560d4f43.js";import{H as q}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6235e8d0.js";function et(je){let d,R,Y,z,w,D,x,O,T,K,$,Pe='<a href="https://huggingface.co/papers/2310.00426" rel="nofollow">PixArt-α: Fast Training of Diffusion Transformer for Photorealistic Text-to-Image Synthesis</a> is Junsong Chen, Jincheng Yu, Chongjian Ge, Lewei Yao, Enze Xie, Yue Wu, Zhongdao Wang, James Kwok, Ping Luo, Huchuan Lu, and Zhenguo Li.',ee,U,Ae="Some notes about this pipeline:",te,_,Ge='<li>It uses a Transformer backbone (instead of a UNet) for denoising. As such it has a similar architecture as <a href="./dit">DiT</a>.</li> <li>It was trained using text conditions computed from T5. This aspect makes the pipeline better at following complex text prompts with intricate details.</li> <li>It is good at producing high-resolution images at different aspect ratios. To get the best results, the authors recommend some size brackets which can be found <a href="https://github.com/PixArt-alpha/PixArt-alpha/blob/08fbbd281ec96866109bdd2cdb75f2f58fb17610/diffusion/data/datasets/utils.py" rel="nofollow">here</a>.</li> <li>It rivals the quality of state-of-the-art text-to-image generation systems (as of this writing) such as Stable Diffusion XL, Imagen, and DALL-E 2, while being more efficient than them.</li>',ne,v,Ve='You can find the original codebase at <a href="https://github.com/PixArt-alpha/PixArt-alpha" rel="nofollow">PixArt-alpha/PixArt-alpha</a> and all the available checkpoints at <a href="https://huggingface.co/PixArt-alpha" rel="nofollow">PixArt-alpha</a>.',le,J,Be="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",ie,C,ae,j,Ie="To deploy models in the PixArt-α pipeline, you will need to compile them to TorchScript optimized for AWS Neuron. There are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",oe,P,Le="<li>Text encoder</li> <li>Transformer</li> <li>VAE encoder</li> <li>VAE decoder</li>",se,A,He="You can either compile and export a PixArt-α Checkpoint via CLI or <code>NeuronPixArtAlphaPipeline</code> class.",re,G,pe,V,me,b,Xe="<p>We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with the Optimum CLI on a CPU-only instance (needs ~35 GB memory), and then run the pre-compiled model on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.</p>",ue,B,he,I,ce,L,fe,H,Ee="<code>NeuronPixArtAlphaPipeline</code> class allows you to generate images from a text prompt on neuron devices similar to the experience with <code>Diffusers</code>.",de,X,Ne="With pre-compiled PixArt-α models, now generate an image with a prompt on Neuron:",ge,E,ye,g,We,Me,N,be,W,ke="Pipeline for text-to-image generation using PixArt-α.",we,y,k,ve,Q,S,xe,Z,Se='Are there any other diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',Te,F,$e;return w=new Ke({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),x=new q({props:{title:"PixArt-α",local:"pixart-α",headingTag:"h1"}}),T=new q({props:{title:"Overview",local:"overview",headingTag:"h2"}}),C=new q({props:{title:"Export to Neuron",local:"export-to-neuron",headingTag:"h2"}}),G=new q({props:{title:"Option 1: CLI",local:"option-1-cli",headingTag:"h3"}}),V=new Ce({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwUGl4QXJ0LWFscGhhJTJGUGl4QXJ0LVhMLTItNTEyeDUxMiUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLWhlaWdodCUyMDUxMiUyMC0td2lkdGglMjA1MTIlMjAtLW51bV9pbWFnZXNfcGVyX3Byb21wdCUyMDElMjAtLXRvcmNoX2R0eXBlJTIwYmZsb2F0MTYlMjAtLXNlcXVlbmNlX2xlbmd0aCUyMDEyMCUyMHBpeGFydF9hbHBoYV9uZXVyb25fNTEyJTJG",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model PixArt-alpha/PixArt-XL-2-512x512 --batch_size 1 --height 512 --width 512 --num_images_per_prompt 1 --torch_dtype bfloat16 --sequence_length 120 pixart_alpha_neuron_512/',wrap:!1}}),B=new q({props:{title:"Option 2: Python API",local:"option-2-python-api",headingTag:"h3"}}),I=new Ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25QaXhBcnRBbHBoYVBpcGVsaW5lJTBBJTBBJTIzJTIwQ29tcGlsZSUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJub25lJTIyJTdEJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMnNlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDEyMCU3RCUwQSUwQW5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvblBpeEFydEFscGhhUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlBpeEFydC1hbHBoYSUyRlBpeEFydC1YTC0yLTUxMng1MTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMGRpc2FibGVfbmV1cm9uX2NhY2hlJTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzKSUwQSUwQSUyMyUyMFNhdmUlMjBsb2NhbGx5JTBBbmV1cm9uX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJwaXhhcnRfYWxwaGFfbmV1cm9uXzUxMiUyRiUyMiklMEElMEElMjMlMjBVcGxvYWQlMjB0byUyMHRoZSUyMEh1Z2dpbmdGYWNlJTIwSHViJTBBbmV1cm9uX21vZGVsLnB1c2hfdG9faHViKCUwQSUyMCUyMCUyMCUyMCUyMnBpeGFydF9hbHBoYV9uZXVyb25fNTEyJTJGJTIyJTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMkppbmd5YSUyRlBpeEFydC1YTC0yLTUxMng1MTItbmV1cm9ueCUyMiUyMCUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIweW91ciUyMEhGJTIwSHViJTIwcmVwbyUyMGlkJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronPixArtAlphaPipeline

<span class="hljs-comment"># Compile</span>
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">120</span>}

neuron_model = NeuronPixArtAlphaPipeline.from_pretrained(<span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-512x512&quot;</span>, torch_dtype=torch.bfloat16, export=<span class="hljs-literal">True</span>, disable_neuron_cache=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally</span>
neuron_model.save_pretrained(<span class="hljs-string">&quot;pixart_alpha_neuron_512/&quot;</span>)

<span class="hljs-comment"># Upload to the HuggingFace Hub</span>
neuron_model.push_to_hub(
    <span class="hljs-string">&quot;pixart_alpha_neuron_512/&quot;</span>, repository_id=<span class="hljs-string">&quot;Jingya/PixArt-XL-2-512x512-neuronx&quot;</span>  <span class="hljs-comment"># Replace with your HF Hub repo id</span>
)`,wrap:!1}}),L=new q({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h2"}}),E=new Ce({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uUGl4QXJ0QWxwaGFQaXBlbGluZSUwQSUwQW5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvblBpeEFydEFscGhhUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnBpeGFydF9hbHBoYV9uZXVyb25fNTEyJTJGJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMk9wcGVuaGVpbWVyJTIwc2l0cyUyMG9uJTIwdGhlJTIwYmVhY2glMjBvbiUyMGElMjBjaGFpciUyQyUyMHdhdGNoaW5nJTIwYSUyMG51Y2xlYXIlMjBleHBvc2l0aW9uJTIwd2l0aCUyMGElMjBodWdlJTIwbXVzaHJvb20lMjBjbG91ZCUyQyUyMDEyMG1tLiUyMiUwQWltYWdlJTIwJTNEJTIwbmV1cm9uX21vZGVsKHByb21wdCUzRHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronPixArtAlphaPipeline

neuron_model = NeuronPixArtAlphaPipeline.from_pretrained(<span class="hljs-string">&quot;pixart_alpha_neuron_512/&quot;</span>)
prompt = <span class="hljs-string">&quot;Oppenheimer sits on the beach on a chair, watching a nuclear exposition with a huge mushroom cloud, 120mm.&quot;</span>
image = neuron_model(prompt=prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),N=new q({props:{title:"NeuronPixArtAlphaPipeline",local:"optimum.neuron.NeuronPixArtAlphaPipeline",headingTag:"h2"}}),k=new qe({props:{name:"class optimum.neuron.NeuronPixArtAlphaPipeline",anchor:"optimum.neuron.NeuronPixArtAlphaPipeline",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_1003/optimum/neuron/modeling_diffusion.py#L1579"}}),S=new qe({props:{name:"__call__",anchor:"optimum.neuron.NeuronPixArtAlphaPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/vr_1003/optimum/neuron/modeling_diffusion.py#L1106"}}),{c(){d=o("meta"),R=i(),Y=o("p"),z=i(),r(w.$$.fragment),D=i(),r(x.$$.fragment),O=i(),r(T.$$.fragment),K=i(),$=o("p"),$.innerHTML=Pe,ee=i(),U=o("p"),U.textContent=Ae,te=i(),_=o("ul"),_.innerHTML=Ge,ne=i(),v=o("p"),v.innerHTML=Ve,le=i(),J=o("p"),J.innerHTML=Be,ie=i(),r(C.$$.fragment),ae=i(),j=o("p"),j.innerHTML=Ie,oe=i(),P=o("ul"),P.innerHTML=Le,se=i(),A=o("p"),A.innerHTML=He,re=i(),r(G.$$.fragment),pe=i(),r(V.$$.fragment),me=i(),b=o("blockquote"),b.innerHTML=Xe,ue=i(),r(B.$$.fragment),he=i(),r(I.$$.fragment),ce=i(),r(L.$$.fragment),fe=i(),H=o("p"),H.innerHTML=Ee,de=i(),X=o("p"),X.textContent=Ne,ge=i(),r(E.$$.fragment),ye=i(),g=o("img"),Me=i(),r(N.$$.fragment),be=i(),W=o("p"),W.textContent=ke,we=i(),y=o("div"),r(k.$$.fragment),ve=i(),Q=o("div"),r(S.$$.fragment),xe=i(),Z=o("p"),Z.innerHTML=Se,Te=i(),F=o("p"),this.h()},l(e){const t=Oe("svelte-u9bgzb",document.head);d=s(t,"META",{name:!0,content:!0}),t.forEach(n),R=a(e),Y=s(e,"P",{}),_e(Y).forEach(n),z=a(e),p(w.$$.fragment,e),D=a(e),p(x.$$.fragment,e),O=a(e),p(T.$$.fragment,e),K=a(e),$=s(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-9ej743"&&($.innerHTML=Pe),ee=a(e),U=s(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-v1sn1g"&&(U.textContent=Ae),te=a(e),_=s(e,"UL",{"data-svelte-h":!0}),m(_)!=="svelte-1o0jwg8"&&(_.innerHTML=Ge),ne=a(e),v=s(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1c7kadv"&&(v.innerHTML=Ve),le=a(e),J=s(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1g87d8z"&&(J.innerHTML=Be),ie=a(e),p(C.$$.fragment,e),ae=a(e),j=s(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1eugdyd"&&(j.innerHTML=Ie),oe=a(e),P=s(e,"UL",{"data-svelte-h":!0}),m(P)!=="svelte-bwcnjm"&&(P.innerHTML=Le),se=a(e),A=s(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-wkhkz6"&&(A.innerHTML=He),re=a(e),p(G.$$.fragment,e),pe=a(e),p(V.$$.fragment,e),me=a(e),b=s(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-6gfoqi"&&(b.innerHTML=Xe),ue=a(e),p(B.$$.fragment,e),he=a(e),p(I.$$.fragment,e),ce=a(e),p(L.$$.fragment,e),fe=a(e),H=s(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-16eqm35"&&(H.innerHTML=Ee),de=a(e),X=s(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-9cwmyz"&&(X.textContent=Ne),ge=a(e),p(E.$$.fragment,e),ye=a(e),g=s(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Me=a(e),p(N.$$.fragment,e),be=a(e),W=s(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-be4wby"&&(W.textContent=ke),we=a(e),y=s(e,"DIV",{class:!0});var Ue=_e(y);p(k.$$.fragment,Ue),ve=a(Ue),Q=s(Ue,"DIV",{class:!0});var Ze=_e(Q);p(S.$$.fragment,Ze),Ze.forEach(n),Ue.forEach(n),xe=a(e),Z=s(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1wos5lv"&&(Z.innerHTML=Se),Te=a(e),F=s(e,"P",{}),_e(F).forEach(n),this.h()},h(){M(d,"name","hf:doc:metadata"),M(d,"content",tt),M(b,"class","tip"),Ye(g.src,We="https://huggingface.co/datasets/Jingya/document_images/resolve/main/optimum/neuron/pixart-alpha-oppenheimer.png")||M(g,"src",We),M(g,"width","256"),M(g,"height","256"),M(g,"alt","PixArt-α generated image."),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){Je(document.head,d),l(e,R,t),l(e,Y,t),l(e,z,t),u(w,e,t),l(e,D,t),u(x,e,t),l(e,O,t),u(T,e,t),l(e,K,t),l(e,$,t),l(e,ee,t),l(e,U,t),l(e,te,t),l(e,_,t),l(e,ne,t),l(e,v,t),l(e,le,t),l(e,J,t),l(e,ie,t),u(C,e,t),l(e,ae,t),l(e,j,t),l(e,oe,t),l(e,P,t),l(e,se,t),l(e,A,t),l(e,re,t),u(G,e,t),l(e,pe,t),u(V,e,t),l(e,me,t),l(e,b,t),l(e,ue,t),u(B,e,t),l(e,he,t),u(I,e,t),l(e,ce,t),u(L,e,t),l(e,fe,t),l(e,H,t),l(e,de,t),l(e,X,t),l(e,ge,t),u(E,e,t),l(e,ye,t),l(e,g,t),l(e,Me,t),u(N,e,t),l(e,be,t),l(e,W,t),l(e,we,t),l(e,y,t),u(k,y,null),Je(y,ve),Je(y,Q),u(S,Q,null),l(e,xe,t),l(e,Z,t),l(e,Te,t),l(e,F,t),$e=!0},p:Fe,i(e){$e||(h(w.$$.fragment,e),h(x.$$.fragment,e),h(T.$$.fragment,e),h(C.$$.fragment,e),h(G.$$.fragment,e),h(V.$$.fragment,e),h(B.$$.fragment,e),h(I.$$.fragment,e),h(L.$$.fragment,e),h(E.$$.fragment,e),h(N.$$.fragment,e),h(k.$$.fragment,e),h(S.$$.fragment,e),$e=!0)},o(e){c(w.$$.fragment,e),c(x.$$.fragment,e),c(T.$$.fragment,e),c(C.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(B.$$.fragment,e),c(I.$$.fragment,e),c(L.$$.fragment,e),c(E.$$.fragment,e),c(N.$$.fragment,e),c(k.$$.fragment,e),c(S.$$.fragment,e),$e=!1},d(e){e&&(n(R),n(Y),n(z),n(D),n(O),n(K),n($),n(ee),n(U),n(te),n(_),n(ne),n(v),n(le),n(J),n(ie),n(ae),n(j),n(oe),n(P),n(se),n(A),n(re),n(pe),n(me),n(b),n(ue),n(he),n(ce),n(fe),n(H),n(de),n(X),n(ge),n(ye),n(g),n(Me),n(be),n(W),n(we),n(y),n(xe),n(Z),n(Te),n(F)),n(d),f(w,e),f(x,e),f(T,e),f(C,e),f(G,e),f(V,e),f(B,e),f(I,e),f(L,e),f(E,e),f(N,e),f(k),f(S)}}}const tt='{"title":"PixArt-α","local":"pixart-α","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Export to Neuron","local":"export-to-neuron","sections":[{"title":"Option 1: CLI","local":"option-1-cli","sections":[],"depth":3},{"title":"Option 2: Python API","local":"option-2-python-api","sections":[],"depth":3}],"depth":2},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":2},{"title":"NeuronPixArtAlphaPipeline","local":"optimum.neuron.NeuronPixArtAlphaPipeline","sections":[],"depth":2}],"depth":1}';function nt(je){return Re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pt extends ze{constructor(d){super(),De(this,d,nt,et,Qe,{})}}export{pt as component};
