import{s as kl,n as Rl,o as vl}from"../chunks/scheduler.56725da7.js";import{S as xl,i as $l,e as i,s as n,c as o,h as Fl,a as M,d as e,b as a,f as _l,g as r,j as p,k as El,l as Ql,m as s,n as J,t as m,o as T,p as y}from"../chunks/index.18a26576.js";import{C as Hl}from"../chunks/CopyLLMTxtMenu.76d2dee2.js";import{C as Y}from"../chunks/CodeBlock.560d4f43.js";import{H as F}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6235e8d0.js";function Yl(Il){let c,z,Q,S,w,L,u,q,d,bl="🤗 Optimum Neuron makes AWS accelerator adoption seamless for Hugging Face users with <strong>drop-in replacements</strong> for standard training and inference components.",D,j,fl='<strong>*🚀 Need to set up your environment first?</strong> Check out our <a href="getting-started-on-ec2">Getting Started on EC2</a> page for complete installation and AWS setup instructions.*',P,U,hl="<strong>Key Features:</strong>",K,I,Zl="<li>🔄 <strong>Drop-in replacement</strong> for standard Transformers training and inference</li> <li>⚡ <strong>Distributed training</strong> support with minimal code changes</li> <li>🎯 <strong>Optimized models</strong> for AWS accelerators</li> <li>📈 <strong>Production-ready</strong> inference with compiled models</li>",O,b,ll,f,Cl="Training on AWS Trainium requires minimal changes to your existing code - just swap in Optimum Neuron’s drop-in replacements:",tl,h,el,Z,gl='This example demonstrates supervised fine-tuning on the <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Databricks Dolly dataset</a> using <code>NeuronSFTTrainer</code> and <code>NeuronModelForCausalLM</code> - the Trainium-optimized versions of standard Transformers components.',sl,C,nl,g,Xl="<strong>Compilation</strong> (optional for first run):",al,X,il,B,Bl="<strong>Training:</strong>",Ml,W,ol,N,rl,A,Wl="Optimized inference requires two steps: <strong>export</strong> your model to Neuron format, then <strong>run</strong> it with <code>NeuronModelForXXX</code> classes.",pl,G,Jl,V,ml,_,Nl='This exports the model with optimized settings: static shapes (<code>batch_size=1</code>, <code>sequence_length=32</code>) and BF16 precision for <code>matmul</code> operations. Check out the <a href="https://huggingface.co/docs/optimum-neuron/guides/export_model" rel="nofollow">exporter guide</a> for more compilation options.',Tl,E,yl,k,cl,R,Al="The <code>NeuronModelForXXX</code> classes work as drop-in replacements for their <code>AutoModelForXXX</code> counterparts, making migration seamless.",wl,v,ul,x,Gl="Ready to dive deeper? Check out our comprehensive guides:",dl,$,Vl='<li>📚 <strong><a href="getting-started">Getting Started</a></strong> - Complete setup and installation</li> <li>🏋️ <strong><a href="training_tutorials/notebooks">Training Tutorials</a></strong> - End-to-end training examples</li> <li>🔧 <strong><a href="guides/export_model">Export Guide</a></strong> - Advanced model compilation options</li>',jl,H,Ul;return w=new Hl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new F({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),b=new F({props:{title:"Training",local:"training",headingTag:"h2"}}),h=new Y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch_xla.runtime <span class="hljs-keyword">as</span> xr

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># Optimum Neuron&#x27;s drop-in replacements for standard training components</span>
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronSFTConfig, NeuronSFTTrainer, NeuronTrainingArguments
<span class="hljs-keyword">from</span> optimum.neuron.models.training <span class="hljs-keyword">import</span> NeuronModelForCausalLM


<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly_dataset</span>(<span class="hljs-params">example</span>):
    <span class="hljs-string">&quot;&quot;&quot;Format Dolly dataset into instruction-following format.&quot;&quot;&quot;</span>
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{example[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> example[<span class="hljs-string">&quot;context&quot;</span>] <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n<span class="hljs-subst">{example[<span class="hljs-string">&#x27;response&#x27;</span>]}</span>&quot;</span>
    
    <span class="hljs-comment"># Combine all parts with double newlines</span>
    parts = [instruction, context, response]
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join(part <span class="hljs-keyword">for</span> part <span class="hljs-keyword">in</span> parts <span class="hljs-keyword">if</span> part)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    <span class="hljs-comment"># Load instruction-following dataset</span>
    dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
    
    <span class="hljs-comment"># Model configuration</span>
    model_id = <span class="hljs-string">&quot;Qwen/Qwen3-1.7B&quot;</span>
    output_dir = <span class="hljs-string">&quot;qwen3-1.7b-finetuned&quot;</span>
    
    <span class="hljs-comment"># Setup tokenizer</span>
    tokenizer = AutoTokenizer.from_pretrained(model_id)
    tokenizer.pad_token = tokenizer.eos_token
    
    <span class="hljs-comment"># Configure training for Trainium</span>
    training_args = NeuronTrainingArguments(
        learning_rate=<span class="hljs-number">1e-4</span>,
        tensor_parallel_size=<span class="hljs-number">8</span>,  <span class="hljs-comment"># Split model across 8 accelerators</span>
        per_device_train_batch_size=<span class="hljs-number">1</span>,  <span class="hljs-comment"># Batch size per device</span>
        gradient_accumulation_steps=<span class="hljs-number">8</span>,
        logging_steps=<span class="hljs-number">1</span>,
        output_dir=output_dir,
    )
    
    <span class="hljs-comment"># Load model optimized for Trainium</span>
    model = NeuronModelForCausalLM.from_pretrained(
        model_id,
        training_args.trn_config,
        torch_dtype=torch.bfloat16,
        attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,  <span class="hljs-comment"># Enable flash attention</span>
    )
    
    <span class="hljs-comment"># Setup supervised fine-tuning</span>
    sft_config = NeuronSFTConfig(
        max_seq_length=<span class="hljs-number">2048</span>,
        packing=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Pack multiple samples for efficiency</span>
        **training_args.to_dict(),
    )
    
    <span class="hljs-comment"># Initialize trainer and start training</span>
    trainer = NeuronSFTTrainer(
        model=model,
        args=sft_config,
        tokenizer=tokenizer,
        train_dataset=dataset,
        formatting_func=format_dolly_dataset,
    )
    
    trainer.train()
    
    <span class="hljs-comment"># Share your model with the community</span>
    trainer.push_to_hub(
        commit_message=<span class="hljs-string">&quot;Fine-tuned on Databricks Dolly dataset&quot;</span>,
        blocking=<span class="hljs-literal">True</span>,
        model_name=output_dir,
    )
    
    <span class="hljs-keyword">if</span> xr.local_ordinal() == <span class="hljs-number">0</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Training complete! Model saved to <span class="hljs-subst">{output_dir}</span>&quot;</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),C=new F({props:{title:"Running Training",local:"running-training",headingTag:"h3"}}),X=new Y({props:{code:"TkVVUk9OX0NDX0ZMQUdTJTNEJTIyLS1tb2RlbC10eXBlJTIwdHJhbnNmb3JtZXIlMjIlMjBuZXVyb25fcGFyYWxsZWxfY29tcGlsZSUyMHRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUyMDMyJTIwc2Z0X2ZpbmV0dW5lX3F3ZW4zLnB5",highlighted:'NEURON_CC_FLAGS=<span class="hljs-string">&quot;--model-type transformer&quot;</span> neuron_parallel_compile torchrun --nproc_per_node 32 sft_finetune_qwen3.py',wrap:!1}}),W=new Y({props:{code:"TkVVUk9OX0NDX0ZMQUdTJTNEJTIyLS1tb2RlbC10eXBlJTIwdHJhbnNmb3JtZXIlMjIlMjB0b3JjaHJ1biUyMC0tbnByb2NfcGVyX25vZGUlMjAzMiUyMHNmdF9maW5ldHVuZV9xd2VuMy5weQ==",highlighted:'NEURON_CC_FLAGS=<span class="hljs-string">&quot;--model-type transformer&quot;</span> torchrun --nproc_per_node 32 sft_finetune_qwen3.py',wrap:!1}}),N=new F({props:{title:"Inference",local:"inference",headingTag:"h2"}}),G=new F({props:{title:"1. Export Your Model",local:"1-export-your-model",headingTag:"h3"}}),V=new Y({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAlNUMlMEElMjAlMjAtLW1vZGVsJTIwZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjAlNUMlMEElMjAlMjAtLWJhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwJTIwLS1zZXF1ZW5jZV9sZW5ndGglMjAzMiUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjAlNUMlMEElMjAlMjBkaXN0aWxiZXJ0X2Jhc2VfdW5jYXNlZF9maW5ldHVuZWRfc3N0Ml9lbmdsaXNoX25ldXJvbiUyRg==",highlighted:`optimum-cli <span class="hljs-built_in">export</span> neuron \\
  --model distilbert-base-uncased-finetuned-sst-2-english \\
  --batch_size 1 \\
  --sequence_length 32 \\
  --auto_cast matmul \\
  --auto_cast_type bf16 \\
  distilbert_base_uncased_finetuned_sst2_english_neuron/`,wrap:!1}}),E=new F({props:{title:"2. Run Inference",local:"2-run-inference",headingTag:"h3"}}),k=new Y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwY29tcGlsZWQlMjBOZXVyb24lMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkaXN0aWxiZXJ0X2Jhc2VfdW5jYXNlZF9maW5ldHVuZWRfc3N0Ml9lbmdsaXNoX25ldXJvbiUyMiUwQSklMEElMEElMjMlMjBTZXR1cCUyMHRva2VuaXplciUyMChzYW1lJTIwYXMlMjBvcmlnaW5hbCUyMG1vZGVsKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQSUwQSUyMyUyMFJ1biUyMGluZmVyZW5jZSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIYW1pbHRvbiUyMGlzJTIwY29uc2lkZXJlZCUyMHRvJTIwYmUlMjB0aGUlMjBiZXN0JTIwbXVzaWNhbCUyMG9mJTIwcGFzdCUyMHllYXJzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByaW50KG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmxvZ2l0cy5hcmdtYXgoKS5pdGVtKCklNUQpJTBBJTIzJTIwJ1BPU0lUSVZFJw==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSequenceClassification

<span class="hljs-comment"># Load the compiled Neuron model</span>
model = NeuronModelForSequenceClassification.from_pretrained(
    <span class="hljs-string">&quot;distilbert_base_uncased_finetuned_sst2_english_neuron&quot;</span>
)

<span class="hljs-comment"># Setup tokenizer (same as original model)</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-comment"># Run inference</span>
inputs = tokenizer(<span class="hljs-string">&quot;Hamilton is considered to be the best musical of past years.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
logits = model(**inputs).logits

<span class="hljs-built_in">print</span>(model.config.id2label[logits.argmax().item()])
<span class="hljs-comment"># &#x27;POSITIVE&#x27;</span>`,wrap:!1}}),v=new F({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),{c(){c=i("meta"),z=n(),Q=i("p"),S=n(),o(w.$$.fragment),L=n(),o(u.$$.fragment),q=n(),d=i("p"),d.innerHTML=bl,D=n(),j=i("p"),j.innerHTML=fl,P=n(),U=i("p"),U.innerHTML=hl,K=n(),I=i("ul"),I.innerHTML=Zl,O=n(),o(b.$$.fragment),ll=n(),f=i("p"),f.textContent=Cl,tl=n(),o(h.$$.fragment),el=n(),Z=i("p"),Z.innerHTML=gl,sl=n(),o(C.$$.fragment),nl=n(),g=i("p"),g.innerHTML=Xl,al=n(),o(X.$$.fragment),il=n(),B=i("p"),B.innerHTML=Bl,Ml=n(),o(W.$$.fragment),ol=n(),o(N.$$.fragment),rl=n(),A=i("p"),A.innerHTML=Wl,pl=n(),o(G.$$.fragment),Jl=n(),o(V.$$.fragment),ml=n(),_=i("p"),_.innerHTML=Nl,Tl=n(),o(E.$$.fragment),yl=n(),o(k.$$.fragment),cl=n(),R=i("p"),R.innerHTML=Al,wl=n(),o(v.$$.fragment),ul=n(),x=i("p"),x.textContent=Gl,dl=n(),$=i("ul"),$.innerHTML=Vl,jl=n(),H=i("p"),this.h()},l(l){const t=Fl("svelte-u9bgzb",document.head);c=M(t,"META",{name:!0,content:!0}),t.forEach(e),z=a(l),Q=M(l,"P",{}),_l(Q).forEach(e),S=a(l),r(w.$$.fragment,l),L=a(l),r(u.$$.fragment,l),q=a(l),d=M(l,"P",{"data-svelte-h":!0}),p(d)!=="svelte-rionjr"&&(d.innerHTML=bl),D=a(l),j=M(l,"P",{"data-svelte-h":!0}),p(j)!=="svelte-4024ac"&&(j.innerHTML=fl),P=a(l),U=M(l,"P",{"data-svelte-h":!0}),p(U)!=="svelte-dcww01"&&(U.innerHTML=hl),K=a(l),I=M(l,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-1x7ik4"&&(I.innerHTML=Zl),O=a(l),r(b.$$.fragment,l),ll=a(l),f=M(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-100vig6"&&(f.textContent=Cl),tl=a(l),r(h.$$.fragment,l),el=a(l),Z=M(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-6vr389"&&(Z.innerHTML=gl),sl=a(l),r(C.$$.fragment,l),nl=a(l),g=M(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-p86113"&&(g.innerHTML=Xl),al=a(l),r(X.$$.fragment,l),il=a(l),B=M(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-16jb019"&&(B.innerHTML=Bl),Ml=a(l),r(W.$$.fragment,l),ol=a(l),r(N.$$.fragment,l),rl=a(l),A=M(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-18qqgpt"&&(A.innerHTML=Wl),pl=a(l),r(G.$$.fragment,l),Jl=a(l),r(V.$$.fragment,l),ml=a(l),_=M(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1xuei7w"&&(_.innerHTML=Nl),Tl=a(l),r(E.$$.fragment,l),yl=a(l),r(k.$$.fragment,l),cl=a(l),R=M(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-7flx79"&&(R.innerHTML=Al),wl=a(l),r(v.$$.fragment,l),ul=a(l),x=M(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-f2vb7f"&&(x.textContent=Gl),dl=a(l),$=M(l,"UL",{"data-svelte-h":!0}),p($)!=="svelte-e9xbbf"&&($.innerHTML=Vl),jl=a(l),H=M(l,"P",{}),_l(H).forEach(e),this.h()},h(){El(c,"name","hf:doc:metadata"),El(c,"content",zl)},m(l,t){Ql(document.head,c),s(l,z,t),s(l,Q,t),s(l,S,t),J(w,l,t),s(l,L,t),J(u,l,t),s(l,q,t),s(l,d,t),s(l,D,t),s(l,j,t),s(l,P,t),s(l,U,t),s(l,K,t),s(l,I,t),s(l,O,t),J(b,l,t),s(l,ll,t),s(l,f,t),s(l,tl,t),J(h,l,t),s(l,el,t),s(l,Z,t),s(l,sl,t),J(C,l,t),s(l,nl,t),s(l,g,t),s(l,al,t),J(X,l,t),s(l,il,t),s(l,B,t),s(l,Ml,t),J(W,l,t),s(l,ol,t),J(N,l,t),s(l,rl,t),s(l,A,t),s(l,pl,t),J(G,l,t),s(l,Jl,t),J(V,l,t),s(l,ml,t),s(l,_,t),s(l,Tl,t),J(E,l,t),s(l,yl,t),J(k,l,t),s(l,cl,t),s(l,R,t),s(l,wl,t),J(v,l,t),s(l,ul,t),s(l,x,t),s(l,dl,t),s(l,$,t),s(l,jl,t),s(l,H,t),Ul=!0},p:Rl,i(l){Ul||(m(w.$$.fragment,l),m(u.$$.fragment,l),m(b.$$.fragment,l),m(h.$$.fragment,l),m(C.$$.fragment,l),m(X.$$.fragment,l),m(W.$$.fragment,l),m(N.$$.fragment,l),m(G.$$.fragment,l),m(V.$$.fragment,l),m(E.$$.fragment,l),m(k.$$.fragment,l),m(v.$$.fragment,l),Ul=!0)},o(l){T(w.$$.fragment,l),T(u.$$.fragment,l),T(b.$$.fragment,l),T(h.$$.fragment,l),T(C.$$.fragment,l),T(X.$$.fragment,l),T(W.$$.fragment,l),T(N.$$.fragment,l),T(G.$$.fragment,l),T(V.$$.fragment,l),T(E.$$.fragment,l),T(k.$$.fragment,l),T(v.$$.fragment,l),Ul=!1},d(l){l&&(e(z),e(Q),e(S),e(L),e(q),e(d),e(D),e(j),e(P),e(U),e(K),e(I),e(O),e(ll),e(f),e(tl),e(el),e(Z),e(sl),e(nl),e(g),e(al),e(il),e(B),e(Ml),e(ol),e(rl),e(A),e(pl),e(Jl),e(ml),e(_),e(Tl),e(yl),e(cl),e(R),e(wl),e(ul),e(x),e(dl),e($),e(jl),e(H)),e(c),y(w,l),y(u,l),y(b,l),y(h,l),y(C,l),y(X,l),y(W,l),y(N,l),y(G,l),y(V,l),y(E,l),y(k,l),y(v,l)}}}const zl='{"title":"Quickstart","local":"quickstart","sections":[{"title":"Training","local":"training","sections":[{"title":"Running Training","local":"running-training","sections":[],"depth":3}],"depth":2},{"title":"Inference","local":"inference","sections":[{"title":"1. Export Your Model","local":"1-export-your-model","sections":[],"depth":3},{"title":"2. Run Inference","local":"2-run-inference","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Sl(Il){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends xl{constructor(c){super(),$l(this,c,Sl,Yl,kl,{})}}export{Ol as component};
