# 🚀  Tutorials: How To Fine-tune & Run LLMs

Learn how to run and fine-tune models for optimal performance with AWS Trainium.
<div style="display: grid !important; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)) !important; gap: 24px !important; margin: 32px -32px !important; padding: 0 32px !important; max-width: none !important; width: calc(100% + 64px) !important;">

<a href="./finetune_llama" style="text-decoration: none !important; color: inherit !important; display: block !important;">
<div style="border-radius: 8px !important; background-color: white !important; box-shadow: 0 2px 8px rgba(0,0,0,0.1) !important; transition: all 0.3s ease-in-out !important; cursor: pointer !important; display: flex !important; flex-direction: column !important; height: 280px !important; width: 100% !important; border: none !important;"
onmouseover="this.style.transform='translateY(-4px)'; this.style.boxShadow='0 8px 24px rgba(0,0,0,0.15)'; this.querySelector('.card-content').style.backgroundPosition='0% 0'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.1)'; this.querySelector('.card-content').style.backgroundPosition='100% 0'">
  <div style="height: 180px !important; width: 100% !important; background: linear-gradient(135deg, #FF6B35 0%, #F7931E 100%) !important; display: flex !important; align-items: center !important; justify-content: center !important; position: relative !important; border: none !important; margin: 0 !important; padding: 0 !important; border-radius: 8px 8px 0 0 !important; overflow: hidden !important;">
    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/optimum/neuron/training_tutorials/llama-logo.png" alt="Llama 3" style="width: 100% !important; height: 100% !important; object-fit: cover !important; border: none !important; border-radius: 8px 8px 0 0 !important;" onerror="this.outerHTML='<div style=\'color: white; font-size: 48px; font-weight: bold; z-index: 10;
position: relative;\'>🦙</div>'"/>
  </div>
  <div class="card-content" style="padding: 20px !important; background: white !important;
background-image: linear-gradient(90deg, transparent 0%, #f8f9fa 50%, #e9ecef 100%) !important; background-size: 200% 100% !important; background-position: 100% 0 !important;
transition: background-position 0.4s ease-out !important; width: 100% !important; box-sizing: border-box !important; flex: 1 !important; border: none !important; margin: 0 !important;
border-radius: 0 0 8px 8px !important;">
    <h3 style="margin: 0 0 8px 0 !important; font-size: 18px !important;
font-weight: 600 !important; color: #24292e !important;">
      Llama 3.1
    </h3>
    <p style="margin: 0 !important;
font-size: 14px !important; color: #586069 !important; line-height: 1.4 !important;">
      Instruction Fine-tuning of Llama 3.1 8B with LoRA on the Dolly dataset
    </p>
  </div>
</div>
</a>

<a href="./finetune_qwen3" style="text-decoration: none !important;
color: inherit !important; display: block !important;">
<div style="border-radius: 8px !important; background-color: white !important; box-shadow: 0 2px 8px rgba(0,0,0,0.1) !important;
transition: all 0.3s ease-in-out !important; cursor: pointer !important; display: flex !important; flex-direction: column !important; height: 280px !important; width: 100% !important;
border: none !important;" onmouseover="this.style.transform='translateY(-4px)'; this.style.boxShadow='0 8px 24px rgba(0,0,0,0.15)'; this.querySelector('.card-content').style.backgroundPosition='0% 0'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.1)';
this.querySelector('.card-content').style.backgroundPosition='100% 0'">
  <div style="height: 180px !important; width: 100% !important; background: linear-gradient(135deg, #faf5ff 0%, #f3e8ff 100%) !important; display: flex !important;
align-items: center !important; justify-content: center !important; position: relative !important; border: none !important; margin: 0 !important; padding: 0 !important;
border-radius: 8px 8px 0 0 !important; overflow: hidden !important;">
    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/optimum/neuron/training_tutorials/qwen3-logo.png" alt="Qwen3" style="width: 100% !important;
height: 100% !important; object-fit: cover !important; border: none !important; border-radius: 8px 8px 0 0 !important;" onerror="this.outerHTML='<div style=\'color: white; font-size: 48px;
font-weight: bold; z-index: 10; position: relative;\'>🔷</div>'"/>
  </div>
  <div class="card-content" style="padding: 20px !important; background: white !important;
background-image: linear-gradient(90deg, transparent 0%, #f8f9fa 50%, #e9ecef 100%) !important; background-size: 200% 100% !important; background-position: 100% 0 !important;
transition: background-position 0.4s ease-out !important; width: 100% !important; box-sizing: border-box !important; flex: 1 !important; border: none !important; margin: 0 !important;
border-radius: 0 0 8px 8px !important;">
    <h3 style="margin: 0 0 8px 0 !important; font-size: 18px !important;
font-weight: 600 !important; color: #24292e !important;">
      Qwen3
    </h3>
    <p style="margin: 0 !important;
font-size: 14px !important; color: #586069 !important; line-height: 1.4 !important;">
      Fine-tune Qwen3 8B with LoRA on the Simple Recipes dataset
    </p>
  </div>
</div>
</a>

<a href="./pretraining_hyperpod_llm" style="text-decoration: none !important;
color: inherit !important; display: block !important;">
<div style="border-radius: 8px !important; background-color: white !important; box-shadow: 0 2px 8px rgba(0,0,0,0.1) !important;
transition: all 0.3s ease-in-out !important; cursor: pointer !important; display: flex !important; flex-direction: column !important; height: 280px !important; width: 100% !important;
border: none !important;" onmouseover="this.style.transform='translateY(-4px)'; this.style.boxShadow='0 8px 24px rgba(0,0,0,0.15)'; this.querySelector('.card-content').style.backgroundPosition='0% 0'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.1)';
this.querySelector('.card-content').style.backgroundPosition='100% 0'">
  <div style="height: 180px !important; width: 100% !important; background: linear-gradient(135deg, #059669 0%, #0891b2 100%) !important; display: flex !important;
align-items: center !important; justify-content: center !important; position: relative !important; border: none !important; margin: 0 !important; padding: 0 !important;
border-radius: 8px 8px 0 0 !important; overflow: hidden !important;">
    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/optimum/neuron/training_tutorials/sagemaker-logo.png" alt="SageMaker Hyperpod" style="width: 100% !important;
height: 100% !important; object-fit: cover !important; border: none !important; border-radius: 8px 8px 0 0 !important;" onerror="this.outerHTML='<div style=\'color: white; font-size: 28px;
font-weight: bold; text-align: center; z-index: 10; position: relative;\'>☁️<br/>SageMaker</div>'"/>
  </div>
  <div class="card-content" style="padding: 20px !important; background: white !important;
background-image: linear-gradient(90deg, transparent 0%, #f8f9fa 50%, #e9ecef 100%) !important; background-size: 200% 100% !important; background-position: 100% 0 !important;
transition: background-position 0.4s ease-out !important; width: 100% !important; box-sizing: border-box !important; flex: 1 !important; border: none !important; margin: 0 !important;
border-radius: 0 0 8px 8px !important;">
    <h3 style="margin: 0 0 8px 0 !important; font-size: 18px !important;
font-weight: 600 !important; color: #24292e !important;">
      Llama 3.2 on SageMaker
    </h3>
    <p style="margin: 0 !important;
font-size: 14px !important; color: #586069 !important; line-height: 1.4 !important;">
      Continuous Pretraining of Llama 3.2 1B on SageMaker Hyperpod
    </p>
  </div>
</div>
</a>

</div>

## What you'll learn

These tutorials will guide you through the complete process of fine-tuning large language models on AWS Trainium:

- **📊 Data Preparation**: Load and preprocess datasets for supervised fine-tuning
- **🔧 Model Configuration**: Set up LoRA adapters and distributed training parameters
- **⚡ Training Optimization**: Leverage tensor parallelism, gradient checkpointing, and mixed precision
- **💾 Checkpoint Management**: Consolidate and merge model checkpoints for deployment
- **🚀 Model Deployment**: Export and test your fine-tuned models for inference

Choose the tutorial that best fits your use case and start fine-tuning your LLMs on AWS Trainium today!