import{s as WT,n as YT,o as HT}from"../chunks/scheduler.56725da7.js";import{S as qT,i as PT,e as C,s as M,c as O,h as KT,a as n,d as U,b as s,f as XT,g as y,j as a,k as $T,l as lU,m as J,n as i,t as e,o as t,p as I}from"../chunks/index.18a26576.js";import{C as el}from"../chunks/CodeBlock.7cf349b0.js";import{H as g}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d7b980df.js";function TU(tT){let p,gl,tl,pl,Q,Ql,k,IT="In todays world, mostly every AI Engineer is familiar with running inference by simply making an API call, but how is that request served optimally by the backend? How does the model provider or service you are using ensure latency and throughput requirements are met?",kl,N,gT="In this blog we will cover how to serve a model using Optimum Neuron on AWS Inferentia2 with the HuggingFace TGI container. I’ll also delve into how to optimize for latency and throughput and what decisions we can make to influence our priorities.",Nl,R,Rl,D,pT="<li>Inferentia2 chips: Inferentia2 is the second generation AWS purpose-built Machine Learning inference accelerator.</li> <li>Optimum Neuron: The interface between the 🤗 Transformers library and AWS Accelerators including AWS Trainium and AWS Inferentia.</li> <li>Text Generation Inference (TGI) container: Text Generation Inference (TGI) is a toolkit for deploying and serving Large Language Models (LLMs).</li> <li>GuideLLM: A tool for evaluating and optimizing the deployment of large language models (LLMs).</li>",Dl,V,QT="The instance I am using for this experiment will be <code>inf2.48xlarge</code>. I can check instance type as well as see each device by running <code>neuron-ls</code> which gives the following output:",Vl,F,Fl,w,wl,c,kT="First, I ran the following commands to install the necessary dependencies, and pull the container needed to compile the model, as well as serve the compiled model for benchmarking.",cl,j,NT="<code>!pip install hftransfer guidellm==0.1.0</code> <code>!git clone https://github.com/huggingface/optimum-neuron.git</code> <code>!docker pull ghcr.io/huggingface/text-generation-inference:latest-neuron</code>",jl,E,RT="Depending on the model, optionally configure your HF_TOKEN like so:",El,r,DT="<code>!export HF_TOKEN=YOUR_HF_TOKEN</code>",rl,u,ul,h,VT="For my use case, I needed to compile my model with specific parameters that were unique. It is important to mention that compilation is not always needed. For example, in the event that the already cached configuration would have worked for me, optimum would use that by default.",hl,x,FT="From the docs: “The Neuron Model Cache is a remote cache for compiled Neuron models in the <code>neff</code> format. It is integrated into the <code>NeuronTrainer</code> and <code>NeuronModelForCausalLM</code> classes to enable loading pretrained models from the cache instead of compiling them locally.”",xl,m,wT="Now I compile the model I have selected, <code>meta-llama-3.1-8b-instruct</code> with the following command:",ml,o,ol,A,cT="Take note that for my use case, I have decided to use a batch size of 8, with a tensor parallel degree of 8. Since an inf2.48xlarge has 24 cores, I can use a data parallel of 3, which means I will have 3 copies of my model across the instance.`",Al,b,bl,d,jT="When optimizing hardware utilization for cost-efficiency, particularly for the inf2.48xlarge instance at $12.98 per hour on-demand, the roofline model is a valuable framework.",dl,S,ET=`The roofline model defines theoretical performance bounds. On one extreme, memory-bound workloads are limited by memory capacity, necessitating frequent read/write operations. On the other, compute-bound workloads fully utilize the accelerator’s compute capabilities, maximizing on-device data processing.
Batch size is a key lever for controlling this balance. Larger batch sizes tend to shift workloads towards being compute-bound, while smaller batch sizes may result in more memory-bound operations.
With that stated, maximizing batch size is not always viable. Keeping in mind max batch size for the specified latency budget (the time we want to take to return a response) is paramount.
This is most directly controlled with batch size. For more information on this topic, check out this resource:
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/arch/neuron-features/neuroncore-batching.html" rel="nofollow">https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/arch/neuron-features/neuroncore-batching.html</a>`,Sl,B,Bl,f,rT="Several files are needed to ensure our configuration is setup properly, and that the model I compiled is used rather than the cached configuration.",fl,v,uT="First I’ll need to create my .env file, which specifies my batch size, precision, etc. It is important to note, that since I compiled my model, I needed to change the model_id from the usual huggingface repo designation, to the container volume location I specified within the compilation command.",vl,L,Ll,G,hT="Next, I create the benchmark.sh script with my desired settings:",Gl,Z,Zl,z,xT="Take note of the parameters passed via the <code>--data</code> flag. As my use case is for long prompts and long generation, I have set <code>prompt_tokens</code> and `generated_tokens accordingly. Remember to set these according to your use case and the input / output token load you expect.\nBased on these numbers, GuideLLM will generate prompts of random sizes in a normal distribution of around 15900 tokens, and ask for a random number of generated tokens in a normal distribution of around 450 tokens.",zl,_,mT="The docker compose file is important for defining your data parallel, by specifying the number of devices I wish to allocate to each container. This is also where I specify the load balancer.",_l,X,Xl,$,oT="Lastly, I define the nginx.conf for the load balancer:",$l,W,Wl,Y,Yl,H,AT="Now that I have defined the necessary files, I start serving my optimum-neuron model with TGI backend.",Hl,q,bT="<code>!docker compose -f docker-compose.yaml --env-file .env up</code>",ql,P,dT=`As a sanity check, I can watch the output of the above command to ensure that each container starts properly as well as the load balancer.
Once I have started the containers successfully, I can begin benchmarking using the previously defined benchmarking script.`,Pl,K,ST="<code>!benchmark.sh &quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</code>",Kl,ll,BT="A colorful stdout will begin to populate the terminal as guidellm begins to test your model serving setup.",lT,Tl,TT,Ul,fT="In approximately 15-20 minutes, benchmarking is completed and displays the following detailed breakdown in the terminal:",UT,Jl,JT,Ml,vT="Unpacking the results, we get quite a few useful data points for us to use. Under the hood, guidellm runs three separate “loads” with which to benchmark the system against.",MT,sl,LT="<li>Synchronous - Serving one request at a time</li> <li>Asynchronous - Serving multiple requests at once at a locked in req/sec (0.85 in this case)</li> <li>Throughput - Serving the maximum number of requests that the system can sustain</li>",sT,Cl,GT=`From these tests we are given several metrics for each like how many requests were successfully performed vs how many failed. The time to first token, prompt input and output sizes and more.
For my experiment, I can see that under max load, I can serve up to 0.85 requests per second at a maximum latency of just under 44 seconds per request. Depending on my latency budget, the next step would be to increase my batch size if I can tolerate longer response times and desire more throughput. Alternatively, I could lower my batch size to decrease the latency, at the cost of potentially reducing throughput.`,CT,nl,ZT="Lastly, the large input and output tokens required for my workload directly effect the benchmark results, specifically the time needed to encode my input context contributing to most of the benchmark time.",nT,al,aT,Ol,zT="In this blog post, I took you through how to compile and load an Optimum Neuron model, how to serve it with the HuggingFace Text Generation Inference container, and how to benchmark your settings to optimize for your workload.",OT,yl,yT,il,_T='<a href="https://huggingface.co/docs/optimum-neuron/en/guides/cache_system" rel="nofollow">https://huggingface.co/docs/optimum-neuron/en/guides/cache_system</a> <a href="https://github.com/huggingface/optimum-neuron/tree/main/benchmark/text-generation-inference/performance" rel="nofollow">https://github.com/huggingface/optimum-neuron/tree/main/benchmark/text-generation-inference/performance</a> <a href="https://github.com/vllm-project/guidellm" rel="nofollow">https://github.com/vllm-project/guidellm</a>',iT,Il,eT;return Q=new g({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),R=new g({props:{title:"Understanding the Tools",local:"understanding-the-tools",headingTag:"h2"}}),F=new el({props:{code:"aW5zdGFuY2UtdHlwZSUzQSUyMGluZjIuNDh4bGFyZ2UlMEElMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0lMkItLS0tLS0tLS0tLSUyQi0tLS0tLS0tLSUyQiUwQSU3QyUyME5FVVJPTiUyMCU3QyUyME5FVVJPTiUyMCU3QyUyME5FVVJPTiUyMCU3QyUyMENPTk5FQ1RFRCUyMCU3QyUyMCUyMCUyMFBDSSUyMCUyMCUyMCU3QyUwQSU3QyUyMERFVklDRSUyMCU3QyUyMENPUkVTJTIwJTIwJTdDJTIwTUVNT1JZJTIwJTdDJTIwJTIwREVWSUNFUyUyMCUyMCU3QyUyMCUyMCUyMEJERiUyMCUyMCUyMCU3QyUwQSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0lMkItLS0tLS0tLSUyQi0tLS0tLS0tLS0tJTJCLS0tLS0tLS0tJTJCJTBBJTdDJTIwMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDIlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAzMiUyMEdCJTIwJTIwJTdDJTIwMTElMkMlMjAxJTIwJTIwJTIwJTIwJTIwJTdDJTIwODAlM0ExZS4wJTIwJTdDJTBBJTdDJTIwMSUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDIlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAzMiUyMEdCJTIwJTIwJTdDJTIwMCUyQyUyMDIlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjA5MCUzQTFlLjAlMjAlN0MlMEElN0MlMjAyJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMiUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDMyJTIwR0IlMjAlMjAlN0MlMjAxJTJDJTIwMyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDgwJTNBMWQuMCUyMCU3QyUwQSU3QyUyMDMlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAyJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMzIlMjBHQiUyMCUyMCU3QyUyMDIlMkMlMjA0JTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwOTAlM0ExZi4wJTIwJTdDJTBBJTdDJTIwNCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDIlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAzMiUyMEdCJTIwJTIwJTdDJTIwMyUyQyUyMDUlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjA4MCUzQTFmLjAlMjAlN0MlMEElN0MlMjA1JTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMiUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDMyJTIwR0IlMjAlMjAlN0MlMjA0JTJDJTIwNiUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDkwJTNBMWQuMCUyMCU3QyUwQSU3QyUyMDYlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAyJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMzIlMjBHQiUyMCUyMCU3QyUyMDUlMkMlMjA3JTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMjAlM0ExZS4wJTIwJTdDJTBBJTdDJTIwNyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDIlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAzMiUyMEdCJTIwJTIwJTdDJTIwNiUyQyUyMDglMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAyMCUzQTFmLjAlMjAlN0MlMEElN0MlMjA4JTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMiUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDMyJTIwR0IlMjAlMjAlN0MlMjA3JTJDJTIwOSUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDEwJTNBMWUuMCUyMCU3QyUwQSU3QyUyMDklMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAyJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMzIlMjBHQiUyMCUyMCU3QyUyMDglMkMlMjAxMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDEwJTNBMWYuMCUyMCU3QyUwQSU3QyUyMDEwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMiUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDMyJTIwR0IlMjAlMjAlN0MlMjA5JTJDJTIwMTElMjAlMjAlMjAlMjAlMjAlN0MlMjAxMCUzQTFkLjAlMjAlN0MlMEElN0MlMjAxMSUyMCUyMCUyMCUyMCUyMCU3QyUyMDIlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAzMiUyMEdCJTIwJTIwJTdDJTIwMTAlMkMlMjAwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMjAlM0ExZC4wJTIwJTdDJTBBJTJCLS0tLS0tLS0lMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0tLS0lMkItLS0tLS0tLS0lMkI=",highlighted:`instance-type: inf2.48xlarge
+--------+--------+--------+-----------+---------+
|<span class="hljs-string"> NEURON </span>|<span class="hljs-string"> NEURON </span>|<span class="hljs-string"> NEURON </span>|<span class="hljs-string"> CONNECTED </span>|<span class="hljs-string">   PCI   </span>|
|<span class="hljs-string"> DEVICE </span>|<span class="hljs-string"> CORES  </span>|<span class="hljs-string"> MEMORY </span>|<span class="hljs-string">  DEVICES  </span>|<span class="hljs-string">   BDF   </span>|
+--------+--------+--------+-----------+---------+
|<span class="hljs-string"> 0      </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 11, 1     </span>|<span class="hljs-string"> 80:1e.0 </span>|
|<span class="hljs-string"> 1      </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 0, 2      </span>|<span class="hljs-string"> 90:1e.0 </span>|
|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 1, 3      </span>|<span class="hljs-string"> 80:1d.0 </span>|
|<span class="hljs-string"> 3      </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 2, 4      </span>|<span class="hljs-string"> 90:1f.0 </span>|
|<span class="hljs-string"> 4      </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 3, 5      </span>|<span class="hljs-string"> 80:1f.0 </span>|
|<span class="hljs-string"> 5      </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 4, 6      </span>|<span class="hljs-string"> 90:1d.0 </span>|
|<span class="hljs-string"> 6      </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 5, 7      </span>|<span class="hljs-string"> 20:1e.0 </span>|
|<span class="hljs-string"> 7      </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 6, 8      </span>|<span class="hljs-string"> 20:1f.0 </span>|
|<span class="hljs-string"> 8      </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 7, 9      </span>|<span class="hljs-string"> 10:1e.0 </span>|
|<span class="hljs-string"> 9      </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 8, 10     </span>|<span class="hljs-string"> 10:1f.0 </span>|
|<span class="hljs-string"> 10     </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 9, 11     </span>|<span class="hljs-string"> 10:1d.0 </span>|
|<span class="hljs-string"> 11     </span>|<span class="hljs-string"> 2      </span>|<span class="hljs-string"> 32 GB  </span>|<span class="hljs-string"> 10, 0     </span>|<span class="hljs-string"> 20:1d.0 </span>|
+--------+--------+--------+-----------+---------+`,wrap:!1}}),w=new g({props:{title:"Setup and Installation",local:"setup-and-installation",headingTag:"h2"}}),u=new g({props:{title:"Model Compilation and Deployment",local:"model-compilation-and-deployment",headingTag:"h2"}}),o=new el({props:{code:"IWRvY2tlciUyMHJ1biUyMC1wJTIwODA4MCUzQTgwJTIwLWUlMjBIRl9UT0tFTiUzRFlPVVJfVE9LRU4lMjAlNUMlMEEtdiUyMCUyNChwd2QpJTNBJTJGZGF0YSUyMCU1QyUwQS0tZGV2aWNlJTNEJTJGZGV2JTJGbmV1cm9uMCUyMCU1QyUwQS0tZGV2aWNlJTNEJTJGZGV2JTJGbmV1cm9uMSUyMCU1QyUwQS0tZGV2aWNlJTNEJTJGZGV2JTJGbmV1cm9uMiUyMCU1QyUwQS0tZGV2aWNlJTNEJTJGZGV2JTJGbmV1cm9uMyUyMCU1QyUwQS0tZGV2aWNlJTNEJTJGZGV2JTJGbmV1cm9uNCUyMCU1QyUwQS0tZGV2aWNlJTNEJTJGZGV2JTJGbmV1cm9uNSUyMCU1QyUwQS0tZGV2aWNlJTNEJTJGZGV2JTJGbmV1cm9uNiUyMCU1QyUwQS0tZGV2aWNlJTNEJTJGZGV2JTJGbmV1cm9uNyUyMCU1QyUwQS0tZGV2aWNlJTNEJTJGZGV2JTJGbmV1cm9uOCUyMCU1QyUwQS0tZGV2aWNlJTNEJTJGZGV2JTJGbmV1cm9uOSUyMCU1QyUwQS0tZGV2aWNlJTNEJTJGZGV2JTJGbmV1cm9uMTAlMjAlNUMlMEEtLWRldmljZSUzRCUyRmRldiUyRm5ldXJvbjExJTIwJTVDJTBBLXRpJTIwJTVDJTBBLS1lbnRyeXBvaW50JTIwJTIyb3B0aW11bS1jbGklMjIlMjBnaGNyLmlvJTJGaHVnZ2luZ2ZhY2UlMkZ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTNBbGF0ZXN0LW5ldXJvbiUyMCU1QyUwQWV4cG9ydCUyMG5ldXJvbiUyMC0tbW9kZWwlMjAlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIlMjAlNUMlMEEtLXNlcXVlbmNlX2xlbmd0aCUyMDE2NTEyJTIwJTVDJTBBLS1iYXRjaF9zaXplJTIwOCUyMCU1QyUwQS0tbnVtX2NvcmVzJTIwOCUyMCU1QyUwQSUyRmRhdGElMkZleHBvcnRlZG1vZGVsJTJG",highlighted:`!docker run -p 8080:80 -e HF_TOKEN=YOUR_TOKEN \\
-v $(<span class="hljs-built_in">pwd</span>):/data \\
--device=/dev/neuron0 \\
--device=/dev/neuron1 \\
--device=/dev/neuron2 \\
--device=/dev/neuron3 \\
--device=/dev/neuron4 \\
--device=/dev/neuron5 \\
--device=/dev/neuron6 \\
--device=/dev/neuron7 \\
--device=/dev/neuron8 \\
--device=/dev/neuron9 \\
--device=/dev/neuron10 \\
--device=/dev/neuron11 \\
-ti \\
--entrypoint <span class="hljs-string">&quot;optimum-cli&quot;</span> ghcr.io/huggingface/text-generation-inference:latest-neuron \\
<span class="hljs-built_in">export</span> neuron --model <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span> \\
--sequence_length 16512 \\
--batch_size 8 \\
--num_cores 8 \\
/data/exportedmodel/`,wrap:!1}}),b=new g({props:{title:"Optimizing Batch Size for Maximum Throughput",local:"optimizing-batch-size-for-maximum-throughput",headingTag:"h2"}}),B=new g({props:{title:"Creating Files for Serving",local:"creating-files-for-serving",headingTag:"h2"}}),L=new el({props:{code:"TU9ERUxfSUQlM0QnJTJGZGF0YSUyRmV4cG9ydGVkbW9kZWwnJTBBTUFYX0JBVENIX1NJWkUlM0Q4JTBBTUFYX0lOUFVUX1RPS0VOUyUzRDE2MDAwJTBBTUFYX1RPVEFMX1RPS0VOUyUzRDE2NTEy",highlighted:`<span class="hljs-attr">MODEL_ID</span>=<span class="hljs-string">&#x27;/data/exportedmodel&#x27;</span>
<span class="hljs-attr">MAX_BATCH_SIZE</span>=<span class="hljs-number">8</span>
<span class="hljs-attr">MAX_INPUT_TOKENS</span>=<span class="hljs-number">16000</span>
<span class="hljs-attr">MAX_TOTAL_TOKENS</span>=<span class="hljs-number">16512</span>`,wrap:!1}}),Z=new el({props:{code:"JTIzISUyRmJpbiUyRmJhc2glMEElMEFtb2RlbCUzRCUyNCU3QjElM0EtbWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy4xLThCLUluc3RydWN0JTdEJTBBJTBBZGF0ZV9zdHIlM0QlMjQoZGF0ZSUyMCclMkIlMjVZLSUyNW0tJTI1ZC0lMjVILSUyNU0tJTI1UycpJTBBb3V0cHV0X3BhdGglM0QlMjIlMjQlN0Jtb2RlbCUyRiUyRiU1QyUyRiUyRl8lN0QlMjMlMjQlN0JkYXRlX3N0ciU3RF9ndWlkZWxsbV9yZXBvcnQuanNvbiUyMiUwQSUwQWV4cG9ydCUyMEhGX1RPS0VOJTNEWU9VUl9UT0tFTiUwQSUwQWV4cG9ydCUyMEdVSURFTExNX19OVU1fU1dFRVBfUFJPRklMRVMlM0QxJTBBZXhwb3J0JTIwR1VJREVMTE1fX01BWF9DT05DVVJSRU5DWSUzRDEyOCUwQWV4cG9ydCUyMEdVSURFTExNX19SRVFVRVNUX1RJTUVPVVQlM0Q2MCUwQSUwQWd1aWRlbGxtJTIwJTVDJTBBJTIwLS10YXJnZXQlMjAlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBODA4MCUyRnYxJTIyJTIwJTVDJTBBJTIwLS1tb2RlbCUyMCUyNCU3Qm1vZGVsJTdEJTIwJTVDJTBBJTIwLS1kYXRhLXR5cGUlMjBlbXVsYXRlZCUyMCU1QyUwQSUyMC0tZGF0YSUyMCUyMnByb21wdF90b2tlbnMlM0QxNTkwMCUyQ3Byb21wdF90b2tlbnNfdmFyaWFuY2UlM0QxMDAlMkNnZW5lcmF0ZWRfdG9rZW5zJTNENDUwJTJDZ2VuZXJhdGVkX3Rva2Vuc192YXJpYW5jZSUzRDUwJTIyJTIwJTVDJTBBJTIwLS1vdXRwdXQtcGF0aCUyMCUyNCU3Qm91dHB1dF9wYXRoJTdEJTIwJTVD",highlighted:`<span class="hljs-meta">#!/bin/bash</span>

model=<span class="hljs-variable">\${1:-meta-llama/Meta-Llama-3.1-8B-Instruct}</span>

date_str=$(<span class="hljs-built_in">date</span> <span class="hljs-string">&#x27;+%Y-%m-%d-%H-%M-%S&#x27;</span>)
output_path=<span class="hljs-string">&quot;<span class="hljs-variable">\${model//\\//_}</span>#<span class="hljs-variable">\${date_str}</span>_guidellm_report.json&quot;</span>

<span class="hljs-built_in">export</span> HF_TOKEN=YOUR_TOKEN

<span class="hljs-built_in">export</span> GUIDELLM__NUM_SWEEP_PROFILES=1
<span class="hljs-built_in">export</span> GUIDELLM__MAX_CONCURRENCY=128
<span class="hljs-built_in">export</span> GUIDELLM__REQUEST_TIMEOUT=60

guidellm \\
 --target <span class="hljs-string">&quot;http://localhost:8080/v1&quot;</span> \\
 --model <span class="hljs-variable">\${model}</span> \\
 --data-type emulated \\
 --data <span class="hljs-string">&quot;prompt_tokens=15900,prompt_tokens_variance=100,generated_tokens=450,generated_tokens_variance=50&quot;</span> \\
 --output-path <span class="hljs-variable">\${output_path}</span> \\`,wrap:!1}}),X=new el({props:{code:"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",highlighted:`<span class="hljs-attribute">version</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&#x27;3.7&#x27;</span>

<span class="hljs-attribute">services</span><span class="hljs-punctuation">:</span>
 <span class="hljs-attribute">tgi-1</span><span class="hljs-punctuation">:</span>
 <span class="hljs-attribute">image</span><span class="hljs-punctuation">:</span> <span class="hljs-string">ghcr.io/huggingface/text-generation-inference:latest-neuron</span>
 <span class="hljs-attribute">ports</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;8081:8081&quot;</span>
 <span class="hljs-attribute">volumes</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">$PWD:/data</span>
 <span class="hljs-attribute">environment</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">PORT=8081</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MODEL_ID=\${MODEL_ID}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">HF_NUM_CORES=8</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_BATCH_SIZE=\${MAX_BATCH_SIZE}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">HF_TOKEN=YOUR_TOKEN</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_INPUT_TOKENS=\${MAX_INPUT_TOKENS}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_TOTAL_TOKENS=\${MAX_TOTAL_TOKENS}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_CONCURRENT_REQUESTS=512</span>
 <span class="hljs-attribute">devices</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron0&quot;</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron1&quot;</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron2&quot;</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron3&quot;</span>

 <span class="hljs-attribute">tgi-2</span><span class="hljs-punctuation">:</span>
 <span class="hljs-attribute">image</span><span class="hljs-punctuation">:</span> <span class="hljs-string">ghcr.io/huggingface/text-generation-inference:latest-neuron</span>
 <span class="hljs-attribute">ports</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;8082:8082&quot;</span>
 <span class="hljs-attribute">volumes</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">$PWD:/data</span>
 <span class="hljs-attribute">environment</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">PORT=8082</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MODEL_ID=\${MODEL_ID}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">HF_NUM_CORES=8</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_BATCH_SIZE=\${MAX_BATCH_SIZE}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">HF_TOKEN=YOUR_TOKEN</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_INPUT_TOKENS=\${MAX_INPUT_TOKENS}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_TOTAL_TOKENS=\${MAX_TOTAL_TOKENS}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_CONCURRENT_REQUESTS=512</span>
 <span class="hljs-attribute">devices</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron4&quot;</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron5&quot;</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron6&quot;</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron7&quot;</span>

 <span class="hljs-attribute">tgi-3</span><span class="hljs-punctuation">:</span>
 <span class="hljs-attribute">image</span><span class="hljs-punctuation">:</span> <span class="hljs-string">ghcr.io/huggingface/text-generation-inference:latest-neuron</span>
 <span class="hljs-attribute">ports</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;8083:8083&quot;</span>
 <span class="hljs-attribute">volumes</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">$PWD:/data</span>
 <span class="hljs-attribute">environment</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">PORT=8083</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MODEL_ID=\${MODEL_ID}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">HF_NUM_CORES=8</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_BATCH_SIZE=\${MAX_BATCH_SIZE}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">HF_TOKEN=YOUR_TOKEN</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_INPUT_TOKENS=\${MAX_INPUT_TOKENS}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_TOTAL_TOKENS=\${MAX_TOTAL_TOKENS}</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">MAX_CONCURRENT_REQUESTS=512</span>
 <span class="hljs-attribute">devices</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron8&quot;</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron9&quot;</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron10&quot;</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/dev/neuron11&quot;</span>

 <span class="hljs-attribute">loadbalancer</span><span class="hljs-punctuation">:</span>
 <span class="hljs-attribute">image</span><span class="hljs-punctuation">:</span> <span class="hljs-string">nginx:alpine</span>
 <span class="hljs-attribute">ports</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;8080:80&quot;</span>
 <span class="hljs-attribute">volumes</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">./nginx.conf:/etc/nginx/nginx.conf:ro</span>
 <span class="hljs-attribute">depends_on</span><span class="hljs-punctuation">:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">tgi-1</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">tgi-2</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">tgi-3</span>
 <span class="hljs-attribute">deploy</span><span class="hljs-punctuation">:</span>
 <span class="hljs-attribute">placement</span><span class="hljs-punctuation">:</span>
 <span class="hljs-attribute">constraints</span><span class="hljs-punctuation">:</span> <span class="hljs-string">[node.role == manager]</span>`,wrap:!1}}),W=new el({props:{code:"JTIzJTIzJTIzJTIwTmdpbnglMjBUR0klMjBMb2FkJTIwQmFsYW5jZXIlMEFldmVudHMlMjAlN0IlN0QlMEFodHRwJTIwJTdCJTBBJTIwdXBzdHJlYW0lMjB0Z2ljbHVzdGVyJTIwJTdCJTBBJTIwJTIwJTIwJTIwc2VydmVyJTIwdGdpLTElM0E4MDgxJTNCJTBBJTIwJTIwJTIwJTIwc2VydmVyJTIwdGdpLTIlM0E4MDgyJTNCJTBBJTIwJTIwJTIwJTIwc2VydmVyJTIwdGdpLTMlM0E4MDgzJTNCJTBBJTIwJTdEJTBBJTIwc2VydmVyJTIwJTdCJTBBJTIwJTIwJTIwJTIwbGlzdGVuJTIwODAlM0IlMEElMjAlMjAlMjAlMjBsb2NhdGlvbiUyMCUyRiUyMCU3QiUwQSUyMCUyMCUyMCUyMHByb3h5X3Bhc3MlMjBodHRwJTNBJTJGJTJGdGdpY2x1c3RlciUzQiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-comment">### Nginx TGI Load Balancer</span>
<span class="hljs-section">events</span> {}
<span class="hljs-section">http</span> {
 <span class="hljs-section">upstream</span> tgicluster {
    <span class="hljs-attribute">server</span> tgi-<span class="hljs-number">1</span>:<span class="hljs-number">8081</span>;
    <span class="hljs-attribute">server</span> tgi-<span class="hljs-number">2</span>:<span class="hljs-number">8082</span>;
    <span class="hljs-attribute">server</span> tgi-<span class="hljs-number">3</span>:<span class="hljs-number">8083</span>;
 }
 <span class="hljs-section">server</span> {
    <span class="hljs-attribute">listen</span> <span class="hljs-number">80</span>;
    <span class="hljs-section">location</span> / {
    <span class="hljs-attribute">proxy_pass</span> http://tgicluster;
    }
 }
}`,wrap:!1}}),Y=new g({props:{title:"Benchmarking with GuideLLM",local:"benchmarking-with-guidellm",headingTag:"h2"}}),Tl=new g({props:{title:"Performance Analysis",local:"performance-analysis",headingTag:"h2"}}),Jl=new el({props:{code:"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",highlighted:`╭─ <span class="hljs-selector-tag">Benchmarks</span> ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮
│ <span class="hljs-selector-attr">[15:02:17]</span> <span class="hljs-number">100%</span> <span class="hljs-selector-tag">synchronous</span> (<span class="hljs-number">0.10</span> req/sec avg)│
│ <span class="hljs-selector-attr">[15:04:17]</span> <span class="hljs-number">100%</span> <span class="hljs-selector-tag">throughput</span> (<span class="hljs-number">0.85</span> req/sec avg)│
│ <span class="hljs-selector-attr">[15:05:25]</span> <span class="hljs-number">100%</span> <span class="hljs-selector-tag">constant</span>@<span class="hljs-number">0.85</span> <span class="hljs-selector-tag">req</span>/<span class="hljs-selector-tag">s</span> (<span class="hljs-number">0.77</span> req/sec avg) │
╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯
 <span class="hljs-selector-tag">Generating</span> <span class="hljs-selector-tag">report</span>... ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ (<span class="hljs-number">3</span>/<span class="hljs-number">3</span>) <span class="hljs-selector-attr">[ 0:05:04 &lt; 0:00:00 ]</span>
╭─ <span class="hljs-selector-tag">GuideLLM</span> <span class="hljs-selector-tag">Benchmarks</span> <span class="hljs-selector-tag">Report</span> (meta-llama_Meta-Llama-<span class="hljs-number">3.1</span>-<span class="hljs-number">8</span>B-Instruct<span class="hljs-number">#2025</span>-<span class="hljs-number">05</span>-<span class="hljs-number">27</span>-<span class="hljs-number">15</span>-<span class="hljs-number">02</span>-<span class="hljs-number">11</span>_guidellm_report.json) ──────────────────────────────────────────────────────────────────────────────────╮
│ ╭─ <span class="hljs-selector-tag">Benchmark</span> <span class="hljs-selector-tag">Report</span> <span class="hljs-number">1</span> ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮ │
│ │ <span class="hljs-selector-tag">Backend</span>(type=openai_server, target=<span class="hljs-attribute">http</span>:<span class="hljs-comment">//localhost:8080/v1, model=meta-llama/Meta-Llama-3.1-8B-Instruct) │ │</span>
│ │ <span class="hljs-built_in">Data</span>(type=emulated, source=prompt_tokens=<span class="hljs-number">15900</span>,prompt_tokens_variance=<span class="hljs-number">100</span>,generated_tokens=<span class="hljs-number">450</span>,generated_tokens_variance=<span class="hljs-number">50</span>, tokenizer=meta-llama/Meta-Llama-<span class="hljs-number">3.1</span>-<span class="hljs-number">8</span>B-Instruct) │ │
│ │ <span class="hljs-built_in">Rate</span>(type=sweep, rate=None) │ │
│ │ <span class="hljs-built_in">Limits</span>(max_number=None requests, max_duration=<span class="hljs-number">120</span> sec) │ │
│ │ │ │
│ │ │ │
│ │ Requests Data by Benchmark │ │
│ │ ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━┳━━━━━━━━━━━━┳━━━━━━━━━━┓ │ │
│ │ ┃ Benchmark ┃ Requests Completed ┃ Request Failed ┃ Duration ┃ Start Time ┃ End Time ┃ │ │
│ │ ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━╇━━━━━━━━━━━━╇━━━━━━━━━━┩ │ │
│ │ │ synchronous │ <span class="hljs-number">11</span>/<span class="hljs-number">11</span> │ <span class="hljs-number">0</span>/<span class="hljs-number">11</span> │ <span class="hljs-number">113.56</span> sec │ <span class="hljs-number">15</span>:<span class="hljs-number">02</span>:<span class="hljs-number">17</span> │ <span class="hljs-number">15</span>:<span class="hljs-number">04</span>:<span class="hljs-number">11</span> │ │ │
│ │ │ asynchronous<span class="hljs-variable">@0</span>.<span class="hljs-number">85</span> req/sec │ <span class="hljs-number">88</span>/<span class="hljs-number">88</span> │ <span class="hljs-number">0</span>/<span class="hljs-number">88</span> │ <span class="hljs-number">114.59</span> sec │ <span class="hljs-number">15</span>:<span class="hljs-number">05</span>:<span class="hljs-number">25</span> │ <span class="hljs-number">15</span>:<span class="hljs-number">07</span>:<span class="hljs-number">19</span> │ │ │
│ │ │ throughput │ <span class="hljs-number">55</span>/<span class="hljs-number">55</span> │ <span class="hljs-number">0</span>/<span class="hljs-number">55</span> │ <span class="hljs-number">64.83</span> sec │ <span class="hljs-number">15</span>:<span class="hljs-number">04</span>:<span class="hljs-number">17</span> │ <span class="hljs-number">15</span>:<span class="hljs-number">05</span>:<span class="hljs-number">22</span> │ │ │
│ │ └───────────────────────────┴────────────────────┴────────────────┴────────────┴────────────┴──────────┘ │ │
│ │ │ │
│ │ Tokens Data by Benchmark │ │
│ │ ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓ │ │
│ │ ┃ Benchmark ┃ Prompt ┃ Prompt (<span class="hljs-number">1%</span>, <span class="hljs-number">5%</span>, <span class="hljs-number">50%</span>, <span class="hljs-number">95%</span>, <span class="hljs-number">99%</span>) ┃ Output ┃ Output (<span class="hljs-number">1%</span>, <span class="hljs-number">5%</span>, <span class="hljs-number">50%</span>, <span class="hljs-number">95%</span>, <span class="hljs-number">99%</span>) ┃ │ │
│ │ ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩ │ │
│ │ │ synchronous │ <span class="hljs-number">15902.82</span> │ <span class="hljs-number">15896.0</span>, <span class="hljs-number">15896.0</span>, <span class="hljs-number">15902.0</span>, <span class="hljs-number">15913.0</span>, <span class="hljs-number">15914.6</span> │ <span class="hljs-number">293.09</span> │ <span class="hljs-number">70.3</span>, <span class="hljs-number">119.5</span>, <span class="hljs-number">315.0</span>, <span class="hljs-number">423.5</span>, <span class="hljs-number">443.1</span> │ │ │
│ │ │ asynchronous<span class="hljs-variable">@0</span>.<span class="hljs-number">85</span> req/sec │ <span class="hljs-number">15899.06</span> │ <span class="hljs-number">15877.4</span>, <span class="hljs-number">15879.4</span>, <span class="hljs-number">15898.5</span>, <span class="hljs-number">15918.0</span>, <span class="hljs-number">15919.8</span> │ <span class="hljs-number">288.75</span> │ <span class="hljs-number">24.6</span>, <span class="hljs-number">74.1</span>, <span class="hljs-number">298.5</span>, <span class="hljs-number">452.6</span>, <span class="hljs-number">459.1</span> │ │ │
│ │ │ throughput │ <span class="hljs-number">15899.22</span> │ <span class="hljs-number">15879.5</span>, <span class="hljs-number">15883.7</span>, <span class="hljs-number">15898.0</span>, <span class="hljs-number">15914.6</span>, <span class="hljs-number">15920.5</span> │ <span class="hljs-number">294.24</span> │ <span class="hljs-number">59.1</span>, <span class="hljs-number">114.9</span>, <span class="hljs-number">285.0</span>, <span class="hljs-number">452.9</span>, <span class="hljs-number">456.4</span> │ │ │
│ │ └───────────────────────────┴──────────┴─────────────────────────────────────────────┴────────┴──────────────────────────────────┘ │ │
│ │ │ │
│ │ Performance Stats by Benchmark │ │
│ │ ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓ │ │
│ │ ┃ ┃ Request Latency [<span class="hljs-number">1%</span>, <span class="hljs-number">5%</span>, <span class="hljs-number">10%</span>, <span class="hljs-number">50%</span>, <span class="hljs-number">90%</span>, <span class="hljs-number">95%</span>, <span class="hljs-number">99%</span>] ┃ Time to First Token [<span class="hljs-number">1%</span>, <span class="hljs-number">5%</span>, <span class="hljs-number">10%</span>, <span class="hljs-number">50%</span>, <span class="hljs-number">90%</span>, <span class="hljs-number">95%</span>, ┃ Inter Token Latency [<span class="hljs-number">1%</span>, <span class="hljs-number">5%</span>, <span class="hljs-number">10%</span>, <span class="hljs-number">50%</span>, <span class="hljs-number">90%</span> <span class="hljs-number">95%</span>, ┃ │ │
│ │ ┃ Benchmark ┃ (sec) ┃ <span class="hljs-number">99%</span>] (ms) ┃ <span class="hljs-number">99%</span>] (ms) ┃ │ │
│ │ ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩ │ │
│ │ │ synchronous │ <span class="hljs-number">3.68</span>, <span class="hljs-number">5.13</span>, <span class="hljs-number">6.94</span>, <span class="hljs-number">10.91</span>, <span class="hljs-number">13.51</span>, <span class="hljs-number">14.26</span>, <span class="hljs-number">14.87</span> │ <span class="hljs-number">1563.3</span>, <span class="hljs-number">1569.2</span>, <span class="hljs-number">1576.5</span>, <span class="hljs-number">1589.4</span>, <span class="hljs-number">1594.0</span>, <span class="hljs-number">1595.3</span>, │ <span class="hljs-number">23.2</span>, <span class="hljs-number">28.2</span>, <span class="hljs-number">29.4</span>, <span class="hljs-number">29.8</span>, <span class="hljs-number">30.3</span>, <span class="hljs-number">31.7</span>, <span class="hljs-number">36.5</span> │ │ │
│ │ │ │ │ <span class="hljs-number">1596.4</span> │ │ │ │
│ │ │ asynchronous<span class="hljs-variable">@0</span>.<span class="hljs-number">85</span> req/sec │ <span class="hljs-number">2.62</span>, <span class="hljs-number">6.55</span>, <span class="hljs-number">9.40</span>, <span class="hljs-number">20.66</span>, <span class="hljs-number">30.60</span>, <span class="hljs-number">32.78</span>, <span class="hljs-number">35.07</span> │ <span class="hljs-number">1594.1</span>, <span class="hljs-number">1602.5</span>, <span class="hljs-number">1605.7</span>, <span class="hljs-number">1629.7</span>, <span class="hljs-number">4650.1</span>, <span class="hljs-number">4924.1</span>, │ <span class="hljs-number">0.2</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">34.3</span>, <span class="hljs-number">44.9</span>, <span class="hljs-number">54.5</span>, <span class="hljs-number">1613.9</span> │ │ │
│ │ │ │ │ <span class="hljs-number">5345.6</span> │ │ │ │
│ │ │ throughput │ <span class="hljs-number">18.29</span>, <span class="hljs-number">21.24</span>, <span class="hljs-number">23.81</span>, <span class="hljs-number">44.60</span>, <span class="hljs-number">61.50</span>, <span class="hljs-number">62.80</span>, <span class="hljs-number">63.72</span> │ <span class="hljs-number">2157.6</span>, <span class="hljs-number">9185.1</span>, <span class="hljs-number">12220.5</span>, <span class="hljs-number">23333.5</span>, <span class="hljs-number">44214.1</span>, │ <span class="hljs-number">28.2</span>, <span class="hljs-number">31.5</span>, <span class="hljs-number">33.1</span>, <span class="hljs-number">39.1</span>, <span class="hljs-number">59.0</span>, <span class="hljs-number">65.2</span>, <span class="hljs-number">1604.6</span> │ │ │
│ │ │ │ │ <span class="hljs-number">45329.8</span>, <span class="hljs-number">51276.9</span> │ │ │ │
│ │ └───────────────────────────┴───────────────────────────────────────────────────┴───────────────────────────────────────────────────┴────────────────────────────────────────────────────┘ │ │
│ │ │ │
│ │ Performance Summary by Benchmark │ │
│ │ ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━┓ │ │
│ │ ┃ Benchmark ┃ Requests per Second ┃ Request Latency ┃ Time to First Token ┃ Inter Token Latency ┃ Output Token Throughput ┃ │ │
│ │ ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━┩ │ │
│ │ │ synchronous │ <span class="hljs-number">0.10</span> req/sec │ <span class="hljs-number">10.32</span> sec │ <span class="hljs-number">1585.08</span> ms │ <span class="hljs-number">29.81</span> ms │ <span class="hljs-number">28.39</span> tokens/sec │ │ │
│ │ │ asynchronous<span class="hljs-variable">@0</span>.<span class="hljs-number">85</span> req/sec │ <span class="hljs-number">0.77</span> req/sec │ <span class="hljs-number">20.77</span> sec │ <span class="hljs-number">2401.32</span> ms │ <span class="hljs-number">63.69</span> ms │ <span class="hljs-number">221.75</span> tokens/sec │ │ │
│ │ │ throughput │ <span class="hljs-number">0.85</span> req/sec │ <span class="hljs-number">43.78</span> sec │ <span class="hljs-number">24624.46</span> ms │ <span class="hljs-number">65.18</span> ms │ <span class="hljs-number">249.64</span> tokens/sec │ │ │
│ │ └───────────────────────────┴─────────────────────┴─────────────────┴─────────────────────┴─────────────────────┴─────────────────────────┘ │ │
│ ╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯ │
╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯`,wrap:!1}}),al=new g({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),yl=new g({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){p=C("meta"),gl=M(),tl=C("p"),pl=M(),O(Q.$$.fragment),Ql=M(),k=C("p"),k.textContent=IT,kl=M(),N=C("p"),N.textContent=gT,Nl=M(),O(R.$$.fragment),Rl=M(),D=C("ul"),D.innerHTML=pT,Dl=M(),V=C("p"),V.innerHTML=QT,Vl=M(),O(F.$$.fragment),Fl=M(),O(w.$$.fragment),wl=M(),c=C("p"),c.textContent=kT,cl=M(),j=C("p"),j.innerHTML=NT,jl=M(),E=C("p"),E.textContent=RT,El=M(),r=C("p"),r.innerHTML=DT,rl=M(),O(u.$$.fragment),ul=M(),h=C("p"),h.textContent=VT,hl=M(),x=C("p"),x.innerHTML=FT,xl=M(),m=C("p"),m.innerHTML=wT,ml=M(),O(o.$$.fragment),ol=M(),A=C("p"),A.textContent=cT,Al=M(),O(b.$$.fragment),bl=M(),d=C("p"),d.textContent=jT,dl=M(),S=C("p"),S.innerHTML=ET,Sl=M(),O(B.$$.fragment),Bl=M(),f=C("p"),f.textContent=rT,fl=M(),v=C("p"),v.textContent=uT,vl=M(),O(L.$$.fragment),Ll=M(),G=C("p"),G.textContent=hT,Gl=M(),O(Z.$$.fragment),Zl=M(),z=C("p"),z.innerHTML=xT,zl=M(),_=C("p"),_.textContent=mT,_l=M(),O(X.$$.fragment),Xl=M(),$=C("p"),$.textContent=oT,$l=M(),O(W.$$.fragment),Wl=M(),O(Y.$$.fragment),Yl=M(),H=C("p"),H.textContent=AT,Hl=M(),q=C("p"),q.innerHTML=bT,ql=M(),P=C("p"),P.textContent=dT,Pl=M(),K=C("p"),K.innerHTML=ST,Kl=M(),ll=C("p"),ll.textContent=BT,lT=M(),O(Tl.$$.fragment),TT=M(),Ul=C("p"),Ul.textContent=fT,UT=M(),O(Jl.$$.fragment),JT=M(),Ml=C("p"),Ml.textContent=vT,MT=M(),sl=C("ol"),sl.innerHTML=LT,sT=M(),Cl=C("p"),Cl.textContent=GT,CT=M(),nl=C("p"),nl.textContent=ZT,nT=M(),O(al.$$.fragment),aT=M(),Ol=C("p"),Ol.textContent=zT,OT=M(),O(yl.$$.fragment),yT=M(),il=C("p"),il.innerHTML=_T,iT=M(),Il=C("p"),this.h()},l(l){const T=KT("svelte-u9bgzb",document.head);p=n(T,"META",{name:!0,content:!0}),T.forEach(U),gl=s(l),tl=n(l,"P",{}),XT(tl).forEach(U),pl=s(l),y(Q.$$.fragment,l),Ql=s(l),k=n(l,"P",{"data-svelte-h":!0}),a(k)!=="svelte-1qtnios"&&(k.textContent=IT),kl=s(l),N=n(l,"P",{"data-svelte-h":!0}),a(N)!=="svelte-mf1d72"&&(N.textContent=gT),Nl=s(l),y(R.$$.fragment,l),Rl=s(l),D=n(l,"UL",{"data-svelte-h":!0}),a(D)!=="svelte-10lap7w"&&(D.innerHTML=pT),Dl=s(l),V=n(l,"P",{"data-svelte-h":!0}),a(V)!=="svelte-yvuj"&&(V.innerHTML=QT),Vl=s(l),y(F.$$.fragment,l),Fl=s(l),y(w.$$.fragment,l),wl=s(l),c=n(l,"P",{"data-svelte-h":!0}),a(c)!=="svelte-1nwqic8"&&(c.textContent=kT),cl=s(l),j=n(l,"P",{"data-svelte-h":!0}),a(j)!=="svelte-10i0lsm"&&(j.innerHTML=NT),jl=s(l),E=n(l,"P",{"data-svelte-h":!0}),a(E)!=="svelte-1aem5lq"&&(E.textContent=RT),El=s(l),r=n(l,"P",{"data-svelte-h":!0}),a(r)!=="svelte-1l2mb9r"&&(r.innerHTML=DT),rl=s(l),y(u.$$.fragment,l),ul=s(l),h=n(l,"P",{"data-svelte-h":!0}),a(h)!=="svelte-paeoq"&&(h.textContent=VT),hl=s(l),x=n(l,"P",{"data-svelte-h":!0}),a(x)!=="svelte-p9wslc"&&(x.innerHTML=FT),xl=s(l),m=n(l,"P",{"data-svelte-h":!0}),a(m)!=="svelte-ppy9hy"&&(m.innerHTML=wT),ml=s(l),y(o.$$.fragment,l),ol=s(l),A=n(l,"P",{"data-svelte-h":!0}),a(A)!=="svelte-1qtk29o"&&(A.textContent=cT),Al=s(l),y(b.$$.fragment,l),bl=s(l),d=n(l,"P",{"data-svelte-h":!0}),a(d)!=="svelte-1scbccj"&&(d.textContent=jT),dl=s(l),S=n(l,"P",{"data-svelte-h":!0}),a(S)!=="svelte-1vzdjbj"&&(S.innerHTML=ET),Sl=s(l),y(B.$$.fragment,l),Bl=s(l),f=n(l,"P",{"data-svelte-h":!0}),a(f)!=="svelte-1u02a8"&&(f.textContent=rT),fl=s(l),v=n(l,"P",{"data-svelte-h":!0}),a(v)!=="svelte-18oj44j"&&(v.textContent=uT),vl=s(l),y(L.$$.fragment,l),Ll=s(l),G=n(l,"P",{"data-svelte-h":!0}),a(G)!=="svelte-ihngmv"&&(G.textContent=hT),Gl=s(l),y(Z.$$.fragment,l),Zl=s(l),z=n(l,"P",{"data-svelte-h":!0}),a(z)!=="svelte-1yjwwi3"&&(z.innerHTML=xT),zl=s(l),_=n(l,"P",{"data-svelte-h":!0}),a(_)!=="svelte-1eszkgs"&&(_.textContent=mT),_l=s(l),y(X.$$.fragment,l),Xl=s(l),$=n(l,"P",{"data-svelte-h":!0}),a($)!=="svelte-1t3vgji"&&($.textContent=oT),$l=s(l),y(W.$$.fragment,l),Wl=s(l),y(Y.$$.fragment,l),Yl=s(l),H=n(l,"P",{"data-svelte-h":!0}),a(H)!=="svelte-wy6iap"&&(H.textContent=AT),Hl=s(l),q=n(l,"P",{"data-svelte-h":!0}),a(q)!=="svelte-15pqef9"&&(q.innerHTML=bT),ql=s(l),P=n(l,"P",{"data-svelte-h":!0}),a(P)!=="svelte-1fewlsy"&&(P.textContent=dT),Pl=s(l),K=n(l,"P",{"data-svelte-h":!0}),a(K)!=="svelte-tuypim"&&(K.innerHTML=ST),Kl=s(l),ll=n(l,"P",{"data-svelte-h":!0}),a(ll)!=="svelte-zl3b8i"&&(ll.textContent=BT),lT=s(l),y(Tl.$$.fragment,l),TT=s(l),Ul=n(l,"P",{"data-svelte-h":!0}),a(Ul)!=="svelte-xy8qv7"&&(Ul.textContent=fT),UT=s(l),y(Jl.$$.fragment,l),JT=s(l),Ml=n(l,"P",{"data-svelte-h":!0}),a(Ml)!=="svelte-bf06av"&&(Ml.textContent=vT),MT=s(l),sl=n(l,"OL",{"data-svelte-h":!0}),a(sl)!=="svelte-j7gq2a"&&(sl.innerHTML=LT),sT=s(l),Cl=n(l,"P",{"data-svelte-h":!0}),a(Cl)!=="svelte-xkujic"&&(Cl.textContent=GT),CT=s(l),nl=n(l,"P",{"data-svelte-h":!0}),a(nl)!=="svelte-11j4vv6"&&(nl.textContent=ZT),nT=s(l),y(al.$$.fragment,l),aT=s(l),Ol=n(l,"P",{"data-svelte-h":!0}),a(Ol)!=="svelte-82p2i1"&&(Ol.textContent=zT),OT=s(l),y(yl.$$.fragment,l),yT=s(l),il=n(l,"P",{"data-svelte-h":!0}),a(il)!=="svelte-1xvm8ix"&&(il.innerHTML=_T),iT=s(l),Il=n(l,"P",{}),XT(Il).forEach(U),this.h()},h(){$T(p,"name","hf:doc:metadata"),$T(p,"content",UU)},m(l,T){lU(document.head,p),J(l,gl,T),J(l,tl,T),J(l,pl,T),i(Q,l,T),J(l,Ql,T),J(l,k,T),J(l,kl,T),J(l,N,T),J(l,Nl,T),i(R,l,T),J(l,Rl,T),J(l,D,T),J(l,Dl,T),J(l,V,T),J(l,Vl,T),i(F,l,T),J(l,Fl,T),i(w,l,T),J(l,wl,T),J(l,c,T),J(l,cl,T),J(l,j,T),J(l,jl,T),J(l,E,T),J(l,El,T),J(l,r,T),J(l,rl,T),i(u,l,T),J(l,ul,T),J(l,h,T),J(l,hl,T),J(l,x,T),J(l,xl,T),J(l,m,T),J(l,ml,T),i(o,l,T),J(l,ol,T),J(l,A,T),J(l,Al,T),i(b,l,T),J(l,bl,T),J(l,d,T),J(l,dl,T),J(l,S,T),J(l,Sl,T),i(B,l,T),J(l,Bl,T),J(l,f,T),J(l,fl,T),J(l,v,T),J(l,vl,T),i(L,l,T),J(l,Ll,T),J(l,G,T),J(l,Gl,T),i(Z,l,T),J(l,Zl,T),J(l,z,T),J(l,zl,T),J(l,_,T),J(l,_l,T),i(X,l,T),J(l,Xl,T),J(l,$,T),J(l,$l,T),i(W,l,T),J(l,Wl,T),i(Y,l,T),J(l,Yl,T),J(l,H,T),J(l,Hl,T),J(l,q,T),J(l,ql,T),J(l,P,T),J(l,Pl,T),J(l,K,T),J(l,Kl,T),J(l,ll,T),J(l,lT,T),i(Tl,l,T),J(l,TT,T),J(l,Ul,T),J(l,UT,T),i(Jl,l,T),J(l,JT,T),J(l,Ml,T),J(l,MT,T),J(l,sl,T),J(l,sT,T),J(l,Cl,T),J(l,CT,T),J(l,nl,T),J(l,nT,T),i(al,l,T),J(l,aT,T),J(l,Ol,T),J(l,OT,T),i(yl,l,T),J(l,yT,T),J(l,il,T),J(l,iT,T),J(l,Il,T),eT=!0},p:YT,i(l){eT||(e(Q.$$.fragment,l),e(R.$$.fragment,l),e(F.$$.fragment,l),e(w.$$.fragment,l),e(u.$$.fragment,l),e(o.$$.fragment,l),e(b.$$.fragment,l),e(B.$$.fragment,l),e(L.$$.fragment,l),e(Z.$$.fragment,l),e(X.$$.fragment,l),e(W.$$.fragment,l),e(Y.$$.fragment,l),e(Tl.$$.fragment,l),e(Jl.$$.fragment,l),e(al.$$.fragment,l),e(yl.$$.fragment,l),eT=!0)},o(l){t(Q.$$.fragment,l),t(R.$$.fragment,l),t(F.$$.fragment,l),t(w.$$.fragment,l),t(u.$$.fragment,l),t(o.$$.fragment,l),t(b.$$.fragment,l),t(B.$$.fragment,l),t(L.$$.fragment,l),t(Z.$$.fragment,l),t(X.$$.fragment,l),t(W.$$.fragment,l),t(Y.$$.fragment,l),t(Tl.$$.fragment,l),t(Jl.$$.fragment,l),t(al.$$.fragment,l),t(yl.$$.fragment,l),eT=!1},d(l){l&&(U(gl),U(tl),U(pl),U(Ql),U(k),U(kl),U(N),U(Nl),U(Rl),U(D),U(Dl),U(V),U(Vl),U(Fl),U(wl),U(c),U(cl),U(j),U(jl),U(E),U(El),U(r),U(rl),U(ul),U(h),U(hl),U(x),U(xl),U(m),U(ml),U(ol),U(A),U(Al),U(bl),U(d),U(dl),U(S),U(Sl),U(Bl),U(f),U(fl),U(v),U(vl),U(Ll),U(G),U(Gl),U(Zl),U(z),U(zl),U(_),U(_l),U(Xl),U($),U($l),U(Wl),U(Yl),U(H),U(Hl),U(q),U(ql),U(P),U(Pl),U(K),U(Kl),U(ll),U(lT),U(TT),U(Ul),U(UT),U(JT),U(Ml),U(MT),U(sl),U(sT),U(Cl),U(CT),U(nl),U(nT),U(aT),U(Ol),U(OT),U(yT),U(il),U(iT),U(Il)),U(p),I(Q,l),I(R,l),I(F,l),I(w,l),I(u,l),I(o,l),I(b,l),I(B,l),I(L,l),I(Z,l),I(X,l),I(W,l),I(Y,l),I(Tl,l),I(Jl,l),I(al,l),I(yl,l)}}}const UU='{"title":"Introduction","local":"introduction","sections":[],"depth":2}';function JU(tT){return HT(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class aU extends qT{constructor(p){super(),PT(this,p,JU,TU,WT,{})}}export{aU as component};
