import{s as ol,n as pl,o as rl}from"../chunks/scheduler.56725da7.js";import{S as cl,i as Ml,e as i,s as n,c as r,h as ul,a as o,d as l,b as a,f as al,g as c,j as p,k as il,l as ml,m as s,n as M,t as u,o as m,p as h}from"../chunks/index.18a26576.js";import{C as hl}from"../chunks/CopyLLMTxtMenu.e184d84e.js";import{C as d}from"../chunks/CodeBlock.42131f15.js";import{H as fe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9d54fd95.js";function dl(bt){let y,Ue,je,Je,j,we,T,be,f,gt='Mixtral 8x7B is an open-source LLM from Mistral AI. It is a Sparse Mixture of Experts and has a similar architecture to Mistral 7B, but comes with a twist: it’s actually 8 “expert” models in one. If you want to learn more about MoEs check out <a href="https://huggingface.co/blog/moe" rel="nofollow">Mixture of Experts Explained</a>.',ge,U,It='In this tutorial you will learn how to deploy <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">mistralai/Mixtral-8x7B-Instruct-v0.1</a> model on AWS Inferentia2 with Hugging Face Optimum Neuron on Amazon SageMaker. We are going to use the Hugging Face TGI Neuron Container, a purpose-built Inference Container to easily deploy LLMs on AWS Inferentia2 powered by <a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">Text Generation Inference</a> and <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">Optimum Neuron</a>.',Ie,J,Ct="We will cover how to:",Ce,w,xt='<li><a href="#1-setup-development-environment">Setup a development environment</a></li> <li><a href="#2-retrieve-the-latest-hugging-face-tgi-neuron-dlc">Retrieve the latest Hugging Face TGI Neuron DLC</a></li> <li><a href="#3-deploy-Mixtral-8x7B-to-inferentia2">Deploy Mixtral 8x7B to Inferentia2</a></li> <li><a href="#4-clean-up">Clean up</a></li>',xe,b,Bt="Lets get started! 🚀",Be,g,vt='<a href="https://aws.amazon.com/ec2/instance-types/inf2/" rel="nofollow">AWS inferentia (Inf2)</a> are purpose-built EC2 for deep learning (DL) inference workloads. Here are the different instances of the Inferentia2 family.',ve,I,Nt="<thead><tr><th>instance size</th> <th>accelerators</th> <th>Neuron Cores</th> <th>accelerator memory</th> <th>vCPU</th> <th>CPU Memory</th> <th>on-demand price ($/h)</th></tr></thead> <tbody><tr><td>inf2.xlarge</td> <td>1</td> <td>2</td> <td>32</td> <td>4</td> <td>16</td> <td>0.76</td></tr> <tr><td>inf2.8xlarge</td> <td>1</td> <td>2</td> <td>32</td> <td>32</td> <td>128</td> <td>1.97</td></tr> <tr><td>inf2.24xlarge</td> <td>6</td> <td>12</td> <td>192</td> <td>96</td> <td>384</td> <td>6.49</td></tr> <tr><td>inf2.48xlarge</td> <td>12</td> <td>24</td> <td>384</td> <td>192</td> <td>768</td> <td>12.98</td></tr></tbody>",Ne,C,We,x,Wt="For this tutorial, we are going to use a Notebook Instance in Amazon SageMaker with the Python 3 (ipykernel) and the <code>sagemaker</code> python SDK to deploy Mixtral 8x7B to a SageMaker inference endpoint.",Ze,B,Zt="Make sur you have the latest version of the SageMaker SDK installed.",Ee,v,_e,N,Et="Then, instantiate the sagemaker role and session.",Ge,W,ke,Z,$e,E,_t='The latest Hugging Face TGI Neuron DLCs can be used to run inference on AWS Inferentia2. To retrieve it you can use the method <code>get_huggingface_llm_image_uri</code> of the Sagemaker SDK. However, if you have the Optimum Neuron package installed, you can use the <code>ecr.image_uri</code> function to retrieve the appropriate Hugging Face TGI Neuron DLC URI based on your desired <code>region</code> and <code>version</code>. Default values can be deduced by your AWS credentials. For more details see the <a href="https://huggingface.co/docs/optimum-neuron/containers" rel="nofollow">containers</a> documentation.',Se,_,Ve,G,Xe,k,Gt=`At the time of writing, <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/v2.6.0/general/arch/neuron-features/dynamic-shapes.html#neuron-dynamic-shapes" rel="nofollow">AWS Inferentia2 does not support dynamic shapes for inference</a>, which means that we need to specify our sequence length and batch size ahead of time.
To make it easier for customers to utilize the full power of Inferentia2, we created a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">neuron model cache</a>, which contains pre-compiled configurations for the most popular LLMs, including Mixtral 8x7B.`,He,$,kt=`This means we don’t need to compile the model ourselves, but we can use the pre-compiled model from the cache. You can find compiled/cached configurations on the
<a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/tree/main/inference-cache-config" rel="nofollow">Hugging Face Hub</a>. If your desired configuration is not yet cached, you can compile it yourself using the <a href="https://huggingface.co/docs/optimum-neuron/guides/export_model" rel="nofollow">Optimum CLI</a> or open a request at the <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/discussions" rel="nofollow">Cache repository</a>.`,Qe,S,$t='Let’s check the different configurations that are in the cache. For that you first need to log in the Hugging Face Hub, using a <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">User Access Token</a> with read access.',Ae,V,St='Make sure you have the necessary permissions to access the model. You can request access to the model <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">here</a>.',Fe,X,qe,H,Vt="Then, we need to install the latest version of Optimum Neuron.",Re,Q,Ye,A,Xt="Finally, we can query the cache and retrieve the existing set of configurations for which we maintained a compiled version of the model.",ze,F,Le,q,Ht="You should retrieve two entries in the cache:",Pe,R,De,Y,Qt="<strong>Deploying Mixtral 8x7B to a SageMaker Endpoint</strong>",Oe,z,At="Before deploying the model to Amazon SageMaker, we must define the TGI Neuron endpoint configuration. We need to make sure the following additional parameters are defined:",Ke,L,Ft="<li><code>HF_NUM_CORES</code>: Number of Neuron Cores used for the compilation.</li> <li><code>HF_BATCH_SIZE</code>: The batch size that was used to compile the model.</li> <li><code>HF_SEQUENCE_LENGTH</code>: The sequence length that was used to compile the model.</li> <li><code>HF_AUTO_CAST_TYPE</code>: The auto cast type that was used to compile the model.</li>",et,P,qt="We still need to define traditional TGI parameters with:",tt,D,Rt="<li><code>HF_MODEL_ID</code>: The Hugging Face model ID.</li> <li><code>HF_TOKEN</code>: The Hugging Face API token to access gated models.</li> <li><code>MAX_BATCH_SIZE</code>: The maximum batch size that the model can handle, equal to the batch size used for compilation.</li> <li><code>MAX_INPUT_TOKEN</code>: The maximum input length that the model can handle.</li> <li><code>MAX_TOTAL_TOKENS</code>: The maximum total tokens the model can generate, equal to the sequence length used for compilation.</li>",lt,O,Yt="Optionnaly, you can configure the endpoint to support chat templates:",st,K,zt="<li><code>MESSAGES_API_ENABLED</code>: Enable Messages API</li>",nt,ee,Lt="<strong>Select the right instance type</strong>",at,te,Pt="Mixtral 8x7B is a large model and requires a lot of memory. We are going to use the <code>inf2.48xlarge</code> instance type, which has 192 vCPUs and 384 GB of accelerator memory. The <code>inf2.48xlarge</code> instance comes with 12 Inferentia2 accelerators that include 24 Neuron Cores. In our case we will use a batch size of 4 and a sequence length of 4096.",it,le,Dt="After that we can create our endpoint configuration and deploy the model to Amazon SageMaker. We will deploy the endpoint with the Messages API enabled, so that it is fully compatible with the OpenAI Chat Completion API.",ot,se,pt,ne,Ot="After we have created the <code>HuggingFaceModel</code> we can deploy it to Amazon SageMaker using the <code>deploy</code> method. We will deploy the model with the <code>ml.inf2.48xlarge</code> instance type. TGI will automatically distribute and shard the model across all Inferentia devices.",rt,ae,ct,ie,Kt="SageMaker will now create our endpoint and deploy the model to it. It takes around 15 minutes for deployment.",Mt,oe,el="After our endpoint is deployed we can run inference on it. We will use the <code>predict</code> method from the <code>predictor</code> to run inference on our endpoint.",ut,pe,tl="The endpoint supports the Messages API, which is fully compatible with the OpenAI Chat Completion API. The Messages API allows us to interact with the model in a conversational way. We can define the role of the message and the content. The role can be either <code>system</code>,<code>assistant</code> or <code>user</code>. The <code>system</code> role is used to provide context to the model and the <code>user</code> role is used to ask questions or provide input to the model.",mt,re,ll='Parameters can be defined as in the <code>parameters</code> attribute of the payload. Check out the chat completion <a href="https://platform.openai.com/docs/api-reference/chat/create" rel="nofollow">documentation</a> to find supported parameters.',ht,ce,dt,Me,yt,ue,sl="Okay lets test it.",jt,me,Tt,he,ft,de,nl="To clean up, we can delete the model and endpoint.",Ut,ye,Jt,Te,wt;return j=new hl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new fe({props:{title:"Deploy Mixtral 8x7B on AWS Inferentia2",local:"deploy-mixtral-8x7b-on-aws-inferentia2",headingTag:"h1"}}),C=new fe({props:{title:"1. Setup development environment",local:"1-setup-development-environment",headingTag:"h2"}}),v=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzYWdlbWFrZXIlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"!pip install sagemaker --upgrade --quiet",wrap:!1}}),W=new d({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyME5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCUyMmlhbSUyMiklMEElMjAlMjAlMjAlMjByb2xlJTIwJTNEJTIwaWFtLmdldF9yb2xlKFJvbGVOYW1lJTNEJTIyc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJTIyKSU1QiUyMlJvbGUlMjIlNUQlNUIlMjJBcm4lMjIlNUQlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oZGVmYXVsdF9idWNrZXQlM0RzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQpJTBBJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMHJvbGUlMjBhcm4lM0ElMjAlN0Jyb2xlJTdEJTIyKSUwQXByaW50KGYlMjJzYWdlbWFrZXIlMjBzZXNzaW9uJTIwcmVnaW9uJTNBJTIwJTdCc2Vzcy5ib3RvX3JlZ2lvbl9uYW1lJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&quot;iam&quot;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&quot;sagemaker_execution_role&quot;</span>)[<span class="hljs-string">&quot;Role&quot;</span>][<span class="hljs-string">&quot;Arn&quot;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),Z=new fe({props:{title:"2. Retrieve the latest Hugging Face TGI Neuron DLC",local:"2-retrieve-the-latest-hugging-face-tgi-neuron-dlc",headingTag:"h2"}}),_=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjBvcHRpbXVtLW5ldXJvbiU1Qm5ldXJvbnglNUQlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24udXRpbHMlMjBpbXBvcnQlMjBlY3IlMEFsbG1faW1hZ2UlMjAlM0QlMjBlY3IuaW1hZ2VfdXJpKCUyMnRnaSUyMiklMEElMjMlMjBwcmludCUyMGltYWdlJTIwdXJpJTBBcHJpbnQoZiUyMmxsbSUyMGltYWdlJTIwdXJpJTNBJTIwJTdCbGxtX2ltYWdlJTdEJTIyKQ==",highlighted:`!pip install optimum-neuron[neuronx]
<span class="hljs-keyword">from</span> optimum.neuron.utils <span class="hljs-keyword">import</span> ecr
llm_image = ecr.image_uri(<span class="hljs-string">&quot;tgi&quot;</span>)
<span class="hljs-comment"># print image uri</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;llm image uri: <span class="hljs-subst">{llm_image}</span>&quot;</span>)`,wrap:!1}}),G=new fe({props:{title:"3. Deploy Mixtral 8x7B to Inferentia2",local:"3-deploy-mixtral-8x7b-to-inferentia2",headingTag:"h2"}}),X=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Q=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjBvcHRpbXVtLW5ldXJvbiUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:"!pip install optimum-neuron --upgrade --quiet",wrap:!1}}),F=new d({props:{code:"SEZfTU9ERUxfSUQlMjAlM0QlMjAlMjJtaXN0cmFsYWklMkZNaXh0cmFsLTh4N0ItSW5zdHJ1Y3QtdjAuMSUyMiUwQSUwQSFvcHRpbXVtLWNsaSUyMG5ldXJvbiUyMGNhY2hlJTIwbG9va3VwJTIwJTI0SEZfTU9ERUxfSUQ=",highlighted:`HF_MODEL_ID = <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>

!optimum-cli neuron cache lookup $HF_MODEL_ID`,wrap:!1}}),R=new d({props:{code:"KioqJTIwMiUyMGVudHJpZShzKSUyMGZvdW5kJTIwaW4lMjBjYWNoZSUyMGZvciUyMG1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIwZm9yJTIwaW5mZXJlbmNlLioqKiUwQSUwQWF1dG9fY2FzdF90eXBlJTNBJTIwYmYxNiUwQWJhdGNoX3NpemUlM0ElMjAxJTBBY2hlY2twb2ludF9pZCUzQSUyMG1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTBBY2hlY2twb2ludF9yZXZpc2lvbiUzQSUyMDQxYmQ0YzllN2U0ZmIzMThjYTQwZTcyMTEzMWQ0OTMzOTY2YzJjYzElMEFjb21waWxlcl90eXBlJTNBJTIwbmV1cm9ueC1jYyUwQWNvbXBpbGVyX3ZlcnNpb24lM0ElMjAyLjE2LjM3Mi4wJTJCNGE5YjIzMjYlMEFudW1fY29yZXMlM0ElMjAyNCUwQXNlcXVlbmNlX2xlbmd0aCUzQSUyMDQwOTYlMEF0YXNrJTNBJTIwdGV4dC1nZW5lcmF0aW9uJTBBJTBBYXV0b19jYXN0X3R5cGUlM0ElMjBiZjE2JTBBYmF0Y2hfc2l6ZSUzQSUyMDQlMEFjaGVja3BvaW50X2lkJTNBJTIwbWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMEFjaGVja3BvaW50X3JldmlzaW9uJTNBJTIwNDFiZDRjOWU3ZTRmYjMxOGNhNDBlNzIxMTMxZDQ5MzM5NjZjMmNjMSUwQWNvbXBpbGVyX3R5cGUlM0ElMjBuZXVyb254LWNjJTBBY29tcGlsZXJfdmVyc2lvbiUzQSUyMDIuMTYuMzcyLjAlMkI0YTliMjMyNiUwQW51bV9jb3JlcyUzQSUyMDI0JTBBc2VxdWVuY2VfbGVuZ3RoJTNBJTIwNDA5NiUwQXRhc2slM0ElMjB0ZXh0LWdlbmVyYXRpb24=",highlighted:`<span class="hljs-string">***</span> <span class="hljs-number">2</span> <span class="hljs-string">entrie(s)</span> <span class="hljs-string">found</span> <span class="hljs-string">in</span> <span class="hljs-string">cache</span> <span class="hljs-string">for</span> <span class="hljs-string">mistralai/Mixtral-8x7B-Instruct-v0.1</span> <span class="hljs-string">for</span> <span class="hljs-string">inference.***</span>

<span class="hljs-attr">auto_cast_type:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">batch_size:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">checkpoint_id:</span> <span class="hljs-string">mistralai/Mixtral-8x7B-Instruct-v0.1</span>
<span class="hljs-attr">checkpoint_revision:</span> <span class="hljs-string">41bd4c9e7e4fb318ca40e721131d4933966c2cc1</span>
<span class="hljs-attr">compiler_type:</span> <span class="hljs-string">neuronx-cc</span>
<span class="hljs-attr">compiler_version:</span> <span class="hljs-number">2.16</span><span class="hljs-number">.372</span><span class="hljs-number">.0</span><span class="hljs-string">+4a9b2326</span>
<span class="hljs-attr">num_cores:</span> <span class="hljs-number">24</span>
<span class="hljs-attr">sequence_length:</span> <span class="hljs-number">4096</span>
<span class="hljs-attr">task:</span> <span class="hljs-string">text-generation</span>

<span class="hljs-attr">auto_cast_type:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">batch_size:</span> <span class="hljs-number">4</span>
<span class="hljs-attr">checkpoint_id:</span> <span class="hljs-string">mistralai/Mixtral-8x7B-Instruct-v0.1</span>
<span class="hljs-attr">checkpoint_revision:</span> <span class="hljs-string">41bd4c9e7e4fb318ca40e721131d4933966c2cc1</span>
<span class="hljs-attr">compiler_type:</span> <span class="hljs-string">neuronx-cc</span>
<span class="hljs-attr">compiler_version:</span> <span class="hljs-number">2.16</span><span class="hljs-number">.372</span><span class="hljs-number">.0</span><span class="hljs-string">+4a9b2326</span>
<span class="hljs-attr">num_cores:</span> <span class="hljs-number">24</span>
<span class="hljs-attr">sequence_length:</span> <span class="hljs-number">4096</span>
<span class="hljs-attr">task:</span> <span class="hljs-string">text-generation</span>`,wrap:!1}}),se=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># sagemaker config</span>
instance_type = <span class="hljs-string">&quot;ml.inf2.48xlarge&quot;</span>
health_check_timeout = <span class="hljs-number">2400</span>  <span class="hljs-comment"># additional time to load the model</span>
volume_size = <span class="hljs-number">512</span>  <span class="hljs-comment"># size in GB of the EBS volume</span>

<span class="hljs-comment"># Define Model and Endpoint configuration parameter</span>
config = {
    <span class="hljs-string">&quot;HF_MODEL_ID&quot;</span>: <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
    <span class="hljs-string">&quot;HF_NUM_CORES&quot;</span>: <span class="hljs-string">&quot;24&quot;</span>,  <span class="hljs-comment"># number of neuron cores</span>
    <span class="hljs-string">&quot;HF_AUTO_CAST_TYPE&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>,  <span class="hljs-comment"># dtype of the model</span>
    <span class="hljs-string">&quot;MAX_BATCH_SIZE&quot;</span>: <span class="hljs-string">&quot;4&quot;</span>,  <span class="hljs-comment"># max batch size for the model</span>
    <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;4000&quot;</span>,  <span class="hljs-comment"># max length of input text</span>
    <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,  <span class="hljs-comment"># max length of generated text</span>
    <span class="hljs-string">&quot;MESSAGES_API_ENABLED&quot;</span>: <span class="hljs-string">&quot;true&quot;</span>,  <span class="hljs-comment"># Enable the messages API</span>
    <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: <span class="hljs-string">&quot;&lt;REPLACE WITH YOUR TOKEN&gt;&quot;</span>,
}

<span class="hljs-keyword">assert</span> config[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] != <span class="hljs-string">&quot;&lt;REPLACE WITH YOUR TOKEN&gt;&quot;</span>, (
    <span class="hljs-string">&quot;Please replace &#x27;&lt;REPLACE WITH YOUR TOKEN&gt;&#x27; with your Hugging Face Hub API token&quot;</span>
)


<span class="hljs-comment"># create HuggingFaceModel with the image uri</span>
llm_model = HuggingFaceModel(role=role, image_uri=llm_image, env=config)`,wrap:!1}}),ae=new d({props:{code:"JTIzJTIwRGVwbG95JTIwbW9kZWwlMjB0byUyMGFuJTIwZW5kcG9pbnQlMEElMjMlMjBodHRwcyUzQSUyRiUyRnNhZ2VtYWtlci5yZWFkdGhlZG9jcy5pbyUyRmVuJTJGc3RhYmxlJTJGYXBpJTJGaW5mZXJlbmNlJTJGbW9kZWwuaHRtbCUyM3NhZ2VtYWtlci5tb2RlbC5Nb2RlbC5kZXBsb3klMEFsbG1fbW9kZWwuX2lzX2NvbXBpbGVkX21vZGVsJTIwJTNEJTIwVHJ1ZSUwQSUwQWxsbSUyMCUzRCUyMGxsbV9tb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwaW5pdGlhbF9pbnN0YW5jZV9jb3VudCUzRDElMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEaW5zdGFuY2VfdHlwZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRhaW5lcl9zdGFydHVwX2hlYWx0aF9jaGVja190aW1lb3V0JTNEaGVhbHRoX2NoZWNrX3RpbWVvdXQlMkMlMEElMjAlMjAlMjAlMjB2b2x1bWVfc2l6ZSUzRHZvbHVtZV9zaXplJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># Deploy model to an endpoint</span>
<span class="hljs-comment"># https://sagemaker.readthedocs.io/en/stable/api/inference/model.html#sagemaker.model.Model.deploy</span>
llm_model._is_compiled_model = <span class="hljs-literal">True</span>

llm = llm_model.deploy(
    initial_instance_count=<span class="hljs-number">1</span>,
    instance_type=instance_type,
    container_startup_health_check_timeout=health_check_timeout,
    volume_size=volume_size,
)`,wrap:!1}}),ce=new d({props:{code:"JTdCJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUyMCU3RCUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">{</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is deep learning?&quot;</span> <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Me=new d({props:{code:"JTIzJTIwUHJvbXB0JTIwdG8lMjBnZW5lcmF0ZSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclMjBpbiUyMG9uZSUyMHNlbnRlbmNlJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMGFyZ3VtZW50cyUyMGh0dHBzJTNBJTJGJTJGcGxhdGZvcm0ub3BlbmFpLmNvbSUyRmRvY3MlMkZhcGktcmVmZXJlbmNlJTJGY2hhdCUyRmNyZWF0ZSUwQXBhcmFtZXRlcnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMTAwJTJDJTBBJTdE",highlighted:`<span class="hljs-comment"># Prompt to generate</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning in one sentence?&quot;</span>},
]

<span class="hljs-comment"># Generation arguments https://platform.openai.com/docs/api-reference/chat/create</span>
parameters = {
    <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">100</span>,
}`,wrap:!1}}),me=new d({props:{code:"Y2hhdCUyMCUzRCUyMGxsbS5wcmVkaWN0KCU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwbWVzc2FnZXMlMkMlMjAqKnBhcmFtZXRlcnMlMkMlMjAlMjJzdGVhbSUyMiUzQSUyMFRydWUlN0QpJTBBJTBBcHJpbnQoY2hhdCU1QiUyMmNob2ljZXMlMjIlNUQlNUIwJTVEJTVCJTIybWVzc2FnZSUyMiU1RCU1QiUyMmNvbnRlbnQlMjIlNUQuc3RyaXAoKSk=",highlighted:`chat = llm.predict({<span class="hljs-string">&quot;messages&quot;</span>: messages, **parameters, <span class="hljs-string">&quot;steam&quot;</span>: <span class="hljs-literal">True</span>})

<span class="hljs-built_in">print</span>(chat[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>].strip())`,wrap:!1}}),he=new fe({props:{title:"4. Clean up",local:"4-clean-up",headingTag:"h2"}}),ye=new d({props:{code:"bGxtLmRlbGV0ZV9tb2RlbCgpJTBBbGxtLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`llm.delete_model()
llm.delete_endpoint()`,wrap:!1}}),{c(){y=i("meta"),Ue=n(),je=i("p"),Je=n(),r(j.$$.fragment),we=n(),r(T.$$.fragment),be=n(),f=i("p"),f.innerHTML=gt,ge=n(),U=i("p"),U.innerHTML=It,Ie=n(),J=i("p"),J.textContent=Ct,Ce=n(),w=i("ol"),w.innerHTML=xt,xe=n(),b=i("p"),b.textContent=Bt,Be=n(),g=i("p"),g.innerHTML=vt,ve=n(),I=i("table"),I.innerHTML=Nt,Ne=n(),r(C.$$.fragment),We=n(),x=i("p"),x.innerHTML=Wt,Ze=n(),B=i("p"),B.textContent=Zt,Ee=n(),r(v.$$.fragment),_e=n(),N=i("p"),N.textContent=Et,Ge=n(),r(W.$$.fragment),ke=n(),r(Z.$$.fragment),$e=n(),E=i("p"),E.innerHTML=_t,Se=n(),r(_.$$.fragment),Ve=n(),r(G.$$.fragment),Xe=n(),k=i("p"),k.innerHTML=Gt,He=n(),$=i("p"),$.innerHTML=kt,Qe=n(),S=i("p"),S.innerHTML=$t,Ae=n(),V=i("p"),V.innerHTML=St,Fe=n(),r(X.$$.fragment),qe=n(),H=i("p"),H.textContent=Vt,Re=n(),r(Q.$$.fragment),Ye=n(),A=i("p"),A.textContent=Xt,ze=n(),r(F.$$.fragment),Le=n(),q=i("p"),q.textContent=Ht,Pe=n(),r(R.$$.fragment),De=n(),Y=i("p"),Y.innerHTML=Qt,Oe=n(),z=i("p"),z.textContent=At,Ke=n(),L=i("ul"),L.innerHTML=Ft,et=n(),P=i("p"),P.textContent=qt,tt=n(),D=i("ul"),D.innerHTML=Rt,lt=n(),O=i("p"),O.textContent=Yt,st=n(),K=i("ul"),K.innerHTML=zt,nt=n(),ee=i("p"),ee.innerHTML=Lt,at=n(),te=i("p"),te.innerHTML=Pt,it=n(),le=i("p"),le.textContent=Dt,ot=n(),r(se.$$.fragment),pt=n(),ne=i("p"),ne.innerHTML=Ot,rt=n(),r(ae.$$.fragment),ct=n(),ie=i("p"),ie.textContent=Kt,Mt=n(),oe=i("p"),oe.innerHTML=el,ut=n(),pe=i("p"),pe.innerHTML=tl,mt=n(),re=i("p"),re.innerHTML=ll,ht=n(),r(ce.$$.fragment),dt=n(),r(Me.$$.fragment),yt=n(),ue=i("p"),ue.textContent=sl,jt=n(),r(me.$$.fragment),Tt=n(),r(he.$$.fragment),ft=n(),de=i("p"),de.textContent=nl,Ut=n(),r(ye.$$.fragment),Jt=n(),Te=i("p"),this.h()},l(e){const t=ul("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ue=a(e),je=o(e,"P",{}),al(je).forEach(l),Je=a(e),c(j.$$.fragment,e),we=a(e),c(T.$$.fragment,e),be=a(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-17okc9y"&&(f.innerHTML=gt),ge=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-pa9wy4"&&(U.innerHTML=It),Ie=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-df2280"&&(J.textContent=Ct),Ce=a(e),w=o(e,"OL",{"data-svelte-h":!0}),p(w)!=="svelte-4bvj6d"&&(w.innerHTML=xt),xe=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-fedw35"&&(b.textContent=Bt),Be=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1q2zsrn"&&(g.innerHTML=vt),ve=a(e),I=o(e,"TABLE",{"data-svelte-h":!0}),p(I)!=="svelte-1tmwmqe"&&(I.innerHTML=Nt),Ne=a(e),c(C.$$.fragment,e),We=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-3gjk7m"&&(x.innerHTML=Wt),Ze=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-gxxxnf"&&(B.textContent=Zt),Ee=a(e),c(v.$$.fragment,e),_e=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-k2b9z7"&&(N.textContent=Et),Ge=a(e),c(W.$$.fragment,e),ke=a(e),c(Z.$$.fragment,e),$e=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-271058"&&(E.innerHTML=_t),Se=a(e),c(_.$$.fragment,e),Ve=a(e),c(G.$$.fragment,e),Xe=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-4yozv7"&&(k.innerHTML=Gt),He=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-6rv5nu"&&($.innerHTML=kt),Qe=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1quxa5j"&&(S.innerHTML=$t),Ae=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-bda3ge"&&(V.innerHTML=St),Fe=a(e),c(X.$$.fragment,e),qe=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-gvpj30"&&(H.textContent=Vt),Re=a(e),c(Q.$$.fragment,e),Ye=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-9yxrws"&&(A.textContent=Xt),ze=a(e),c(F.$$.fragment,e),Le=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1mgox28"&&(q.textContent=Ht),Pe=a(e),c(R.$$.fragment,e),De=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1ay2eoj"&&(Y.innerHTML=Qt),Oe=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1lo8mr8"&&(z.textContent=At),Ke=a(e),L=o(e,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-19xkqok"&&(L.innerHTML=Ft),et=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-7y1w5l"&&(P.textContent=qt),tt=a(e),D=o(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-21hz0o"&&(D.innerHTML=Rt),lt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-ba46xn"&&(O.textContent=Yt),st=a(e),K=o(e,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-i1wt4y"&&(K.innerHTML=zt),nt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1qiwbk5"&&(ee.innerHTML=Lt),at=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-jofx65"&&(te.innerHTML=Pt),it=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-dbarld"&&(le.textContent=Dt),ot=a(e),c(se.$$.fragment,e),pt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-eb49q4"&&(ne.innerHTML=Ot),rt=a(e),c(ae.$$.fragment,e),ct=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-qvkvmm"&&(ie.textContent=Kt),Mt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1popn9h"&&(oe.innerHTML=el),ut=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-7vzs06"&&(pe.innerHTML=tl),mt=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-gr6587"&&(re.innerHTML=ll),ht=a(e),c(ce.$$.fragment,e),dt=a(e),c(Me.$$.fragment,e),yt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1pq3qhh"&&(ue.textContent=sl),jt=a(e),c(me.$$.fragment,e),Tt=a(e),c(he.$$.fragment,e),ft=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-100mxno"&&(de.textContent=nl),Ut=a(e),c(ye.$$.fragment,e),Jt=a(e),Te=o(e,"P",{}),al(Te).forEach(l),this.h()},h(){il(y,"name","hf:doc:metadata"),il(y,"content",yl)},m(e,t){ml(document.head,y),s(e,Ue,t),s(e,je,t),s(e,Je,t),M(j,e,t),s(e,we,t),M(T,e,t),s(e,be,t),s(e,f,t),s(e,ge,t),s(e,U,t),s(e,Ie,t),s(e,J,t),s(e,Ce,t),s(e,w,t),s(e,xe,t),s(e,b,t),s(e,Be,t),s(e,g,t),s(e,ve,t),s(e,I,t),s(e,Ne,t),M(C,e,t),s(e,We,t),s(e,x,t),s(e,Ze,t),s(e,B,t),s(e,Ee,t),M(v,e,t),s(e,_e,t),s(e,N,t),s(e,Ge,t),M(W,e,t),s(e,ke,t),M(Z,e,t),s(e,$e,t),s(e,E,t),s(e,Se,t),M(_,e,t),s(e,Ve,t),M(G,e,t),s(e,Xe,t),s(e,k,t),s(e,He,t),s(e,$,t),s(e,Qe,t),s(e,S,t),s(e,Ae,t),s(e,V,t),s(e,Fe,t),M(X,e,t),s(e,qe,t),s(e,H,t),s(e,Re,t),M(Q,e,t),s(e,Ye,t),s(e,A,t),s(e,ze,t),M(F,e,t),s(e,Le,t),s(e,q,t),s(e,Pe,t),M(R,e,t),s(e,De,t),s(e,Y,t),s(e,Oe,t),s(e,z,t),s(e,Ke,t),s(e,L,t),s(e,et,t),s(e,P,t),s(e,tt,t),s(e,D,t),s(e,lt,t),s(e,O,t),s(e,st,t),s(e,K,t),s(e,nt,t),s(e,ee,t),s(e,at,t),s(e,te,t),s(e,it,t),s(e,le,t),s(e,ot,t),M(se,e,t),s(e,pt,t),s(e,ne,t),s(e,rt,t),M(ae,e,t),s(e,ct,t),s(e,ie,t),s(e,Mt,t),s(e,oe,t),s(e,ut,t),s(e,pe,t),s(e,mt,t),s(e,re,t),s(e,ht,t),M(ce,e,t),s(e,dt,t),M(Me,e,t),s(e,yt,t),s(e,ue,t),s(e,jt,t),M(me,e,t),s(e,Tt,t),M(he,e,t),s(e,ft,t),s(e,de,t),s(e,Ut,t),M(ye,e,t),s(e,Jt,t),s(e,Te,t),wt=!0},p:pl,i(e){wt||(u(j.$$.fragment,e),u(T.$$.fragment,e),u(C.$$.fragment,e),u(v.$$.fragment,e),u(W.$$.fragment,e),u(Z.$$.fragment,e),u(_.$$.fragment,e),u(G.$$.fragment,e),u(X.$$.fragment,e),u(Q.$$.fragment,e),u(F.$$.fragment,e),u(R.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(ce.$$.fragment,e),u(Me.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(ye.$$.fragment,e),wt=!0)},o(e){m(j.$$.fragment,e),m(T.$$.fragment,e),m(C.$$.fragment,e),m(v.$$.fragment,e),m(W.$$.fragment,e),m(Z.$$.fragment,e),m(_.$$.fragment,e),m(G.$$.fragment,e),m(X.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(R.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(ce.$$.fragment,e),m(Me.$$.fragment,e),m(me.$$.fragment,e),m(he.$$.fragment,e),m(ye.$$.fragment,e),wt=!1},d(e){e&&(l(Ue),l(je),l(Je),l(we),l(be),l(f),l(ge),l(U),l(Ie),l(J),l(Ce),l(w),l(xe),l(b),l(Be),l(g),l(ve),l(I),l(Ne),l(We),l(x),l(Ze),l(B),l(Ee),l(_e),l(N),l(Ge),l(ke),l($e),l(E),l(Se),l(Ve),l(Xe),l(k),l(He),l($),l(Qe),l(S),l(Ae),l(V),l(Fe),l(qe),l(H),l(Re),l(Ye),l(A),l(ze),l(Le),l(q),l(Pe),l(De),l(Y),l(Oe),l(z),l(Ke),l(L),l(et),l(P),l(tt),l(D),l(lt),l(O),l(st),l(K),l(nt),l(ee),l(at),l(te),l(it),l(le),l(ot),l(pt),l(ne),l(rt),l(ct),l(ie),l(Mt),l(oe),l(ut),l(pe),l(mt),l(re),l(ht),l(dt),l(yt),l(ue),l(jt),l(Tt),l(ft),l(de),l(Ut),l(Jt),l(Te)),l(y),h(j,e),h(T,e),h(C,e),h(v,e),h(W,e),h(Z,e),h(_,e),h(G,e),h(X,e),h(Q,e),h(F,e),h(R,e),h(se,e),h(ae,e),h(ce,e),h(Me,e),h(me,e),h(he,e),h(ye,e)}}}const yl='{"title":"Deploy Mixtral 8x7B on AWS Inferentia2","local":"deploy-mixtral-8x7b-on-aws-inferentia2","sections":[{"title":"1. Setup development environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Retrieve the latest Hugging Face TGI Neuron DLC","local":"2-retrieve-the-latest-hugging-face-tgi-neuron-dlc","sections":[],"depth":2},{"title":"3. Deploy Mixtral 8x7B to Inferentia2","local":"3-deploy-mixtral-8x7b-to-inferentia2","sections":[],"depth":2},{"title":"4. Clean up","local":"4-clean-up","sections":[],"depth":2}],"depth":1}';function jl(bt){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends cl{constructor(y){super(),Ml(this,y,jl,dl,ol,{})}}export{bl as component};
