import{s as Se,n as We,o as ve}from"../chunks/scheduler.56725da7.js";import{S as He,i as ke,e as M,s as n,c as o,h as xe,a as i,d as t,b as a,f as Xe,g as T,j as p,k as Ne,l as ze,m as s,n as y,t as U,o as r,p as J}from"../chunks/index.18a26576.js";import{C as Ye}from"../chunks/CopyLLMTxtMenu.858d3d8e.js";import{C as m}from"../chunks/CodeBlock.38ee6649.js";import{H as ol}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.5c78f0bd.js";function $e(ie){let c,Ul,Tl,rl,w,Jl,d,ml,u,pe="This tutorial shows how to fine-tune the Qwen3 model on AWS Trainium accelerators using optimum-neuron.",cl,j,oe='<strong>This is based on the <a href="https://github.com/huggingface/optimum-neuron/tree/main/examples/training/qwen3" rel="nofollow">Qwen3 fine-tuning example script</a>.</strong>',wl,h,dl,b,Te="We’ll use a <code>trn1.32xlarge</code> instance with 16 Trainium Accelerators (32 Neuron Cores) and the Hugging Face Neuron Deep Learning AMI.",ul,I,ye="The Hugging Face AMI includes all required libraries pre-installed:",jl,f,Ue="<li><code>datasets</code>, <code>transformers</code>, <code>optimum-neuron</code></li> <li>Neuron SDK packages</li> <li>No additional environment setup needed</li>",hl,Z,re='To create your instance, follow the guide <a href="https://huggingface.co/docs/optimum-neuron/ec2-setup" rel="nofollow">here</a>.',bl,B,Il,C,Je='We’ll use the <a href="https://huggingface.co/datasets/tengomucho/simple_recipes" rel="nofollow">simple recipes dataset</a> to fine-tune our model for recipe generation.',fl,E,Zl,R,me="To load the dataset we use the <code>load_dataset()</code> method from the <code>datasets</code> library.",Bl,V,Cl,_,ce="To tune our model we need to convert our structured examples into a collection of quotes with a given context, so we define our tokenization function that we will be able to map on the dataset.",El,G,we=`The dataset should be structured with input-output pairs, where each input is a prompt and the output is the expected response from the model.
We will make use of the model’s tokenizer chat template and preprocess the dataset to be fed to the trainer.`,Rl,F,Vl,g,de='Note: these functions make references of <code>eos_token</code> and <code>tokenizer</code>, they are well-defined in the <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/training/qwen3/finetune_qwen3.py" rel="nofollow">Python script</a> to run this tutorial.',_l,Q,Gl,A,ue='For standard PyTorch fine-tuning, you’d typically use <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> with LoRA adapters and the <a href="https://huggingface.co/docs/trl/en/sft_trainer" rel="nofollow"><code>SFTTrainer</code></a>.',Fl,X,je="On AWS Trainium, <code>optimum-neuron</code> provides <code>NeuronSFTTrainer</code> as a drop-in replacement.",gl,N,he=`<strong>Distributed Training on Trainium:</strong>
Since Qwen3 doesn’t fit on a single accelerator, we use distributed training techniques:`,Ql,S,be="<li>Data Parallel (DDP)</li> <li>Tensor Parallelism</li>",Al,W,Ie="Model loading and LoRA configuration work similarly to other accelerators.",Xl,v,fe="Combining all the pieces together, and assuming the dataset has already been loaded, we can write the following code to fine-tune Qwen3 on AWS Trainium:",Nl,H,Sl,k,Ze='📝 <strong>Complete script available:</strong> All steps above are combined in a ready-to-use script <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/training/qwen3/finetune_qwen3.py" rel="nofollow">finetune_qwen3.py</a>.',Wl,x,Be="To launch training, just run the following command in your AWS Trainium instance:",vl,z,Hl,Y,Ce='🔧 <strong>Single command execution:</strong> The complete bash training script <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/training/qwen3/finetune_qwen3.sh" rel="nofollow">finetune_qwen3.sh</a> is available:',kl,$,xl,L,zl,q,Ee="Optimum Neuron saves model shards separately during distributed training. These need to be consolidated before use.",Yl,P,Re="Use the Optimum CLI to consolidate:",$l,D,Ll,O,Ve="This will create an <code>adapter_model.safetensors</code> file, the LoRA adapter weights that we trained in the previous step. We can now reload the model and merge it, so it can be loaded for evaluation:",ql,K,Pl,ll,_e="Once this step is done, it is possible to test the model with a new prompt.",Dl,el,Ge="You have successfully created a fine-tuned model from Qwen3!",Ol,tl,Kl,sl,Fe="Share your fine-tuned model with the community by uploading it to the Hugging Face Hub.",le,nl,ge="<strong>Step 1: Authentication</strong>",ee,al,te,Ml,Qe="<strong>Step 2: Upload your model</strong>",se,il,ne,pl,Ae="🎉 <strong>Your fine-tuned Qwen3 model is now available on the Hub for others to use!</strong>",ae,yl,Me;return w=new Ye({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new ol({props:{title:"🚀 Fine-Tune Qwen3 8B with LoRA",local:"-fine-tune-qwen3-8b-with-lora",headingTag:"h1"}}),h=new ol({props:{title:"1. 🛠️ Setup AWS Environment",local:"1--setup-aws-environment",headingTag:"h2"}}),B=new ol({props:{title:"2. 📊 Load and Prepare the Dataset",local:"2--load-and-prepare-the-dataset",headingTag:"h2"}}),E=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJ3JlY2lwZXMnJTNBJTIwJTIyLSUyMFByZWhlYXQlMjBvdmVuJTIwdG8lMjAzNTAlMjBkZWdyZWVzJTVDbi0lMjBCdXR0ZXIlMjB0d28lMjA5eDUnJTIwbG9hZiUyMHBhbnMlNUNuLSUyMENyZWFtJTIwdGhlJTIwc3VnYXIlMjBhbmQlMjB0aGUlMjBidXR0ZXIlMjB1bnRpbCUyMGxpZ2h0JTIwYW5kJTIwd2hpcHBlZCU1Q24tJTIwQWRkJTIwdGhlJTIwYmFuYW5hcyUyQyUyMGVnZ3MlMkMlMjBsZW1vbiUyMGp1aWNlJTJDJTIwb3JhbmdlJTIwcmluZCU1Q24tJTIwQmVhdCUyMHVudGlsJTIwYmxlbmRlZCUyMHVuaWZvcm1seSU1Q24tJTIwQmUlMjBwYXRpZW50JTJDJTIwYW5kJTIwYmVhdCUyMHVudGlsJTIwdGhlJTIwYmFuYW5hJTIwbHVtcHMlMjBhcmUlMjBnb25lJTVDbi0lMjBTaWZ0JTIwdGhlJTIwZHJ5JTIwaW5ncmVkaWVudHMlMjB0b2dldGhlciU1Q24tJTIwRm9sZCUyMGxpZ2h0bHklMjBhbmQlMjB0aG9yb3VnaGx5JTIwaW50byUyMHRoZSUyMGJhbmFuYSUyMG1peHR1cmUlNUNuLSUyMFBvdXIlMjB0aGUlMjBiYXR0ZXIlMjBpbnRvJTIwcHJlcGFyZWQlMjBsb2FmJTIwcGFucyU1Q24tJTIwQmFrZSUyMGZvciUyMDQ1JTIwdG8lMjA1NSUyMG1pbnV0ZXMlMkMlMjB1bnRpbCUyMHRoZSUyMGxvYXZlcyUyMGFyZSUyMGZpcm0lMjBpbiUyMHRoZSUyMG1pZGRsZSUyMGFuZCUyMHRoZSUyMGVkZ2VzJTIwYmVnaW4lMjB0byUyMHB1bGwlMjBhd2F5JTIwZnJvbSUyMHRoZSUyMHBhbnMlNUNuLSUyMENvb2wlMjB0aGUlMjBsb2F2ZXMlMjBvbiUyMHJhY2tzJTIwZm9yJTIwMzAlMjBtaW51dGVzJTIwYmVmb3JlJTIwcmVtb3ZpbmclMjBmcm9tJTIwdGhlJTIwcGFucyU1Q24tJTIwRnJlZXplcyUyMHdlbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAnbmFtZXMnJTNBJTIwJ0JlYXQlMjB0aGlzJTIwYmFuYW5hJTIwYnJlYWQnJTBBJTdE",highlighted:`{
    <span class="hljs-string">&#x27;recipes&#x27;</span>: <span class="hljs-comment">&quot;- Preheat oven to 350 degrees\\n- Butter two 9x5&#x27; loaf pans\\n- Cream the sugar and the butter until light and whipped\\n- Add the bananas, eggs, lemon juice, orange rind\\n- Beat until blended uniformly\\n- Be patient, and beat until the banana lumps are gone\\n- Sift the dry ingredients together\\n- Fold lightly and thoroughly into the banana mixture\\n- Pour the batter into prepared loaf pans\\n- Bake for 45 to 55 minutes, until the loaves are firm in the middle and the edges begin to pull away from the pans\\n- Cool the loaves on racks for 30 minutes before removing from the pans\\n- Freezes well&quot;</span>,
    <span class="hljs-string">&#x27;names&#x27;</span>: <span class="hljs-string">&#x27;Beat this banana bread&#x27;</span>
}`,wrap:!1}}),V=new m({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXRfaWQlMjAlM0QlMjAlMjJ0ZW5nb211Y2hvJTJGc2ltcGxlX3JlY2lwZXMlMjIlMEFyZWNpcGVzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfaWQlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQWRhdGFzZXRfc2l6ZSUyMCUzRCUyMGxlbihyZWNpcGVzKSUwQXByaW50KGYlMjJkYXRhc2V0JTIwc2l6ZSUzQSUyMCU3QmRhdGFzZXRfc2l6ZSU3RCUyMiklMEFwcmludChyZWNpcGVzJTVCcmFuZHJhbmdlKGRhdGFzZXRfc2l6ZSklNUQpJTBBJTIzJTIwZGF0YXNldCUyMHNpemUlM0ElMjAyMDAwMA==",highlighted:`<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset


<span class="hljs-comment"># Load dataset from the hub</span>
dataset_id = <span class="hljs-string">&quot;tengomucho/simple_recipes&quot;</span>
recipes = load_dataset(dataset_id, split=<span class="hljs-string">&quot;train&quot;</span>)

dataset_size = <span class="hljs-built_in">len</span>(recipes)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{dataset_size}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(recipes[randrange(dataset_size)])
<span class="hljs-comment"># dataset size: 20000</span>`,wrap:!1}}),F=new m({props:{code:"JTIzJTIwUHJlcHJvY2Vzc2VzJTIwdGhlJTIwZGF0YXNldCUwQWRlZiUyMHByZXByb2Nlc3NfZGF0YXNldF93aXRoX2Vvcyhlb3NfdG9rZW4pJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2Vzc19mdW5jdGlvbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWNpcGVzJTIwJTNEJTIwZXhhbXBsZXMlNUIlMjJyZWNpcGVzJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZXMlMjAlM0QlMjBleGFtcGxlcyU1QiUyMm5hbWVzJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2hhdHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjByZWNpcGUlMkMlMjBuYW1lJTIwaW4lMjB6aXAocmVjaXBlcyUyQyUyMG5hbWVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEFwcGVuZCUyMHRoZSUyMEVPUyUyMHRva2VuJTIwdG8lMjB0aGUlMjByZXNwb25zZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlY2lwZSUyMCUyQiUzRCUyMGVvc190b2tlbiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBmJTIySG93JTIwY2FuJTIwSSUyMG1ha2UlMjAlN0JuYW1lJTdEJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjByZWNpcGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaGF0cy5hcHBlbmQoY2hhdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJtZXNzYWdlcyUyMiUzQSUyMGNoYXRzJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMHJlY2lwZXMubWFwKHByZXByb2Nlc3NfZnVuY3Rpb24lMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEcmVjaXBlcy5jb2x1bW5fbmFtZXMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGF0YXNldCUwQSUwQSUyMyUyMFN0cnVjdHVyZXMlMjB0aGUlMjBkYXRhc2V0JTIwaW50byUyMHByb21wdC1leHBlY3RlZCUyMG91dHB1dCUyMHBhaXJzLiUwQWRlZiUyMGZvcm1hdHRpbmdfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoZXhhbXBsZXMlNUIlMjJtZXNzYWdlcyUyMiU1RCUyQyUyMHRva2VuaXplJTNERmFsc2UlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RGYWxzZSk=",highlighted:`<span class="hljs-comment"># Preprocesses the dataset</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_dataset_with_eos</span>(<span class="hljs-params">eos_token</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
        recipes = examples[<span class="hljs-string">&quot;recipes&quot;</span>]
        names = examples[<span class="hljs-string">&quot;names&quot;</span>]

        chats = []
        <span class="hljs-keyword">for</span> recipe, name <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(recipes, names):
            <span class="hljs-comment"># Append the EOS token to the response</span>
            recipe += eos_token

            chat = [
                {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">f&quot;How can I make <span class="hljs-subst">{name}</span>?&quot;</span>},
                {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: recipe},
            ]

            chats.append(chat)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;messages&quot;</span>: chats}

    dataset = recipes.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>, remove_columns=recipes.column_names)
    <span class="hljs-keyword">return</span> dataset

<span class="hljs-comment"># Structures the dataset into prompt-expected output pairs.</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer.apply_chat_template(examples[<span class="hljs-string">&quot;messages&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)`,wrap:!1}}),Q=new ol({props:{title:"3. 🎯 Fine-tune Qwen3 with NeuronSFTTrainer and PEFT",local:"3--fine-tune-qwen3-with-neuronsfttrainer-and-peft",headingTag:"h2"}}),H=new m({props:{code:"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",highlighted:`model_id = <span class="hljs-string">&quot;Qwen/Qwen3-8B&quot;</span>

<span class="hljs-comment"># Define the training arguments</span>
output_dir = <span class="hljs-string">&quot;qwen3-finetuned-recipes&quot;</span>
training_args = NeuronTrainingArguments(
    output_dir=output_dir,
    num_train_epochs=<span class="hljs-number">3</span>,
    do_train=<span class="hljs-literal">True</span>,
    max_steps=-<span class="hljs-number">1</span>,  <span class="hljs-comment"># -1 means train until the end of the dataset</span>
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">5e-4</span>,
    bf16=<span class="hljs-literal">True</span>,
    tensor_parallel_size=<span class="hljs-number">8</span>,
    logging_steps=<span class="hljs-number">2</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;cosine&quot;</span>,
    overwrite_output_dir=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># Load the model with the NeuronModelForCausalLM class.</span>
<span class="hljs-comment"># It will load the model with a custom modeling speficically designed for AWS Trainium.</span>
trn_config = training_args.trn_config
dtype = torch.bfloat16 <span class="hljs-keyword">if</span> training_args.bf16 <span class="hljs-keyword">else</span> torch.float32
model = NeuronModelForCausalLM.from_pretrained(
    model_id,
    trn_config,
    dtype=dtype,
    <span class="hljs-comment"># Use FlashAttention2 for better performance and to be able to use larger sequence lengths.</span>
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)

lora_config = LoraConfig(
    r=<span class="hljs-number">64</span>,
    lora_alpha=<span class="hljs-number">128</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    target_modules=[
        <span class="hljs-string">&quot;embed_tokens&quot;</span>,
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
    ],
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># Converting the NeuronTrainingArguments to a dictionary to feed them to the NeuronSFTConfig.</span>
args = training_args.to_dict()

sft_config = NeuronSFTConfig(
    max_length=<span class="hljs-number">4096</span>,
    packing=<span class="hljs-literal">True</span>,
    **args,
)

tokenizer = AutoTokenizer.from_pretrained(model_id)
dataset = preprocess_dataset_with_eos(tokenizer.eos_token)

 <span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_function</span>(<span class="hljs-params">examples</span>):
     <span class="hljs-keyword">return</span> tokenizer.apply_chat_template(examples[<span class="hljs-string">&quot;messages&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)

 <span class="hljs-comment"># The NeuronSFTTrainer will use \`formatting_function\` to format the dataset and \`lora_config\` to apply LoRA on the</span>
 <span class="hljs-comment"># model.</span>
 trainer = NeuronSFTTrainer(
     args=sft_config,
     model=model,
     peft_config=lora_config,
     processing_class=tokenizer,
     train_dataset=dataset,
     formatting_func=formatting_function,
 )
 trainer.train()`,wrap:!1}}),z=new m({props:{code:"JTIzJTIwRmxhZ3MlMjBmb3IlMjBOZXVyb24lMjBjb21waWxhdGlvbiUwQWV4cG9ydCUyME5FVVJPTl9DQ19GTEFHUyUzRCUyMi0tbW9kZWwtdHlwZSUyMHRyYW5zZm9ybWVyJTIwLS1yZXRyeV9mYWlsZWRfY29tcGlsYXRpb24lMjIlMEFleHBvcnQlMjBORVVST05fRlVTRV9TT0ZUTUFYJTNEMSUwQWV4cG9ydCUyME5FVVJPTl9SVF9BU1lOQ19FWEVDX01BWF9JTkZMSUdIVF9SRVFVRVNUUyUzRDMlMjAlMjMlMjBBc3luYyUyMFJ1bnRpbWUlMEFleHBvcnQlMjBNQUxMT0NfQVJFTkFfTUFYJTNENjQlMjAlMjMlMjBIb3N0JTIwT09NJTIwbWl0aWdhdGlvbiUwQSUwQSUyMyUyMFZhcmlhYmxlcyUyMGZvciUyMHRyYWluaW5nJTBBUFJPQ0VTU0VTX1BFUl9OT0RFJTNEMzIlMEFOVU1fRVBPQ0hTJTNEMyUwQVRQX0RFR1JFRSUzRDglMEFCUyUzRDElMEFHUkFESUVOVF9BQ0NVTVVMQVRJT05fU1RFUFMlM0Q4JTBBTE9HR0lOR19TVEVQUyUzRDIlMEFNT0RFTF9OQU1FJTNEJTIyUXdlbiUyRlF3ZW4zLThCJTIyJTIwJTIzJTIwQ2hhbmdlJTIwdGhpcyUyMHRvJTIwdGhlJTIwZGVzaXJlZCUyMG1vZGVsJTIwbmFtZSUwQU9VVFBVVF9ESVIlM0QlMjIlMjQoZWNobyUyMCUyNE1PREVMX05BTUUlMjAlN0MlMjBjdXQlMjAtZCclMkYnJTIwLWYyKS1maW5ldHVuZWQlMjIlMEFESVNUUklCVVRFRF9BUkdTJTNEJTIyLS1ucHJvY19wZXJfbm9kZSUyMCUyNFBST0NFU1NFU19QRVJfTk9ERSUyMiUwQVNDUklQVF9ESVIlM0QlMjQoJTIwY2QlMjAtLSUyMCUyMiUyNCglMjBkaXJuYW1lJTIwLS0lMjAlMjIlMjQlN0JCQVNIX1NPVVJDRSU1QjAlNUQlN0QlMjIlMjApJTIyJTIwJTI2JTNFJTIwJTJGZGV2JTJGbnVsbCUyMCUyNiUyNiUyMHB3ZCUyMCklMEElMEFpZiUyMCU1QiUyMCUyMiUyNE5FVVJPTl9FWFRSQUNUX0dSQVBIU19PTkxZJTIyJTIwJTNEJTIwJTIyMSUyMiUyMCU1RCUzQiUyMHRoZW4lMEElMjAlMjAlMjAlMjBNQVhfU1RFUFMlM0Q1JTBBZWxzZSUwQSUyMCUyMCUyMCUyME1BWF9TVEVQUyUzRC0xJTBBZmklMEElMEF0b3JjaHJ1biUyMC0tbnByb2NfcGVyX25vZGUlMjAlMjRQUk9DRVNTRVNfUEVSX05PREUlMjBmaW5ldHVuZV9xd2VuMy5weSUyMCU1QyUwQSUyMCUyMC0tbW9kZWxfaWQlMjAlMjRNT0RFTF9OQU1FJTIwJTVDJTBBJTIwJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwJTI0TlVNX0VQT0NIUyUyMCU1QyUwQSUyMCUyMC0tZG9fdHJhaW4lMjAlNUMlMEElMjAlMjAtLW1heF9zdGVwcyUyMCUyNE1BWF9TVEVQUyUyMCU1QyUwQSUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwJTI0QlMlMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUyNEdSQURJRU5UX0FDQ1VNVUxBVElPTl9TVEVQUyUyMCU1QyUwQSUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDhlLTQlMjAlNUMlMEElMjAlMjAtLWJmMTYlMjAlNUMlMEElMjAlMjAtLXRlbnNvcl9wYXJhbGxlbF9zaXplJTIwJTI0VFBfREVHUkVFJTIwJTVDJTBBJTIwJTIwLS16ZXJvXzElMjAlNUMlMEElMjAlMjAtLWFzeW5jX3NhdmUlMjAlNUMlMEElMjAlMjAtLWxvZ2dpbmdfc3RlcHMlMjAlMjRMT0dHSU5HX1NURVBTJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTIwJTI0T1VUUFVUX0RJUiUyMCU1QyUwQSUyMCUyMC0tbHJfc2NoZWR1bGVyX3R5cGUlMjAlMjJjb3NpbmUlMjIlMjAlNUMlMEElMjAlMjAtLW92ZXJ3cml0ZV9vdXRwdXRfZGly",highlighted:`<span class="hljs-comment"># Flags for Neuron compilation</span>
<span class="hljs-built_in">export</span> NEURON_CC_FLAGS=<span class="hljs-string">&quot;--model-type transformer --retry_failed_compilation&quot;</span>
<span class="hljs-built_in">export</span> NEURON_FUSE_SOFTMAX=1
<span class="hljs-built_in">export</span> NEURON_RT_ASYNC_EXEC_MAX_INFLIGHT_REQUESTS=3 <span class="hljs-comment"># Async Runtime</span>
<span class="hljs-built_in">export</span> MALLOC_ARENA_MAX=64 <span class="hljs-comment"># Host OOM mitigation</span>

<span class="hljs-comment"># Variables for training</span>
PROCESSES_PER_NODE=32
NUM_EPOCHS=3
TP_DEGREE=8
BS=1
GRADIENT_ACCUMULATION_STEPS=8
LOGGING_STEPS=2
MODEL_NAME=<span class="hljs-string">&quot;Qwen/Qwen3-8B&quot;</span> <span class="hljs-comment"># Change this to the desired model name</span>
OUTPUT_DIR=<span class="hljs-string">&quot;<span class="hljs-subst">$(echo $MODEL_NAME | cut -d&#x27;/&#x27; -f2)</span>-finetuned&quot;</span>
DISTRIBUTED_ARGS=<span class="hljs-string">&quot;--nproc_per_node <span class="hljs-variable">$PROCESSES_PER_NODE</span>&quot;</span>
SCRIPT_DIR=$( <span class="hljs-built_in">cd</span> -- <span class="hljs-string">&quot;<span class="hljs-subst">$( dirname -- <span class="hljs-string">&quot;<span class="hljs-variable">\${BASH_SOURCE[0]}</span>&quot;</span> )</span>&quot;</span> &amp;&gt; /dev/null &amp;&amp; <span class="hljs-built_in">pwd</span> )

<span class="hljs-keyword">if</span> [ <span class="hljs-string">&quot;<span class="hljs-variable">$NEURON_EXTRACT_GRAPHS_ONLY</span>&quot;</span> = <span class="hljs-string">&quot;1&quot;</span> ]; <span class="hljs-keyword">then</span>
    MAX_STEPS=5
<span class="hljs-keyword">else</span>
    MAX_STEPS=-1
<span class="hljs-keyword">fi</span>

torchrun --nproc_per_node <span class="hljs-variable">$PROCESSES_PER_NODE</span> finetune_qwen3.py \\
  --model_id <span class="hljs-variable">$MODEL_NAME</span> \\
  --num_train_epochs <span class="hljs-variable">$NUM_EPOCHS</span> \\
  --do_train \\
  --max_steps <span class="hljs-variable">$MAX_STEPS</span> \\
  --per_device_train_batch_size <span class="hljs-variable">$BS</span> \\
  --gradient_accumulation_steps <span class="hljs-variable">$GRADIENT_ACCUMULATION_STEPS</span> \\
  --learning_rate 8e-4 \\
  --bf16 \\
  --tensor_parallel_size <span class="hljs-variable">$TP_DEGREE</span> \\
  --zero_1 \\
  --async_save \\
  --logging_steps <span class="hljs-variable">$LOGGING_STEPS</span> \\
  --output_dir <span class="hljs-variable">$OUTPUT_DIR</span> \\
  --lr_scheduler_type <span class="hljs-string">&quot;cosine&quot;</span> \\
  --overwrite_output_dir`,wrap:!1}}),$=new m({props:{code:"LiUyRmZpbmV0dW5lX3F3ZW4zLnNo",highlighted:"./finetune_qwen3.sh",wrap:!1}}),L=new ol({props:{title:"4. 🔄 Consolidate and Test the Fine-Tuned Model",local:"4--consolidate-and-test-the-fine-tuned-model",headingTag:"h2"}}),D=new m({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMFF3ZW4zLThCLWZpbmV0dW5lZCUyMFF3ZW4zLThCLWZpbmV0dW5lZCUyRmFkYXB0ZXJfZGVmYXVsdA==",highlighted:"optimum-cli neuron consolidate Qwen3-8B-finetuned Qwen3-8B-finetuned/adapter_default",wrap:!1}}),K=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTJDJTIwUGVmdENvbmZpZyUwQSUwQSUwQU1PREVMX05BTUUlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjMtOEIlMjIlMEFBREFQVEVSX1BBVEglMjAlM0QlMjAlMjJRd2VuMy04Qi1maW5ldHVuZWQlMkZhZGFwdGVyX2RlZmF1bHQlMjIlMEFNRVJHRURfTU9ERUxfUEFUSCUyMCUzRCUyMCUyMlF3ZW4zLThCLXJlY2lwZXMlMjIlMEElMEElMjMlMjBMb2FkJTIwYmFzZSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoTU9ERUxfTkFNRSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChNT0RFTF9OQU1FKSUwQSUwQSUyMyUyMExvYWQlMjBhZGFwdGVyJTIwY29uZmlndXJhdGlvbiUyMGFuZCUyMG1vZGVsJTBBYWRhcHRlcl9jb25maWclMjAlM0QlMjBQZWZ0Q29uZmlnLmZyb21fcHJldHJhaW5lZChBREFQVEVSX1BBVEgpJTBBZmluZXR1bmVkX21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMEFEQVBURVJfUEFUSCUyQyUyMGNvbmZpZyUzRGFkYXB0ZXJfY29uZmlnKSUwQSUwQXByaW50KCUyMlNhdmluZyUyMHRva2VuaXplciUyMiklMEF0b2tlbml6ZXIuc2F2ZV9wcmV0cmFpbmVkKE1FUkdFRF9NT0RFTF9QQVRIKSUwQXByaW50KCUyMlNhdmluZyUyMG1vZGVsJTIyKSUwQWZpbmV0dW5lZF9tb2RlbCUyMCUzRCUyMGZpbmV0dW5lZF9tb2RlbC5tZXJnZV9hbmRfdW5sb2FkKCklMEFmaW5ldHVuZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKE1FUkdFRF9NT0RFTF9QQVRIKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig


MODEL_NAME = <span class="hljs-string">&quot;Qwen/Qwen3-8B&quot;</span>
ADAPTER_PATH = <span class="hljs-string">&quot;Qwen3-8B-finetuned/adapter_default&quot;</span>
MERGED_MODEL_PATH = <span class="hljs-string">&quot;Qwen3-8B-recipes&quot;</span>

<span class="hljs-comment"># Load base model</span>
model = AutoModelForCausalLM.from_pretrained(MODEL_NAME)
tokenizer = AutoTokenizer.from_pretrained(MODEL_NAME)

<span class="hljs-comment"># Load adapter configuration and model</span>
adapter_config = PeftConfig.from_pretrained(ADAPTER_PATH)
finetuned_model = PeftModel.from_pretrained(model, ADAPTER_PATH, config=adapter_config)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving tokenizer&quot;</span>)
tokenizer.save_pretrained(MERGED_MODEL_PATH)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Saving model&quot;</span>)
finetuned_model = finetuned_model.merge_and_unload()
finetuned_model.save_pretrained(MERGED_MODEL_PATH)`,wrap:!1}}),tl=new ol({props:{title:"5. 🤗 Push to Hugging Face Hub",local:"5--push-to-hugging-face-hub",headingTag:"h2"}}),al=new m({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),il=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQU1FUkdFRF9NT0RFTF9QQVRIJTIwJTNEJTIwJTIyUXdlbjMtOEItcmVjaXBlcyUyMiUwQUhVQl9NT0RFTF9OQU1FJTIwJTNEJTIwJTIyeW91ci11c2VybmFtZSUyRnF3ZW4zLThiLXJlY2lwZXMlMjIlMEElMEElMjMlMjBMb2FkJTIwYW5kJTIwcHVzaCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKE1FUkdFRF9NT0RFTF9QQVRIKSUwQXRva2VuaXplci5wdXNoX3RvX2h1YihIVUJfTU9ERUxfTkFNRSklMEElMEElMjMlMjBMb2FkJTIwYW5kJTIwcHVzaCUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoTUVSR0VEX01PREVMX1BBVEgpJTBBbW9kZWwucHVzaF90b19odWIoSFVCX01PREVMX05BTUUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

MERGED_MODEL_PATH = <span class="hljs-string">&quot;Qwen3-8B-recipes&quot;</span>
HUB_MODEL_NAME = <span class="hljs-string">&quot;your-username/qwen3-8b-recipes&quot;</span>

<span class="hljs-comment"># Load and push tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(MERGED_MODEL_PATH)
tokenizer.push_to_hub(HUB_MODEL_NAME)

<span class="hljs-comment"># Load and push model</span>
model = AutoModelForCausalLM.from_pretrained(MERGED_MODEL_PATH)
model.push_to_hub(HUB_MODEL_NAME)`,wrap:!1}}),{c(){c=M("meta"),Ul=n(),Tl=M("p"),rl=n(),o(w.$$.fragment),Jl=n(),o(d.$$.fragment),ml=n(),u=M("p"),u.textContent=pe,cl=n(),j=M("p"),j.innerHTML=oe,wl=n(),o(h.$$.fragment),dl=n(),b=M("p"),b.innerHTML=Te,ul=n(),I=M("p"),I.textContent=ye,jl=n(),f=M("ul"),f.innerHTML=Ue,hl=n(),Z=M("p"),Z.innerHTML=re,bl=n(),o(B.$$.fragment),Il=n(),C=M("p"),C.innerHTML=Je,fl=n(),o(E.$$.fragment),Zl=n(),R=M("p"),R.innerHTML=me,Bl=n(),o(V.$$.fragment),Cl=n(),_=M("p"),_.textContent=ce,El=n(),G=M("p"),G.textContent=we,Rl=n(),o(F.$$.fragment),Vl=n(),g=M("p"),g.innerHTML=de,_l=n(),o(Q.$$.fragment),Gl=n(),A=M("p"),A.innerHTML=ue,Fl=n(),X=M("p"),X.innerHTML=je,gl=n(),N=M("p"),N.innerHTML=he,Ql=n(),S=M("ul"),S.innerHTML=be,Al=n(),W=M("p"),W.textContent=Ie,Xl=n(),v=M("p"),v.textContent=fe,Nl=n(),o(H.$$.fragment),Sl=n(),k=M("p"),k.innerHTML=Ze,Wl=n(),x=M("p"),x.textContent=Be,vl=n(),o(z.$$.fragment),Hl=n(),Y=M("p"),Y.innerHTML=Ce,kl=n(),o($.$$.fragment),xl=n(),o(L.$$.fragment),zl=n(),q=M("p"),q.textContent=Ee,Yl=n(),P=M("p"),P.textContent=Re,$l=n(),o(D.$$.fragment),Ll=n(),O=M("p"),O.innerHTML=Ve,ql=n(),o(K.$$.fragment),Pl=n(),ll=M("p"),ll.textContent=_e,Dl=n(),el=M("p"),el.textContent=Ge,Ol=n(),o(tl.$$.fragment),Kl=n(),sl=M("p"),sl.textContent=Fe,le=n(),nl=M("p"),nl.innerHTML=ge,ee=n(),o(al.$$.fragment),te=n(),Ml=M("p"),Ml.innerHTML=Qe,se=n(),o(il.$$.fragment),ne=n(),pl=M("p"),pl.innerHTML=Ae,ae=n(),yl=M("p"),this.h()},l(l){const e=xe("svelte-u9bgzb",document.head);c=i(e,"META",{name:!0,content:!0}),e.forEach(t),Ul=a(l),Tl=i(l,"P",{}),Xe(Tl).forEach(t),rl=a(l),T(w.$$.fragment,l),Jl=a(l),T(d.$$.fragment,l),ml=a(l),u=i(l,"P",{"data-svelte-h":!0}),p(u)!=="svelte-61i5q2"&&(u.textContent=pe),cl=a(l),j=i(l,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1vtxnz9"&&(j.innerHTML=oe),wl=a(l),T(h.$$.fragment,l),dl=a(l),b=i(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-43r1bv"&&(b.innerHTML=Te),ul=a(l),I=i(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1ktungo"&&(I.textContent=ye),jl=a(l),f=i(l,"UL",{"data-svelte-h":!0}),p(f)!=="svelte-1efvabb"&&(f.innerHTML=Ue),hl=a(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1gchww4"&&(Z.innerHTML=re),bl=a(l),T(B.$$.fragment,l),Il=a(l),C=i(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1uki1hp"&&(C.innerHTML=Je),fl=a(l),T(E.$$.fragment,l),Zl=a(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-25b86y"&&(R.innerHTML=me),Bl=a(l),T(V.$$.fragment,l),Cl=a(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1e4z25x"&&(_.textContent=ce),El=a(l),G=i(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-13ur3kw"&&(G.textContent=we),Rl=a(l),T(F.$$.fragment,l),Vl=a(l),g=i(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-rgxks7"&&(g.innerHTML=de),_l=a(l),T(Q.$$.fragment,l),Gl=a(l),A=i(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1iw1mwz"&&(A.innerHTML=ue),Fl=a(l),X=i(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-dh3p5f"&&(X.innerHTML=je),gl=a(l),N=i(l,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1l7hprp"&&(N.innerHTML=he),Ql=a(l),S=i(l,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-1iqb34b"&&(S.innerHTML=be),Al=a(l),W=i(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1xxdciy"&&(W.textContent=Ie),Xl=a(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1v29c1g"&&(v.textContent=fe),Nl=a(l),T(H.$$.fragment,l),Sl=a(l),k=i(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1loxsby"&&(k.innerHTML=Ze),Wl=a(l),x=i(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-pvqso5"&&(x.textContent=Be),vl=a(l),T(z.$$.fragment,l),Hl=a(l),Y=i(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-2cag06"&&(Y.innerHTML=Ce),kl=a(l),T($.$$.fragment,l),xl=a(l),T(L.$$.fragment,l),zl=a(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-46jexq"&&(q.textContent=Ee),Yl=a(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-9a9g75"&&(P.textContent=Re),$l=a(l),T(D.$$.fragment,l),Ll=a(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1cigzjn"&&(O.innerHTML=Ve),ql=a(l),T(K.$$.fragment,l),Pl=a(l),ll=i(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-vght15"&&(ll.textContent=_e),Dl=a(l),el=i(l,"P",{"data-svelte-h":!0}),p(el)!=="svelte-1sz4goc"&&(el.textContent=Ge),Ol=a(l),T(tl.$$.fragment,l),Kl=a(l),sl=i(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-a60mly"&&(sl.textContent=Fe),le=a(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-z9yml0"&&(nl.innerHTML=ge),ee=a(l),T(al.$$.fragment,l),te=a(l),Ml=i(l,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-h2brza"&&(Ml.innerHTML=Qe),se=a(l),T(il.$$.fragment,l),ne=a(l),pl=i(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-fnz57k"&&(pl.innerHTML=Ae),ae=a(l),yl=i(l,"P",{}),Xe(yl).forEach(t),this.h()},h(){Ne(c,"name","hf:doc:metadata"),Ne(c,"content",Le)},m(l,e){ze(document.head,c),s(l,Ul,e),s(l,Tl,e),s(l,rl,e),y(w,l,e),s(l,Jl,e),y(d,l,e),s(l,ml,e),s(l,u,e),s(l,cl,e),s(l,j,e),s(l,wl,e),y(h,l,e),s(l,dl,e),s(l,b,e),s(l,ul,e),s(l,I,e),s(l,jl,e),s(l,f,e),s(l,hl,e),s(l,Z,e),s(l,bl,e),y(B,l,e),s(l,Il,e),s(l,C,e),s(l,fl,e),y(E,l,e),s(l,Zl,e),s(l,R,e),s(l,Bl,e),y(V,l,e),s(l,Cl,e),s(l,_,e),s(l,El,e),s(l,G,e),s(l,Rl,e),y(F,l,e),s(l,Vl,e),s(l,g,e),s(l,_l,e),y(Q,l,e),s(l,Gl,e),s(l,A,e),s(l,Fl,e),s(l,X,e),s(l,gl,e),s(l,N,e),s(l,Ql,e),s(l,S,e),s(l,Al,e),s(l,W,e),s(l,Xl,e),s(l,v,e),s(l,Nl,e),y(H,l,e),s(l,Sl,e),s(l,k,e),s(l,Wl,e),s(l,x,e),s(l,vl,e),y(z,l,e),s(l,Hl,e),s(l,Y,e),s(l,kl,e),y($,l,e),s(l,xl,e),y(L,l,e),s(l,zl,e),s(l,q,e),s(l,Yl,e),s(l,P,e),s(l,$l,e),y(D,l,e),s(l,Ll,e),s(l,O,e),s(l,ql,e),y(K,l,e),s(l,Pl,e),s(l,ll,e),s(l,Dl,e),s(l,el,e),s(l,Ol,e),y(tl,l,e),s(l,Kl,e),s(l,sl,e),s(l,le,e),s(l,nl,e),s(l,ee,e),y(al,l,e),s(l,te,e),s(l,Ml,e),s(l,se,e),y(il,l,e),s(l,ne,e),s(l,pl,e),s(l,ae,e),s(l,yl,e),Me=!0},p:We,i(l){Me||(U(w.$$.fragment,l),U(d.$$.fragment,l),U(h.$$.fragment,l),U(B.$$.fragment,l),U(E.$$.fragment,l),U(V.$$.fragment,l),U(F.$$.fragment,l),U(Q.$$.fragment,l),U(H.$$.fragment,l),U(z.$$.fragment,l),U($.$$.fragment,l),U(L.$$.fragment,l),U(D.$$.fragment,l),U(K.$$.fragment,l),U(tl.$$.fragment,l),U(al.$$.fragment,l),U(il.$$.fragment,l),Me=!0)},o(l){r(w.$$.fragment,l),r(d.$$.fragment,l),r(h.$$.fragment,l),r(B.$$.fragment,l),r(E.$$.fragment,l),r(V.$$.fragment,l),r(F.$$.fragment,l),r(Q.$$.fragment,l),r(H.$$.fragment,l),r(z.$$.fragment,l),r($.$$.fragment,l),r(L.$$.fragment,l),r(D.$$.fragment,l),r(K.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(il.$$.fragment,l),Me=!1},d(l){l&&(t(Ul),t(Tl),t(rl),t(Jl),t(ml),t(u),t(cl),t(j),t(wl),t(dl),t(b),t(ul),t(I),t(jl),t(f),t(hl),t(Z),t(bl),t(Il),t(C),t(fl),t(Zl),t(R),t(Bl),t(Cl),t(_),t(El),t(G),t(Rl),t(Vl),t(g),t(_l),t(Gl),t(A),t(Fl),t(X),t(gl),t(N),t(Ql),t(S),t(Al),t(W),t(Xl),t(v),t(Nl),t(Sl),t(k),t(Wl),t(x),t(vl),t(Hl),t(Y),t(kl),t(xl),t(zl),t(q),t(Yl),t(P),t($l),t(Ll),t(O),t(ql),t(Pl),t(ll),t(Dl),t(el),t(Ol),t(Kl),t(sl),t(le),t(nl),t(ee),t(te),t(Ml),t(se),t(ne),t(pl),t(ae),t(yl)),t(c),J(w,l),J(d,l),J(h,l),J(B,l),J(E,l),J(V,l),J(F,l),J(Q,l),J(H,l),J(z,l),J($,l),J(L,l),J(D,l),J(K,l),J(tl,l),J(al,l),J(il,l)}}}const Le='{"title":"🚀 Fine-Tune Qwen3 8B with LoRA","local":"-fine-tune-qwen3-8b-with-lora","sections":[{"title":"1. 🛠️ Setup AWS Environment","local":"1--setup-aws-environment","sections":[],"depth":2},{"title":"2. 📊 Load and Prepare the Dataset","local":"2--load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. 🎯 Fine-tune Qwen3 with NeuronSFTTrainer and PEFT","local":"3--fine-tune-qwen3-with-neuronsfttrainer-and-peft","sections":[],"depth":2},{"title":"4. 🔄 Consolidate and Test the Fine-Tuned Model","local":"4--consolidate-and-test-the-fine-tuned-model","sections":[],"depth":2},{"title":"5. 🤗 Push to Hugging Face Hub","local":"5--push-to-hugging-face-hub","sections":[],"depth":2}],"depth":1}';function qe(ie){return ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends He{constructor(c){super(),ke(this,c,qe,$e,Se,{})}}export{et as component};
