import{s as Ks,b as Os,n as el,o as tl}from"../chunks/scheduler.aec39e6a.js";import{S as sl,i as ll,e as i,s as a,c as p,h as al,a as r,d as s,b as n,f as is,g as M,j as o,k as u,l as nl,m as l,n as J,t as c,o as y,p as m}from"../chunks/index.4ee0a2d0.js";import{C as il,H as w,E as rl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b53bb2f5.js";import{C as d}from"../chunks/CodeBlock.4c36c0e1.js";function ol(rs){let h,Se,He,Ae,U,Re,g,Ee,T,os,Xe,I,ps="This guide will show you how to train a 🤗 Transformers model with the <code>HuggingFace</code> SageMaker Python SDK. Learn how to:",Ve,f,Ms='<li><a href="#installation-and-setup">Install and setup your training environment</a>.</li> <li><a href="#prepare-a-transformers-fine-tuning-script">Prepare a training script</a>.</li> <li><a href="#create-a-hugging-face-estimator">Create a Hugging Face Estimator</a>.</li> <li><a href="#execute-training">Run training with the <code>fit</code> method</a>.</li> <li><a href="#access-trained-model">Access your trained model</a>.</li> <li><a href="#distributed-training">Perform distributed training</a>.</li> <li><a href="#spot-instances">Create a spot instance</a>.</li> <li><a href="#git-repository">Load a training script from a GitHub repository</a>.</li> <li><a href="#sagemaker-metrics">Collect training metrics</a>.</li>',Ye,j,Qe,C,Js='Before you can train a 🤗 Transformers model with SageMaker, you need to sign up for an AWS account. If you don’t have an AWS account yet, learn more <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-set-up.html" rel="nofollow">here</a>.',Fe,b,cs="Once you have an AWS account, get started using one of the following:",Le,_,ys='<li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-studio-onboard.html" rel="nofollow">SageMaker Studio</a></li> <li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-console.html" rel="nofollow">SageMaker notebook instance</a></li> <li>Local environment</li>',qe,x,ms='To start training locally, you need to setup an appropriate <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM role</a>.',De,Z,Ts="Upgrade to the latest <code>sagemaker</code> version:",Pe,B,Ke,k,ws='<p>[!WARNING][SageMaker Python SDK v3 has been recently released](<a href="https://github.com/aws/sagemaker-python-sdk" rel="nofollow">https://github.com/aws/sagemaker-python-sdk</a>), so unless specified otherwise, all the documentation and tutorials are still using the <a href="https://github.com/aws/sagemaker-python-sdk/tree/master-v2" rel="nofollow">SageMaker Python SDK v2</a>. We are actively working on updating all the tutorials and examples, but in the meantime make sure to install the SageMaker SDK as <code>pip install &quot;sagemaker&lt;3.0.0&quot;</code>.</p>',Oe,v,ds="<strong>SageMaker environment</strong>",et,W,hs="Setup your SageMaker environment as shown below:",tt,G,st,z,us="<em>Note: The execution role is only available when running a notebook within SageMaker. If you run <code>get_execution_role</code> in a notebook not on SageMaker, expect a <code>region</code> error.</em>",lt,$,Us="<strong>Local environment</strong>",at,H,gs="Setup your local environment as shown below:",nt,N,it,S,rt,A,Is='Our training script is very similar to a training script you might run outside of SageMaker. However, you can access useful properties about the training environment through various environment variables (see <a href="https://github.com/aws/sagemaker-training-toolkit/blob/master/ENVIRONMENT_VARIABLES.md" rel="nofollow">here</a> for a complete list), such as:',ot,R,fs="<li><p><code>SM_MODEL_DIR</code>: A string representing the path to which the training job writes the model artifacts. After training, artifacts in this directory are uploaded to S3 for model hosting. <code>SM_MODEL_DIR</code> is always set to <code>/opt/ml/model</code>.</p></li> <li><p><code>SM_NUM_GPUS</code>: An integer representing the number of GPUs available to the host.</p></li> <li><p><code>SM_CHANNEL_XXXX:</code> A string representing the path to the directory that contains the input data for the specified channel. For example, when you specify <code>train</code> and <code>test</code> in the Hugging Face Estimator <code>fit</code> method, the environment variables are set to <code>SM_CHANNEL_TRAIN</code> and <code>SM_CHANNEL_TEST</code>.</p></li>",pt,E,js='The <code>hyperparameters</code> defined in the <a href="#create-an-huggingface-estimator">Hugging Face Estimator</a> are passed as named arguments and processed by <code>ArgumentParser()</code>.',Mt,X,Jt,V,Cs="<em>Note that SageMaker doesn’t support argparse actions. For example, if you want to use a boolean hyperparameter, specify <code>type</code> as <code>bool</code> in your script and provide an explicit <code>True</code> or <code>False</code> value.</em>",ct,Y,bs='Look <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">train.py file</a> for a complete example of a 🤗 Transformers training script.',yt,Q,mt,F,_s=`If <code>output_dir</code> in the <code>TrainingArguments</code> is set to ‘/opt/ml/model’ the Trainer saves all training artifacts, including logs, checkpoints, and models. Amazon SageMaker archives the whole ‘/opt/ml/model’ directory as <code>model.tar.gz</code> and uploads it at the end of the training job to Amazon S3. Depending on your Hyperparameters and <code>TrainingArguments</code> this could lead to a large artifact (&gt; 5GB), which can slow down deployment for Amazon SageMaker Inference.
You can control how checkpoints, logs, and artifacts are saved by customization the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>. For example by providing <code>save_total_limit</code> as <code>TrainingArgument</code> you can control the limit of the total amount of checkpoints. Deletes the older checkpoints in <code>output_dir</code> if new ones are saved and the maximum limit is reached.`,Tt,L,xs=`In addition to the options already mentioned above, there is another option to save the training artifacts during the training session. Amazon SageMaker supports <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-checkpoints.html" rel="nofollow">Checkpointing</a>, which allows you to continuously save your artifacts during training to Amazon S3 rather than at the end of your training. To enable <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-checkpoints.html" rel="nofollow">Checkpointing</a> you need to provide the <code>checkpoint_s3_uri</code> parameter pointing to an Amazon S3 location in the <code>HuggingFace</code> estimator and set <code>output_dir</code> to <code>/opt/ml/checkpoints</code>.
<em>Note: If you set <code>output_dir</code> to <code>/opt/ml/checkpoints</code> make sure to call <code>trainer.save_model(&quot;/opt/ml/model&quot;)</code> or model.save_pretrained(“/opt/ml/model”)/<code>tokenizer.save_pretrained(&quot;/opt/ml/model&quot;)</code> at the end of your training to be able to deploy your model seamlessly to Amazon SageMaker for Inference.</em>`,wt,q,dt,D,Zs='Run 🤗 Transformers training scripts on SageMaker by creating a <a href="https://sagemaker.readthedocs.io/en/stable/frameworks/huggingface/sagemaker.huggingface.html#huggingface-estimator" rel="nofollow">Hugging Face Estimator</a>. The Estimator handles end-to-end SageMaker training. There are several parameters you should define in the Estimator:',ht,P,Bs='<li><code>entry_point</code> specifies which fine-tuning script to use.</li> <li><code>instance_type</code> specifies an Amazon instance to launch. Refer <a href="https://aws.amazon.com/sagemaker/pricing/" rel="nofollow">here</a> for a complete list of instance types.</li> <li><code>hyperparameters</code> specifies training hyperparameters. View additional available hyperparameters in <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">train.py file</a>.</li>',ut,K,ks="The following code sample shows how to train with a custom script <code>train.py</code> with three hyperparameters (<code>epochs</code>, <code>per_device_train_batch_size</code>, and <code>model_name_or_path</code>):",Ut,O,gt,ee,vs="If you are running a <code>TrainingJob</code> locally, define <code>instance_type=&#39;local&#39;</code> or <code>instance_type=&#39;local_gpu&#39;</code> for GPU usage. Note that this will not work with SageMaker Studio.",It,te,ft,se,Ws="Start your <code>TrainingJob</code> by calling <code>fit</code> on a Hugging Face Estimator. Specify your input training data in <code>fit</code>. The input training data can be a:",jt,le,Gs='<li>S3 URI such as <code>s3://my-bucket/my-training-data</code>.</li> <li><code>FileSystemInput</code> for Amazon Elastic File System or FSx for Lustre. See <a href="https://sagemaker.readthedocs.io/en/stable/overview.html?highlight=FileSystemInput#use-file-systems-as-training-inputs" rel="nofollow">here</a> for more details about using these file systems as input.</li>',Ct,ae,zs="Call <code>fit</code> to begin training:",bt,ne,_t,ie,$s="SageMaker starts and manages all the required EC2 instances and initiates the <code>TrainingJob</code> by running:",xt,re,Zt,oe,Bt,pe,Hs='Once training is complete, you can access your model through the <a href="https://console.aws.amazon.com/console/home?nc2=h_ct&amp;src=header-signin" rel="nofollow">AWS console</a> or download it directly from S3.',kt,Me,vt,Je,Wt,ce,Ns="SageMaker provides two strategies for distributed training: data parallelism and model parallelism. Data parallelism splits a training set across several GPUs, while model parallelism splits a model across several GPUs.",Gt,ye,zt,me,Ss='The Hugging Face <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Trainer</a> supports SageMaker’s data parallelism library. If your training script uses the Trainer API, you only need to define the distribution parameter in the Hugging Face Estimator:',$t,Te,Ht,we,As='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/07_tensorflow_distributed_training_data_parallelism/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb notebook</a> for an example of how to run the data parallelism library with TensorFlow.',Nt,de,St,he,Rs='The Hugging Face [Trainer] also supports SageMaker’s model parallelism library. If your training script uses the Trainer API, you only need to define the distribution parameter in the Hugging Face Estimator (see <a href="https://sagemaker.readthedocs.io/en/stable/api/training/smd_model_parallel_general.html?highlight=modelparallel#required-sagemaker-python-sdk-parameters" rel="nofollow">here</a> for more detailed information about using model parallelism):',At,ue,Rt,Ue,Es='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/04_distributed_training_model_parallelism/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb notebook</a> for an example of how to run the model parallelism library.',Et,ge,Xt,Ie,Xs='The Hugging Face extension for the SageMaker Python SDK means we can benefit from <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html" rel="nofollow">fully-managed EC2 spot instances</a>. This can help you save up to 90% of training costs!',Vt,fe,Vs='<em>Note: Unless your training job completes quickly, we recommend you use <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-checkpoints.html" rel="nofollow">checkpointing</a> with managed spot training. In this case, you need to define the <code>checkpoint_s3_uri</code>.</em>',Yt,je,Ys="Set <code>use_spot_instances=True</code> and define your <code>max_wait</code> and <code>max_run</code> time in the Estimator to use spot instances:",Qt,Ce,Ft,be,Qs='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/05_spot_instances/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb notebook</a> for an example of how to use spot instances.',Lt,_e,qt,xe,Fs='The Hugging Face Estimator can load a training script <a href="https://sagemaker.readthedocs.io/en/stable/overview.html#use-scripts-stored-in-a-git-repository" rel="nofollow">stored in a GitHub repository</a>. Provide the relative path to the training script in <code>entry_point</code> and the relative path to the directory in <code>source_dir</code>.',Dt,Ze,Ls='If you are using <code>git_config</code> to run the <a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">🤗 Transformers example scripts</a>, you need to configure the correct <code>&#39;branch&#39;</code> in <code>transformers_version</code> (e.g. if you use <code>transformers_version=&#39;4.4.2</code> you have to use <code>&#39;branch&#39;:&#39;v4.4.2&#39;</code>).',Pt,Be,qs="<em>Tip: Save your model to S3 by setting <code>output_dir=/opt/ml/model</code> in the hyperparameter of your training script.</em>",Kt,ke,Ot,ve,es,We,Ds='<a href="https://docs.aws.amazon.com/sagemaker/latest/dg/training-metrics.html#define-train-metrics" rel="nofollow">SageMaker metrics</a> automatically parses training job logs for metrics and sends them to CloudWatch. If you want SageMaker to parse the logs, you must specify the metric’s name and a regular expression for SageMaker to use to find the metric.',ts,Ge,ss,ze,Ps='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/06_sagemaker_metrics/sagemaker-notebook.ipynb" rel="nofollow">notebook</a> for an example of how to capture metrics in SageMaker.',ls,$e,as,Ne,ns;return U=new il({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new w({props:{title:"Run training on Amazon SageMaker",local:"run-training-on-amazon-sagemaker",headingTag:"h1"}}),j=new w({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),B=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzYWdlbWFrZXIlM0MzLjAuMCc=",highlighted:'pip install <span class="hljs-string">&#x27;sagemaker&lt;3.0.0&#x27;</span>',wrap:!1}}),G=new d({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFyb2xlJTIwJTNEJTIwc2FnZW1ha2VyLmdldF9leGVjdXRpb25fcm9sZSgp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
sess = sagemaker.Session()
role = sagemaker.get_execution_role()`,wrap:!1}}),N=new d({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFpYW1fY2xpZW50JTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQXJvbGUlMjAlM0QlMjBpYW1fY2xpZW50LmdldF9yb2xlKFJvbGVOYW1lJTNEJ3JvbGUtbmFtZS1vZi15b3VyLWlhbS1yb2xlLXdpdGgtcmlnaHQtcGVybWlzc2lvbnMnKSU1QidSb2xlJyU1RCU1QidBcm4nJTVEJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

iam_client = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
role = iam_client.get_role(RoleName=<span class="hljs-string">&#x27;role-name-of-your-iam-role-with-right-permissions&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]
sess = sagemaker.Session()`,wrap:!1}}),S=new w({props:{title:"Prepare a 🤗 Transformers fine-tuning script",local:"prepare-a--transformers-fine-tuning-script",headingTag:"h2"}}),X=new d({props:{code:"aW1wb3J0JTIwdHJhbnNmb3JtZXJzJTBBaW1wb3J0JTIwZGF0YXNldHMlMEFpbXBvcnQlMjBhcmdwYXJzZSUwQWltcG9ydCUyMG9zJTBBJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTBBJTIwJTIwJTIwJTIwcGFyc2VyJTIwJTNEJTIwYXJncGFyc2UuQXJndW1lbnRQYXJzZXIoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGh5cGVycGFyYW1ldGVycyUyMHNlbnQlMjBieSUyMHRoZSUyMGNsaWVudCUyMGFyZSUyMHBhc3NlZCUyMGFzJTIwY29tbWFuZC1saW5lJTIwYXJndW1lbnRzJTIwdG8lMjB0aGUlMjBzY3JpcHQlMEElMjAlMjAlMjAlMjBwYXJzZXIuYWRkX2FyZ3VtZW50KCUyMi0tZXBvY2hzJTIyJTJDJTIwdHlwZSUzRGludCUyQyUyMGRlZmF1bHQlM0QzKSUwQSUyMCUyMCUyMCUyMHBhcnNlci5hZGRfYXJndW1lbnQoJTIyLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjIlMkMlMjB0eXBlJTNEaW50JTJDJTIwZGVmYXVsdCUzRDMyKSUwQSUyMCUyMCUyMCUyMHBhcnNlci5hZGRfYXJndW1lbnQoJTIyLS1tb2RlbF9uYW1lX29yX3BhdGglMjIlMkMlMjB0eXBlJTNEc3RyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRhdGElMkMlMjBtb2RlbCUyQyUyMGFuZCUyMG91dHB1dCUyMGRpcmVjdG9yaWVzJTBBJTIwJTIwJTIwJTIwcGFyc2VyLmFkZF9hcmd1bWVudCglMjItLW1vZGVsLWRpciUyMiUyQyUyMHR5cGUlM0RzdHIlMkMlMjBkZWZhdWx0JTNEb3MuZW52aXJvbiU1QiUyMlNNX01PREVMX0RJUiUyMiU1RCklMEElMjAlMjAlMjAlMjBwYXJzZXIuYWRkX2FyZ3VtZW50KCUyMi0tdHJhaW5pbmdfZGlyJTIyJTJDJTIwdHlwZSUzRHN0ciUyQyUyMGRlZmF1bHQlM0Rvcy5lbnZpcm9uJTVCJTIyU01fQ0hBTk5FTF9UUkFJTiUyMiU1RCklMEElMjAlMjAlMjAlMjBwYXJzZXIuYWRkX2FyZ3VtZW50KCUyMi0tdGVzdF9kaXIlMjIlMkMlMjB0eXBlJTNEc3RyJTJDJTIwZGVmYXVsdCUzRG9zLmVudmlyb24lNUIlMjJTTV9DSEFOTkVMX1RFU1QlMjIlNUQp",highlighted:`<span class="hljs-keyword">import</span> transformers
<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">import</span> argparse
<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:

    parser = argparse.ArgumentParser()

    <span class="hljs-comment"># hyperparameters sent by the client are passed as command-line arguments to the script</span>
    parser.add_argument(<span class="hljs-string">&quot;--epochs&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">3</span>)
    parser.add_argument(<span class="hljs-string">&quot;--per_device_train_batch_size&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">32</span>)
    parser.add_argument(<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>)

    <span class="hljs-comment"># data, model, and output directories</span>
    parser.add_argument(<span class="hljs-string">&quot;--model-dir&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=os.environ[<span class="hljs-string">&quot;SM_MODEL_DIR&quot;</span>])
    parser.add_argument(<span class="hljs-string">&quot;--training_dir&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=os.environ[<span class="hljs-string">&quot;SM_CHANNEL_TRAIN&quot;</span>])
    parser.add_argument(<span class="hljs-string">&quot;--test_dir&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=os.environ[<span class="hljs-string">&quot;SM_CHANNEL_TEST&quot;</span>])`,wrap:!1}}),Q=new w({props:{title:"Training Output Management",local:"training-output-management",headingTag:"h2"}}),q=new w({props:{title:"Create a Hugging Face Estimator",local:"create-a-hugging-face-estimator",headingTag:"h2"}}),O=new d({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlJTBBJTBBJTBBJTIzJTIwaHlwZXJwYXJhbWV0ZXJzJTIwd2hpY2glMjBhcmUlMjBwYXNzZWQlMjB0byUyMHRoZSUyMHRyYWluaW5nJTIwam9iJTBBaHlwZXJwYXJhbWV0ZXJzJTNEJTdCJ2Vwb2NocyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3Blcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSclM0ElMjAzMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdtb2RlbF9uYW1lX29yX3BhdGgnJTNBJTIwJ2Rpc3RpbGJlcnQtYmFzZS11bmNhc2VkJyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRoZSUyMEVzdGltYXRvciUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5X3BvaW50JTNEJ3RyYWluLnB5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNvdXJjZV9kaXIlM0QnLiUyRnNjcmlwdHMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCdtbC5nNi4xMnhsYXJnZSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnN0YW5jZV9jb3VudCUzRDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyc192ZXJzaW9uJTNEJzQuMjYnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0b3JjaF92ZXJzaW9uJTNEJzEuMTMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHlfdmVyc2lvbiUzRCdweTM5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGh5cGVycGFyYW1ldGVycyUyMCUzRCUyMGh5cGVycGFyYW1ldGVycyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace


<span class="hljs-comment"># hyperparameters which are passed to the training job</span>
hyperparameters={<span class="hljs-string">&#x27;epochs&#x27;</span>: <span class="hljs-number">1</span>,
                 <span class="hljs-string">&#x27;per_device_train_batch_size&#x27;</span>: <span class="hljs-number">32</span>,
                 <span class="hljs-string">&#x27;model_name_or_path&#x27;</span>: <span class="hljs-string">&#x27;distilbert-base-uncased&#x27;</span>
                 }

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.g6.12xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters
)`,wrap:!1}}),te=new w({props:{title:"Execute training",local:"execute-training",headingTag:"h2"}}),ne=new d({props:{code:"aHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmZpdCglMEElMjAlMjAlN0IndHJhaW4nJTNBJTIwJ3MzJTNBJTJGJTJGc2FnZW1ha2VyLXVzLWVhc3QtMS01NTgxMDUxNDE3MjElMkZzYW1wbGVzJTJGZGF0YXNldHMlMkZpbWRiJTJGdHJhaW4nJTJDJTBBJTIwJTIwJTIwJ3Rlc3QnJTNBJTIwJ3MzJTNBJTJGJTJGc2FnZW1ha2VyLXVzLWVhc3QtMS01NTgxMDUxNDE3MjElMkZzYW1wbGVzJTJGZGF0YXNldHMlMkZpbWRiJTJGdGVzdCclN0QlMEEp",highlighted:`huggingface_estimator.fit(
  {<span class="hljs-string">&#x27;train&#x27;</span>: <span class="hljs-string">&#x27;s3://sagemaker-us-east-1-558105141721/samples/datasets/imdb/train&#x27;</span>,
   <span class="hljs-string">&#x27;test&#x27;</span>: <span class="hljs-string">&#x27;s3://sagemaker-us-east-1-558105141721/samples/datasets/imdb/test&#x27;</span>}
)`,wrap:!1}}),re=new d({props:{code:"JTJGb3B0JTJGY29uZGElMkZiaW4lMkZweXRob24lMjB0cmFpbi5weSUyMC0tZXBvY2hzJTIwMSUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDMy",highlighted:"/opt/conda/bin/python train.py --epochs 1 --model_name_or_path distilbert-base-uncased --per_device_train_batch_size 32",wrap:!1}}),oe=new w({props:{title:"Access trained model",local:"access-trained-model",headingTag:"h2"}}),Me=new d({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5zMyUyMGltcG9ydCUyMFMzRG93bmxvYWRlciUwQSUwQVMzRG93bmxvYWRlci5kb3dubG9hZCglMEElMjAlMjAlMjAlMjBzM191cmklM0RodWdnaW5nZmFjZV9lc3RpbWF0b3IubW9kZWxfZGF0YSUyQyUyMCUyMyUyMFMzJTIwVVJJJTIwd2hlcmUlMjB0aGUlMjB0cmFpbmVkJTIwbW9kZWwlMjBpcyUyMGxvY2F0ZWQlMEElMjAlMjAlMjAlMjBsb2NhbF9wYXRoJTNEJy4nJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbG9jYWwlMjBwYXRoJTIwd2hlcmUlMjAqLnRhcmcuZ3olMjBpcyUyMHNhdmVkJTBBJTIwJTIwJTIwJTIwc2FnZW1ha2VyX3Nlc3Npb24lM0RzZXNzJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2FnZU1ha2VyJTIwc2Vzc2lvbiUyMHVzZWQlMjBmb3IlMjB0cmFpbmluZyUyMHRoZSUyMG1vZGVsJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.s3 <span class="hljs-keyword">import</span> S3Downloader

S3Downloader.download(
    s3_uri=huggingface_estimator.model_data, <span class="hljs-comment"># S3 URI where the trained model is located</span>
    local_path=<span class="hljs-string">&#x27;.&#x27;</span>,                          <span class="hljs-comment"># local path where *.targ.gz is saved</span>
    sagemaker_session=sess                   <span class="hljs-comment"># SageMaker session used for training the model</span>
)`,wrap:!1}}),Je=new w({props:{title:"Distributed training",local:"distributed-training",headingTag:"h2"}}),ye=new w({props:{title:"Data parallelism",local:"data-parallelism",headingTag:"h3"}}),Te=new d({props:{code:"JTIzJTIwY29uZmlndXJhdGlvbiUyMGZvciUyMHJ1bm5pbmclMjB0cmFpbmluZyUyMG9uJTIwc21kaXN0cmlidXRlZCUyMGRhdGElMjBwYXJhbGxlbCUwQWRpc3RyaWJ1dGlvbiUyMCUzRCUyMCU3QidzbWRpc3RyaWJ1dGVkJyUzQSU3QidkYXRhcGFyYWxsZWwnJTNBJTdCJTIwJ2VuYWJsZWQnJTNBJTIwVHJ1ZSUyMCU3RCU3RCU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRoZSUyMEVzdGltYXRvciUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5X3BvaW50JTNEJ3RyYWluLnB5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNvdXJjZV9kaXIlM0QnLiUyRnNjcmlwdHMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCdtbC5wM2RuLjI0eGxhcmdlJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RhbmNlX2NvdW50JTNEMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJvbGUlM0Ryb2xlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXJzX3ZlcnNpb24lM0QnNC4yNi4wJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5dG9yY2hfdmVyc2lvbiUzRCcxLjEzLjEnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHlfdmVyc2lvbiUzRCdweTM5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGh5cGVycGFyYW1ldGVycyUyMCUzRCUyMGh5cGVycGFyYW1ldGVycyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3RyaWJ1dGlvbiUyMCUzRCUyMGRpc3RyaWJ1dGlvbiUwQSk=",highlighted:`<span class="hljs-comment"># configuration for running training on smdistributed data parallel</span>
distribution = {<span class="hljs-string">&#x27;smdistributed&#x27;</span>:{<span class="hljs-string">&#x27;dataparallel&#x27;</span>:{ <span class="hljs-string">&#x27;enabled&#x27;</span>: <span class="hljs-literal">True</span> }}}

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.p3dn.24xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">2</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26.0&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13.1&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters,
        distribution = distribution
)`,wrap:!1}}),de=new w({props:{title:"Model parallelism",local:"model-parallelism",headingTag:"h3"}}),ue=new d({props:{code:"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",highlighted:`<span class="hljs-comment"># configuration for running training on smdistributed model parallel</span>
mpi_options = {
    <span class="hljs-string">&quot;enabled&quot;</span> : <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;processes_per_host&quot;</span> : <span class="hljs-number">8</span>
}

smp_options = {
    <span class="hljs-string">&quot;enabled&quot;</span>:<span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
        <span class="hljs-string">&quot;microbatches&quot;</span>: <span class="hljs-number">4</span>,
        <span class="hljs-string">&quot;placement_strategy&quot;</span>: <span class="hljs-string">&quot;spread&quot;</span>,
        <span class="hljs-string">&quot;pipeline&quot;</span>: <span class="hljs-string">&quot;interleaved&quot;</span>,
        <span class="hljs-string">&quot;optimize&quot;</span>: <span class="hljs-string">&quot;speed&quot;</span>,
        <span class="hljs-string">&quot;partitions&quot;</span>: <span class="hljs-number">4</span>,
        <span class="hljs-string">&quot;ddp&quot;</span>: <span class="hljs-literal">True</span>,
    }
}

distribution={
    <span class="hljs-string">&quot;smdistributed&quot;</span>: {<span class="hljs-string">&quot;modelparallel&quot;</span>: smp_options},
    <span class="hljs-string">&quot;mpi&quot;</span>: mpi_options
}

 <span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.p3dn.24xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">2</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26.0&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13.1&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters,
        distribution = distribution
)`,wrap:!1}}),ge=new w({props:{title:"Spot instances",local:"spot-instances",headingTag:"h2"}}),Ce=new d({props:{code:"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",highlighted:`<span class="hljs-comment"># hyperparameters which are passed to the training job</span>
hyperparameters={<span class="hljs-string">&#x27;epochs&#x27;</span>: <span class="hljs-number">1</span>,
                 <span class="hljs-string">&#x27;train_batch_size&#x27;</span>: <span class="hljs-number">32</span>,
                 <span class="hljs-string">&#x27;model_name&#x27;</span>:<span class="hljs-string">&#x27;distilbert-base-uncased&#x27;</span>,
                 <span class="hljs-string">&#x27;output_dir&#x27;</span>:<span class="hljs-string">&#x27;/opt/ml/checkpoints&#x27;</span>
                 }

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.g6.12xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
	    checkpoint_s3_uri=<span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/checkpoints&#x27;</span>
        use_spot_instances=<span class="hljs-literal">True</span>,
        <span class="hljs-comment"># max_wait should be equal to or greater than max_run in seconds</span>
        max_wait=<span class="hljs-number">3600</span>,
        max_run=<span class="hljs-number">1000</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters
)

<span class="hljs-comment"># Training seconds: 874</span>
<span class="hljs-comment"># Billable seconds: 262</span>
<span class="hljs-comment"># Managed Spot Training savings: 70.0%</span>`,wrap:!1}}),_e=new w({props:{title:"Git repository",local:"git-repository",headingTag:"h2"}}),ke=new d({props:{code:"JTIzJTIwY29uZmlndXJlJTIwZ2l0JTIwc2V0dGluZ3MlMEFnaXRfY29uZmlnJTIwJTNEJTIwJTdCJ3JlcG8nJTNBJTIwJ2h0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzLmdpdCclMkMnYnJhbmNoJyUzQSUyMCd2NC40LjInJTdEJTIwJTIzJTIwdjQuNC4yJTIwcmVmZXJzJTIwdG8lMjB0aGUlMjB0cmFuc2Zvcm1lcnNfdmVyc2lvbiUyMHlvdSUyMHVzZSUyMGluJTIwdGhlJTIwZXN0aW1hdG9yJTBBJTBBJTIwJTIzJTIwY3JlYXRlJTIwdGhlJTIwRXN0aW1hdG9yJTBBaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yJTIwJTNEJTIwSHVnZ2luZ0ZhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW50cnlfcG9pbnQlM0QncnVuX2dsdWUucHknJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc291cmNlX2RpciUzRCcuJTJGZXhhbXBsZXMlMkZweXRvcmNoJTJGdGV4dC1jbGFzc2lmaWNhdGlvbiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnaXRfY29uZmlnJTNEZ2l0X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QnbWwuZzYuMTJ4bGFyZ2UnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm9sZSUzRHJvbGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1lcnNfdmVyc2lvbiUzRCc0LjI2JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5dG9yY2hfdmVyc2lvbiUzRCcxLjEzJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5X3ZlcnNpb24lM0QncHkzOSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoeXBlcnBhcmFtZXRlcnMlM0RoeXBlcnBhcmFtZXRlcnMlMEEp",highlighted:`<span class="hljs-comment"># configure git settings</span>
git_config = {<span class="hljs-string">&#x27;repo&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/transformers.git&#x27;</span>,<span class="hljs-string">&#x27;branch&#x27;</span>: <span class="hljs-string">&#x27;v4.4.2&#x27;</span>} <span class="hljs-comment"># v4.4.2 refers to the transformers_version you use in the estimator</span>

 <span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;run_glue.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./examples/pytorch/text-classification&#x27;</span>,
        git_config=git_config,
        instance_type=<span class="hljs-string">&#x27;ml.g6.12xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters=hyperparameters
)`,wrap:!1}}),ve=new w({props:{title:"SageMaker metrics",local:"sagemaker-metrics",headingTag:"h2"}}),Ge=new d({props:{code:"JTIzJTIwZGVmaW5lJTIwbWV0cmljcyUyMGRlZmluaXRpb25zJTBBbWV0cmljX2RlZmluaXRpb25zJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyTmFtZSUyMiUzQSUyMCUyMnRyYWluX3J1bnRpbWUlMjIlMkMlMjAlMjJSZWdleCUyMiUzQSUyMCUyMnRyYWluX3J1bnRpbWUuKiUzRCU1Q0QqKC4qJTNGKSUyNCUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMk5hbWUlMjIlM0ElMjAlMjJldmFsX2FjY3VyYWN5JTIyJTJDJTIwJTIyUmVnZXglMjIlM0ElMjAlMjJldmFsX2FjY3VyYWN5LiolM0QlNUNEKiguKiUzRiklMjQlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJOYW1lJTIyJTNBJTIwJTIyZXZhbF9sb3NzJTIyJTJDJTIwJTIyUmVnZXglMjIlM0ElMjAlMjJldmFsX2xvc3MuKiUzRCU1Q0QqKC4qJTNGKSUyNCUyMiU3RCUyQyUwQSU1RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRoZSUyMEVzdGltYXRvciUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5X3BvaW50JTNEJ3RyYWluLnB5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNvdXJjZV9kaXIlM0QnLiUyRnNjcmlwdHMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCdtbC5nNi4xMnhsYXJnZSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnN0YW5jZV9jb3VudCUzRDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyc192ZXJzaW9uJTNEJzQuMjYnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0b3JjaF92ZXJzaW9uJTNEJzEuMTMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHlfdmVyc2lvbiUzRCdweTM5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldHJpY19kZWZpbml0aW9ucyUzRG1ldHJpY19kZWZpbml0aW9ucyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGh5cGVycGFyYW1ldGVycyUyMCUzRCUyMGh5cGVycGFyYW1ldGVycyk=",highlighted:`<span class="hljs-comment"># define metrics definitions</span>
metric_definitions = [
    {<span class="hljs-string">&quot;Name&quot;</span>: <span class="hljs-string">&quot;train_runtime&quot;</span>, <span class="hljs-string">&quot;Regex&quot;</span>: <span class="hljs-string">&quot;train_runtime.*=\\D*(.*?)$&quot;</span>},
    {<span class="hljs-string">&quot;Name&quot;</span>: <span class="hljs-string">&quot;eval_accuracy&quot;</span>, <span class="hljs-string">&quot;Regex&quot;</span>: <span class="hljs-string">&quot;eval_accuracy.*=\\D*(.*?)$&quot;</span>},
    {<span class="hljs-string">&quot;Name&quot;</span>: <span class="hljs-string">&quot;eval_loss&quot;</span>, <span class="hljs-string">&quot;Regex&quot;</span>: <span class="hljs-string">&quot;eval_loss.*=\\D*(.*?)$&quot;</span>},
]

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.g6.12xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        metric_definitions=metric_definitions,
        hyperparameters = hyperparameters)`,wrap:!1}}),$e=new rl({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/tutorials/sagemaker-sdk/training-sagemaker-sdk.md"}}),{c(){h=i("meta"),Se=a(),He=i("p"),Ae=a(),p(U.$$.fragment),Re=a(),p(g.$$.fragment),Ee=a(),T=i("iframe"),Xe=a(),I=i("p"),I.innerHTML=ps,Ve=a(),f=i("ul"),f.innerHTML=Ms,Ye=a(),p(j.$$.fragment),Qe=a(),C=i("p"),C.innerHTML=Js,Fe=a(),b=i("p"),b.textContent=cs,Le=a(),_=i("ul"),_.innerHTML=ys,qe=a(),x=i("p"),x.innerHTML=ms,De=a(),Z=i("p"),Z.innerHTML=Ts,Pe=a(),p(B.$$.fragment),Ke=a(),k=i("blockquote"),k.innerHTML=ws,Oe=a(),v=i("p"),v.innerHTML=ds,et=a(),W=i("p"),W.textContent=hs,tt=a(),p(G.$$.fragment),st=a(),z=i("p"),z.innerHTML=us,lt=a(),$=i("p"),$.innerHTML=Us,at=a(),H=i("p"),H.textContent=gs,nt=a(),p(N.$$.fragment),it=a(),p(S.$$.fragment),rt=a(),A=i("p"),A.innerHTML=Is,ot=a(),R=i("ul"),R.innerHTML=fs,pt=a(),E=i("p"),E.innerHTML=js,Mt=a(),p(X.$$.fragment),Jt=a(),V=i("p"),V.innerHTML=Cs,ct=a(),Y=i("p"),Y.innerHTML=bs,yt=a(),p(Q.$$.fragment),mt=a(),F=i("p"),F.innerHTML=_s,Tt=a(),L=i("p"),L.innerHTML=xs,wt=a(),p(q.$$.fragment),dt=a(),D=i("p"),D.innerHTML=Zs,ht=a(),P=i("ol"),P.innerHTML=Bs,ut=a(),K=i("p"),K.innerHTML=ks,Ut=a(),p(O.$$.fragment),gt=a(),ee=i("p"),ee.innerHTML=vs,It=a(),p(te.$$.fragment),ft=a(),se=i("p"),se.innerHTML=Ws,jt=a(),le=i("ul"),le.innerHTML=Gs,Ct=a(),ae=i("p"),ae.innerHTML=zs,bt=a(),p(ne.$$.fragment),_t=a(),ie=i("p"),ie.innerHTML=$s,xt=a(),p(re.$$.fragment),Zt=a(),p(oe.$$.fragment),Bt=a(),pe=i("p"),pe.innerHTML=Hs,kt=a(),p(Me.$$.fragment),vt=a(),p(Je.$$.fragment),Wt=a(),ce=i("p"),ce.textContent=Ns,Gt=a(),p(ye.$$.fragment),zt=a(),me=i("p"),me.innerHTML=Ss,$t=a(),p(Te.$$.fragment),Ht=a(),we=i("p"),we.innerHTML=As,Nt=a(),p(de.$$.fragment),St=a(),he=i("p"),he.innerHTML=Rs,At=a(),p(ue.$$.fragment),Rt=a(),Ue=i("p"),Ue.innerHTML=Es,Et=a(),p(ge.$$.fragment),Xt=a(),Ie=i("p"),Ie.innerHTML=Xs,Vt=a(),fe=i("p"),fe.innerHTML=Vs,Yt=a(),je=i("p"),je.innerHTML=Ys,Qt=a(),p(Ce.$$.fragment),Ft=a(),be=i("p"),be.innerHTML=Qs,Lt=a(),p(_e.$$.fragment),qt=a(),xe=i("p"),xe.innerHTML=Fs,Dt=a(),Ze=i("p"),Ze.innerHTML=Ls,Pt=a(),Be=i("p"),Be.innerHTML=qs,Kt=a(),p(ke.$$.fragment),Ot=a(),p(ve.$$.fragment),es=a(),We=i("p"),We.innerHTML=Ds,ts=a(),p(Ge.$$.fragment),ss=a(),ze=i("p"),ze.innerHTML=Ps,ls=a(),p($e.$$.fragment),as=a(),Ne=i("p"),this.h()},l(e){const t=al("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(s),Se=n(e),He=r(e,"P",{}),is(He).forEach(s),Ae=n(e),M(U.$$.fragment,e),Re=n(e),M(g.$$.fragment,e),Ee=n(e),T=r(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),is(T).forEach(s),Xe=n(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-zhmf4d"&&(I.innerHTML=ps),Ve=n(e),f=r(e,"UL",{"data-svelte-h":!0}),o(f)!=="svelte-d99lsl"&&(f.innerHTML=Ms),Ye=n(e),M(j.$$.fragment,e),Qe=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-9mb7jq"&&(C.innerHTML=Js),Fe=n(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-14pz1nf"&&(b.textContent=cs),Le=n(e),_=r(e,"UL",{"data-svelte-h":!0}),o(_)!=="svelte-nu9uzs"&&(_.innerHTML=ys),qe=n(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-10vylvb"&&(x.innerHTML=ms),De=n(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1q1gn32"&&(Z.innerHTML=Ts),Pe=n(e),M(B.$$.fragment,e),Ke=n(e),k=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(k)!=="svelte-p7runb"&&(k.innerHTML=ws),Oe=n(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-aqpf90"&&(v.innerHTML=ds),et=n(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1n86nit"&&(W.textContent=hs),tt=n(e),M(G.$$.fragment,e),st=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-bmcgfj"&&(z.innerHTML=us),lt=n(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-12o7543"&&($.innerHTML=Us),at=n(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-qjt50s"&&(H.textContent=gs),nt=n(e),M(N.$$.fragment,e),it=n(e),M(S.$$.fragment,e),rt=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1u3xeug"&&(A.innerHTML=Is),ot=n(e),R=r(e,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-1owy1vd"&&(R.innerHTML=fs),pt=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1djq75m"&&(E.innerHTML=js),Mt=n(e),M(X.$$.fragment,e),Jt=n(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-x146s4"&&(V.innerHTML=Cs),ct=n(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1v5ow9s"&&(Y.innerHTML=bs),yt=n(e),M(Q.$$.fragment,e),mt=n(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1iromrn"&&(F.innerHTML=_s),Tt=n(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-17anpad"&&(L.innerHTML=xs),wt=n(e),M(q.$$.fragment,e),dt=n(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-w7qkuf"&&(D.innerHTML=Zs),ht=n(e),P=r(e,"OL",{"data-svelte-h":!0}),o(P)!=="svelte-17zgu79"&&(P.innerHTML=Bs),ut=n(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-129am2x"&&(K.innerHTML=ks),Ut=n(e),M(O.$$.fragment,e),gt=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1dwzx5g"&&(ee.innerHTML=vs),It=n(e),M(te.$$.fragment,e),ft=n(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1rykzxi"&&(se.innerHTML=Ws),jt=n(e),le=r(e,"UL",{"data-svelte-h":!0}),o(le)!=="svelte-n55cqy"&&(le.innerHTML=Gs),Ct=n(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1v0hjve"&&(ae.innerHTML=zs),bt=n(e),M(ne.$$.fragment,e),_t=n(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-pdxcpx"&&(ie.innerHTML=$s),xt=n(e),M(re.$$.fragment,e),Zt=n(e),M(oe.$$.fragment,e),Bt=n(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-l786pq"&&(pe.innerHTML=Hs),kt=n(e),M(Me.$$.fragment,e),vt=n(e),M(Je.$$.fragment,e),Wt=n(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-8hyjxi"&&(ce.textContent=Ns),Gt=n(e),M(ye.$$.fragment,e),zt=n(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-170csdj"&&(me.innerHTML=Ss),$t=n(e),M(Te.$$.fragment,e),Ht=n(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-oj7kbb"&&(we.innerHTML=As),Nt=n(e),M(de.$$.fragment,e),St=n(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-o081ci"&&(he.innerHTML=Rs),At=n(e),M(ue.$$.fragment,e),Rt=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-16yf61l"&&(Ue.innerHTML=Es),Et=n(e),M(ge.$$.fragment,e),Xt=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1yk874x"&&(Ie.innerHTML=Xs),Vt=n(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-11t96qn"&&(fe.innerHTML=Vs),Yt=n(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1d0l8c6"&&(je.innerHTML=Ys),Qt=n(e),M(Ce.$$.fragment,e),Ft=n(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1384417"&&(be.innerHTML=Qs),Lt=n(e),M(_e.$$.fragment,e),qt=n(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1rsnmrd"&&(xe.innerHTML=Fs),Dt=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1mokhnw"&&(Ze.innerHTML=Ls),Pt=n(e),Be=r(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-hhyk3e"&&(Be.innerHTML=qs),Kt=n(e),M(ke.$$.fragment,e),Ot=n(e),M(ve.$$.fragment,e),es=n(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-xro6kp"&&(We.innerHTML=Ds),ts=n(e),M(Ge.$$.fragment,e),ss=n(e),ze=r(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1y5r5uo"&&(ze.innerHTML=Ps),ls=n(e),M($e.$$.fragment,e),as=n(e),Ne=r(e,"P",{}),is(Ne).forEach(s),this.h()},h(){u(h,"name","hf:doc:metadata"),u(h,"content",pl),u(T,"width","700"),u(T,"height","394"),Os(T.src,os="https://www.youtube.com/embed/ok3hetb42gU")||u(T,"src",os),u(T,"title","YouTube video player"),u(T,"frameborder","0"),u(T,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),T.allowFullscreen=""},m(e,t){nl(document.head,h),l(e,Se,t),l(e,He,t),l(e,Ae,t),J(U,e,t),l(e,Re,t),J(g,e,t),l(e,Ee,t),l(e,T,t),l(e,Xe,t),l(e,I,t),l(e,Ve,t),l(e,f,t),l(e,Ye,t),J(j,e,t),l(e,Qe,t),l(e,C,t),l(e,Fe,t),l(e,b,t),l(e,Le,t),l(e,_,t),l(e,qe,t),l(e,x,t),l(e,De,t),l(e,Z,t),l(e,Pe,t),J(B,e,t),l(e,Ke,t),l(e,k,t),l(e,Oe,t),l(e,v,t),l(e,et,t),l(e,W,t),l(e,tt,t),J(G,e,t),l(e,st,t),l(e,z,t),l(e,lt,t),l(e,$,t),l(e,at,t),l(e,H,t),l(e,nt,t),J(N,e,t),l(e,it,t),J(S,e,t),l(e,rt,t),l(e,A,t),l(e,ot,t),l(e,R,t),l(e,pt,t),l(e,E,t),l(e,Mt,t),J(X,e,t),l(e,Jt,t),l(e,V,t),l(e,ct,t),l(e,Y,t),l(e,yt,t),J(Q,e,t),l(e,mt,t),l(e,F,t),l(e,Tt,t),l(e,L,t),l(e,wt,t),J(q,e,t),l(e,dt,t),l(e,D,t),l(e,ht,t),l(e,P,t),l(e,ut,t),l(e,K,t),l(e,Ut,t),J(O,e,t),l(e,gt,t),l(e,ee,t),l(e,It,t),J(te,e,t),l(e,ft,t),l(e,se,t),l(e,jt,t),l(e,le,t),l(e,Ct,t),l(e,ae,t),l(e,bt,t),J(ne,e,t),l(e,_t,t),l(e,ie,t),l(e,xt,t),J(re,e,t),l(e,Zt,t),J(oe,e,t),l(e,Bt,t),l(e,pe,t),l(e,kt,t),J(Me,e,t),l(e,vt,t),J(Je,e,t),l(e,Wt,t),l(e,ce,t),l(e,Gt,t),J(ye,e,t),l(e,zt,t),l(e,me,t),l(e,$t,t),J(Te,e,t),l(e,Ht,t),l(e,we,t),l(e,Nt,t),J(de,e,t),l(e,St,t),l(e,he,t),l(e,At,t),J(ue,e,t),l(e,Rt,t),l(e,Ue,t),l(e,Et,t),J(ge,e,t),l(e,Xt,t),l(e,Ie,t),l(e,Vt,t),l(e,fe,t),l(e,Yt,t),l(e,je,t),l(e,Qt,t),J(Ce,e,t),l(e,Ft,t),l(e,be,t),l(e,Lt,t),J(_e,e,t),l(e,qt,t),l(e,xe,t),l(e,Dt,t),l(e,Ze,t),l(e,Pt,t),l(e,Be,t),l(e,Kt,t),J(ke,e,t),l(e,Ot,t),J(ve,e,t),l(e,es,t),l(e,We,t),l(e,ts,t),J(Ge,e,t),l(e,ss,t),l(e,ze,t),l(e,ls,t),J($e,e,t),l(e,as,t),l(e,Ne,t),ns=!0},p:el,i(e){ns||(c(U.$$.fragment,e),c(g.$$.fragment,e),c(j.$$.fragment,e),c(B.$$.fragment,e),c(G.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(X.$$.fragment,e),c(Q.$$.fragment,e),c(q.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(re.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(Je.$$.fragment,e),c(ye.$$.fragment,e),c(Te.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(ge.$$.fragment,e),c(Ce.$$.fragment,e),c(_e.$$.fragment,e),c(ke.$$.fragment,e),c(ve.$$.fragment,e),c(Ge.$$.fragment,e),c($e.$$.fragment,e),ns=!0)},o(e){y(U.$$.fragment,e),y(g.$$.fragment,e),y(j.$$.fragment,e),y(B.$$.fragment,e),y(G.$$.fragment,e),y(N.$$.fragment,e),y(S.$$.fragment,e),y(X.$$.fragment,e),y(Q.$$.fragment,e),y(q.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(ne.$$.fragment,e),y(re.$$.fragment,e),y(oe.$$.fragment,e),y(Me.$$.fragment,e),y(Je.$$.fragment,e),y(ye.$$.fragment,e),y(Te.$$.fragment,e),y(de.$$.fragment,e),y(ue.$$.fragment,e),y(ge.$$.fragment,e),y(Ce.$$.fragment,e),y(_e.$$.fragment,e),y(ke.$$.fragment,e),y(ve.$$.fragment,e),y(Ge.$$.fragment,e),y($e.$$.fragment,e),ns=!1},d(e){e&&(s(Se),s(He),s(Ae),s(Re),s(Ee),s(T),s(Xe),s(I),s(Ve),s(f),s(Ye),s(Qe),s(C),s(Fe),s(b),s(Le),s(_),s(qe),s(x),s(De),s(Z),s(Pe),s(Ke),s(k),s(Oe),s(v),s(et),s(W),s(tt),s(st),s(z),s(lt),s($),s(at),s(H),s(nt),s(it),s(rt),s(A),s(ot),s(R),s(pt),s(E),s(Mt),s(Jt),s(V),s(ct),s(Y),s(yt),s(mt),s(F),s(Tt),s(L),s(wt),s(dt),s(D),s(ht),s(P),s(ut),s(K),s(Ut),s(gt),s(ee),s(It),s(ft),s(se),s(jt),s(le),s(Ct),s(ae),s(bt),s(_t),s(ie),s(xt),s(Zt),s(Bt),s(pe),s(kt),s(vt),s(Wt),s(ce),s(Gt),s(zt),s(me),s($t),s(Ht),s(we),s(Nt),s(St),s(he),s(At),s(Rt),s(Ue),s(Et),s(Xt),s(Ie),s(Vt),s(fe),s(Yt),s(je),s(Qt),s(Ft),s(be),s(Lt),s(qt),s(xe),s(Dt),s(Ze),s(Pt),s(Be),s(Kt),s(Ot),s(es),s(We),s(ts),s(ss),s(ze),s(ls),s(as),s(Ne)),s(h),m(U,e),m(g,e),m(j,e),m(B,e),m(G,e),m(N,e),m(S,e),m(X,e),m(Q,e),m(q,e),m(O,e),m(te,e),m(ne,e),m(re,e),m(oe,e),m(Me,e),m(Je,e),m(ye,e),m(Te,e),m(de,e),m(ue,e),m(ge,e),m(Ce,e),m(_e,e),m(ke,e),m(ve,e),m(Ge,e),m($e,e)}}}const pl='{"title":"Run training on Amazon SageMaker","local":"run-training-on-amazon-sagemaker","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Prepare a 🤗 Transformers fine-tuning script","local":"prepare-a--transformers-fine-tuning-script","sections":[],"depth":2},{"title":"Training Output Management","local":"training-output-management","sections":[],"depth":2},{"title":"Create a Hugging Face Estimator","local":"create-a-hugging-face-estimator","sections":[],"depth":2},{"title":"Execute training","local":"execute-training","sections":[],"depth":2},{"title":"Access trained model","local":"access-trained-model","sections":[],"depth":2},{"title":"Distributed training","local":"distributed-training","sections":[{"title":"Data parallelism","local":"data-parallelism","sections":[],"depth":3},{"title":"Model parallelism","local":"model-parallelism","sections":[],"depth":3}],"depth":2},{"title":"Spot instances","local":"spot-instances","sections":[],"depth":2},{"title":"Git repository","local":"git-repository","sections":[],"depth":2},{"title":"SageMaker metrics","local":"sagemaker-metrics","sections":[],"depth":2}],"depth":1}';function Ml(rs){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tl extends sl{constructor(h){super(),ll(this,h,Ml,ol,Ks,{})}}export{Tl as component};
